/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.cache;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.AbstractCacheManager;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheRubriqueManager
extends AbstractCacheManager {
    public static final String ID_BEAN = "cacheRubriqueManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheRubriqueManager.class);
    public static final String KEY_CACHE = "CacheRubriqueManager.cacheRubriques";

    public static CacheRubriqueManager getInstance() {
        return (CacheRubriqueManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    private HashMap<String, InfosRubriques> getCacheRubriques() throws Exception {
        HashMap<String, InfosRubriques> listeRubriques = new HashMap<String, InfosRubriques>();
        InfosRubriques infosRubriqueTop = new InfosRubriques("00");
        listeRubriques.put(infosRubriqueTop.getCode(), infosRubriqueTop);
        int count = 0;
        try (ContexteDao ctx = new ContexteDao();){
            Rubrique rubrique = new Rubrique();
            rubrique.setCtx(ctx);
            rubrique.selectNoCount("");
            InfosRubriques infosRubrique = null;
            while (rubrique.nextItem()) {
                infosRubrique = new InfosRubriques(rubrique);
                if (rubrique.getIdBandeau() != 0L) {
                    infosRubrique.setIdMediaBandeau(rubrique.getIdBandeau());
                    infosRubrique.setUrlBandeau(Media.getMedia(rubrique.getIdBandeau()).getUrlAbsolue());
                }
                if (rubrique.getIdPicto() != 0L) {
                    infosRubrique.setIdMediaPicto(rubrique.getIdPicto());
                    infosRubrique.setUrlPicto(Media.getMedia(rubrique.getIdPicto()).getUrlAbsolue());
                }
                listeRubriques.put(infosRubrique.getCode(), infosRubrique);
                ++count;
            }
        }
        catch (Exception e) {
            LOGGER.error("impossible de r\u00e9cup\u00e9rer les rubriques", (Throwable)e);
            throw e;
        }
        Iterator listRubriqueIt = listeRubriques.values().iterator();
        InfosRubriques rubrique = null;
        InfosRubriques rubriqueMere = null;
        while (listRubriqueIt.hasNext()) {
            rubrique = (InfosRubriques)listRubriqueIt.next();
            if (rubrique.getCode() == "00") continue;
            rubriqueMere = (InfosRubriques)listeRubriques.get(rubrique.getCodeRubriqueMere());
            if (rubriqueMere == null || rubriqueMere.getCode().length() == 0) {
                rubriqueMere = infosRubriqueTop;
            }
            rubrique.rattacheA(rubriqueMere);
        }
        LOGGER.info("Chargement de " + count + " rubriques OK");
        return listeRubriques;
    }

    @Override
    public Object getObjectToCache() throws Exception {
        return this.getCacheRubriques();
    }

    @Override
    public String getCacheName() {
        return KEY_CACHE;
    }

    @Override
    public Object getObjectKey() {
        return KEY_CACHE;
    }

    @Override
    public Object call() {
        Object res = super.call();
        if (res != null) {
            return res;
        }
        return new HashMap();
    }
}

