/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.cache;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kdecole.cache.aspect.StaticCacheFlush;
import com.kdecole.cache.aspect.StaticCacheGet;
import com.univ.objetspartages.cache.ICacheFicheManager;
import com.univ.objetspartages.om.ElementArboStructure;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStructureManager
implements ICacheFicheManager {
    public static final String ID_BEAN = "cacheStructureManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheStructureManager.class);

    @StaticCacheGet(key="CacheStructureManager.getListeStructures", contextual=false)
    public HashMap<String, ElementArboStructure> getListeStructures() {
        HashMap<String, ElementArboStructure> listeStructure = new HashMap<String, ElementArboStructure>();
        try (ContexteDao ctx = new ContexteDao();){
            for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
                if (ficheUniv == null || !(ficheUniv instanceof StructureModele)) continue;
                StructureModele structure = (StructureModele)ficheUniv;
                structure.setCtx(ctx);
                int count = structure.select("where ETAT_OBJET = '0003'");
                if (count <= 0) continue;
                HashMap<Long, String> hashMetaStructure = new HashMap<Long, String>();
                Metatag meta = new Metatag();
                meta.init();
                meta.setCtx(ctx);
                if (meta.select(codeObjet, null) > 0) {
                    while (meta.nextItem()) {
                        hashMetaStructure.put(meta.getMetaIdFiche(), meta.getMetaInTree());
                    }
                }
                while (structure.nextItem()) {
                    ElementArboStructure eltArbo;
                    InfosStructure infosStructure = new InfosStructure(structure);
                    if (structure.getIdBandeau() != 0L) {
                        infosStructure.setUrlBandeau(Media.getMedia(structure.getIdBandeau()).getUrlAbsolue());
                    }
                    if (hashMetaStructure.containsKey(structure.getIdFiche())) {
                        infosStructure.setVisibleInFront("1".equals(hashMetaStructure.get(structure.getIdFiche())));
                    }
                    if ((eltArbo = listeStructure.get(structure.getCode())) == null) {
                        eltArbo = new ElementArboStructure(structure.getCode());
                        listeStructure.put(structure.getCode(), eltArbo);
                    }
                    eltArbo.addInfosStructure(infosStructure);
                }
                LOGGER.info("Chargement de " + count + " structures de type " + ReferentielObjets.getLibelleObjet(codeObjet) + " OK");
            }
            ElementArboStructure eltArboTop = listeStructure.get("00");
            if (eltArboTop == null) {
                eltArboTop = new ElementArboStructure("00");
                listeStructure.put(eltArboTop.getCode(), eltArboTop);
            }
            for (int i = 0; i < LangueUtil.getNbLangues(); ++i) {
                InfosStructure infosStructTop = new InfosStructure();
                infosStructTop.setCode("00");
                infosStructTop.setLangue(String.valueOf(i));
                eltArboTop.addInfosStructure(infosStructTop);
            }
            for (ElementArboStructure elementArboStructure : listeStructure.values()) {
                for (InfosStructure infosStructure : elementArboStructure.getListeInfosStructure().values()) {
                    CacheStructureManager.rattacheStructure(listeStructure, infosStructure);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Impossible de charger le cache des structures", (Throwable)e);
        }
        return listeStructure;
    }

    private static void rattacheStructure(HashMap<String, ElementArboStructure> listeStructure, InfosStructure structure) {
        if (!"00".equals(structure.getCode())) {
            InfosStructure structureMere = null;
            ElementArboStructure elementArbo = listeStructure.get(structure.getCodeRattachement());
            if (elementArbo != null && (structureMere = elementArbo.getInfosStructure(structure.getLangue())) == null && !elementArbo.getListeInfosStructure().isEmpty()) {
                structure = elementArbo.getListeInfosStructure().values().iterator().next();
            }
            if (structureMere == null || structureMere.getCode().length() == 0) {
                structureMere = listeStructure.get("00").getInfosStructure(structure.getLangue());
            } else if (!structureMere.getLangue().equals(structure.getLangue())) {
                Locale locale = LangueUtil.getLocale(structure.getLangue());
                LOGGER.warn("La structure " + structure.getCodeRattachement() + " n'a pas \u00e9t\u00e9 traduite en " + (locale != null ? locale.getDisplayLanguage() : "langue " + structure.getLangue()));
                structureMere = (InfosStructure)structureMere.clone();
                structureMere.setLangue(structure.getLangue());
                CacheStructureManager.rattacheStructure(listeStructure, structureMere);
                listeStructure.get(structureMere.getCode()).addInfosStructure(structureMere);
            }
            structure.rattacheA(structureMere);
        }
    }

    @Override
    @StaticCacheFlush(key="CacheStructureManager.getListeStructures", contextual=false)
    public void flush() {
    }
}

