/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.dao;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.univ.objetspartages.dao.FicheDAO;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFicheDAO<T>
extends AbstractCommonDAO<T>
implements FicheDAO<T> {
    @Override
    public List<T> selectParCodeRubrique(String codeRubrique, String langue) throws DataSourceException {
        RequeteSQL codeRubriqueLangueEnLigneOrdreTitre = new RequeteSQL();
        ClauseWhere whereCodeRubriqueLangueEtat = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            whereCodeRubriqueLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_RUBRIQUE", codeRubrique));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
        }
        whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", "0003"));
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeRubriqueLangueEnLigneOrdreTitre.where(whereCodeRubriqueLangueEtat).orderBy(orderBy);
        return this.select(codeRubriqueLangueEnLigneOrdreTitre.formaterRequete());
    }

    @Override
    public List<T> selectCodeLangueEtat(String code, String langue, String etat) throws DataSourceException {
        RequeteSQL codeLangueEtatOrdreSurTitre = new RequeteSQL();
        ClauseWhere whereCodeLangueEtat = ConditionHelper.whereCodeLangueEtat(code, langue, etat);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeLangueEtatOrdreSurTitre.where(whereCodeLangueEtat).orderBy(orderBy);
        return this.select(codeLangueEtatOrdreSurTitre.formaterRequete());
    }
}

