/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.dao.impl;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.univ.objetspartages.bean.ArticleBean;
import com.univ.objetspartages.dao.AbstractFicheDAO;
import com.univ.objetspartages.om.Article;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ClauseJoinHelper;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;

public class ArticleDAO
extends AbstractFicheDAO<ArticleBean> {
    public ArticleDAO() {
        this.tableName = "ARTICLE";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArticleBean add(ArticleBean fiche) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("insert into ARTICLE (ID_ARTICLE , TITRE , SOUS_TITRE , DATE_ARTICLE , ID_VIGNETTE , CHAPEAU , CORPS , THEMATIQUE , ORDRE , CODE , CODE_RUBRIQUE , CODE_RATTACHEMENT , META_KEYWORDS , META_DESCRIPTION , TITRE_ENCADRE , CONTENU_ENCADRE , ENCADRE_RECHERCHE , ENCADRE_RECHERCHE_BIS , DATE_ALERTE , MESSAGE_ALERTE , DATE_CREATION , DATE_PROPOSITION , DATE_VALIDATION , DATE_MODIFICATION , CODE_REDACTEUR , CODE_VALIDATION , LANGUE , ETAT_OBJET , NB_HITS , DIFFUSION_PUBLIC_VISE , DIFFUSION_MODE_RESTRICTION , DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);){
                stmt.setObject(1, (Object)fiche.getIdArticle(), -5);
                stmt.setObject(2, (Object)fiche.getTitre(), 12);
                stmt.setObject(3, (Object)fiche.getSousTitre(), -1);
                stmt.setObject(4, (Object)fiche.getDateArticle(), 91);
                stmt.setObject(5, (Object)fiche.getIdVignette(), -5);
                stmt.setObject(6, (Object)fiche.getChapeau(), -1);
                stmt.setObject(7, (Object)fiche.getCorps(), -1);
                stmt.setObject(8, (Object)fiche.getThematique(), 12);
                stmt.setObject(9, (Object)fiche.getOrdre(), 4);
                stmt.setObject(10, (Object)fiche.getCode(), 12);
                stmt.setObject(11, (Object)fiche.getCodeRubrique(), 12);
                stmt.setObject(12, (Object)fiche.getCodeRattachement(), 12);
                stmt.setObject(13, (Object)fiche.getMetaKeywords(), -1);
                stmt.setObject(14, (Object)fiche.getMetaDescription(), -1);
                stmt.setObject(15, (Object)fiche.getTitreEncadre(), 12);
                stmt.setObject(16, (Object)fiche.getContenuEncadre(), -1);
                stmt.setObject(17, (Object)fiche.getEncadreRecherche(), 12);
                stmt.setObject(18, (Object)fiche.getEncadreRechercheBis(), 12);
                stmt.setObject(19, (Object)fiche.getDateAlerte(), 91);
                stmt.setObject(20, (Object)fiche.getMessageAlerte(), -1);
                stmt.setObject(21, (Object)fiche.getDateCreation(), 93);
                stmt.setObject(22, (Object)fiche.getDateProposition(), 93);
                stmt.setObject(23, (Object)fiche.getDateValidation(), 93);
                stmt.setObject(24, (Object)fiche.getDateModification(), 93);
                stmt.setObject(25, (Object)fiche.getCodeRedacteur(), 12);
                stmt.setObject(26, (Object)fiche.getCodeValidation(), 12);
                stmt.setObject(27, (Object)fiche.getLangue(), 12);
                stmt.setObject(28, (Object)fiche.getEtatObjet(), 12);
                stmt.setObject(29, (Object)fiche.getNbHits(), -5);
                stmt.setObject(30, (Object)fiche.getDiffusionPublicVise(), 12);
                stmt.setObject(31, (Object)fiche.getDiffusionModeRestriction(), 12);
                stmt.setObject(32, (Object)fiche.getDiffusionPublicViseRestriction(), 12);
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\" : %d row(s) affected", fiche.toString(), this.tableName, rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                fiche.setIdArticle(rs.getLong(1));
            }
            if (rs == null) return fiche;
        }
        catch (SQLException e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\"", fiche.toString(), this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return fiche;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return fiche;
        }
    }

    @Override
    public ArticleBean update(ArticleBean fiche) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update ARTICLE set ID_ARTICLE = ?, TITRE = ?, SOUS_TITRE = ?, DATE_ARTICLE = ?, ID_VIGNETTE = ?, CHAPEAU = ?, CORPS = ?, THEMATIQUE = ?, ORDRE = ?, CODE = ?, CODE_RUBRIQUE = ?, CODE_RATTACHEMENT = ?, META_KEYWORDS = ?, META_DESCRIPTION = ?, TITRE_ENCADRE = ?, CONTENU_ENCADRE = ?, ENCADRE_RECHERCHE = ?, ENCADRE_RECHERCHE_BIS = ?, DATE_ALERTE = ?, MESSAGE_ALERTE = ?, DATE_CREATION = ?, DATE_PROPOSITION = ?, DATE_VALIDATION = ?, DATE_MODIFICATION = ?, CODE_REDACTEUR = ?, CODE_VALIDATION = ?, LANGUE = ?, ETAT_OBJET = ?, NB_HITS = ?, DIFFUSION_PUBLIC_VISE = ?, DIFFUSION_MODE_RESTRICTION = ?, DIFFUSION_PUBLIC_VISE_RESTRICTION = ? where ID_ARTICLE = ?");){
            stmt.setObject(1, (Object)fiche.getIdArticle(), -5);
            stmt.setObject(2, (Object)fiche.getTitre(), 12);
            stmt.setObject(3, (Object)fiche.getSousTitre(), -1);
            stmt.setObject(4, (Object)fiche.getDateArticle(), 91);
            stmt.setObject(5, (Object)fiche.getIdVignette(), -5);
            stmt.setObject(6, (Object)fiche.getChapeau(), -1);
            stmt.setObject(7, (Object)fiche.getCorps(), -1);
            stmt.setObject(8, (Object)fiche.getThematique(), 12);
            stmt.setObject(9, (Object)fiche.getOrdre(), 4);
            stmt.setObject(10, (Object)fiche.getCode(), 12);
            stmt.setObject(11, (Object)fiche.getCodeRubrique(), 12);
            stmt.setObject(12, (Object)fiche.getCodeRattachement(), 12);
            stmt.setObject(13, (Object)fiche.getMetaKeywords(), -1);
            stmt.setObject(14, (Object)fiche.getMetaDescription(), -1);
            stmt.setObject(15, (Object)fiche.getTitreEncadre(), 12);
            stmt.setObject(16, (Object)fiche.getContenuEncadre(), -1);
            stmt.setObject(17, (Object)fiche.getEncadreRecherche(), 12);
            stmt.setObject(18, (Object)fiche.getEncadreRechercheBis(), 12);
            stmt.setObject(19, (Object)fiche.getDateAlerte(), 91);
            stmt.setObject(20, (Object)fiche.getMessageAlerte(), -1);
            stmt.setObject(21, (Object)fiche.getDateCreation(), 93);
            stmt.setObject(22, (Object)fiche.getDateProposition(), 93);
            stmt.setObject(23, (Object)fiche.getDateValidation(), 93);
            stmt.setObject(24, (Object)fiche.getDateModification(), 93);
            stmt.setObject(25, (Object)fiche.getCodeRedacteur(), 12);
            stmt.setObject(26, (Object)fiche.getCodeValidation(), 12);
            stmt.setObject(27, (Object)fiche.getLangue(), 12);
            stmt.setObject(28, (Object)fiche.getEtatObjet(), 12);
            stmt.setObject(29, (Object)fiche.getNbHits(), -5);
            stmt.setObject(30, (Object)fiche.getDiffusionPublicVise(), 12);
            stmt.setObject(31, (Object)fiche.getDiffusionModeRestriction(), 12);
            stmt.setObject(32, (Object)fiche.getDiffusionPublicViseRestriction(), 12);
            stmt.setObject(33, (Object)fiche.getIdArticle(), -5);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"%s\"", fiche.toString(), this.tableName), e);
        }
        return fiche;
    }

    @Override
    protected ArticleBean fill(ResultSet rs) throws DataSourceException {
        ArticleBean article = new ArticleBean();
        try {
            article.setIdArticle(new Long(rs.getLong("ID_ARTICLE")));
            article.setTitre(rs.getString("TITRE"));
            article.setSousTitre(rs.getString("SOUS_TITRE"));
            article.setDateArticle(rs.getDate("DATE_ARTICLE"));
            article.setIdVignette(new Long(rs.getLong("ID_VIGNETTE")));
            article.setChapeau(rs.getString("CHAPEAU"));
            article.setCorps(rs.getString("CORPS"));
            article.setThematique(rs.getString("THEMATIQUE"));
            article.setOrdre(new Integer(rs.getInt("ORDRE")));
            article.setCode(rs.getString("CODE"));
            article.setCodeRubrique(rs.getString("CODE_RUBRIQUE"));
            article.setCodeRattachement(rs.getString("CODE_RATTACHEMENT"));
            article.setMetaKeywords(rs.getString("META_KEYWORDS"));
            article.setMetaDescription(rs.getString("META_DESCRIPTION"));
            article.setTitreEncadre(rs.getString("TITRE_ENCADRE"));
            article.setContenuEncadre(rs.getString("CONTENU_ENCADRE"));
            article.setEncadreRecherche(rs.getString("ENCADRE_RECHERCHE"));
            article.setEncadreRechercheBis(rs.getString("ENCADRE_RECHERCHE_BIS"));
            article.setDateAlerte(rs.getDate("DATE_ALERTE"));
            article.setMessageAlerte(rs.getString("MESSAGE_ALERTE"));
            article.setDateCreation(new Date(rs.getTimestamp("DATE_CREATION").getTime()));
            article.setDateProposition(new Date(rs.getTimestamp("DATE_PROPOSITION").getTime()));
            article.setDateValidation(new Date(rs.getTimestamp("DATE_VALIDATION").getTime()));
            article.setDateModification(new Date(rs.getTimestamp("DATE_MODIFICATION").getTime()));
            article.setCodeRedacteur(rs.getString("CODE_REDACTEUR"));
            article.setCodeValidation(rs.getString("CODE_VALIDATION"));
            article.setLangue(rs.getString("LANGUE"));
            article.setEtatObjet(rs.getString("ETAT_OBJET"));
            article.setNbHits(new Long(rs.getLong("NB_HITS")));
            article.setDiffusionPublicVise(rs.getString("DIFFUSION_PUBLIC_VISE"));
            article.setDiffusionModeRestriction(rs.getString("DIFFUSION_MODE_RESTRICTION"));
            article.setDiffusionPublicViseRestriction(rs.getString("DIFFUSION_PUBLIC_VISE_RESTRICTION"));
        }
        catch (SQLException e) {
            throw new DataSourceException("An error occured trying to map resultset to object", e);
        }
        return article;
    }

    public List<ArticleBean> select(Article article, String titre, Date dateDebut, Date dateFin, String thematique, String codeRubrique, String codeRattachement, String etatObjet, String langue, String codeRedacteur, String nombre, String ordre, String ids, String code) throws Exception {
        boolean existJoinMeta;
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            where.setPremiereCondition(ConditionHelper.rechercheMots("TITRE", titre));
        }
        if (Formateur.estSaisie(dateDebut)) {
            where.and(ConditionHelper.critereDateDebut("DATE_ARTICLE", dateDebut));
        }
        if (Formateur.estSaisie(dateFin)) {
            where.and(ConditionHelper.critereDateFin("DATE_ARTICLE", dateFin));
        }
        if (StringUtils.isNotEmpty((CharSequence)thematique) && !"0000".equals(thematique)) {
            where.and(ConditionHelper.likePourValeursMultiple("THEMATIQUE", thematique));
        }
        if (StringUtils.isNotEmpty((CharSequence)ids) && !"0000".equals(ids)) {
            where.and(ConditionHelper.in("ID_ARTICLE", Chaine.getVecteurPointsVirgules(ids)));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure("CODE_RATTACHEMENT", codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar("CODE_REDACTEUR", codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar("T1.CODE", code));
        }
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        RequeteSQL requeteSelect = RequeteSQLHelper.getRequeteGenerique(where, ctx, article, codeRubrique);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)ordre)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy(ordre);
        } else {
            orderBy.orderBy("T1.ORDRE", ClauseOrderBy.SensDeTri.ASC).orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        }
        if (orderBy != null && StringUtils.contains((CharSequence)orderBy.formaterSQL(), (CharSequence)"META.") && !(existJoinMeta = CollectionUtils.exists(requeteSelect.getJointures(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                ClauseJoin jointure = (ClauseJoin)o;
                return StringUtils.contains((CharSequence)jointure.getNomTable(), (CharSequence)"METATAG");
            }
        }))) {
            requeteSelect.join(ClauseJoinHelper.creerJointureMetaTag(article));
        }
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(ctx, nombre);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }
}

