/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.misc;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AbstractRechercheExterne;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RechercheCore
extends AbstractRechercheExterne {
    @Override
    public boolean preparerRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        String objet = StringUtils.defaultString((String)infoBean.getString("OBJET"), (String)"").toUpperCase();
        if (objet.equals("PAGELIBRE")) {
            infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(ctx.getLocale()));
            rechercheEffectuee = true;
        }
        return rechercheEffectuee;
    }

    @Override
    public boolean traiterRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        String objet = infoBean.getString("OBJET").toUpperCase();
        if (objet.equals("PAGELIBRE")) {
            ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
            Objetpartage module = ReferentielObjets.getObjetByNom(objet);
            criteres.add(new CritereRecherche("OBJET", infoBean.getString("OBJET"), ""));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(infoBean, "TITRE"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(infoBean, "MOTS_CLES"));
            if ("0".equals(module.getProperty("fiche.PAGELIBRE.recherche_vide")) && criteres.size() <= 1) {
                throw new ErreurApplicative(module.getMessage(ctx.getLocale(), "ST_RECHERCHE_SAISIR_UN_CRITERE"));
            }
            rechercheEffectuee = true;
            criteres.addAll(this.getCritereDefaut(infoBean));
            infoBean.set("CRITERE_REQUETE", criteres);
            this.gestionAncienFront(infoBean, criteres);
        }
        return rechercheEffectuee;
    }

    @Override
    public List<String> getCriteresRequete(String objet, boolean listeIncluse) {
        return new ArrayList<String>();
    }
}

