/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.manager.DataSourceDAOManager;
import com.univ.objetspartages.bean.AbstractPersistenceBean;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOm<T extends AbstractPersistenceBean, Y extends CommonDAO<T>> {
    protected T persistenceBean;
    protected Y commonDao;
    protected Collection<T> currentSelect;
    protected Iterator<T> currentSelectIt;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOm.class);

    private Class<T> getGenericType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public AbstractOm() {
        DataSourceDAOManager manager = (DataSourceDAOManager)ApplicationContextManager.getCoreContextBean("daoManager");
        this.commonDao = manager.getDao(this.getGenericType());
        try {
            this.persistenceBean = (AbstractPersistenceBean)this.getGenericType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error(String.format("Couldn't instanciate %s object", this.getGenericType().getName()), (Throwable)e);
        }
    }

    public T getPersistenceBean() {
        return this.persistenceBean;
    }

    public void setPersistenceBean(T persistenceBean) {
        this.persistenceBean = persistenceBean;
    }

    public void add() throws Exception {
        this.commonDao.add(this.persistenceBean);
    }

    public void delete() throws Exception {
        this.commonDao.delete(((AbstractPersistenceBean)this.persistenceBean).getId());
    }

    public void update() throws Exception {
        this.commonDao.update(this.persistenceBean);
    }

    public T getById(Long id) throws Exception {
        return (T)((AbstractPersistenceBean)this.commonDao.getById(id));
    }

    public int select(String requete) throws Exception {
        this.currentSelect = this.commonDao.select(requete);
        this.currentSelectIt = this.currentSelect.iterator();
        return this.currentSelect.size();
    }

    public List<T> selectAll(String requete) throws Exception {
        return this.commonDao.select(requete);
    }

    @Deprecated
    public boolean nextItem() throws Exception {
        if (this.currentSelectIt != null && this.currentSelectIt.hasNext()) {
            this.persistenceBean = (AbstractPersistenceBean)this.currentSelectIt.next();
            return true;
        }
        return false;
    }
}

