/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.RechercheExterne;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RechercheFicheHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRechercheExterne
implements RechercheExterne {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRechercheExterne.class);

    @Deprecated
    public String ajouterCritereDefaut(InfoBean infoBean, String requete) throws Exception {
        String codeRubrique;
        String codeStructure;
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "CODE");
        requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "ETAT_OBJET", Boolean.TRUE, Boolean.FALSE);
        requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "LANGUE");
        requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "IDS");
        String codeRedacteur = infoBean.getString("CODE_REDACTEUR");
        if (StringUtils.isNotBlank((CharSequence)codeRedacteur)) {
            requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "CODE_REDACTEUR");
            try {
                String libelleRedacteur = Utilisateur.getLibelle(codeRedacteur);
                if (StringUtils.isNotBlank((CharSequence)libelleRedacteur)) {
                    requete = requete + "&LIBELLE_CODE_REDACTEUR=" + libelleRedacteur;
                }
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle r\u00e9dacteur dans la recherche");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(codeStructure = infoBean.getString("CODE_RATTACHEMENT")))) {
            requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "CODE_RATTACHEMENT");
            try {
                String libelleStructure = Structure.getLibelleAffichable(codeStructure, LangueUtil.getLangueLocale(ctx.getLocale()));
                if (StringUtils.isNotBlank((CharSequence)libelleStructure)) {
                    requete = requete + "&LIBELLE_CODE_RATTACHEMENT=" + libelleStructure;
                }
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle structure dans la recherche");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(codeRubrique = infoBean.getString("CODE_RUBRIQUE")))) {
            requete = RechercheFicheHelper.ajouterCritereRequete(infoBean.getValues(), requete, "CODE_RUBRIQUE");
            try {
                String libelleRubrique = Rubrique.getIntitule(codeRubrique);
                if (StringUtils.isNotBlank((CharSequence)libelleRubrique)) {
                    requete = requete + "&LIBELLE_CODE_RUBRIQUE=" + libelleRubrique;
                }
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle rubrique dans la recherche");
            }
        }
        String idBean = "ficheUnivDatagrid";
        if (infoBean.get("TOOLBOX") != null) {
            idBean = "ficheToolboxDatagrid";
        }
        requete = requete + "&BEAN_RECHERCHE=" + idBean;
        return requete;
    }

    public List<CritereRecherche> getCritereDefaut(InfoBean infoBean) {
        String codeRubrique;
        String codeStructure;
        String codeRedacteur;
        String langue;
        ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "CODE"));
        String etatObjet = infoBean.getString("ETAT_OBJET");
        if (StringUtils.isNotBlank((CharSequence)etatObjet)) {
            criteres.add(new CritereRecherche("ETAT_OBJET", etatObjet, MessageHelper.getCoreMessage("ETATFICHE_" + etatObjet)));
        }
        if (StringUtils.isNotBlank((CharSequence)(langue = infoBean.getString("LANGUE"))) && !"0000".equals(langue)) {
            criteres.add(new CritereRecherche("LANGUE", langue, LangueUtil.getLocale(langue).getDisplayLanguage(ctx.getLocale())));
        }
        String idsFil = infoBean.getString("IDS");
        String valeurFil = infoBean.getString("FIL");
        if (StringUtils.isNotBlank((CharSequence)idsFil) && !"0000".equals(idsFil) && StringUtils.isNotBlank((CharSequence)valeurFil)) {
            criteres.add(new CritereRecherche("IDS", idsFil));
            String libelleFil = infoBean.getString("LIBELLE_FIL");
            if (StringUtils.isNotBlank((CharSequence)libelleFil)) {
                criteres.add(new CritereRecherche("FIL", valeurFil, libelleFil));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(codeRedacteur = infoBean.getString("CODE_REDACTEUR")))) {
            try {
                String libelleRedacteur = Utilisateur.getLibelle(codeRedacteur);
                criteres.add(new CritereRecherche("CODE_REDACTEUR", codeRedacteur, libelleRedacteur));
                criteres.add(new CritereRecherche("LIBELLE_CODE_REDACTEUR", libelleRedacteur));
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle r\u00e9dacteur dans la recherche");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(codeStructure = infoBean.getString("CODE_RATTACHEMENT")))) {
            try {
                InfosStructure structure = Structure.renvoyerItemStructure(codeStructure, LangueUtil.getLangueLocale(ctx.getLocale()));
                String libelleStructure = structure.getLibelleLong();
                criteres.add(new CritereRecherche("CODE_RATTACHEMENT", codeStructure, libelleStructure));
                criteres.add(new CritereRecherche("LIBELLE_CODE_RATTACHEMENT", libelleStructure));
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle structure dans la recherche");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(codeRubrique = infoBean.getString("CODE_RUBRIQUE")))) {
            try {
                String libelleRubrique = Rubrique.getIntitule(codeRubrique);
                criteres.add(new CritereRecherche("CODE_RUBRIQUE", codeRubrique, libelleRubrique));
                criteres.add(new CritereRecherche("LIBELLE_CODE_RUBRIQUE", libelleRubrique));
            }
            catch (Exception e) {
                LOG.debug("impossible de r\u00e9cuperer le libelle rubrique dans la recherche");
            }
        }
        String idBean = "ficheUnivDatagrid";
        if (infoBean.get("TOOLBOX") != null) {
            idBean = "ficheToolboxDatagrid";
        }
        criteres.add(new CritereRecherche("BEAN_RECHERCHE", idBean));
        return criteres;
    }

    protected void gestionAncienFront(InfoBean infoBean, List<CritereRecherche> criteres) {
        Collection requete = CollectionUtils.collect(criteres, (Transformer)new Transformer(){

            public Object transform(Object input) {
                CritereRecherche critere = (CritereRecherche)input;
                return critere.getNomChamp() + "=" + critere.getValeurARechercher();
            }
        });
        infoBean.set("REQUETE", StringUtils.join((Iterable)requete, (String)"&"));
    }
}

