/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.cms.objetspartages.annotation.FicheAnnotation;
import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;
import com.univ.objetspartages.bean.ArticleBean;
import com.univ.objetspartages.dao.impl.ArticleDAO;
import com.univ.objetspartages.om.AbstractFiche;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheExportableXML;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.UnivWebFmt;
import com.univ.xml.NodeUtil;
import java.sql.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@FicheAnnotation
public class Article
extends AbstractFiche<ArticleBean>
implements DiffusionSelective,
FicheExportableXML {
    public static String getLibelleAffichable(String codes, String langue) throws Exception {
        String res = "";
        if (StringUtils.isEmpty((CharSequence)codes)) {
            return res;
        }
        Article article = new Article();
        article.init();
        if (StringUtils.isEmpty((CharSequence)langue)) {
            langue = "0";
        }
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            int count = article.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = article.selectCodeLangueEtat(code, langue, "");
            }
            if (count > 0) {
                if (res.length() > 1) {
                    res = res + ";";
                }
                if (!article.nextItem()) continue;
                res = res + article.getLibelleAffichable();
                continue;
            }
            res = res + "-";
        }
        return res;
    }

    public static Article getFicheArticle(String code, String langue) throws Exception {
        Article fiche = null;
        if (code != null && code.length() > 0) {
            if (langue == null || langue.length() == 0) {
                langue = "0";
            }
            fiche = new Article();
            fiche.init();
            int count = fiche.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, langue, "");
            }
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, "", "0003");
            }
            if (count > 0) {
                fiche.nextItem();
            }
        }
        return fiche;
    }

    @Override
    public void init() {
        super.init();
        this.setSousTitre("");
        this.setDateArticle(new Date(System.currentTimeMillis()));
        this.setIdVignette(0L);
        this.setChapeau("");
        this.setCorps("");
        this.setThematique("");
        this.setOrdre(1000);
    }

    public void setOrdre(Integer ordre) {
        ((ArticleBean)this.persistenceBean).setOrdre(ordre);
    }

    public Integer getOrdre() {
        return ((ArticleBean)this.persistenceBean).getOrdre();
    }

    public void setThematique(String thematique) {
        ((ArticleBean)this.persistenceBean).setThematique(thematique);
    }

    public String getThematique() {
        return ((ArticleBean)this.persistenceBean).getThematique();
    }

    @SetterAnnotation(isToolbox=true)
    public void setCorps(String corps) {
        ((ArticleBean)this.persistenceBean).setCorps(corps);
    }

    @GetterAnnotation(isToolbox=true)
    public String getCorps() {
        return ((ArticleBean)this.persistenceBean).getCorps();
    }

    public void setChapeau(String chapeau) {
        ((ArticleBean)this.persistenceBean).setChapeau(chapeau);
    }

    public String getChapeau() {
        return ((ArticleBean)this.persistenceBean).getChapeau();
    }

    public void setIdVignette(Long idVignette) {
        ((ArticleBean)this.persistenceBean).setIdVignette(idVignette);
    }

    public Long getIdVignette() {
        return ((ArticleBean)this.persistenceBean).getIdVignette();
    }

    public void setDateArticle(Date dateArticle) {
        ((ArticleBean)this.persistenceBean).setDateArticle(dateArticle);
    }

    public Date getDateArticle() {
        return ((ArticleBean)this.persistenceBean).getDateArticle();
    }

    public void setSousTitre(String sousTitre) {
        ((ArticleBean)this.persistenceBean).setSousTitre(sousTitre);
    }

    public String getSousTitre() {
        return ((ArticleBean)this.persistenceBean).getSousTitre();
    }

    @Override
    public String getLibelleAffichable() {
        return this.getTitre();
    }

    public String getFormatedCorps() throws Exception {
        return UnivWebFmt.formaterEnHTML(ContexteUtil.getContexteUniv(), this.getCorps());
    }

    public String getLibelleThematique() {
        return Libelle.getLibelle("04", this.getThematique(), LangueUtil.getLocale(Integer.parseInt(this.getLangue())));
    }

    public List<String> getListLibelleThematique() {
        return Libelle.getLibelleSousFormeDeListe("04", this.getThematique(), LangueUtil.getLocale(Integer.parseInt(this.getLangue())));
    }

    public List<Ressource> getListeFichiers() throws Exception {
        return Ressource.getListeFichier(this);
    }

    public List<Ressource> getListeFichiersIndices() throws Exception {
        return Ressource.getListeFichierIndice(this);
    }

    public InfosRubriques getInfosRubrique() {
        return Rubrique.renvoyerItemRubrique(this.getCodeRubrique());
    }

    public InfosStructure getInfosStructure() throws Exception {
        return Structure.renvoyerItemStructure(this.getCodeRattachement(), this.getLangue());
    }

    public Metatag getMeta() throws Exception {
        return FicheUnivMgr.lireMeta(this);
    }

    @Override
    public String getFullTextString() {
        return this.getSousTitre() + " " + this.getChapeau() + " " + this.getCorps() + " " + StringUtils.replace((String)this.getLibelleThematique(), (String)";", (String)" ");
    }

    @Override
    public int traiterRequete(String requete) throws Exception {
        String code = RequeteUtil.renvoyerParametre(requete, "CODE");
        String titre = RequeteUtil.renvoyerParametre(requete, "TITRE");
        String sDateDebut = RequeteUtil.renvoyerParametre(requete, "DATE_DEBUT");
        String sDateFin = RequeteUtil.renvoyerParametre(requete, "DATE_FIN");
        String thematique = RequeteUtil.renvoyerParametre(requete, "THEMATIQUE");
        String codeRubrique = RequeteUtil.renvoyerParametre(requete, "CODE_RUBRIQUE");
        String codeRattachement = RequeteUtil.renvoyerParametre(requete, "CODE_RATTACHEMENT");
        String langue = RequeteUtil.renvoyerParametre(requete, "LANGUE");
        String selection = RequeteUtil.renvoyerParametre(requete, "SELECTION");
        String tri = RequeteUtil.renvoyerParametre(requete, "TRI_DATE");
        String nbJours = RequeteUtil.renvoyerParametre(requete, "JOUR");
        String nombre = RequeteUtil.renvoyerParametre(requete, "NOMBRE");
        String ids = RequeteUtil.renvoyerParametre(requete, "IDS");
        String etatObjet = (String)StringUtils.defaultIfBlank((CharSequence)RequeteUtil.renvoyerParametre(requete, "ETAT_OBJET"), (CharSequence)EtatFiche.EN_LIGNE.toString());
        String codeRedacteur = RequeteUtil.renvoyerParametre(requete, "CODE_REDACTEUR");
        if (sDateDebut.length() == 0) {
            sDateDebut = RequeteUtil.renvoyerParametre(requete, "DATE_ARTICLE_DEBUT");
        }
        if (sDateFin.length() == 0) {
            sDateFin = RequeteUtil.renvoyerParametre(requete, "DATE_ARTICLE_FIN");
        }
        Date dateDebut = null;
        Date dateFin = null;
        String orderDate = "";
        String orderTri = "";
        if (selection.length() > 0) {
            Date today = new Date(System.currentTimeMillis());
            orderDate = "T1.DATE_ARTICLE";
            if ("0003".equals(selection)) {
                dateFin = today;
                orderTri = " DESC";
            } else if ("0004".equals(selection)) {
                dateDebut = today;
                dateFin = today;
            } else if ("0005".equals(selection)) {
                dateDebut = DateUtil.getFirstDayOfWeek(today);
                dateFin = DateUtil.getLastDayOfWeek(today);
            } else if ("0006".equals(selection)) {
                dateDebut = DateUtil.getFirstDayOfMonth(today);
                dateFin = DateUtil.getLastDayOfMonth(today);
            } else if ("0007".equals(selection)) {
                orderDate = "META.META_DATE_MISE_EN_LIGNE";
                orderTri = "DESC";
            }
        } else if (StringUtils.isNotBlank((CharSequence)nbJours)) {
            dateDebut = DateUtil.addDays(new Date(System.currentTimeMillis()), -Integer.parseInt(nbJours));
            dateFin = new Date(System.currentTimeMillis());
            orderDate = "T1.DATE_ARTICLE";
            orderTri = "DESC";
        } else if (StringUtils.isNotBlank((CharSequence)sDateDebut) || StringUtils.isNotBlank((CharSequence)sDateFin)) {
            dateDebut = DateUtil.parseDate(sDateDebut);
            dateFin = DateUtil.parseDate(sDateFin);
            orderDate = "T1.DATE_ARTICLE";
            orderTri = "DESC";
        }
        if ("DATE_DESC".equals(tri)) {
            orderTri = "DESC";
        }
        if ("DATE_ASC".equals(tri)) {
            orderTri = "ASC";
        }
        String order = "T1.ORDRE, T1.TITRE";
        if (orderDate.length() > 0) {
            order = orderDate + " " + orderTri + ", " + order;
        }
        return this.select(titre, dateDebut, dateFin, thematique, codeRubrique, codeRattachement, etatObjet, langue, codeRedacteur, nombre, order, ids, code);
    }

    @Override
    public String getReferences() {
        String res = FicheUnivMgr.getReferenceParPhoto(this.getIdVignette()) + FicheUnivMgr.getReferenceParTexte(this.getCorps()) + FicheUnivMgr.getReferenceParJointure("structure", this.getCodeRattachement());
        try {
            res = res + FicheUnivMgr.getReferenceParListePhoto(this.getListeFichiers()) + FicheUnivMgr.getReferenceParListePhoto(this.getListeFichiersIndices());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public int select(String titre, Date dateDebut, Date dateFin, String thematique, String codeRubrique, String codeRattachement, String etatObjet, String langue, String codeRedacteur, String nombre, String ordre, String ids, String code) throws Exception {
        this.currentSelect = ((ArticleDAO)this.commonDao).select(this, titre, dateDebut, dateFin, thematique, codeRubrique, codeRattachement, etatObjet, langue, codeRedacteur, nombre, ordre, ids, code);
        this.currentSelectIt = this.currentSelect.iterator();
        return this.currentSelect.size();
    }

    public String getLibelleBackOffice() {
        return this.getLibelleAffichable() + " [" + Rubrique.getIntitule(this.getCodeRubrique()) + "]";
    }

    public String getContenu() {
        return this.getCorps();
    }

    @Override
    public Node exportNodeFiche(Node liste, String formatExport) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        Document document = liste.getOwnerDocument();
        Element fiche = document.createElement("ARTICLE");
        NodeUtil.addNode((Node)fiche, "CODE", this.getCode());
        NodeUtil.addNode((Node)fiche, "LANGUE", this.getLangue());
        NodeUtil.addNode((Node)fiche, "RATTACHEMENT", Structure.getLibelleRattachement(ctx, this.getCodeRattachement(), this.getLangue(), true));
        NodeUtil.addNode((Node)fiche, "LIBELLE", this.getLibelleAffichable());
        NodeUtil.addNode((Node)fiche, "TITRE", this.getTitre());
        NodeUtil.addNode((Node)fiche, "SOUS_TITRE", this.getTitre());
        NodeUtil.addNode((Node)fiche, "DATE_ARTICLE", Formateur.formaterDate(this.getDateArticle(), ""));
        NodeUtil.addNode((Node)fiche, "CHAPEAU", this.getChapeau());
        NodeUtil.addNode((Node)fiche, "CORPS", this.getCorps());
        NodeUtil.addNode((Node)fiche, "URL_VIGNETTE", Media.getMedia(this.getIdVignette()).getUrlAbsolue());
        NodeUtil.addNode((Node)fiche, "CODE_RUBRIQUE", this.getCodeRubrique());
        NodeUtil.addNode((Node)fiche, "RUBRIQUE", Rubrique.renvoyerItemRubrique(this.getCodeRubrique()).getIntitule());
        return fiche;
    }

    @Override
    public String getDiffusionModeRestriction() {
        return ((ArticleBean)this.persistenceBean).getDiffusionModeRestriction();
    }

    @Override
    public void setDiffusionModeRestriction(String diffusionModeRestriction) {
        ((ArticleBean)this.persistenceBean).setDiffusionModeRestriction(diffusionModeRestriction);
    }

    @Override
    public String getDiffusionPublicVise() {
        return ((ArticleBean)this.persistenceBean).getDiffusionPublicVise();
    }

    @Override
    public void setDiffusionPublicVise(String diffusionPublicVise) {
        ((ArticleBean)this.persistenceBean).setDiffusionPublicVise(diffusionPublicVise);
    }

    @Override
    public String getDiffusionPublicViseRestriction() {
        return ((ArticleBean)this.persistenceBean).getDiffusionPublicViseRestriction();
    }

    @Override
    public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
        ((ArticleBean)this.persistenceBean).setDiffusionPublicViseRestriction(diffusionPublicViseRestriction);
    }
}

