/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.PropertyHelper;
import com.univ.collaboratif.bean.UserRolesCollaboratifBean;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.NiveauPerimetre;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.Chaine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutorisationBean {
    public static final int INDICE_CREATION = 0;
    public static final int INDICE_TRADUCTION = 1;
    public static final int INDICE_MODIFICATION = 2;
    public static final int INDICE_VALIDATION = 3;
    public static final int INDICE_SUPPRESSION = 4;
    public static final int INDICE_APPROBATION = 5;
    public static final int INDICE_MISE_EN_LIGNE_UNITAIRE = 6;
    public static final int INDICE_SUPPRESSION_UNITAIRE = 7;
    private static final Logger LOG = LoggerFactory.getLogger(AutorisationBean.class);
    private static final Hashtable<String, String> listeNiveauxApprobation = AutorisationBean.chargerNiveauxApprobation();
    private static final TreeSet<String> listePermissionsValidation = new TreeSet<String>(listeNiveauxApprobation.keySet());
    private final Hashtable<String, Vector<Perimetre>> listePermissions = new Hashtable();
    @Deprecated
    private final TreeSet<String> listeEspaces = new TreeSet();
    @Deprecated
    private final Vector<String> listeEspacesDontModerateur = new Vector();
    @Deprecated
    private final Vector<String> listeEspacesDontVisiteur = new Vector();
    private String niveauApprobation = "";
    private Vector<String> listeGroupes = null;
    private boolean possedeModeExpert = false;
    private String code = "";
    private String codeStructure = "";
    private Hashtable<String, String> listeObjetsRedacteur = null;
    private boolean isWebMaster = false;
    @Deprecated
    private boolean isRelaiComposante = false;
    private boolean isValidateur = false;
    private boolean isDiffuseurDSI = false;
    private boolean isAdministrateurRubrique = false;
    private boolean isAdministrateurEncadre = false;
    private boolean isAdministrateurPhototheque = false;
    private boolean isRedacteurFicheCourante = false;

    public AutorisationBean(Utilisateur utilisateur, Vector<String> groupesdsi, OMContext _ctx) throws Exception {
        this.initialiserPermissions(utilisateur, groupesdsi, _ctx);
        if (LOG.isDebugEnabled()) {
            this.dumpPermissions();
        }
        this.code = utilisateur.getCode();
        this.listeGroupes = groupesdsi;
        this.codeStructure = utilisateur.getCodeRattachement();
        PermissionBean permission = new PermissionBean("TECH", "mda", "");
        if (this.listePermissions.get(permission.getChaineSerialisee()) != null) {
            this.possedeModeExpert = true;
        }
        Metatag meta = new Metatag();
        meta.setCtx(_ctx);
        this.listeObjetsRedacteur = meta.getListeObjetsRedacteur(this.code);
    }

    public static List<String> getStructuresPerimetreFiche(FicheUniv fiche) {
        String codeRattachementSecondaire = null;
        if (fiche instanceof FicheRattachementsSecondaires) {
            codeRattachementSecondaire = ((FicheRattachementsSecondaires)((Object)fiche)).getCodeRattachementAutres();
        }
        return AutorisationBean.getStructuresPerimetreFiche(ReferentielObjets.getCodeObjet(fiche), fiche.getCode(), fiche.getCodeRattachement(), codeRattachementSecondaire);
    }

    private static List<String> getStructuresPerimetreFiche(String codeObjet, String code, String codeStructure, String codeRattachementAutre) {
        ArrayList<String> codesStructures = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)Structure.renvoyerItemStructure(code).getCode())) {
            codeStructure = code;
        }
        codesStructures.add(codeStructure);
        if (StringUtils.isNotEmpty((CharSequence)codeRattachementAutre) && !"0".equals(PropertyHelper.getCoreProperty("fiche." + ReferentielObjets.getNomObjet(codeObjet) + ".filtre_rattachements_secondaires"))) {
            Enumeration<String> e = Chaine.getVecteurPointsVirgules(codeRattachementAutre).elements();
            while (e.hasMoreElements()) {
                codesStructures.add(e.nextElement());
            }
        }
        return codesStructures;
    }

    @Deprecated
    public static String formaterMgsOperationInterdite() {
        return "Op\u00e9ration non autoris\u00e9e ";
    }

    @Deprecated
    public static String formaterMgsOperationInterdite(String raison) {
        return "Op\u00e9ration non autoris\u00e9e (" + raison + ")";
    }

    private static Hashtable<String, String> chargerNiveauxApprobation() {
        String activationMultiNiveaux = PropertyHelper.getCoreProperty("validation_multi_niveaux.activation");
        Hashtable<String, String> niveauxApprobation = new Hashtable<String, String>();
        if ("1".equals(activationMultiNiveaux)) {
            LOG.debug("Chargement des niveaux d'approbations");
            niveauxApprobation = CodeLibelle.lireTable(null, "permission_validation_fiche", null);
            LOG.debug("Nombre de niveaux d'approbration : {}", (Object)niveauxApprobation.size());
        }
        return niveauxApprobation;
    }

    public static Hashtable<String, String> getListeNiveauxApprobation() {
        return listeNiveauxApprobation;
    }

    public static TreeSet<String> getListePermissionsValidation() {
        return listePermissionsValidation;
    }

    private void initialiserPermissionsRoles(String roles) {
        HashSet<NiveauPerimetre> setNiveauPerimetre = new HashSet<NiveauPerimetre>();
        StringTokenizer st = new StringTokenizer(roles, "[]");
        ArrayList<Object[]> aRoles = new ArrayList<Object[]>(st.countTokens());
        while (st.hasMoreTokens()) {
            Perimetre perimetreRole;
            Perimetre perimetreRoleEffectif;
            String val = st.nextToken();
            int indexPointVirgule = val.indexOf(59);
            if (indexPointVirgule == -1) continue;
            String codeRole = val.substring(0, indexPointVirgule);
            String sPerimetre = val.substring(indexPointVirgule + 1);
            LOG.debug("initialiserPermissionsRoles role = " + codeRole + ";" + sPerimetre);
            Perimetre perimetreAffectation = new Perimetre(sPerimetre);
            InfosRole infosRole = Role.renvoyerItemRole(codeRole);
            if (infosRole.getCode().length() <= 0 || (perimetreRoleEffectif = Perimetre.calculerPerimetrePermission(perimetreAffectation, perimetreRole = new Perimetre(infosRole.getPerimetre()))) == null) continue;
            setNiveauPerimetre.add(new NiveauPerimetre(perimetreRoleEffectif));
            Object[] rolePerimetre = new Object[]{infosRole, perimetreRoleEffectif};
            aRoles.add(rolePerimetre);
        }
        Hashtable<String, NiveauPerimetre> tableNiveauPerimetreInitialise = this.initialiserlisteNiveauPerimetre(setNiveauPerimetre);
        for (Object[] oRolePerimetre : aRoles) {
            InfosRole infosRole = (InfosRole)oRolePerimetre[0];
            Perimetre perimetreRoleEffectif = (Perimetre)oRolePerimetre[1];
            Enumeration<PermissionBean> en = infosRole.getVecteurPermissions().elements();
            NiveauPerimetre niveauPerimetreEffectif = tableNiveauPerimetreInitialise.get(perimetreRoleEffectif.getIdentifiantNiveau());
            while (en.hasMoreElements()) {
                PermissionBean permission = en.nextElement();
                if (perimetreRoleEffectif.getCodeEspaceCollaboratif().length() > 0 && (this.isNotPermissionFicheCollab(permission) || this.isNotPermissionGestionCollab(permission))) continue;
                Vector<Perimetre> listePerimetres = this.listePermissions.get(permission.getChaineSerialisee());
                if (listePerimetres == null) {
                    listePerimetres = new Vector(0);
                }
                boolean perimetreAInserer = true;
                for (int i = 0; i < listePerimetres.size(); ++i) {
                    if (!perimetreAInserer) continue;
                    Perimetre perimetreCourant = listePerimetres.get(i);
                    if (perimetreRoleEffectif.getCodeEspaceCollaboratif().length() != 0) continue;
                    NiveauPerimetre niveauPerimetreCourant = tableNiveauPerimetreInitialise.get(perimetreCourant.getIdentifiantNiveau());
                    boolean estEnfant = niveauPerimetreCourant.getLstEnfant().contains(niveauPerimetreEffectif);
                    boolean estParent = niveauPerimetreCourant.getLstParent().contains(niveauPerimetreEffectif);
                    if (estEnfant) {
                        perimetreAInserer = false;
                    }
                    if (!estParent || estEnfant) continue;
                    listePerimetres.remove(i);
                    --i;
                }
                if (perimetreAInserer) {
                    listePerimetres.add(perimetreRoleEffectif);
                }
                this.listePermissions.put(permission.getChaineSerialisee(), listePerimetres);
            }
        }
    }

    private boolean isNotPermissionGestionCollab(PermissionBean permission) {
        return "TECH".equals(permission.getType()) && !"ges".equals(permission.getObjet());
    }

    private boolean isNotPermissionFicheCollab(PermissionBean permission) {
        Objetpartage objet = ReferentielObjets.getObjetByCode(permission.getObjet());
        return "FICHE".equals(permission.getType()) && (objet == null || !objet.isCollaboratif());
    }

    private Hashtable<String, NiveauPerimetre> initialiserlisteNiveauPerimetre(HashSet<NiveauPerimetre> setNiveauPerimetre) {
        Hashtable<String, NiveauPerimetre> tableNiveauPerimetre = new Hashtable<String, NiveauPerimetre>();
        HashSet<NiveauPerimetre> perimetresTests = new HashSet<NiveauPerimetre>(setNiveauPerimetre);
        for (NiveauPerimetre niveauPerimetre : setNiveauPerimetre) {
            NiveauPerimetre niveauPerimetreCourant = niveauPerimetre;
            if (niveauPerimetreCourant.getCodeEspaceCollaboratif().length() == 0) {
                for (NiveauPerimetre niveauPerimetre2 : perimetresTests) {
                    NiveauPerimetre niveauPerimetreTest = niveauPerimetre2;
                    int niveau = niveauPerimetreCourant.getNiveauPerimetre(niveauPerimetreTest);
                    if (niveau == NiveauPerimetre.EGAL || niveau == NiveauPerimetre.DESSOUS) {
                        niveauPerimetreCourant.ajouteParent(niveauPerimetreTest);
                    }
                    if (niveau != NiveauPerimetre.EGAL && niveau != NiveauPerimetre.DESSUS) continue;
                    niveauPerimetreCourant.ajouteEnfant(niveauPerimetreTest);
                }
            }
            tableNiveauPerimetre.put(niveauPerimetreCourant.toString(), niveauPerimetreCourant);
        }
        return tableNiveauPerimetre;
    }

    @Deprecated
    public void calculerListeEspaceDontModerateur() throws Exception {
        for (String codeEspace : this.listeEspaces) {
            boolean ajouterEspace = false;
            Enumeration<String> e = this.listePermissions.keys();
            while (!ajouterEspace && e.hasMoreElements()) {
                Vector<Perimetre> listePerimetres;
                String key = e.nextElement();
                PermissionBean permission = new PermissionBean(key);
                if (!permission.getType().equals("FICHE") || !permission.getAction().equals("V") || (listePerimetres = this.listePermissions.get(permission.getChaineSerialisee())) == null) continue;
                for (int i = 0; !ajouterEspace && i < listePerimetres.size(); ++i) {
                    Perimetre perimetreCourant = listePerimetres.get(i);
                    if (!perimetreCourant.getCodeEspaceCollaboratif().equals(codeEspace)) continue;
                    boolean validationParMembres = false;
                    Vector<String> vCodesRoles = Espacecollaboratif.renvoyerRolesTousLesMembres(codeEspace);
                    Enumeration<String> eCodesRoles = vCodesRoles.elements();
                    while (eCodesRoles.hasMoreElements()) {
                        String codeRole = eCodesRoles.nextElement();
                        InfosRole infosRole = Role.renvoyerItemRole(codeRole);
                        Enumeration<PermissionBean> ePermissionsMembres = infosRole.getVecteurPermissions().elements();
                        while (ePermissionsMembres.hasMoreElements()) {
                            PermissionBean permissionMembre = ePermissionsMembres.nextElement();
                            if (!permissionMembre.getAction().equals("V") || !permissionMembre.getType().equals("FICHE") || !permissionMembre.getObjet().equals(permission.getObjet())) continue;
                            validationParMembres = true;
                        }
                    }
                    if (validationParMembres) continue;
                    ajouterEspace = true;
                }
            }
            if (!ajouterEspace) continue;
            this.listeEspacesDontModerateur.add(codeEspace);
        }
    }

    @Deprecated
    public void calculerListeEspaceDontVisiteur(OMContext ctx, Vector<String> vGroupeUtilisateur) throws Exception {
        for (InfosEspaceCollaboratif infosEspace : Espacecollaboratif.getListeEspaces()) {
            Vector<String> vGroupeConsultation = Chaine.getVecteurAccolades(infosEspace.getGroupesConsultation());
            for (String groupe : vGroupeUtilisateur) {
                if (!vGroupeConsultation.contains(groupe)) continue;
                this.listeEspacesDontVisiteur.add(infosEspace.getCode());
            }
        }
    }

    @Deprecated
    public void calculerListeEspaceDontVisiteur(Vector<String> vGroupeUtilisateur) throws Exception {
        for (InfosEspaceCollaboratif infosEspace : Espacecollaboratif.getListeEspaces()) {
            Vector<String> vGroupeConsultation = Chaine.getVecteurAccolades(infosEspace.getGroupesConsultation());
            for (String groupe : vGroupeUtilisateur) {
                if (!vGroupeConsultation.contains(groupe)) continue;
                this.listeEspacesDontVisiteur.add(infosEspace.getCode());
            }
        }
    }

    private void initialiserPermissions(Utilisateur utilisateur, Vector<String> groupesUtilisateurs, OMContext ctx) throws Exception {
        String sRoles = utilisateur.getRoles();
        Enumeration<String> e = groupesUtilisateurs.elements();
        HashSet<Object> setGroupesParent = new HashSet<Object>();
        while (e.hasMoreElements()) {
            Object infosGroupe = Groupedsi.renvoyerItemGroupeDsi(e.nextElement());
            Object codeGroupe = ((InfosGroupeDsi)infosGroupe).getCode();
            if (((String)codeGroupe).length() <= 0) continue;
            setGroupesParent.add(codeGroupe);
            LOG.debug("** initialiserPermissions groupe : " + (String)codeGroupe + "role : " + ((InfosGroupeDsi)infosGroupe).getRoles());
            int niveauItemCourant = ((InfosGroupeDsi)infosGroupe).getNiveau();
            for (int niveau = niveauItemCourant - 1; niveau > 0; --niveau) {
                codeGroupe = ((InfosGroupeDsi)infosGroupe).getCodeGroupePere();
                if (((String)codeGroupe).length() > 0) {
                    setGroupesParent.add(codeGroupe);
                }
                infosGroupe = Groupedsi.renvoyerItemGroupeDsi((String)codeGroupe);
            }
        }
        for (Object codeGroupe : setGroupesParent) {
            InfosGroupeDsi infosGroupe = Groupedsi.renvoyerItemGroupeDsi((String)codeGroupe);
            sRoles = sRoles + infosGroupe.getRoles();
        }
        if (Espacecollaboratif.isExtensionActivated()) {
            Map<String, UserRolesCollaboratifBean> rolesEspaces = Espacecollaboratif.getRolesEspacesForUserAndGroup(utilisateur.getCode(), groupesUtilisateurs);
            for (String codeEspace : rolesEspaces.keySet()) {
                this.listeEspaces.add(codeEspace);
                sRoles = sRoles + "[" + rolesEspaces.get(codeEspace).getCodeRole() + ";" + new Perimetre("", "", "", "", codeEspace).getChaineSerialisee() + "]";
            }
        }
        this.initialiserPermissionsRoles(sRoles);
        PermissionBean permission = new PermissionBean("TECH", "wmg", "");
        this.isWebMaster = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "fna", "");
        this.isRelaiComposante = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        e = this.listePermissions.keys();
        while (e.hasMoreElements() && !this.isValidateur) {
            String key = e.nextElement();
            permission = new PermissionBean(key);
            this.isValidateur = "FICHE".equals(permission.getType()) && ("V".equals(permission.getAction()) || permission.getAction().startsWith("A"));
        }
        permission = new PermissionBean("TECH", "dsi", "");
        this.isDiffuseurDSI = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "rub", "C");
        this.isAdministrateurRubrique = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "rub", "S");
        this.isAdministrateurRubrique = this.isAdministrateurRubrique || this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "rub", "M");
        this.isAdministrateurRubrique = this.isAdministrateurRubrique || this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "enc", "M");
        this.isAdministrateurEncadre = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "pho", "C");
        this.isAdministrateurPhototheque = this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "pho", "S");
        this.isAdministrateurPhototheque = this.isAdministrateurPhototheque || this.listePermissions.get(permission.getChaineSerialisee()) != null;
        permission = new PermissionBean("TECH", "pho", "M");
        this.isAdministrateurPhototheque = this.isAdministrateurPhototheque || this.listePermissions.get(permission.getChaineSerialisee()) != null;
    }

    private void dumpPermissions() {
        Enumeration<String> e = this.listePermissions.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            LOG.debug("> permission " + key);
            Vector<Perimetre> listePerimetres = this.listePermissions.get(key);
            for (Perimetre perimetreCourant : listePerimetres) {
                LOG.debug("   p\u00e9rim\u00e8tre " + perimetreCourant.getChaineSerialisee());
            }
        }
    }

    public boolean possedePermission(PermissionBean permission, Perimetre perimetre) {
        boolean res = false;
        Vector<Object> listePerimetres = new Vector();
        String chaineSerialisee = permission.getChaineSerialisee();
        if ("*".equals(permission.getObjet())) {
            List<Objetpartage> objetsPartages = ReferentielObjets.getObjetsPartagesTries();
            for (Objetpartage objetPartage : objetsPartages) {
                chaineSerialisee = permission.getType() + "/" + objetPartage.getCodeObjet() + "/" + permission.getAction();
                if (this.listePermissions.get(chaineSerialisee) == null) continue;
                listePerimetres.addAll((Collection<Object>)this.listePermissions.get(chaineSerialisee));
            }
        } else {
            listePerimetres = this.listePermissions.get(chaineSerialisee);
        }
        if (listePerimetres != null) {
            for (int i = 0; !res && i < listePerimetres.size(); ++i) {
                Perimetre perimetreCourant = (Perimetre)listePerimetres.get(i);
                res = perimetre.getCodeEspaceCollaboratif().length() > 0 ? perimetreCourant.getCodeEspaceCollaboratif().equals(perimetre.getCodeEspaceCollaboratif()) : perimetre.estConformeAuPerimetre(perimetreCourant);
            }
        }
        return res;
    }

    public boolean possedeActionFICHE(String action, Perimetre perimetre) {
        boolean res = false;
        Enumeration<String> e = this.listePermissions.keys();
        while (e.hasMoreElements()) {
            Vector<Perimetre> listePerimetres;
            String key = e.nextElement();
            PermissionBean permission = new PermissionBean(key);
            if (!"FICHE".equals(permission.getType()) || !permission.getAction().equals(action) || (listePerimetres = this.listePermissions.get(permission.getChaineSerialisee())) == null) continue;
            for (int i = 0; !res && i < listePerimetres.size(); ++i) {
                Perimetre perimetreCourant = listePerimetres.get(i);
                if (perimetre.getCodeEspaceCollaboratif().length() > 0) {
                    if (!perimetreCourant.getCodeEspaceCollaboratif().equals(perimetre.getCodeEspaceCollaboratif())) continue;
                    res = true;
                    continue;
                }
                if (!perimetre.estConformeAuPerimetre(perimetreCourant)) continue;
                res = true;
            }
        }
        return res;
    }

    @Deprecated
    public boolean estModerateurEspace(String _codeEspace) {
        return this.listeEspacesDontModerateur.contains(_codeEspace);
    }

    @Deprecated
    public boolean estMembreEspace(String _codeEspace) {
        return this.listeEspaces.contains(_codeEspace);
    }

    @Deprecated
    public boolean estVisiteurEspace(String _codeEspace) {
        return this.listeEspacesDontVisiteur.contains(_codeEspace);
    }

    public boolean possedePermissionPartielleSurPerimetre(PermissionBean permission, Perimetre perimetre) {
        boolean res = false;
        Vector<Object> listePerimetres = new Vector();
        String chaineSerialisee = permission.getChaineSerialisee();
        if ("*".equals(permission.getObjet())) {
            List<Objetpartage> objetsPartages = ReferentielObjets.getObjetsPartagesTries();
            for (Objetpartage objetPartage : objetsPartages) {
                chaineSerialisee = permission.getType() + "/" + objetPartage.getCodeObjet() + "/" + permission.getAction();
                if (this.listePermissions.get(chaineSerialisee) == null) continue;
                listePerimetres.addAll((Collection<Object>)this.listePermissions.get(chaineSerialisee));
            }
        } else {
            listePerimetres = this.listePermissions.get(chaineSerialisee);
        }
        if (listePerimetres != null) {
            for (int i = 0; !res && i < listePerimetres.size(); ++i) {
                Perimetre perimetreCourant = (Perimetre)listePerimetres.get(i);
                res = perimetre.estPartiellementConformeAuPerimetre(perimetreCourant);
            }
        }
        return res;
    }

    public Vector<Perimetre> getListePerimetres(PermissionBean permission) {
        Vector<Perimetre> res = this.listePermissions.get(permission.getChaineSerialisee());
        if (res == null) {
            res = new Vector();
        }
        return res;
    }

    public Hashtable<String, Vector<Perimetre>> getListePermissions() {
        return this.listePermissions;
    }

    public boolean estAutoriseAToutModifier(String _objet) {
        return this.getAutorisation(_objet, 2);
    }

    public boolean estAValider(String _objet) {
        return true;
    }

    public boolean getAutorisation(String objet, int indiceAutorisation) {
        String action = "";
        boolean parcoursNiveauxApprobation = false;
        boolean res = false;
        if (indiceAutorisation == 0) {
            action = "C";
        }
        if (indiceAutorisation == 6) {
            action = "U";
        }
        if (indiceAutorisation == 7) {
            action = "R";
        }
        if (indiceAutorisation == 1) {
            action = "D";
        }
        if (indiceAutorisation == 2) {
            action = "M";
        }
        if (indiceAutorisation == 3) {
            if (listePermissionsValidation.size() > 0) {
                parcoursNiveauxApprobation = true;
            } else {
                action = "V";
            }
        }
        if (indiceAutorisation == 4) {
            action = "S";
        }
        if (parcoursNiveauxApprobation) {
            for (String aListePermissionsValidation : listePermissionsValidation) {
                PermissionBean permission = new PermissionBean("FICHE", objet, aListePermissionsValidation);
                if (this.listePermissions.get(permission.getChaineSerialisee()) == null) continue;
                res = true;
                break;
            }
            action = "V";
        }
        PermissionBean permission = new PermissionBean("FICHE", objet, action);
        return res || this.listePermissions.get(permission.getChaineSerialisee()) != null;
    }

    public boolean possedePermissionTech(String permission) {
        return this.possedePermission(new PermissionBean("TECH", permission, ""));
    }

    public boolean possedePermission(PermissionBean permission) {
        return permission != null && this.listePermissions.get(permission.getChaineSerialisee()) != null;
    }

    public boolean getAutorisationParFiche(FicheUniv fiche, int indiceAutorisation) {
        return this.getAutorisationParFiche(fiche, indiceAutorisation, "");
    }

    public boolean getAutorisationParFiche(FicheUniv fiche, int indiceApprobation, String codeApprobationCourant) {
        String publicVise = null;
        String modeRestriction = null;
        String publicViseRestriction = null;
        String codeRattachementSecondaire = null;
        if (fiche instanceof DiffusionSelective) {
            publicVise = ((DiffusionSelective)((Object)fiche)).getDiffusionPublicVise();
            modeRestriction = ((DiffusionSelective)((Object)fiche)).getDiffusionModeRestriction();
            publicViseRestriction = ((DiffusionSelective)((Object)fiche)).getDiffusionPublicViseRestriction();
        }
        if (fiche instanceof FicheRattachementsSecondaires) {
            codeRattachementSecondaire = ((FicheRattachementsSecondaires)((Object)fiche)).getCodeRattachementAutres();
        }
        return this.getAutorisation(ReferentielObjets.getCodeObjet(fiche), fiche.getCode(), fiche.getCodeRubrique(), fiche.getCodeRattachement(), codeRattachementSecondaire, publicVise, modeRestriction, publicViseRestriction, indiceApprobation, codeApprobationCourant);
    }

    public boolean getAutorisation(String codeObjet, String codeFiche, String codeRubrique, String codeRattachement, String codeRattachementAutre, String publicVise, String modeRestriction, String publicViseResctriction, int indiceAutorisation, String codeApprobation) {
        boolean parcoursNiveauxApprobation = false;
        String action = "";
        if (indiceAutorisation == 0) {
            action = "C";
        } else if (indiceAutorisation == 6) {
            action = "U";
        } else if (indiceAutorisation == 7) {
            action = "R";
        } else if (indiceAutorisation == 1) {
            action = "D";
        } else if (indiceAutorisation == 2) {
            action = "M";
        } else if (indiceAutorisation == 3) {
            Iterator<String> it = listePermissionsValidation.iterator();
            if (it.hasNext() && !"V".equals(codeApprobation)) {
                parcoursNiveauxApprobation = true;
                while (it.hasNext()) {
                    String codePermission = it.next();
                    if ("".equals(codeApprobation)) {
                        action = codePermission;
                        codeApprobation = it.hasNext() ? it.next() : "V";
                        break;
                    }
                    if (!codePermission.equals(codeApprobation)) continue;
                    action = codeApprobation;
                    if (it.hasNext()) {
                        codeApprobation = it.next();
                        continue;
                    }
                    codeApprobation = "V";
                }
            } else {
                action = "V";
            }
        }
        if (indiceAutorisation == 5) {
            action = "".equals(codeApprobation) ? "V" : codeApprobation;
        } else if (indiceAutorisation == 4) {
            action = "S";
        }
        PermissionBean permission = new PermissionBean("FICHE", codeObjet, action);
        List<String> codesStructures = AutorisationBean.getStructuresPerimetreFiche(codeObjet, codeFiche, codeRattachement, codeRattachementAutre);
        ArrayList<String> codesRubriques = new ArrayList<String>();
        if (codeRubrique != null) {
            codesRubriques.add(codeRubrique);
        }
        ArrayList<String> codesPublicsVises = new ArrayList<String>();
        ArrayList<String> codesEspaces = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)modeRestriction)) {
            if ("4".equals(modeRestriction)) {
                codesEspaces.add(publicViseResctriction);
            } else {
                codesPublicsVises.add("/*");
            }
        }
        boolean res = this.getAutorisationPourPerimetresFiche(permission, codesStructures, codesRubriques, codesPublicsVises, codesEspaces);
        if (indiceAutorisation == 3) {
            if (parcoursNiveauxApprobation && res) {
                res = this.getAutorisation(codeObjet, codeFiche, codeRubrique, codeRattachement, codeRattachementAutre, publicVise, modeRestriction, publicViseResctriction, indiceAutorisation, codeApprobation);
            } else {
                this.niveauApprobation = parcoursNiveauxApprobation && !"V".equals(action) ? action : "";
            }
        }
        return res;
    }

    @Deprecated
    public boolean getAutorisationParAction(String objet, String action) {
        return false;
    }

    public boolean getAutorisationPourPerimetresFiche(PermissionBean permission, List<String> _codesStructuresFiche, List<String> _codesRubriquesFiche, List<String> _codesPublicsVisesFiche, List<String> _codesEspacesFiche) {
        Object[] codesEspaces;
        Object[] codesPublicsVises;
        Object[] codesRubriques;
        boolean res = false;
        Object[] codesStructures = _codesStructuresFiche.toArray();
        if (codesStructures.length == 0) {
            codesStructures = new String[]{""};
        }
        if ((codesRubriques = _codesRubriquesFiche.toArray()).length == 0) {
            codesRubriques = new String[]{""};
        }
        if ((codesPublicsVises = _codesPublicsVisesFiche.toArray()).length == 0) {
            codesPublicsVises = new String[]{""};
        }
        if ((codesEspaces = _codesEspacesFiche.toArray()).length == 0) {
            codesEspaces = new String[]{""};
        }
        for (int i = 0; i < codesStructures.length && !res; ++i) {
            for (int j = 0; j < codesRubriques.length && !res; ++j) {
                for (int k = 0; k < codesPublicsVises.length && !res; ++k) {
                    String publicVise = (String)codesPublicsVises[k];
                    String groupe = "";
                    String profil = "";
                    int indiceSeparateur = publicVise.indexOf("/");
                    if (indiceSeparateur != -1) {
                        profil = publicVise.substring(0, indiceSeparateur);
                        groupe = publicVise.substring(indiceSeparateur + 1);
                    }
                    for (int l = 0; l < codesEspaces.length && !res; ++l) {
                        Perimetre perimetreFiche = new Perimetre((String)codesStructures[i], (String)codesRubriques[j], profil, groupe, (String)codesEspaces[l]);
                        if (!this.possedePermission(permission, perimetreFiche)) continue;
                        res = true;
                    }
                }
            }
        }
        return res;
    }

    public boolean estAutoriseADemanderApprobation(FicheUniv fiche, String codeApprobationCourant, String codeApprobationDemande) {
        boolean res = true;
        boolean niveauDemande = false;
        for (String codePermission : listePermissionsValidation) {
            if (!niveauDemande && (codeApprobationCourant.length() == 0 || codePermission.equals(codeApprobationCourant))) {
                niveauDemande = true;
                if (!this.getAutorisationParFiche(fiche, 5, codePermission)) {
                    res = false;
                    break;
                }
            } else if (niveauDemande && !codePermission.equals(codeApprobationDemande) && !this.getAutorisationParFiche(fiche, 5, codePermission)) {
                res = false;
                break;
            }
            if (!codePermission.equals(codeApprobationDemande)) continue;
            break;
        }
        this.niveauApprobation = "V".equals(codeApprobationDemande) ? "" : codeApprobationDemande;
        return res;
    }

    public boolean possedeAutorisationValidation(FicheUniv fiche, String codeApprobationCourant) {
        boolean res = false;
        if ("0002".equals(fiche.getEtatObjet())) {
            res = this.getAutorisationParFiche(fiche, 5, codeApprobationCourant);
        } else {
            for (String aListePermissionsValidation : listePermissionsValidation) {
                if (!this.getAutorisationParFiche(fiche, 5, aListePermissionsValidation)) continue;
                res = true;
                break;
            }
            if (!res) {
                res = this.getAutorisationParFiche(fiche, 5, "V");
            }
        }
        return res;
    }

    public boolean estAutoriseAModifierLaFiche(FicheUniv fiche) {
        return this.estAutoriseAModifierLaFiche(fiche, true);
    }

    public boolean estAutoriseAModifierLaFiche(FicheUniv fiche, boolean enregistrementRubriqueCourante) {
        boolean res = false;
        if (fiche != null) {
            if (enregistrementRubriqueCourante && fiche.getCodeRedacteur().equals(this.code)) {
                res = true;
            } else {
                res = this.getAutorisationParFiche(fiche, 2);
                if (!res && !enregistrementRubriqueCourante) {
                    res = this.getAutorisationParFiche(fiche, 0);
                }
            }
        }
        return res;
    }

    public boolean estAutoriseAModifierLafiche(String codeObjet, String codeFiche, String codeRedacteur, String codeRubrique, String codeRattachement, String codeRattachementAutre, String publicVise, String modeRestriction, String publicViseResctriction, boolean enregistrementRubriqueCourante) {
        boolean res = false;
        if (enregistrementRubriqueCourante && codeRedacteur.equals(this.code)) {
            res = true;
        } else {
            res = this.getAutorisation(codeObjet, codeFiche, codeRubrique, codeRattachement, codeRattachementAutre, publicVise, modeRestriction, publicViseResctriction, 2, "");
            if (!res && !enregistrementRubriqueCourante) {
                res = this.getAutorisation(codeObjet, codeFiche, codeRubrique, codeRattachement, codeRattachementAutre, publicVise, modeRestriction, publicViseResctriction, 0, "");
            }
        }
        return res;
    }

    public boolean estAutoriseASupprimerLaFiche(FicheUniv fiche, boolean inclureSuppressionBrouillons) {
        boolean res = false;
        if (fiche != null) {
            if (inclureSuppressionBrouillons && "0001".equals(fiche.getEtatObjet())) {
                res = true;
            } else if (fiche.getCodeRedacteur().equals(this.getCode()) && this.getAutorisationParFiche(fiche, 7)) {
                res = true;
            } else if (this.getAutorisationParFiche(fiche, 4)) {
                res = true;
            }
        }
        return res;
    }

    public boolean estAutoriseASupprimerLaFiche(FicheUniv fiche) {
        return this.estAutoriseASupprimerLaFiche(fiche, true);
    }

    public String getCode() {
        return this.code;
    }

    public Vector<String> getListeObjets() {
        String key;
        Hashtable<String, String> liste = new Hashtable<String, String>();
        Enumeration<String> e = this.listePermissions.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            PermissionBean permission = new PermissionBean(key);
            if (!"FICHE".equals(permission.getType())) continue;
            liste.put(permission.getObjet(), "");
        }
        e = this.listeObjetsRedacteur.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            liste.put(key, "");
        }
        Vector<String> res = new Vector<String>();
        res.addAll(liste.keySet());
        return res;
    }

    public Vector<String> getListeGroupes() {
        return this.listeGroupes;
    }

    public String getCodeStructure() {
        return this.codeStructure;
    }

    @Deprecated
    public boolean isRelaiComposante() {
        return this.isRelaiComposante;
    }

    public boolean isValidateur() {
        return this.isValidateur;
    }

    public boolean isWebMaster() {
        return this.isWebMaster;
    }

    public boolean isDiffuseurDSI() {
        return this.isDiffuseurDSI;
    }

    public boolean isAdministrateurRubrique() {
        return this.isAdministrateurRubrique;
    }

    @Deprecated
    public TreeSet<String> getListeEspaces() {
        return this.listeEspaces;
    }

    public boolean isAdministrateurEncadre() {
        return this.isAdministrateurEncadre;
    }

    public boolean isAdministrateurPhototheque() {
        return this.isAdministrateurPhototheque;
    }

    public String getNiveauApprobation() {
        return this.niveauApprobation;
    }

    @Deprecated
    public Vector<String> getListeEspacesDontVisiteur() {
        return this.listeEspacesDontVisiteur;
    }

    public boolean possedeModeExpert() {
        return this.possedeModeExpert;
    }

    public boolean isRedacteurFicheCourante() {
        return this.isRedacteurFicheCourante;
    }

    public void setRedacteurFicheCourante(boolean isRedacteurFicheCourante) {
        this.isRedacteurFicheCourante = isRedacteurFicheCourante;
    }
}

