/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.sgbd.EncadreDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Encadre
extends EncadreDB
implements Cloneable {
    private static final long serialVersionUID = 1672741661121689614L;

    public Encadre clone() throws CloneNotSupportedException {
        return (Encadre)super.clone();
    }

    public void init() {
        this.setIdEncadre(new Long(System.currentTimeMillis()));
        this.setIntitule("");
        this.setActif("1");
        this.setLangue("0");
        this.setPoids(new Integer(0));
        this.setContenu("");
        this.setObjets("");
        this.setCode("");
        this.setCodeRattachement("");
        this.setCodeRubrique("");
    }

    public List<String> getVecteurObjets() {
        return Arrays.asList(StringUtils.split((String)this.getObjets(), (String)";"));
    }

    public void setVecteurObjets(Vector<String> v) {
        this.setObjets(StringUtils.defaultString((String)StringUtils.join(v, (String)";")));
    }

    public static Hashtable<String, String> getListeEncadresRecherche() throws Exception {
        Hashtable<String, String> listeEncadresRecherche = new Hashtable<String, String>();
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            if (!ReferentielObjets.gereEncadreRechercheEmbarquable(codeObjet)) continue;
            listeEncadresRecherche.put(codeObjet, ReferentielObjets.getLibelleObjet(codeObjet));
        }
        return listeEncadresRecherche;
    }

    public static ArrayList<Encadre> getListeObjetsEncadres(ContexteUniv _ctx, FicheUniv ficheUniv, String _langue) throws Exception {
        RequeteSQL requeteEncadre;
        int count;
        ArrayList<Encadre> encadres = new ArrayList<Encadre>();
        String codeObjet = "";
        if (ficheUniv != null && ((codeObjet = ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName())) == null || codeObjet.length() == 0)) {
            return encadres;
        }
        Encadre encadre = new Encadre();
        encadre.init();
        encadre.setCtx(_ctx);
        String codeRubrique = _ctx.getCodeRubriquePageCourante();
        String codeStructure = "";
        if (ficheUniv != null) {
            codeStructure = ficheUniv.getCodeRattachement();
        }
        if ((count = encadre.select((requeteEncadre = Encadre.construireRequeteObjetsEncadres(_langue, codeRubrique, codeStructure, codeObjet)).formaterRequete())) > 0) {
            while (encadre.nextItem()) {
                encadres.add(encadre.clone());
            }
        }
        return encadres;
    }

    public static ArrayList<Encadre> getListeObjetsEncadres(String codeRubrique, FicheUniv ficheUniv, String langue) throws Exception {
        ArrayList<Encadre> encadres = new ArrayList<Encadre>();
        String codeObjet = "";
        if (ficheUniv != null && StringUtils.isEmpty((CharSequence)(codeObjet = ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName())))) {
            return encadres;
        }
        Encadre encadre = new Encadre();
        encadre.init();
        try (ContexteDao ctxDao = new ContexteDao();){
            RequeteSQL requeteEncadre;
            int count;
            encadre.setCtx(ctxDao);
            String codeStructure = "";
            if (ficheUniv != null) {
                codeStructure = ficheUniv.getCodeRattachement();
            }
            if ((count = encadre.select((requeteEncadre = Encadre.construireRequeteObjetsEncadres(langue, codeRubrique, codeStructure, codeObjet)).formaterRequete())) > 0) {
                while (encadre.nextItem()) {
                    encadres.add(encadre.clone());
                }
            }
        }
        return encadres;
    }

    private static RequeteSQL construireRequeteObjetsEncadres(String langue, String codeRubrique, String codeStructure, String codeObjet) {
        RequeteSQL requete = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        ClauseOrderBy orderBy = new ClauseOrderBy("POIDS", ClauseOrderBy.SensDeTri.ASC);
        where.setPremiereCondition(ConditionHelper.egalVarchar("ACTIF", "1"));
        if (StringUtils.isEmpty((CharSequence)langue)) {
            langue = "0";
        }
        where.and(ConditionHelper.egalVarchar("LANGUE", langue));
        where.and(Encadre.conditionRubriqueStructureEtObjet(codeRubrique, codeStructure, codeObjet));
        requete.where(where).orderBy(orderBy);
        return requete;
    }

    private static ConditionList conditionRubriqueStructureEtObjet(String codeRubrique, String codeStructure, String codeObjet) {
        ConditionList listeConditionRubStructEtObjet = new ConditionList(ConditionHelper.egalVarchar("OBJETS", ""));
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            listeConditionRubStructEtObjet.or(ConditionHelper.likePourValeursMultiple("OBJETS", "RUB_" + codeRubrique));
            for (int niveau = Rubrique.renvoyerItemRubrique(codeRubrique).getNiveau(); niveau > 1; --niveau) {
                codeRubrique = Rubrique.renvoyerItemRubrique(codeRubrique).getCodeRubriqueMere();
                listeConditionRubStructEtObjet.or(ConditionHelper.likePourValeursMultiple("OBJETS", "RUB_" + codeRubrique));
            }
        }
        listeConditionRubStructEtObjet.or(Encadre.conditionStructure(codeStructure, codeObjet));
        listeConditionRubStructEtObjet.or(ConditionHelper.likePourValeursMultiple("OBJETS", codeObjet + "/"));
        return listeConditionRubStructEtObjet;
    }

    private static ConditionList conditionStructure(String codeStructure, String codeObjet) {
        ConditionList conditionStructure = new ConditionList();
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            conditionStructure.setPremiereCondtion(ConditionHelper.likePourValeursMultiple("OBJETS", "/" + codeStructure));
            conditionStructure.or(ConditionHelper.likePourValeursMultiple("OBJETS", codeObjet + "/" + codeStructure));
            for (int niveau = Structure.renvoyerItemStructure(codeStructure).getNiveau(); niveau > 1; --niveau) {
                codeStructure = Structure.renvoyerItemStructure(codeStructure).getCodeRattachement();
                conditionStructure.or(ConditionHelper.likePourValeursMultiple("OBJETS", "/" + codeStructure));
                conditionStructure.or(ConditionHelper.likePourValeursMultiple("OBJETS", codeObjet + "/" + codeStructure));
            }
        }
        return conditionStructure;
    }

    @Deprecated
    public static ArrayList<String> getListeEncadres(ContexteUniv ctx, FicheUniv ficheUniv, String langue) throws Exception {
        ArrayList<String> a = new ArrayList<String>();
        for (Encadre encadre : Encadre.getListeObjetsEncadres(ctx.getCodeRubriquePageCourante(), ficheUniv, langue)) {
            a.add(encadre.getContenu());
        }
        return a;
    }

    public static ArrayList<String> getListeEncadres(String codeRubrique, FicheUniv ficheUniv, String langue) throws Exception {
        ArrayList<String> a = new ArrayList<String>();
        for (Encadre encadre : Encadre.getListeObjetsEncadres(codeRubrique, ficheUniv, langue)) {
            a.add(encadre.getContenu());
        }
        return a;
    }
}

