/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

public enum EtatFiche {
    BROUILLON("0001", true),
    A_VALIDER("0002", true),
    EN_LIGNE("0003", true),
    A_SUPPRIMER("0004", false),
    APERCU("0005", false),
    SAUVEGARDE_AUTO("0006", false),
    ARCHIVE("0007", false);

    private String etat;
    private boolean isFront;

    private EtatFiche(String codeEtat, boolean isVisibleInFront) {
        this.etat = codeEtat;
        this.isFront = isVisibleInFront;
    }

    public String getEtat() {
        return this.etat;
    }

    public String toString() {
        return this.etat;
    }

    public static EtatFiche getEtatParCode(String code) {
        for (EtatFiche etatFiche : EtatFiche.values()) {
            if (!etatFiche.getEtat().equals(code)) continue;
            return etatFiche;
        }
        return null;
    }

    public static boolean isEtatPerene(String code) {
        EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
        return EtatFiche.isEtatPerene(etatCourant);
    }

    public static boolean isEtatPerene(EtatFiche etat) {
        return BROUILLON.equals((Object)etat) || A_VALIDER.equals((Object)etat) || EN_LIGNE.equals((Object)etat) || ARCHIVE.equals((Object)etat);
    }

    public static boolean isAValider(String code) {
        EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
        return A_VALIDER.equals((Object)etatCourant);
    }

    public static boolean isEtatEnregistrable(String code) {
        EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
        return !A_VALIDER.equals((Object)etatCourant) && !SAUVEGARDE_AUTO.equals((Object)etatCourant) && !A_SUPPRIMER.equals((Object)etatCourant);
    }

    public boolean isFront() {
        return this.isFront;
    }
}

