/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FicheAnnuaire {
    public static final String NOM_OBJET_ANNUAIRE = "annuaire";
    private static final Logger LOG = LoggerFactory.getLogger(FicheAnnuaire.class);

    public static String checkCode(String _code, String _langue, OMContext _ctx) throws ErreurApplicative, IllegalArgumentException, ClassNotFoundException, InstantiationException, InvocationTargetException, NoSuchMethodException, Exception {
        Chaine.controlerCodeMetier(_code);
        for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
            Object[] params;
            if (!objet.isRecherchable()) continue;
            Class[] classesParam = new Class[]{};
            Class<?> classeObjet = Class.forName(objet.getNomClasse());
            Constructor<?> constructeur = classeObjet.getConstructor(classesParam);
            FicheUniv ficheUniv = (FicheUniv)constructeur.newInstance(params = new Object[0]);
            if (!(ficheUniv instanceof AnnuaireModele)) continue;
            AnnuaireModele annuaire = (AnnuaireModele)ficheUniv;
            annuaire.init();
            annuaire.setCtx(_ctx);
            int count = ficheUniv.selectCodeLangueEtat(_code, _langue, "");
            if (count <= 0) continue;
            ficheUniv.nextItem();
            throw new ErreurApplicative("Ce code est d\u00e9j\u00e0 utilis\u00e9 pour la fiche " + ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv)) + " : " + ficheUniv.getLibelleAffichable());
        }
        return _code;
    }

    public static AnnuaireModele getFicheAnnuaire(OMContext ctx, String code, String langue) throws Exception {
        return FicheAnnuaire.getFicheAnnuaire(code, langue);
    }

    private static AnnuaireModele getFicheAnnuaireParCodeLangue(String code, String langue) throws Exception {
        AnnuaireModele res = null;
        AnnuaireModele annuaire = null;
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
            if (ficheUniv == null || !(ficheUniv instanceof AnnuaireModele)) continue;
            ContexteDao ctx = new ContexteDao();
            Throwable throwable = null;
            try {
                annuaire = (AnnuaireModele)ficheUniv;
                annuaire.init();
                annuaire.setCtx(ctx);
                int count = ficheUniv.selectCodeLangueEtat(code, langue, EtatFiche.EN_LIGNE.getEtat());
                if (count == 0) {
                    count = ficheUniv.selectCodeLangueEtat(code, langue, "");
                }
                if (count <= 0 || !annuaire.nextItem()) continue;
                res = annuaire;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
        return res;
    }

    public static AnnuaireModele getFicheAnnuaire(String code) throws Exception {
        return FicheAnnuaire.getFicheAnnuaireParCodeLangue(code, null);
    }

    public static AnnuaireModele getFicheAnnuaire(String code, String langue) throws Exception {
        String codeFiche = code;
        String langueFiche = langue;
        if (StringUtils.contains((CharSequence)code, (CharSequence)",LANGUE=")) {
            codeFiche = StringUtils.substringBefore((String)code, (String)",LANGUE=");
            langueFiche = StringUtils.substringAfter((String)code, (String)",LANGUE=");
        }
        if (StringUtils.isBlank((CharSequence)langueFiche)) {
            langueFiche = String.valueOf(0);
        }
        return FicheAnnuaire.getFicheAnnuaireParCodeLangue(codeFiche, langueFiche);
    }

    public static List<Objetpartage> getObjetsAnnuaires() {
        ArrayList<Objetpartage> fichesAnnuaires = new ArrayList<Objetpartage>();
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
            if (ficheUniv == null || !(ficheUniv instanceof AnnuaireModele)) continue;
            fichesAnnuaires.add(ReferentielObjets.getObjetByCode(codeObjet));
        }
        return fichesAnnuaires;
    }

    @Deprecated
    public static String getMailto(OMContext ctx, String code, String langue) throws Exception {
        return FicheAnnuaire.getFicheAnnuaire(code, langue).getAdresseMail();
    }

    public static ArrayList<String> getLibellesLiensAnnuaires(OMContext _ctx, String _codes, String _langue) throws Exception {
        ArrayList<String> listeAnnuaires = new ArrayList<String>();
        AnnuaireModele annuaire = null;
        String langue = _langue;
        if (langue == null || langue.length() == 0) {
            langue = "0";
        }
        if (_codes == null || _codes.length() == 0) {
            return listeAnnuaires;
        }
        StringTokenizer st = new StringTokenizer(_codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
                if (ficheUniv == null || !(ficheUniv instanceof AnnuaireModele)) continue;
                String[] values = code.split(",");
                annuaire = (AnnuaireModele)ficheUniv;
                annuaire.init();
                annuaire.setCtx(_ctx);
                int count = ficheUniv.selectCodeLangueEtat(values[0], langue, EtatFiche.EN_LIGNE.getEtat());
                if (count <= 0) continue;
                while (annuaire.nextItem()) {
                    listeAnnuaires.add("<a href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche((ContexteUniv)_ctx, annuaire), _ctx) + "\" title=\"" + annuaire.getLibelleAffichable() + "\">" + annuaire.getLibelleAffichable() + "</a>");
                }
            }
        }
        return listeAnnuaires;
    }

    @Deprecated
    public static String getLibelleAffichable(OMContext ctx, String codes, String langue) throws Exception {
        return FicheAnnuaire.getLibelleAffichable(codes, langue);
    }

    public static String getLibelleAffichable(String codes, String langue) throws Exception {
        ArrayList<CharSequence> res = new ArrayList<CharSequence>();
        if (StringUtils.isEmpty((CharSequence)codes)) {
            return "";
        }
        langue = (String)StringUtils.defaultIfEmpty((CharSequence)langue, (CharSequence)"0");
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            String libelle = null;
            for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
                if (ficheUniv == null || !(ficheUniv instanceof AnnuaireModele)) continue;
                String[] values = code.split(",");
                ContexteDao ctx = new ContexteDao();
                Throwable throwable = null;
                try {
                    AnnuaireModele annuaire = (AnnuaireModele)ficheUniv;
                    annuaire.init();
                    annuaire.setCtx(ctx);
                    int count = ficheUniv.selectCodeLangueEtat(values[0], langue, EtatFiche.EN_LIGNE.getEtat());
                    if (count == 0) {
                        count = ficheUniv.selectCodeLangueEtat(values[0], langue, "");
                    }
                    if (count <= 0) continue;
                    if (!annuaire.nextItem()) break;
                    libelle = annuaire.getLibelleAffichable();
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
            res.add(StringUtils.defaultIfBlank(libelle, (CharSequence)"-"));
        }
        return StringUtils.join(res, (String)";");
    }

    public static String getNomObjetAnnuaireParCodeLangue(String codeObjet, String langue) {
        AnnuaireModele annuaire = null;
        try {
            annuaire = FicheAnnuaire.getFicheAnnuaire(codeObjet, langue);
        }
        catch (Exception e) {
            LOG.error("Erreur lors de la r\u00e9cup\u00e9ration de l'annuaire", (Throwable)e);
        }
        if (annuaire != null) {
            return ReferentielObjets.getNomObjet(annuaire);
        }
        return "";
    }
}

