/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.EscapeString;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FicheObjetHelper {
    public static void updateAll(OMContext ctx, FicheUniv ficheUniv, String classeObjet, Long idMeta) throws Exception {
        String codeObjet = ReferentielObjets.getCodeObjetParClasse(classeObjet);
        FicheUniv ficheObjet = ReferentielObjets.instancierFiche(codeObjet);
        if (ficheObjet instanceof FicheObjet) {
            String codeRattachement = ficheUniv.getCodeRattachement();
            String codeRubrique = ficheUniv.getCodeRubrique();
            String codeRattachementAutres = "";
            if (ficheUniv instanceof FicheRattachementsSecondaires) {
                codeRattachementAutres = ((FicheRattachementsSecondaires)((Object)ficheUniv)).getCodeRattachementAutres();
            }
            String publicVise = "";
            String publicModeRestriction = "";
            String publicViseRestriction = "";
            if (ficheUniv instanceof DiffusionSelective) {
                publicVise = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicVise();
                publicModeRestriction = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction();
                publicViseRestriction = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction();
            }
            String etatObjet = ficheUniv.getEtatObjet();
            try (Statement _stmt = null;){
                ClauseWhere whereIdMeta = new ClauseWhere(ConditionHelper.egal("ID_META", idMeta, TypeOperande.LONG));
                String query = "SELECT ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMeta.formaterSQL();
                _stmt = ctx.getConnection().prepareStatement(query);
                ResultSet rs = _stmt.executeQuery();
                ArrayList<String> idsMeta = new ArrayList<String>();
                while (rs.next()) {
                    idsMeta.add(EscapeString.escapeSqlValue(String.valueOf(rs.getLong(1))));
                }
                rs.close();
                if (CollectionUtils.isNotEmpty(idsMeta)) {
                    query = "UPDATE " + ReferentielObjets.getNomTableSql(codeObjet) + " SET ETAT_OBJET='" + EscapeString.escapeSqlValue(etatObjet) + "', CODE_RUBRIQUE='" + EscapeString.escapeSql(codeRubrique) + "', CODE_RATTACHEMENT='" + EscapeString.escapeSqlValue(codeRattachement) + "', CODE_RATTACHEMENT_AUTRES='" + EscapeString.escapeSqlValue(codeRattachementAutres) + "', DIFFUSION_PUBLIC_VISE='" + EscapeString.escapeSqlValue(publicVise) + "',DIFFUSION_MODE_RESTRICTION='" + EscapeString.escapeSqlValue(publicModeRestriction) + "', DIFFUSION_PUBLIC_VISE_RESTRICTION='" + EscapeString.escapeSqlValue(publicViseRestriction) + "', DATE_MODIFICATION='" + ficheUniv.getDateModification() + "'  WHERE ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " IN (" + StringUtils.join(idsMeta, (String)" , ") + " ) ";
                    _stmt.close();
                    _stmt = ctx.getConnection().prepareStatement(query);
                    _stmt.executeUpdate();
                    query = "UPDATE METATAG SET META_ETAT_OBJET='" + EscapeString.escapeSqlValue(etatObjet) + "', META_CODE_RUBRIQUE='" + EscapeString.escapeSqlValue(codeRubrique) + "', META_CODE_RATTACHEMENT='" + EscapeString.escapeSqlValue(codeRattachement) + "', META_CODE_RATTACHEMENT_AUTRES='" + EscapeString.escapeSqlValue(codeRattachementAutres) + "', META_DIFFUSION_PUBLIC_VISE='" + EscapeString.escapeSqlValue(publicVise) + "',META_DIFFUSION_MODE_RESTRICTION='" + EscapeString.escapeSqlValue(publicModeRestriction) + "', META_DIFFUSION_PUBLIC_VISE_RESTRICTION='" + EscapeString.escapeSqlValue(publicViseRestriction) + "',  META_DATE_MODIFICATION='" + ficheUniv.getDateModification() + "' WHERE META_ID_FICHE IN (" + StringUtils.join(idsMeta, (String)" , ") + ") AND META_CODE_OBJET='" + EscapeString.escapeSqlValue(codeObjet) + "'";
                    _stmt.close();
                    _stmt = ctx.getConnection().prepareStatement(query);
                    _stmt.executeUpdate();
                    _stmt.close();
                }
            }
        }
    }

    public static void deleteAll(OMContext ctx, String classeObjet, Long idMeta) throws Exception {
        String codeObjet = ReferentielObjets.getCodeObjetParClasse(classeObjet);
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
        if (ficheUniv instanceof FicheObjet) {
            PreparedStatement _stmt = null;
            try {
                ClauseWhere whereIdMeta = new ClauseWhere(ConditionHelper.egal("ID_META", idMeta, TypeOperande.LONG));
                String query = "SELECT ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMeta.formaterSQL();
                _stmt = ctx.getConnection().prepareStatement(query);
                ResultSet rs = _stmt.executeQuery();
                ArrayList<String> idsMeta = new ArrayList<String>();
                while (rs.next()) {
                    idsMeta.add(String.valueOf(rs.getLong(1)));
                }
                rs.close();
                if (CollectionUtils.isNotEmpty(idsMeta)) {
                    ClauseWhere whereIdMetaIn = new ClauseWhere(ConditionHelper.in("ID_" + ReferentielObjets.getNomTableSql(codeObjet), idsMeta));
                    query = "DELETE FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMetaIn.formaterSQL();
                    _stmt = ctx.getConnection().prepareStatement(query);
                    _stmt.executeUpdate();
                    ClauseWhere whereIdMetaInAndCodeObjet = new ClauseWhere(ConditionHelper.in("META_ID_FICHE", idsMeta));
                    whereIdMetaInAndCodeObjet.and(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
                    query = "DELETE FROM METATAG " + whereIdMetaInAndCodeObjet.formaterSQL();
                    _stmt = ctx.getConnection().prepareStatement(query);
                    _stmt.executeUpdate();
                }
                _stmt.close();
            }
            catch (SQLException exc) {
                throw new Exception("ERROR_IN_METHOD FicheNonLisibleHelper.deleteGlobal() " + exc);
            }
            finally {
                _stmt = null;
            }
        }
    }
}

