/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.RequeteGroupeDynamiqueSynchronisable;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.SynchronisationGroupeDynamiqueData;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupeDynamiqueDeStructure
extends RequeteGroupeDynamiqueSynchronisable {
    private static final String NOM_REQUETE = "req_structure";
    private static final Logger LOG = LoggerFactory.getLogger(GroupeDynamiqueDeStructure.class);

    public GroupeDynamiqueDeStructure() {
        this.setNomRequete(NOM_REQUETE);
    }

    @Override
    protected boolean estGereParReqDyn(String requeteGroupe) {
        return true;
    }

    @Override
    protected Vector<String> getGroupesUtilisateur(String codeUtilisateur) throws Exception {
        LOG.debug("D\u00e9but de requete dynamique de structure : getGroupesUtilisateur (" + codeUtilisateur + ")");
        Vector<String> vGroupes = new Vector<String>();
        try (ContexteDao ctx = new ContexteDao();){
            Utilisateur user = Utilisateur.getUtilisateur(codeUtilisateur);
            if (!"".equals(user.getCodeRattachement())) {
                Groupedsi groupeDsi = new Groupedsi();
                groupeDsi.setCtx(ctx);
                HashSet<String> hsGroupes = new HashSet<String>();
                String codeRattachement = user.getCodeRattachement();
                ClauseWhere whereRequeteLDAP = new ClauseWhere();
                whereRequeteLDAP.setPremiereCondition(ConditionHelper.likePourValeursMultiple("REQUETE_LDAP", codeRattachement));
                groupeDsi.select(whereRequeteLDAP.formaterSQL());
                while (groupeDsi.nextItem()) {
                    hsGroupes.add(groupeDsi.getCode());
                }
                vGroupes.addAll(hsGroupes);
            }
        }
        return vGroupes;
    }

    @Override
    protected Vector<String> getVecteurUtilisateurs(String codeGroupe) throws Exception {
        LOG.debug("Debut de requete dynamique : getVecteurUtilisateur (" + codeGroupe + ")");
        Vector<String> vUtilisateurs = new Vector<String>();
        try (ContexteDao ctx = new ContexteDao();){
            Groupedsi groupeDsi = new Groupedsi();
            groupeDsi.setCtx(ctx);
            if (groupeDsi.select(codeGroupe, "", "", "", "") > 0) {
                groupeDsi.nextItem();
                HashSet<String> hsUtilisateurs = new HashSet<String>();
                StringTokenizer stCodesStructures = new StringTokenizer(groupeDsi.getRequeteLdap(), ";");
                Utilisateur user = new Utilisateur();
                user.init();
                user.setCtx(ctx);
                while (stCodesStructures.hasMoreTokens()) {
                    if (user.select("", "", "", "", "", "", stCodesStructures.nextToken(), "") <= 0) continue;
                    while (user.nextItem()) {
                        hsUtilisateurs.add(user.getCode());
                    }
                }
                vUtilisateurs.addAll(hsUtilisateurs);
            }
        }
        LOG.debug("Fin de requete dynamique : getVecteurUtilisateur (" + codeGroupe + ")");
        return vUtilisateurs;
    }

    @Override
    protected Map<String, SynchronisationGroupeDynamiqueData> getDataToSynchronize() throws Exception {
        Structure.forcerRechargement();
        InfosStructure infosStructureRoot = Structure.getTopLevelStructure(this.getCurrentLanguage());
        Collection<InfosStructure> listeStructure = infosStructureRoot.getListeSousStructuresTousNiveaux();
        if (listeStructure != null) {
            HashMap<String, SynchronisationGroupeDynamiqueData> returnMap = new HashMap<String, SynchronisationGroupeDynamiqueData>();
            for (InfosStructure structure : listeStructure) {
                String codeStructure = structure.getCode();
                if (codeStructure == null) continue;
                SynchronisationGroupeDynamiqueData syncData = new SynchronisationGroupeDynamiqueData(codeStructure, structure.getLibelleAffichable());
                syncData.setCodeDuParent(structure.getCodeRattachement());
                returnMap.put(codeStructure, syncData);
            }
            return returnMap;
        }
        return null;
    }

    @Override
    public void preparerPRINCIPAL(InfoBean infoBean, Groupedsi groupe) throws Exception {
        if (groupe.getRequeteGroupe().length() > 0 && groupe.getRequeteGroupe().equals(this.getNomRequete())) {
            infoBean.set("REQUETE_LDAP_" + groupe.getRequeteGroupe(), groupe.getRequeteLdap());
            infoBean.set("REQUETE_LDAP_" + this.getNomRequete(), groupe.getRequeteLdap());
            String libellesStructure = "";
            StringTokenizer stCodesStructures = new StringTokenizer(groupe.getRequeteLdap(), ";");
            String langue = this.getCurrentLanguage();
            while (stCodesStructures.hasMoreTokens()) {
                libellesStructure = libellesStructure + Structure.getLibelleAffichable(stCodesStructures.nextToken(), langue) + ";";
            }
            infoBean.set("LIBELLE_REQUETE_LDAP_" + this.getNomRequete(), libellesStructure);
            infoBean.set("INFOBULLE_REQUETE_LDAP_" + this.getNomRequete(), libellesStructure);
        }
    }

    private String getCurrentLanguage() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        Locale currentLocale = LangueUtil.getDefaultLocale();
        if (ctx != null) {
            currentLocale = ctx.getLocale();
        }
        return LangueUtil.getLangueLocale(currentLocale);
    }
}

