/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRequeteGroupe;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.sgbd.GroupedsiDB;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.xhtml.JavascriptTreeGroupedsi;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Groupedsi
extends GroupedsiDB
implements Cloneable {
    public static final String CODE_GROUPE_ROOT = "00";

    public void init() {
        this.setIdGroupedsi(0L);
        this.setCode(String.valueOf(System.currentTimeMillis()));
        this.setLibelle("");
        this.setType("");
        this.setCodePageTete("");
        this.setCodeStructure("");
        this.setRoles("");
        this.setCodeGroupePere("");
        this.setSourceImport("");
        this.setRequeteGroupe("");
        this.setRequeteLdap("");
        this.setGestionCache("0");
        Long tsInit = 0L;
        this.setDelaiExpirationCache(tsInit);
        this.setDerniereMajCache(tsInit);
        this.setSelectionnable("1");
    }

    @Deprecated
    public static String getIntitule(OMContext _ctx, String _code) {
        return Groupedsi.getIntitule(_code);
    }

    public static String getIntitule(String _code) {
        String res = "";
        if (_code == null || _code.length() == 0) {
            return res;
        }
        StringTokenizer st = new StringTokenizer(_code, ";");
        while (st.hasMoreTokens()) {
            String intitule;
            String code = st.nextToken();
            if (res.length() > 0) {
                res = res + ";";
            }
            if ((intitule = Groupedsi.renvoyerItemGroupeDsi(code).getIntitule()).length() == 0) {
                intitule = MessageHelper.getCoreMessage("BO_GROUPE_INEXISTANT");
            }
            res = res + intitule;
        }
        return res;
    }

    private static Map<String, InfosGroupeDsi> getListeGroupesDsi() {
        CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
        return cache.getListeGroupesDsi();
    }

    public static Map<String, InfosRequeteGroupe> getListeRequetesGroupes() {
        CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
        return cache.getListeRequetesGroupes();
    }

    public static Vector<InfosGroupeDsi> renvoyerCodesGroupeDsiParType(String _type) {
        Vector<InfosGroupeDsi> res = new Vector<InfosGroupeDsi>();
        for (InfosGroupeDsi info : Groupedsi.getListeGroupesDsi().values()) {
            if (!info.getType().equalsIgnoreCase(_type)) continue;
            res.add(info);
        }
        return res;
    }

    public static InfosGroupeDsi renvoyerItemGroupeDsi(String code) {
        InfosGroupeDsi res = Groupedsi.getListeGroupesDsi().get(code);
        if (res == null) {
            res = new InfosGroupeDsi();
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, Vector<Perimetre>> renvoyerGroupesEtPerimetres(OMContext _ctx, String _role, List<String> codesStructures, String _codeRubrique, String _publicsVises, String _codeEspaceCollaboratif) throws Exception {
        Hashtable<String, Vector<Perimetre>> h = new Hashtable<String, Vector<Perimetre>>();
        for (InfosGroupeDsi info : Groupedsi.getListeGroupesDsi().values()) {
            Vector<Perimetre> v = Role.renvoyerPerimetresAffectation(info.getRoles(), _role, codesStructures, _codeRubrique, _publicsVises, _codeEspaceCollaboratif);
            if (v.size() <= 0) continue;
            h.put(info.getCode(), v);
        }
        return h;
    }

    public static Hashtable<String, Vector<Perimetre>> renvoyerGroupesEtPerimetres(String _role, List<String> codesStructures, String _codeRubrique, String _publicsVises, String _codeEspaceCollaboratif) throws Exception {
        Hashtable<String, Vector<Perimetre>> h = new Hashtable<String, Vector<Perimetre>>();
        for (InfosGroupeDsi info : Groupedsi.getListeGroupesDsi().values()) {
            Vector<Perimetre> v = Role.renvoyerPerimetresAffectation(info.getRoles(), _role, codesStructures, _codeRubrique, _publicsVises, _codeEspaceCollaboratif);
            if (v.size() <= 0) continue;
            h.put(info.getCode(), v);
        }
        return h;
    }

    public int select(String code, String type, String libelle, String codeStructure, String gestionCache) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        ClauseOrderBy orderBy = new ClauseOrderBy("LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)type) && !"0000".equals(type)) {
            where.and(ConditionHelper.egalVarchar("TYPE", type));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.rechercheMots("LIBELLE", libelle));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            where.and(ConditionHelper.getConditionStructure("CODE_STRUCTURE", codeStructure));
        }
        if (StringUtils.isNotEmpty((CharSequence)gestionCache)) {
            where.and(ConditionHelper.egalVarchar("GESTION_CACHE", gestionCache));
        }
        requeteSelect.where(where).orderBy(orderBy);
        return this.select(requeteSelect.formaterRequete());
    }

    @Deprecated
    public static Hashtable<String, String> getListeRequetesGroupesPourAffichage(OMContext _ctx) {
        return Groupedsi.getListeRequetesGroupesPourAffichage();
    }

    public static Hashtable<String, String> getListeRequetesGroupesPourAffichage() {
        Hashtable<String, String> res = new Hashtable<String, String>();
        for (InfosRequeteGroupe info : Groupedsi.getListeRequetesGroupes().values()) {
            res.put(info.getAlias(), info.getIntitule());
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getInfosRequete(OMContext _ctx) {
        Hashtable<String, String> res = new Hashtable<String, String>();
        for (InfosRequeteGroupe info : Groupedsi.getListeRequetesGroupes().values()) {
            res.put(info.getAlias(), info.getIntitule());
        }
        return res;
    }

    public static InfosRequeteGroupe renvoyerItemRequeteGroupe(String code) {
        InfosRequeteGroupe res = Groupedsi.getListeRequetesGroupes().get(code);
        if (res == null) {
            res = new InfosRequeteGroupe();
        }
        return res;
    }

    @Deprecated
    public static Vector<InfosGroupeDsi> getListeGroupesDynamiques(OMContext _ctx) {
        return Groupedsi.getListeGroupesDynamiques();
    }

    public static Vector<InfosGroupeDsi> getListeGroupesDynamiques() {
        Vector<InfosGroupeDsi> res = new Vector<InfosGroupeDsi>();
        for (InfosGroupeDsi info : Groupedsi.getListeGroupesDsi().values()) {
            if (info.getRequete().equals("")) continue;
            res.add(info);
        }
        return res;
    }

    @Deprecated
    public static Collection<InfosGroupeDsi> getListeGroupesPrincipaux() {
        return Groupedsi.getTopLevelGroupedsi().getListeSousGroupes();
    }

    private static InfosGroupeDsi getTopLevelGroupedsi() {
        return Groupedsi.getListeGroupesDsi().get(CODE_GROUPE_ROOT);
    }

    public static boolean controlerPermission(AutorisationBean autorisations, String sPermission, String codeGroupe) {
        PermissionBean permission = new PermissionBean(sPermission);
        Perimetre perimetre = new Perimetre("", "", "", codeGroupe, "");
        return autorisations.possedePermissionPartielleSurPerimetre(permission, perimetre);
    }

    public static String getArbreJavaScript(String code, AutorisationBean autorisations, String sPermission) throws Exception {
        if (code == null || code.length() == 0) {
            code = CODE_GROUPE_ROOT;
        }
        JavascriptTreeGroupedsi tree = new JavascriptTreeGroupedsi(autorisations, sPermission);
        tree.load(Groupedsi.getTopLevelGroupedsi(), Groupedsi.renvoyerItemGroupeDsi(code));
        return tree.print();
    }

    public static String getFilAriane(String codeGroupe, String separateur) {
        String filAriane = "";
        try {
            if (separateur.length() == 0) {
                separateur = "&gt;";
            }
            InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
            while (groupe.getNiveau() > 0) {
                if (filAriane.length() > 0) {
                    filAriane = " " + separateur + " " + filAriane;
                }
                filAriane = groupe.getIntitule() + filAriane;
                groupe = groupe.getGroupePere();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filAriane;
    }

    public Groupedsi clone() throws CloneNotSupportedException {
        return (Groupedsi)super.clone();
    }
}

