/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.Groupedsi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class InfosGroupeDsi
implements Serializable {
    private static final long serialVersionUID = 7437361262139171837L;
    private Long id = 0L;
    private String code = "";
    private String codeStructure = "";
    private String intitule = "";
    private String codePageTete = "";
    private String roles = "";
    private String codeGroupePere = "";
    private String requete = "";
    private String selectionnable = "";
    private String type = "";
    private int niveau = 0;
    private InfosGroupeDsi groupePere = null;
    private Collection<InfosGroupeDsi> listeSousGroupes = null;
    private Collection<InfosGroupeDsi> listeSousGroupesTousNiveaux = null;

    public InfosGroupeDsi() {
        this.listeSousGroupes = new ArrayList<InfosGroupeDsi>();
    }

    public InfosGroupeDsi(Groupedsi groupe) {
        this.id = groupe.getIdGroupedsi();
        this.code = groupe.getCode();
        this.codeStructure = groupe.getCodeStructure();
        this.intitule = groupe.getLibelle();
        this.type = groupe.getType();
        this.codeGroupePere = groupe.getCodeGroupePere();
        this.codePageTete = groupe.getCodePageTete();
        this.roles = groupe.getRoles();
        this.requete = groupe.getRequeteGroupe();
        this.selectionnable = groupe.getSelectionnable();
        this.listeSousGroupes = new ArrayList<InfosGroupeDsi>();
    }

    public Long getId() {
        return this.id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeStructure() {
        return this.codeStructure;
    }

    public String getRequete() {
        return this.requete;
    }

    public void setRequete(String requete) {
        this.requete = requete;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodePageTete() {
        return this.codePageTete;
    }

    public String getIntitule() {
        return this.intitule;
    }

    public String getType() {
        return this.type;
    }

    public String getRoles() {
        return this.roles;
    }

    public Collection<InfosGroupeDsi> getListeSousGroupes() {
        return this.listeSousGroupes;
    }

    public Collection<InfosGroupeDsi> getListeSousGroupesSortedByLibelle() {
        Iterator<InfosGroupeDsi> listeSousGroupesIt = this.listeSousGroupes.iterator();
        TreeMap<String, InfosGroupeDsi> sortedListeSousGroupes = new TreeMap<String, InfosGroupeDsi>();
        InfosGroupeDsi sousGroupe = null;
        while (listeSousGroupesIt.hasNext()) {
            sousGroupe = listeSousGroupesIt.next();
            sortedListeSousGroupes.put(sousGroupe.getIntitule() + "_" + sousGroupe.getCode(), sousGroupe);
        }
        return sortedListeSousGroupes.values();
    }

    public Collection<InfosGroupeDsi> getListeSousGroupesTousNiveaux() {
        if (this.listeSousGroupesTousNiveaux == null) {
            this.listeSousGroupesTousNiveaux = new ArrayList<InfosGroupeDsi>();
            Iterator<InfosGroupeDsi> listeSousGroupesIt = this.getListeSousGroupes().iterator();
            InfosGroupeDsi sousGroupe = null;
            while (listeSousGroupesIt.hasNext()) {
                sousGroupe = listeSousGroupesIt.next();
                this.listeSousGroupesTousNiveaux.addAll(sousGroupe.getListeSousGroupesTousNiveaux());
                this.listeSousGroupesTousNiveaux.add(sousGroupe);
            }
        }
        return this.listeSousGroupesTousNiveaux;
    }

    public int getNiveau() {
        return this.niveau;
    }

    public String getCodeGroupePere() {
        return this.codeGroupePere;
    }

    public InfosGroupeDsi getGroupePere() {
        return this.groupePere;
    }

    public void addSousGroupe(InfosGroupeDsi sousGroupe) {
        this.listeSousGroupes.add(sousGroupe);
    }

    public void rattacheA(InfosGroupeDsi groupe) {
        this.groupePere = groupe;
        this.groupePere.addSousGroupe(this);
        this.updateNiveau();
    }

    private void updateNiveau() {
        this.niveau = this.groupePere.getNiveau() + 1;
        for (InfosGroupeDsi infosGroupeDsi : this.getListeSousGroupes()) {
            infosGroupeDsi.updateNiveau();
        }
    }

    public boolean contains(InfosGroupeDsi groupe) {
        boolean inFamilia = false;
        while (groupe != null && !inFamilia) {
            if (groupe.equals(this)) {
                inFamilia = true;
                continue;
            }
            groupe = groupe.getGroupePere();
        }
        return inFamilia;
    }

    public String getSelectionnable() {
        return this.selectionnable;
    }

    public boolean isSelectionnable() {
        boolean res = false;
        if ("1".equals(this.selectionnable)) {
            res = true;
        }
        return res;
    }
}

