/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.Preferences;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InfosPreferences {
    private String codeUtilisateur = "";
    private String service = "";
    private String type = "";
    private String nom = "";
    private List<String> valeur = new ArrayList<String>();

    public InfosPreferences(Preferences pref) {
        if (pref != null) {
            this.codeUtilisateur = pref.getCodeUtilisateur();
            this.service = pref.getService();
            this.type = pref.getType();
            this.nom = pref.getNom();
            this.valeur = Preferences.getListeValeurPreference(pref.getValeur());
        }
    }

    public InfosPreferences(String codeUtilisateur, String service, String type, String nom, String valeur) {
        this.codeUtilisateur = codeUtilisateur;
        this.service = service;
        this.type = type;
        this.nom = nom;
        this.valeur = Preferences.getListeValeurPreference(valeur);
    }

    public String getCodeUtilisateur() {
        return this.codeUtilisateur;
    }

    public String getNom() {
        return this.nom;
    }

    public String getService() {
        return this.service;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getValeursAsList() {
        return this.valeur;
    }

    public String getValeursAsString() {
        String value = "";
        for (String val : this.valeur) {
            val = val.replaceAll(";", ";;");
            if ("".equals(value)) {
                value = val;
                continue;
            }
            value = value.concat(";".concat(val));
        }
        return value;
    }

    public void setValeur(Iterator<String> itValeurAInserer) {
        this.valeur.clear();
        if (itValeurAInserer != null) {
            while (itValeurAInserer.hasNext()) {
                this.valeur.add(itValeurAInserer.next());
            }
        }
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof InfosPreferences) {
            equals = this.nom.equals(((InfosPreferences)obj).getNom());
        }
        return equals;
    }

    public int hashCode() {
        return this.nom.hashCode();
    }
}

