/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class InfosRubriques
implements Serializable {
    private static final long serialVersionUID = -8136833859411710834L;
    private Long idRubrique = 0L;
    private String code = "";
    private String codeRubriqueMere = "";
    private String langue = "0";
    private String typeRubrique = "";
    private String pageAccueil = "";
    private String intitule = "";
    private String onglet = "";
    private String accroche = "";
    private String contact = "";
    private String couleurFond = "";
    private String couleurTitre = "";
    private String encadre = "";
    private long idMediaBandeau = 0L;
    private String urlBandeau = "";
    private String ordre = "";
    private String gestionEncadre = "";
    private String categorie = "";
    private boolean encadreSousRubrique = false;
    private int niveau = 0;
    private Set<String> groupesDsi = new HashSet<String>();
    private InfosRubriques rubriqueMere = null;
    private TreeMap<String, InfosRubriques> listeSousRubriques = null;
    private Collection<InfosRubriques> listeSousRubriquesTousNiveaux = null;
    private String urlPicto = "";
    private long idMediaPicto = 0L;

    public InfosRubriques(String code) {
        this.code = code;
        this.listeSousRubriques = new TreeMap();
    }

    public InfosRubriques(Rubrique rubrique) {
        this.idRubrique = rubrique.getIdRubrique();
        this.code = rubrique.getCode();
        this.codeRubriqueMere = rubrique.getCodeRubriqueMere();
        this.langue = rubrique.getLangue();
        this.typeRubrique = rubrique.getTypeRubrique();
        this.pageAccueil = rubrique.getPageAccueil();
        this.intitule = rubrique.getIntitule();
        this.onglet = rubrique.getNomOnglet();
        this.accroche = rubrique.getAccroche();
        this.contact = rubrique.getContact();
        this.couleurTitre = rubrique.getCouleurTitre();
        this.couleurFond = rubrique.getCouleurFond();
        this.encadre = rubrique.getEncadre();
        this.ordre = rubrique.getOrdre();
        this.groupesDsi = Chaine.getHashSetAccolades(rubrique.getGroupesDsi());
        this.gestionEncadre = rubrique.getGestionEncadre();
        this.encadreSousRubrique = "1".equals(rubrique.getEncadreSousRubrique());
        this.listeSousRubriques = new TreeMap();
        this.categorie = rubrique.getCategorie();
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeRubriqueMere() {
        return this.codeRubriqueMere;
    }

    public String getLangue() {
        return this.langue;
    }

    public String getGestionEncadre() {
        return this.gestionEncadre;
    }

    public String getIntitule() {
        return this.intitule;
    }

    @Deprecated
    public String getIntitule(String strSeparateur) {
        String strRes = "";
        strRes = this.intitule.contains(strSeparateur) ? this.intitule.substring(this.intitule.indexOf(strSeparateur) + 1) : this.intitule;
        return strRes;
    }

    public int getNiveau() {
        return this.niveau;
    }

    public String getOnglet() {
        return this.onglet;
    }

    public String getContact() {
        return this.contact;
    }

    public InfosRubriques getRubriqueMere() {
        return this.rubriqueMere;
    }

    public String getTypeRubrique() {
        return this.typeRubrique;
    }

    public String getCouleurFond() {
        return this.couleurFond;
    }

    public String getCouleurTitre() {
        return this.couleurTitre;
    }

    public String getEncadre() {
        return this.encadre;
    }

    public boolean isEncadreSousRubrique() {
        return this.encadreSousRubrique;
    }

    public Long getIdRubrique() {
        return this.idRubrique;
    }

    @Deprecated
    public String getUrlBandeau() {
        return this.urlBandeau;
    }

    @Deprecated
    public void setUrlBandeau(String urlBandeau) {
        this.urlBandeau = urlBandeau;
    }

    public String getAccroche() {
        return this.accroche;
    }

    public String getOrdre() {
        return this.ordre;
    }

    public Set<String> getGroupesDsi() {
        return this.groupesDsi;
    }

    public String getLibelleAffichable() {
        return this.intitule;
    }

    public Collection<InfosRubriques> getListeSousRubriques() {
        return this.listeSousRubriques.values();
    }

    public Collection<InfosRubriques> getListeSousRubriquesTousNiveaux() {
        if (this.listeSousRubriquesTousNiveaux == null) {
            this.listeSousRubriquesTousNiveaux = new ArrayList<InfosRubriques>();
            Iterator<InfosRubriques> listeSousRubriquesIt = this.getListeSousRubriques().iterator();
            InfosRubriques sousRubrique = null;
            while (listeSousRubriquesIt.hasNext()) {
                sousRubrique = listeSousRubriquesIt.next();
                this.listeSousRubriquesTousNiveaux.addAll(sousRubrique.getListeSousRubriquesTousNiveaux());
                this.listeSousRubriquesTousNiveaux.add(sousRubrique);
            }
        }
        return new ArrayList<InfosRubriques>(this.listeSousRubriquesTousNiveaux);
    }

    public Collection<InfosRubriques> getListeSousRubriquesFront(ContexteUniv _ctx) {
        ArrayList<InfosRubriques> lSousRubriquesFront = new ArrayList<InfosRubriques>();
        Collection<InfosRubriques> lSousRubriques = this.getListeSousRubriques();
        Iterator<InfosRubriques> itSousRubriques = lSousRubriques.iterator();
        InfosRubriques sousRubrique = null;
        while (itSousRubriques.hasNext()) {
            sousRubrique = itSousRubriques.next();
            if (!Rubrique.controlerRestrictionRubrique(_ctx, sousRubrique.getCode()) || sousRubrique.getCategorie().toUpperCase().equals("HIDDEN")) continue;
            lSousRubriquesFront.add(sousRubrique);
        }
        return lSousRubriquesFront;
    }

    public void addSousRubrique(InfosRubriques sousRubrique) {
        String ordreSousRub = sousRubrique.getOrdre();
        for (int i = ordreSousRub.length(); i < 4; ++i) {
            ordreSousRub = "0" + ordreSousRub;
        }
        ordreSousRub = ordreSousRub + "_" + sousRubrique.getOnglet() + "_" + sousRubrique.getCode();
        this.listeSousRubriques.put(ordreSousRub, sousRubrique);
    }

    public void rattacheA(InfosRubriques rubrique) {
        this.rubriqueMere = rubrique;
        this.rubriqueMere.addSousRubrique(this);
        this.updateNiveau();
    }

    private void updateNiveau() {
        this.niveau = this.rubriqueMere.getNiveau() + 1;
        for (InfosRubriques infosRubriques : this.getListeSousRubriques()) {
            infosRubriques.updateNiveau();
        }
    }

    public boolean contains(InfosRubriques rubrique) {
        boolean inFamilia = false;
        while (rubrique != null && !inFamilia) {
            if (rubrique.equals(this)) {
                inFamilia = true;
                continue;
            }
            rubrique = rubrique.getRubriqueMere();
        }
        return inFamilia;
    }

    public String getCategorie() {
        return this.categorie;
    }

    public String getPageAccueil() {
        return this.pageAccueil;
    }

    @Deprecated
    public String getUrlPicto() {
        return this.urlPicto;
    }

    @Deprecated
    public void setUrlPicto(String urlPicto) {
        this.urlPicto = urlPicto;
    }

    public long getIdMediaBandeau() {
        return this.idMediaBandeau;
    }

    public void setIdMediaBandeau(long idMediaBandeau) {
        this.idMediaBandeau = idMediaBandeau;
    }

    public long getIdMediaPicto() {
        return this.idMediaPicto;
    }

    public void setIdMediaPicto(long idMediaPicto) {
        this.idMediaPicto = idMediaPicto;
    }
}

