/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public class InfosStructure
implements Serializable {
    private static final long serialVersionUID = 7296998673760536148L;
    private Long idStructure = 0L;
    private String code = "";
    private String codeObjet = "";
    private String codeRattachement = "";
    private String langue = "";
    private String libelleCourt = "";
    private String libelleLong = "";
    private String onglets = "";
    private String couleurTitre = "";
    private String couleurFond = "";
    private String typeStructure = "";
    private String urlBandeau = "";
    private Long idBandeau = 0L;
    private String attributSpecifique1 = "";
    private String attributSpecifique2 = "";
    private String attributSpecifique3 = "";
    private String attributSpecifique4 = "";
    private String attributSpecifique5 = "";
    private boolean visibleInFront = true;
    private InfosStructure structureRattachement = null;
    private Collection<InfosStructure> listeSousStructures = null;
    private Collection<InfosStructure> listeSousStructuresTousNiveaux = null;
    private int niveau = 0;

    public InfosStructure() {
        this.listeSousStructures = new ArrayList<InfosStructure>();
    }

    public InfosStructure(StructureModele structure) {
        this.idStructure = structure.getIdFiche();
        this.code = structure.getCode();
        this.codeObjet = ReferentielObjets.getCodeObjet(structure);
        this.codeRattachement = structure.getCodeRattachement();
        this.langue = structure.getLangue();
        this.libelleCourt = structure.getLibelleCourt();
        this.libelleLong = structure.getLibelleLong();
        this.onglets = structure.getOnglets();
        this.couleurTitre = structure.getCouleurTitre();
        this.couleurFond = structure.getCouleurFond();
        this.typeStructure = structure.getTypeStructure();
        this.listeSousStructures = new ArrayList<InfosStructure>();
        this.idBandeau = structure.getIdBandeau();
        this.attributSpecifique1 = structure.getAttributSpecifique1();
        this.attributSpecifique2 = structure.getAttributSpecifique2();
        this.attributSpecifique3 = structure.getAttributSpecifique3();
        this.attributSpecifique4 = structure.getAttributSpecifique4();
        this.attributSpecifique5 = structure.getAttributSpecifique5();
    }

    public InfosStructure(InfosStructure structure) {
        this.idStructure = structure.getIdStructure();
        this.code = structure.getCode();
        this.codeRattachement = structure.getCodeRattachement();
        this.langue = structure.getLangue();
        this.libelleCourt = structure.getLibelleCourt();
        this.libelleLong = structure.getLibelleLong();
        this.onglets = structure.getOnglets();
        this.couleurTitre = structure.getCouleurTitre();
        this.couleurFond = structure.getCouleurFond();
        this.typeStructure = structure.getTypeStructure();
        this.listeSousStructures = new ArrayList<InfosStructure>();
        this.idBandeau = structure.getIdBandeau();
        this.urlBandeau = structure.getUrlBandeau();
        this.visibleInFront = structure.isVisibleInFront();
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeRattachement() {
        return this.codeRattachement;
    }

    public String getLangue() {
        return this.langue;
    }

    public String getLibelleCourt() {
        return this.libelleCourt;
    }

    public String getLibelleLong() {
        return this.libelleLong;
    }

    public String getOnglets() {
        return this.onglets;
    }

    public String getCouleurTitre() {
        return this.couleurTitre;
    }

    public String getCouleurFond() {
        return this.couleurFond;
    }

    public String getTypeStructure() {
        return this.typeStructure;
    }

    public String getUrlBandeau() {
        return this.urlBandeau;
    }

    public boolean isVisibleInFront() {
        return this.visibleInFront;
    }

    public int getNiveau() {
        return this.niveau;
    }

    public InfosStructure getStructureRattachement() {
        return this.structureRattachement;
    }

    public Collection<InfosStructure> getListeSousStructures() {
        return this.listeSousStructures;
    }

    public Collection<InfosStructure> getListeSousStructuresSortedByLibelleCourt() {
        TreeMap<String, InfosStructure> sortedListeSousStructures = new TreeMap<String, InfosStructure>();
        for (InfosStructure sousStructure : this.listeSousStructures) {
            sortedListeSousStructures.put(sousStructure.getLibelleCourt() + "___" + sousStructure.getCode(), sousStructure);
        }
        return sortedListeSousStructures.values();
    }

    public Collection<InfosStructure> getListeSousStructuresSortedByLibelleLong() {
        TreeMap<String, InfosStructure> sortedListeSousStructures = new TreeMap<String, InfosStructure>();
        for (InfosStructure sousStructure : this.listeSousStructures) {
            sortedListeSousStructures.put(sousStructure.getLibelleLong() + "___" + sousStructure.getCode(), sousStructure);
        }
        return sortedListeSousStructures.values();
    }

    public Collection<InfosStructure> getListeSousStructuresTousNiveaux() {
        if (this.listeSousStructuresTousNiveaux == null) {
            this.listeSousStructuresTousNiveaux = new ArrayList<InfosStructure>();
            for (InfosStructure sousStructure : this.getListeSousStructures()) {
                this.listeSousStructuresTousNiveaux.addAll(sousStructure.getListeSousStructuresTousNiveaux());
                this.listeSousStructuresTousNiveaux.add(sousStructure);
            }
        }
        return this.listeSousStructuresTousNiveaux;
    }

    public void setCode(String newCode) {
        this.code = newCode;
    }

    public void setLangue(String newLangue) {
        this.langue = newLangue;
    }

    public void setUrlBandeau(String newUrlBandeau) {
        this.urlBandeau = newUrlBandeau;
    }

    public void setVisibleInFront(boolean visibleInFront) {
        this.visibleInFront = visibleInFront;
    }

    public void addSousStructure(InfosStructure sousStructure) {
        this.listeSousStructures.add(sousStructure);
    }

    public void rattacheA(InfosStructure structureMere) {
        this.structureRattachement = structureMere;
        this.structureRattachement.addSousStructure(this);
        this.updateNiveau();
    }

    private void updateNiveau() {
        this.niveau = this.structureRattachement.getNiveau() + 1;
        for (InfosStructure infosStructure : this.getListeSousStructures()) {
            infosStructure.updateNiveau();
        }
    }

    public boolean contains(InfosStructure structure) {
        boolean inFamilia = false;
        while (structure != null && !inFamilia) {
            if (structure.equals(this)) {
                inFamilia = true;
                continue;
            }
            structure = structure.getStructureRattachement();
        }
        return inFamilia;
    }

    public Long getIdBandeau() {
        return this.idBandeau;
    }

    public Long getIdStructure() {
        return this.idStructure;
    }

    public String getLibelleAffichable() {
        return this.libelleLong;
    }

    public Object clone() {
        return new InfosStructure(this);
    }

    public String getAttributSpecifique1() {
        return this.attributSpecifique1;
    }

    public String getAttributSpecifique2() {
        return this.attributSpecifique2;
    }

    public String getAttributSpecifique3() {
        return this.attributSpecifique3;
    }

    public String getAttributSpecifique4() {
        return this.attributSpecifique4;
    }

    public String getAttributSpecifique5() {
        return this.attributSpecifique5;
    }

    public String getCodeObjet() {
        return this.codeObjet;
    }
}

