/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.om.InfosLibelle;
import com.univ.objetspartages.sgbd.LibelleDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class Libelle
extends LibelleDB
implements Cloneable {
    private Collection<String> languesPossiblesPourTraduction = new ArrayList<String>();
    private boolean isLibelleSupprimable = Boolean.TRUE;

    public void init() {
        this.setIdLibelle(0L);
        this.setType("");
        this.setCode("");
        this.setLibelle("");
        this.setLangue("");
    }

    public String getLibelleAffichable() {
        int i;
        if (this.getLibelle().startsWith("[") && (i = this.getLibelle().indexOf("]") + 1) != 0 && i != this.getLibelle().length()) {
            return this.getLibelle().substring(i);
        }
        return this.getLibelle();
    }

    public String getCodeSiteLibelle() {
        int i;
        if (this.getLibelle().startsWith("[") && (i = this.getLibelle().indexOf("]") + 1) != 0 && i != this.getLibelle().length()) {
            return this.getLibelle().substring(1, i - 1);
        }
        return "";
    }

    public static String addLibelle(OMContext _ctx, String _typeLibelle, String _code, String _libelle, String _langue) throws Exception {
        Libelle libelle = new Libelle();
        libelle.setCtx(_ctx);
        ClauseWhere typeCodeLangue = new ClauseWhere(ConditionHelper.egalVarchar("TYPE", _typeLibelle));
        typeCodeLangue.and(ConditionHelper.egalVarchar("CODE", _code));
        typeCodeLangue.and(ConditionHelper.egalVarchar("LANGUE", _langue));
        if (libelle.select(typeCodeLangue.formaterSQL()) > 0) {
            while (libelle.nextItem()) {
                libelle.setLibelle(_libelle);
                libelle.update();
            }
        } else {
            libelle.init();
            libelle.setCode(_code);
            libelle.setLibelle(_libelle);
            libelle.setLangue(_langue);
            libelle.setType(_typeLibelle);
            libelle.add();
        }
        return "";
    }

    @Deprecated
    public static List<String> getLibelleSousFormeDeListe(OMContext _ctx, String _typeLibelle, String _codes, Locale _locale) {
        return Libelle.getLibelleSousFormeDeListe(_typeLibelle, _codes, _locale);
    }

    public static List<String> getLibelleSousFormeDeListe(String _typeLibelle, String _codes, Locale _locale) {
        String code = "";
        ArrayList<String> libelles = new ArrayList<String>();
        if (_codes != null && !_codes.equals("") && !_codes.equals("0000")) {
            StringTokenizer st = new StringTokenizer(_codes, ";");
            int i = 0;
            while (st.hasMoreTokens()) {
                code = st.nextToken();
                InfosLibelle infosLibelle = Libelle.renvoyerItemLibelle(_typeLibelle, code, Integer.toString(LangueUtil.getIndiceLocale(_locale)));
                if (infosLibelle != null) {
                    if (ContexteUtil.getContexteUniv() != null) {
                        libelles.add(i, infosLibelle.getLibelleAffichable());
                    } else {
                        libelles.add(i, infosLibelle.getLibelle());
                    }
                } else {
                    libelles.add(i, String.format("&lt;%s&gt;", MessageHelper.getCoreMessage("LIBELLE.INCONNU")));
                }
                ++i;
            }
        }
        return libelles;
    }

    @Deprecated
    public static String getLibelle(OMContext _ctx, String _typeLibelle, String _codes, Locale _locale) {
        return Libelle.getLibelle(_typeLibelle, _codes, _locale);
    }

    @Deprecated
    public static String getLibelle(OMContext _ctx, String _typeLibelle, String _codes, Locale _locale, String _separateur) {
        return Libelle.getLibelle(_typeLibelle, _codes, _locale);
    }

    public static String getLibelle(String _typeLibelle, String _codes, Locale _locale) {
        String res = "";
        if (_codes != null && !_codes.equals("") && !_codes.equals("0000")) {
            StringTokenizer st = new StringTokenizer(_codes, ";");
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            while (st.hasMoreTokens()) {
                InfosLibelle infosLibelle;
                String code = st.nextToken();
                if (res.length() > 0) {
                    res = ctx != null ? res + ", " : res + ";";
                }
                if ((infosLibelle = Libelle.renvoyerItemLibelle(_typeLibelle, code, Integer.toString(LangueUtil.getIndiceLocale(_locale)))) != null) {
                    if (ctx != null) {
                        res = res + infosLibelle.getLibelleAffichable();
                        continue;
                    }
                    res = res + infosLibelle.getLibelle();
                    continue;
                }
                res = res + String.format("&lt;%s&gt;", MessageHelper.getCoreMessage("LIBELLE.INCONNU"));
            }
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getListe(OMContext _ctx, String _typeLibelle, Locale _locale) throws Exception {
        return Libelle.getListe(_typeLibelle, _locale);
    }

    public static Hashtable<String, String> getListe(String _typeLibelle, Locale _locale) throws Exception {
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (_locale == null) {
            _locale = LangueUtil.getDefaultLocale();
        }
        try (ContexteDao ctx = new ContexteDao();){
            Libelle libelle = new Libelle();
            libelle.setCtx(ctx);
            ClauseWhere typeLangue = new ClauseWhere(ConditionHelper.egalVarchar("TYPE", _typeLibelle));
            typeLangue.and(ConditionHelper.egalVarchar("LANGUE", String.valueOf(LangueUtil.getIndiceLocale(_locale))));
            if (libelle.select(typeLangue.formaterSQL()) > 0) {
                while (libelle.nextItem()) {
                    if (ContexteUtil.getContexteUniv() != null) {
                        String codeSite = ContexteUtil.getContexteUniv().getInfosSite().getAlias();
                        String codeSiteLibelle = libelle.getCodeSiteLibelle();
                        if (!codeSiteLibelle.equals("") && !codeSiteLibelle.equalsIgnoreCase(codeSite)) continue;
                        h.put(libelle.getCode(), libelle.getLibelleAffichable());
                        continue;
                    }
                    h.put(libelle.getCode(), libelle.getLibelle());
                }
            }
        }
        return h;
    }

    public static Vector<Libelle> getListeTrieeParLibelle(OMContext _ctx, String _typeLibelle, Locale _locale) throws Exception {
        Libelle libelle = new Libelle();
        libelle.setCtx(_ctx);
        Vector<Libelle> v = new Vector<Libelle>();
        ClauseWhere typeLangue = new ClauseWhere(ConditionHelper.egalVarchar("TYPE", _typeLibelle));
        typeLangue.and(ConditionHelper.egalVarchar("LANGUE", String.valueOf(LangueUtil.getIndiceLocale(_locale))));
        ClauseOrderBy orderByLibelle = new ClauseOrderBy("LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        RequeteSQL requeteLibelle = new RequeteSQL();
        requeteLibelle.where(typeLangue).orderBy(orderByLibelle);
        if (libelle.select(requeteLibelle.formaterRequete()) > 0) {
            while (libelle.nextItem()) {
                v.add(libelle.clone());
            }
        }
        return v;
    }

    public static Hashtable<String, String> getListeParToken(OMContext _ctx, String _typeLibelle, String token) throws Exception {
        Libelle libelle = new Libelle();
        libelle.setCtx(_ctx);
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (libelle.select("WHERE TYPE='" + _typeLibelle + "' AND LIBELLE  LIKE '" + token + "'") > 0) {
            while (libelle.nextItem()) {
                h.put(libelle.getCode(), libelle.getLibelle());
            }
        }
        return h;
    }

    public static Hashtable<String, String> getListeTypesLibelles() {
        CacheLibelleManager cache = (CacheLibelleManager)ApplicationContextManager.getCoreContextBean("cacheLibelleManager");
        return cache.getListeTypesLibelles();
    }

    public static InfosLibelle renvoyerItemLibelle(String type, String code, String langue) {
        CacheLibelleManager cache = (CacheLibelleManager)ApplicationContextManager.getCoreContextBean("cacheLibelleManager");
        return cache.getListeInfosLibelles().get(type + code.toLowerCase() + langue);
    }

    public Libelle clone() throws CloneNotSupportedException {
        return (Libelle)super.clone();
    }

    public Collection<String> getLanguesPossiblesPourTraduction() {
        return this.languesPossiblesPourTraduction;
    }

    public void setLanguesPossiblesPourTraduction(Collection<String> languesPossiblesPourTraduction) {
        this.languesPossiblesPourTraduction = languesPossiblesPourTraduction;
    }

    public boolean isLibelleSupprimable() {
        return this.isLibelleSupprimable;
    }

    public void setLibelleSupprimable(boolean isLibelleSupprimable) {
        this.isLibelleSupprimable = isLibelleSupprimable;
    }
}

