/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.sgbd.MailingDB;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;

public class Mailing
extends MailingDB {
    public void init() {
        this.setIdMailing(new Long(0L));
        this.setEmail("");
        this.setNomUtilisateur("");
        this.setReplyTo("");
        this.setObjet("");
        this.setTypeMime("");
        this.setMessage("");
        this.setFichier("");
        this.setNomFichier("");
        this.setEtat("");
        this.setErrorMessage("");
        this.setIdNewsletter("");
        this.setCodeUtilisateur("");
        this.setDatePurge(new Date(0L));
        this.setDateCreation(new Timestamp(System.currentTimeMillis()));
        this.setType("");
    }

    public int select(String emailUtilisateur, String idNewsletter) throws Exception {
        ClauseWhere whereMailAndIdNewsletter = new ClauseWhere();
        if (StringUtils.isNotBlank((CharSequence)emailUtilisateur)) {
            whereMailAndIdNewsletter.setPremiereCondition(ConditionHelper.egalVarchar("EMAIL", emailUtilisateur));
        }
        whereMailAndIdNewsletter.and(ConditionHelper.egalVarchar("ID_NEWSLETTER", idNewsletter));
        return this.select(whereMailAndIdNewsletter.formaterSQL());
    }

    public int selectParDate(Date date) throws Exception {
        ClauseWhere whereDate = new ClauseWhere(ConditionHelper.genericConditionSurColonne("DATE_PURGE", date, TypeOperande.DATE, Operateur.GREATER_EQUALS));
        return this.select(whereDate.formaterSQL());
    }

    public int selectParObjetTypeDateCreationEtPublic(String objet, String type, Date dateDebut, Date dateFin, boolean publicInterne) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere whereTypeDatePublic = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)objet)) {
            whereTypeDatePublic.setPremiereCondition(ConditionHelper.like("T1.OBJET", objet, "%", "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)type) && !"0000".equals(type)) {
            whereTypeDatePublic.and(ConditionHelper.egalVarchar("T1.TYPE", type));
        }
        if (dateDebut != null) {
            whereTypeDatePublic.and(ConditionHelper.greaterEquals("T1.DATE_CREATION", dateDebut, TypeOperande.DATE));
        }
        if (dateFin != null) {
            whereTypeDatePublic.and(ConditionHelper.lessEquals("T1.DATE_CREATION", "('" + dateFin + "' + INTERVAL 1 DAY - INTERVAL 1 SECOND)", TypeOperande.NON_ECHAPABLE));
        }
        whereTypeDatePublic.and(ConditionHelper.egalVarchar("T1.ETAT", "SENT"));
        whereTypeDatePublic.and(ConditionHelper.egalVarchar("T1.TYPE_MIME", "0"));
        whereTypeDatePublic.and(ConditionHelper.like("T1.EMAIL", "[", "", "%"));
        requeteSelect.where(whereTypeDatePublic);
        return this.select(requeteSelect.formaterRequete());
    }
}

