/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.mediatheque.CacheMediaManager;
import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.RessourceUniv;
import com.univ.objetspartages.sgbd.MediaDB;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.FileUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Media
extends MediaDB
implements RessourceUniv,
Cloneable {
    private static final long serialVersionUID = 4562627951365613065L;
    private static final Logger LOG = LoggerFactory.getLogger(Media.class);
    private int langue = 0;
    private String generateName = "";

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    public void init() {
        this.setIdMedia(0L);
        this.setTitre("");
        this.setLegende("");
        this.setDescription("");
        this.setFormat("");
        this.setSource("");
        this.setIsMutualise("");
        this.setAuteur("");
        this.setCopyright("");
        this.setTypeRessource("");
        this.setTypeMedia("");
        this.setCodeRubrique("");
        this.setCodeRattachement("");
        this.setUrl("");
        this.setUrlVignette("");
        this.setPoids(0);
        this.setCodeRedacteur("");
        this.setDateCreation(new Date(0L));
        this.setThematique("");
        this.setMetaKeywords("");
        this.setSpecificData("");
        this.setTraductionData("");
        this.setAccessibilityData("");
    }

    public String getLibelleAffichable() {
        String res = this.getTitre();
        if (res.length() == 0) {
            res = this.getSource();
        }
        return res;
    }

    public String getLibelleTypeRessource() throws Exception {
        return Mediatheque.getInstance().getRessourceByExtension(this.getExtension()).getLibelle();
    }

    public String getLibelleTypeMedia() throws Exception {
        return Libelle.getLibelle("201", this.getTypeMedia(), LangueUtil.getDefaultLocale());
    }

    public String getLibelleThematique() throws Exception {
        return Libelle.getLibelle("04", this.getThematique(), LangueUtil.getDefaultLocale());
    }

    private ClauseWhere preparerRequete(Long idMedia, String titre, String legende, String description, String copyright, String auteur, String typeRessource, String typeMedia, String thematique, String codeRattachement, String codeRubrique, String codeRedacteur, String metaKeywords, Date dateCreation, String _mode) throws Exception {
        ClauseWhere where = new ClauseWhere();
        if (!idMedia.equals(0L)) {
            where.setPremiereCondition(ConditionHelper.egal("T1.ID_MEDIA", idMedia, TypeOperande.LONG));
        }
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            ConditionList titreEtSource = new ConditionList(ConditionHelper.rechercheMots("T1.TITRE", titre));
            titreEtSource.or(ConditionHelper.rechercheMots("T1.SOURCE", titre));
            where.and(titreEtSource);
        }
        if (StringUtils.isNotEmpty((CharSequence)legende)) {
            where.and(ConditionHelper.rechercheMots("T1.LEGENDE", legende));
        }
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            where.and(ConditionHelper.rechercheMots("T1.DESCRIPTION", description));
        }
        if (StringUtils.isNotEmpty((CharSequence)copyright)) {
            where.and(ConditionHelper.rechercheMots("T1.COPYRIGHT", copyright));
        }
        if (StringUtils.isNotEmpty((CharSequence)auteur)) {
            where.and(ConditionHelper.rechercheMots("T1.AUTEUR", auteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)typeRessource) && !"0000".equals(typeRessource)) {
            where.and(ConditionHelper.egalVarchar("T1.TYPE_RESSOURCE", typeRessource));
        } else {
            where.and(ConditionHelper.notEgal("T1.TYPE_RESSOURCE", "", TypeOperande.TEXTE));
        }
        if (StringUtils.isNotEmpty((CharSequence)typeMedia) && !"0000".equals(typeMedia)) {
            where.and(ConditionHelper.egalVarchar("T1.TYPE_MEDIA", typeMedia));
        }
        if (StringUtils.isNotEmpty((CharSequence)thematique) && !"0000".equals(thematique)) {
            where.and(ConditionHelper.egalVarchar("T1.THEMATIQUE", thematique));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.egalVarchar("T1.CODE_RATTACHEMENT", codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            where.and(ConditionHelper.getConditionRubrique("CODE_RUBRIQUE", codeRubrique));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar("T1.CODE_REDACTEUR", codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)metaKeywords)) {
            where.and(ConditionHelper.rechercheMots("META_KEYWORDS", metaKeywords));
        }
        if (Formateur.estSaisie(dateCreation)) {
            where.and(ConditionHelper.greaterEquals("T1.DATE_CREATION", dateCreation, TypeOperande.DATE_ET_HEURE));
        }
        where.and(ConditionHelper.egalVarchar("T1.IS_MUTUALISE", "0"));
        where.and(Media.conditionPerimetreMedia(this.ctx, _mode));
        return where;
    }

    public ClauseWhere preparerRequete(Long idMedia, String titre, String legende, String description, String copyright, String auteur, String typeRessource, String typeMedia, String thematique, String codeRattachement, String codeRubrique, String codeRedacteur, String metaKeywords, Date dateCreation, String _mode, String poidsMinimum, String poidsMaximum) throws Exception {
        ClauseWhere where = this.preparerRequete(idMedia, titre, legende, description, copyright, auteur, typeRessource, typeMedia, thematique, codeRattachement, codeRubrique, codeRedacteur, metaKeywords, dateCreation, _mode);
        if (StringUtils.isNotBlank((CharSequence)poidsMinimum)) {
            where.and(ConditionHelper.greaterEquals("T1.POIDS", poidsMinimum, TypeOperande.VARCHAR));
        }
        if (StringUtils.isNotBlank((CharSequence)poidsMaximum)) {
            where.and(ConditionHelper.lessEquals("T1.POIDS", poidsMaximum, TypeOperande.VARCHAR));
        }
        return where;
    }

    public static ConditionList conditionPerimetreMedia(OMContext ctx, String mode) throws Exception {
        ConditionList conditionBOMedia = new ConditionList();
        if (Media.possedeDesAutorisations(ctx)) {
            Boolean accesTousPerimetre = Boolean.FALSE;
            AutorisationBean autorisations = (AutorisationBean)ctx.getDatas().get("AUTORISATIONS");
            Hashtable<String, Vector<Perimetre>> permisssions = autorisations.getListePermissions();
            for (Map.Entry<String, Vector<Perimetre>> clePermission : permisssions.entrySet()) {
                PermissionBean permission = new PermissionBean(clePermission.getKey());
                if (!Media.isValidePermission(permission, mode)) continue;
                Vector<Perimetre> lesPerimetres = clePermission.getValue();
                for (Perimetre perimetre : lesPerimetres) {
                    ConditionList conditionPerimetre = new ConditionList();
                    accesTousPerimetre = Media.isAccesTousPerimetre(perimetre);
                    if (!accesTousPerimetre.booleanValue()) {
                        conditionPerimetre.setPremiereCondtion(Media.traiterConditionRubrique(perimetre));
                        conditionPerimetre.and(Media.traiterConditionStructure(perimetre));
                    }
                    conditionBOMedia.or(conditionPerimetre);
                }
            }
            if (!accesTousPerimetre.booleanValue()) {
                conditionBOMedia.or(ConditionHelper.egalVarchar("CODE_REDACTEUR", autorisations.getCode()));
            }
        }
        return conditionBOMedia;
    }

    private static Condition traiterConditionStructure(Perimetre perimetre) throws Exception {
        Condition conditionsStructures = new ConditionList();
        String codeStructure = perimetre.getCodeStructure();
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            conditionsStructures = ConditionHelper.getConditionStructure("CODE_RATTACHEMENT", codeStructure);
        }
        return conditionsStructures;
    }

    private static Condition traiterConditionRubrique(Perimetre perimetre) throws Exception {
        Condition conditionsRubriques = new ConditionList();
        String codeRubrique = perimetre.getCodeRubrique();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            conditionsRubriques = ConditionHelper.getConditionRubrique("CODE_RUBRIQUE", codeRubrique);
        }
        return conditionsRubriques;
    }

    private static boolean isAccesTousPerimetre(Perimetre perimetre) {
        return perimetre.getCodeRubrique().length() == 0 && perimetre.getCodeStructure().length() == 0;
    }

    private static boolean possedeDesAutorisations(OMContext ctx) {
        return ctx.getDatas() != null && ctx.getDatas().get("AUTORISATIONS") != null;
    }

    private static boolean isValidePermission(PermissionBean permission, String mode) {
        return permission.getType().equals("TECH") && ("ADMINISTRATION".equals(mode) && permission.getObjet().equals("pho") && (permission.getAction().equals("M") || permission.getAction().equals("S")) || !"ADMINISTRATION".equals(mode) && permission.getObjet().equals("acp"));
    }

    @Override
    public String getUrlAbsolue() {
        if (this.getIdMedia() != null && !this.getIdMedia().equals(0L)) {
            String sUrl = this.getUrl();
            if (StringUtils.isNotBlank((CharSequence)sUrl) && this.isLocal()) {
                sUrl = MediathequeHelper.getAbsolutePath();
                String sServerPath = new File(WebAppUtil.getWebInfPath()).getAbsolutePath();
                if (!sServerPath.endsWith(File.separator)) {
                    sServerPath = sServerPath + File.separator;
                }
                if (sUrl.indexOf(sServerPath) == 0) {
                    sUrl = sServerPath.endsWith("/") ? sUrl.substring(sServerPath.length()) : "/" + sUrl.substring(sServerPath.length());
                } else {
                    sUrl = MediathequeHelper.getDefaultRelativePath();
                    if (!StringUtils.startsWith((CharSequence)sUrl, (CharSequence)"/")) {
                        sUrl = "/" + sUrl;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.getTypeRessource())) {
                    sUrl = sUrl + "/" + this.getTypeRessource().toLowerCase();
                }
                sUrl = sUrl + "/" + this.getUrl();
            }
            if (StringUtils.startsWith((CharSequence)sUrl, (CharSequence)"/") || !this.isLocal()) {
                return sUrl;
            }
            return "/" + sUrl;
        }
        return "";
    }

    public static String getPathAbsoluFichierTmp(String urlTmp) {
        if (StringUtils.isNotEmpty((CharSequence)urlTmp)) {
            return MediathequeHelper.getAbsolutePath() + urlTmp;
        }
        return "";
    }

    public boolean isPublic() {
        return !this.getIsMutualise().equals("2");
    }

    @Override
    public String getPathAbsolu() {
        String sUrl = this.getUrl();
        if (sUrl.length() > 0 && this.isLocal()) {
            sUrl = MediathequeHelper.getAbsolutePath();
            if (StringUtils.isNotBlank((CharSequence)this.getTypeRessource())) {
                sUrl = sUrl + "/" + this.getTypeRessource().toLowerCase();
            }
            sUrl = sUrl + "/" + this.getUrl();
        }
        return sUrl;
    }

    @Override
    public String getPathVignetteAbsolu() {
        String sUrl = this.getUrlVignette();
        if (sUrl.length() > 0) {
            sUrl = MediathequeHelper.getAbsolutePath();
            if (this.getTypeRessource().length() > 0) {
                sUrl = sUrl + "/" + this.getTypeRessource().toLowerCase();
            }
            sUrl = sUrl + "/" + this.getUrlVignette();
        }
        return sUrl;
    }

    public String getUrlVignetteAbsolue() {
        String sUrl = this.getUrlVignette();
        if (sUrl.length() > 0) {
            String sServerPath;
            sUrl = MediathequeHelper.getAbsolutePath();
            sUrl = sUrl.indexOf(sServerPath = WebAppUtil.getAbsolutePath()) == 0 ? (sServerPath.endsWith("/") ? "/" + sUrl.substring(sServerPath.length()) : "/" + sUrl.substring(sServerPath.length() + 1)) : MediathequeHelper.getDefaultRelativePath();
            if (this.getTypeRessource().length() > 0) {
                sUrl = sUrl + "/" + this.getTypeRessource().toLowerCase();
            }
            sUrl = sUrl + "/" + this.getUrlVignette();
        }
        return sUrl;
    }

    public boolean isLocal() {
        return !this.getUrl().contains("/");
    }

    public String getSpecificData(String propertie) {
        String sRes = "";
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(this.getSpecificData().getBytes()));
        }
        catch (IOException e) {
            LOG.error("erreur de la lecture des properties du media", (Throwable)e);
        }
        if (properties.get(propertie) != null) {
            sRes = (String)properties.get(propertie);
        }
        return sRes;
    }

    public String getTraductionData(String propertie) {
        String sRes = "";
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(this.getTraductionData().getBytes()));
        }
        catch (IOException e) {
            LOG.error("erreur de la lecture des properties du media", (Throwable)e);
        }
        if (properties.get(propertie) != null) {
            sRes = (String)properties.get(propertie);
        }
        return sRes;
    }

    public String getSpecificDataAsString() {
        String sRes = "";
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(this.getSpecificData().getBytes()));
        }
        catch (IOException e) {
            LOG.error("erreur de la lecture des properties du media", (Throwable)e);
        }
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String propertie = (String)e.nextElement();
            String value = properties.getProperty(propertie);
            if (value.length() <= 0 || value.equals("0")) continue;
            if (sRes.length() > 0) {
                sRes = sRes + '\n';
            }
            sRes = sRes + propertie.toLowerCase() + " : " + value;
        }
        return sRes;
    }

    public void save(OMContext _ctx, String sAbsolutePathFile, String sAbsolutePathVignette, String sFileName, String sVignetteName) throws Exception {
        String newPath;
        boolean okDirs;
        File fRepertoire;
        String repertoire;
        File tmpFile;
        String sOldAbsolutePathFile = this.getPathAbsolu();
        String sOldAbsolutePathVignette = this.getPathVignetteAbsolu();
        boolean suppressionFile = false;
        boolean suppressionVignette = false;
        if (this.isLocal() && !sAbsolutePathFile.equals(sOldAbsolutePathFile)) {
            suppressionFile = true;
            tmpFile = new File(sAbsolutePathFile);
            if (tmpFile.exists()) {
                repertoire = "";
                repertoire = MediathequeHelper.getAbsolutePath();
                if (this.getTypeRessource().length() > 0) {
                    repertoire = repertoire + File.separator + this.getTypeRessource().toLowerCase();
                }
                fRepertoire = new File(repertoire);
                okDirs = true;
                if (!fRepertoire.exists()) {
                    okDirs = fRepertoire.mkdirs();
                }
                if (!okDirs) {
                    LOG.error("Impossible de creer le repertoire des medias :" + fRepertoire + " (verifier les droits d'ecriture sur le repertoire)");
                }
                newPath = repertoire + File.separator + sFileName;
                try {
                    FileUtil.primitiveCopierFichier(tmpFile, new File(newPath), !sAbsolutePathFile.equals(sAbsolutePathVignette));
                }
                catch (IOException e) {
                    throw new ErreurApplicative(String.format("Une erreur est survenue lors de l'enregistrement du m\u00e9dia : %s", e.getMessage()));
                }
                this.setUrl(sFileName);
            }
        }
        if (!sAbsolutePathVignette.equals(sOldAbsolutePathVignette)) {
            suppressionVignette = true;
            tmpFile = new File(sAbsolutePathVignette);
            if (tmpFile.exists()) {
                repertoire = MediathequeHelper.getAbsolutePath();
                if (this.getTypeRessource().length() > 0) {
                    repertoire = repertoire + File.separator + this.getTypeRessource().toLowerCase();
                }
                fRepertoire = new File(repertoire);
                okDirs = true;
                if (!fRepertoire.exists()) {
                    okDirs = fRepertoire.mkdirs();
                }
                if (!okDirs) {
                    LOG.error("Impossible de creer le repertoire des medias :" + fRepertoire + " (verifier les droits d'ecriture sur le repertoire)");
                }
                newPath = repertoire + File.separator + "v_";
                newPath = sVignetteName.length() > 0 ? newPath + sVignetteName : newPath + sFileName;
                FileUtil.copierFichier(tmpFile, new File(newPath), true);
                this.setUrlVignette("v_" + (sVignetteName.length() > 0 ? sVignetteName : sFileName));
            }
        }
        if (this.getIdMedia().equals(new Long(0L))) {
            this.add();
        } else {
            this.update();
            if (suppressionFile && sOldAbsolutePathFile.length() > 0) {
                new File(sOldAbsolutePathFile).delete();
            }
            if (suppressionVignette && sOldAbsolutePathVignette.length() > 0) {
                new File(sOldAbsolutePathVignette).delete();
            }
        }
        CacheMediaManager.getInstance().refresh(this, true);
    }

    @Deprecated
    public static void deleteById(OMContext ctx, Long id) {
        Media.deleteById(ctx, id, true);
    }

    @Deprecated
    public static void deleteById(OMContext ctx, Long id, boolean onlyNotMutualise) {
        try {
            Media media = new Media();
            media.setCtx(ctx);
            media.setIdMedia(id);
            media.retrieve();
            if (!onlyNotMutualise || onlyNotMutualise && !media.getIsMutualise().equals("0")) {
                media.delete();
                new File(media.getPathAbsolu()).delete();
                if (media.getUrlVignette().length() > 0) {
                    new File(media.getUrlVignetteAbsolue()).delete();
                }
            }
        }
        catch (Exception e) {
            LOG.error("erreur lors de la requete en BDD", (Throwable)e);
        }
    }

    public static void deleteById(Long id) {
        Media.deleteById(id, true);
    }

    public static void deleteById(Long id, boolean onlyNotMutualise) {
        try (ContexteDao ctx = new ContexteDao();){
            Media media = new Media();
            media.setCtx(ctx);
            media.setIdMedia(id);
            media.retrieve();
            if (!onlyNotMutualise || onlyNotMutualise && !media.getIsMutualise().equals("0")) {
                media.delete();
                new File(media.getPathAbsolu()).delete();
                if (media.getUrlVignette().length() > 0) {
                    new File(media.getUrlVignetteAbsolue()).delete();
                }
            }
        }
        catch (Exception e) {
            LOG.error("An error occured while deleting the media", (Throwable)e);
        }
    }

    @Deprecated
    public static Media getMedia(OMContext ctx, Long idMedia) {
        Media media = new Media();
        media.setCtx(ctx);
        media.init();
        if (idMedia != null && !idMedia.equals(new Long(0L))) {
            media.setIdMedia(idMedia);
            try {
                media.retrieve();
                if (ctx.getLocale() != null && !ctx.getLocale().equals(LangueUtil.getDefaultLocale())) {
                    media.setLangue(LangueUtil.getIndiceLocale(ctx.getLocale()));
                }
            }
            catch (Exception e) {
                LOG.warn("Media id=" + idMedia + " inexistant");
            }
        }
        return media;
    }

    public static Media getMedia(Long idMedia) {
        Media media = new Media();
        if (idMedia != null && !idMedia.equals(new Long(0L))) {
            media.init();
            media.setIdMedia(idMedia);
            try (ContexteDao ctx = new ContexteDao();){
                media.setCtx(ctx);
                media.retrieve();
            }
            catch (Exception e) {
                LOG.warn("Media id=" + idMedia + " inexistant");
            }
        }
        return media;
    }

    public static Media getMediaParUrlOuUrlVignette(OMContext _ctx, String sMedia) {
        Media media = new Media();
        media.setCtx(_ctx);
        Hashtable h = new Hashtable();
        ClauseWhere whereMedia = new ClauseWhere(ConditionHelper.egalVarchar("URL", sMedia));
        new ConditionHelper();
        whereMedia.or(ConditionHelper.egalVarchar("URL_VIGNETTE", sMedia));
        try {
            if (media.select(whereMedia.formaterSQL()) > 0 && media.nextItem()) {
                return media;
            }
        }
        catch (Exception e) {
            LOG.debug("Erreur lors de la r\u00e9cup\u00e9ration du m\u00e9dia par son Url", (Throwable)e);
        }
        return null;
    }

    public static Hashtable<String, String> getListePhotoParType(OMContext _ctx, String type) throws Exception {
        Media media = new Media();
        media.setCtx(_ctx);
        Hashtable<String, String> h = new Hashtable<String, String>();
        ClauseWhere whereMedia = new ClauseWhere(ConditionHelper.egalVarchar("TYPE_RESSOURCE", "photo"));
        whereMedia.and(ConditionHelper.egalVarchar("TYPE_MEDIA", type));
        whereMedia.and(Media.conditionPerimetreMedia(_ctx, "SELECTION"));
        if (media.select(whereMedia.formaterSQL()) > 0) {
            while (media.nextItem()) {
                h.put(media.getIdMedia().toString(), media.getLibelleAffichable());
            }
        }
        return h;
    }

    public static void modifierCodeRubriqueParInfobean(InfoBean infoBean, String codeRubrique) {
        if (CollectionUtils.isNotEmpty(infoBean.getHashSet("contentNewRessources"))) {
            Set listRessource = infoBean.getHashSet("contentNewRessources");
            for (String ressource : listRessource) {
                Media media;
                Object[] tabRessource = ressource.split("#");
                if (!ArrayUtils.isNotEmpty((Object[])tabRessource) || !StringUtils.isNotEmpty((CharSequence)tabRessource[0]) || (media = Media.getMedia(Long.valueOf((String)tabRessource[0]))) == null) continue;
                media.setCodeRubrique(codeRubrique);
                try {
                    media.update();
                }
                catch (Exception e) {
                    LOG.error("Impossible de mettre \u00e0 jour le m\u00e9dia");
                }
            }
        }
    }

    public synchronized String generateName(String extension) {
        if (this.generateName.equals("")) {
            if (extension.length() == 0) {
                extension = this.getExtension();
            }
            String nomFichierSansExtension = StringUtils.defaultString((String)StringUtils.substringBeforeLast((String)this.getSource(), (String)"."));
            this.generateName = Chaine.formatString(nomFichierSansExtension) + "_" + System.currentTimeMillis() + "-" + extension;
        }
        return this.generateName;
    }

    public String getExtension() {
        String res = "";
        int i = this.getSource().lastIndexOf(".");
        if (i != -1) {
            res = this.getSource().substring(i + 1);
        } else {
            i = this.getFormat().lastIndexOf("-");
            if (i != -1) {
                res = this.getFormat().substring(i + 1);
            }
        }
        return res;
    }

    public Media clone() throws CloneNotSupportedException {
        return (Media)super.clone();
    }

    public int getLangue() {
        return this.langue;
    }

    public void setLangue(int langue) {
        this.langue = langue;
    }

    @Override
    public String getDescription() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("DESCRIPTION_" + this.langue);
        }
        return super.getDescription();
    }

    @Override
    public String getTitre() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("TITRE_" + this.langue);
        }
        return super.getTitre();
    }

    @Override
    public String getAuteur() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("AUTEUR_" + this.langue);
        }
        return super.getAuteur();
    }

    @Override
    public String getCopyright() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("COPYRIGHT_" + this.langue);
        }
        return super.getCopyright();
    }

    @Override
    public String getLegende() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("LEGENDE_" + this.langue);
        }
        return super.getLegende();
    }

    @Override
    public String getMetaKeywords() {
        if (this.langue != 0 && "0".equals(this.getIsMutualise())) {
            return this.getTraductionData("LEGENDE_META_KEYWORDS_" + this.langue);
        }
        return super.getMetaKeywords();
    }
}

