/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.Mediatheque;
import com.univ.objetspartages.om.RessourceUniv;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.FileUtil;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MediaAudio
extends SpecificMedia {
    @Override
    public void setSpecificProperties(InfoBean infoBean, Properties properties) {
    }

    @Override
    public void prepareMedia(InfoBean infoBean, RessourceUniv media) throws Exception {
        this.setContenuInfoBean(infoBean, media.getSpecificData());
    }

    @Override
    public String checkMedia(InfoBean infoBean, UploadedFile file) throws Exception {
        String extension;
        File f = null;
        if (file != null) {
            f = file.getTemporaryFile();
        }
        boolean check = true;
        if (file.getContentType() != null && file.getContentType().length() > 0 && !this.extensions.contains(extension = FileUtil.getExtension(file.getContentFilename()))) {
            check = false;
        }
        if (!check) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FORMAT_MP3"));
        }
        infoBean.set("SOURCE", file.getContentFilename());
        infoBean.set("POIDS", Long.toString(f.length() / 1024L));
        if (StringUtils.isNotEmpty((CharSequence)file.getContentType())) {
            infoBean.set("FORMAT", file.getContentType());
        } else {
            String nomFichierUploade = file.getContentFilename();
            nomFichierUploade = (String)StringUtils.defaultIfBlank((CharSequence)nomFichierUploade, (CharSequence)f.getName());
            String formatFichierUploade = Mediatheque.getInstance().getContentType(nomFichierUploade);
            infoBean.set("FORMAT", formatFichierUploade);
        }
        return f.getAbsolutePath();
    }

    @Override
    public String processMedia(InfoBean infoBean, RessourceUniv media) throws Exception {
        String sPathFile = infoBean.getString("URL_RESSOURCE");
        if (!sPathFile.equals(media.getUrlAbsolue())) {
            File f = new File(sPathFile);
            if (!f.exists()) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_OBLIGATOIRE"));
            }
            sPathFile = f.getAbsolutePath();
            media.setPoids(new Integer(Long.toString(f.length() / 1024L)));
        } else {
            sPathFile = media.getPathAbsolu();
        }
        if (infoBean.get("TYPE_MEDIA_" + this.getCode().toUpperCase()) != null && !infoBean.getString("TYPE_MEDIA_" + this.getCode().toUpperCase()).equals("0000")) {
            media.setTypeMedia(infoBean.getString("TYPE_MEDIA_" + this.getCode().toUpperCase()));
        }
        media.setSpecificData(this.getPropertiesAsString(infoBean));
        return sPathFile;
    }

    @Override
    public String processVignette(InfoBean infoBean, RessourceUniv media) throws Exception {
        return media.getPathVignetteAbsolu();
    }
}

