/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.mediatheque.Mediatheque;
import com.univ.objetspartages.om.CriterePhoto;
import com.univ.objetspartages.om.RessourceUniv;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.FileUtil;
import com.univ.utils.ImageInfo;
import com.univ.utils.PhotoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaPhoto
extends SpecificMedia {
    private static CriterePhoto critereLimite = null;
    private static CriterePhoto critereVignette = null;
    private static ArrayList<Object> lstCriterePhoto = null;
    public static final String ATTRIBUT_LARGEUR = "LARGEUR";
    public static final String ATTRIBUT_HAUTEUR = "HAUTEUR";
    private static final Logger LOG = LoggerFactory.getLogger(MediaPhoto.class);

    @Override
    public void setSpecificProperties(InfoBean infoBean, Properties properties) throws Exception {
        String prop = "";
        if (infoBean.get(ATTRIBUT_LARGEUR) != null) {
            prop = infoBean.get(ATTRIBUT_LARGEUR).toString();
        }
        properties.setProperty(ATTRIBUT_LARGEUR, prop);
        prop = "";
        if (infoBean.get(ATTRIBUT_HAUTEUR) != null) {
            prop = infoBean.get(ATTRIBUT_HAUTEUR).toString();
        }
        properties.setProperty(ATTRIBUT_HAUTEUR, prop);
    }

    @Override
    public void prepareMedia(InfoBean infoBean, RessourceUniv media) throws Exception {
        this.setContenuInfoBean(infoBean, media.getSpecificData());
    }

    @Override
    public String checkMedia(InfoBean infoBean, UploadedFile file) throws Exception {
        File f = null;
        if (file == null) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_OBLIGATOIRE"));
        }
        f = file.getTemporaryFile();
        boolean check = false;
        ImageInfo ii = new ImageInfo();
        String path = f.getAbsolutePath();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            ii.setInput(fis);
            check = ii.check();
        }
        catch (Exception e) {
            throw new ErreurApplicative(e.getMessage());
        }
        finally {
            ii.close();
            if (fis != null) {
                fis.close();
            }
        }
        if (!check) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FORMAT_IMAGE"));
        }
        infoBean.set("SOURCE", file.getContentFilename());
        infoBean.set("POIDS", Long.toString(f.length() / 1024L));
        if (StringUtils.isNotEmpty((CharSequence)file.getContentType())) {
            infoBean.set("FORMAT", file.getContentType());
        } else {
            String nomFichierUploade = file.getContentFilename();
            nomFichierUploade = (String)StringUtils.defaultIfBlank((CharSequence)nomFichierUploade, (CharSequence)f.getName());
            String formatFichierUploade = Mediatheque.getInstance().getContentType(nomFichierUploade);
            infoBean.set("FORMAT", formatFichierUploade);
        }
        infoBean.set(ATTRIBUT_LARGEUR, Integer.toString(ii.getWidth()));
        infoBean.set(ATTRIBUT_HAUTEUR, Integer.toString(ii.getHeight()));
        infoBean.set("CRITERE", String.valueOf(lstCriterePhoto.size() + 1));
        infoBean.set("criteres", lstCriterePhoto);
        infoBean.set("HAUTEUR_PERSONNALISE", "");
        infoBean.set("LARGEUR_PERSONNALISE", "");
        LOG.debug("caract\u00e9ristiques image : " + ii.getFormatName() + ", " + ii.getWidth() + " x " + ii.getHeight() + " pixels, " + ii.getBitsPerPixel() + " bits per pixel.");
        return f.getAbsolutePath();
    }

    @Override
    public String processMedia(InfoBean infoBean, RessourceUniv media) throws Exception {
        String sPathFile = infoBean.getString("URL_RESSOURCE");
        String extension = FileUtil.getExtension(media.getSource());
        boolean replace = false;
        if (sPathFile.equals(media.getUrlAbsolue())) {
            replace = true;
            sPathFile = media.getPathAbsolu();
        }
        if ((String)infoBean.get("CRITERE") != null) {
            File f = new File(sPathFile);
            if (!f.exists()) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_PHOTO_OBLIGATOIRE"));
            }
            int index = Integer.parseInt((String)infoBean.get("CRITERE"));
            int largeur = Integer.parseInt(infoBean.getString(ATTRIBUT_LARGEUR));
            int hauteur = Integer.parseInt(infoBean.getString(ATTRIBUT_HAUTEUR));
            int newLargeur = largeur;
            int newHauteur = hauteur;
            if (index < lstCriterePhoto.size()) {
                CriterePhoto critere = (CriterePhoto)lstCriterePhoto.get(index);
                newLargeur = critere.getLargeur();
                newHauteur = critere.getHauteur();
                float rapportHauteur = (float)newHauteur / (float)hauteur;
                float rapportLargeur = (float)newLargeur / (float)largeur;
                if (newLargeur == 0) {
                    newLargeur = (int)((float)largeur * rapportHauteur);
                } else if (newHauteur == 0) {
                    newHauteur = (int)((float)hauteur * rapportLargeur);
                } else if (rapportLargeur < rapportHauteur) {
                    newHauteur = (int)((float)hauteur * rapportLargeur);
                } else {
                    newLargeur = (int)((float)largeur * rapportHauteur);
                }
                f = PhotoUtil.resize(sPathFile, extension, newLargeur, newHauteur, replace);
            } else if (index == lstCriterePhoto.size()) {
                newHauteur = (Integer)infoBean.get("HAUTEUR_PERSONNALISE");
                newLargeur = (Integer)infoBean.get("LARGEUR_PERSONNALISE");
                if (newHauteur == 0 && newLargeur == 0) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.TAILLE_REDIMENSION"));
                }
                float rapportHauteur = (float)newHauteur / (float)hauteur;
                float rapportLargeur = (float)newLargeur / (float)largeur;
                if (newLargeur == 0) {
                    newLargeur = (int)((float)largeur * rapportHauteur);
                } else if (newHauteur == 0) {
                    newHauteur = (int)((float)hauteur * rapportLargeur);
                } else if (rapportLargeur < rapportHauteur) {
                    newHauteur = (int)((float)hauteur * rapportLargeur);
                } else {
                    newLargeur = (int)((float)largeur * rapportHauteur);
                }
                f = PhotoUtil.resize(sPathFile, extension, newLargeur, newHauteur, replace);
            }
            infoBean.set(ATTRIBUT_LARGEUR, Integer.toString(newLargeur));
            infoBean.set(ATTRIBUT_HAUTEUR, Integer.toString(newHauteur));
            infoBean.set("WIDTH", Integer.toString(newLargeur));
            infoBean.set("HEIGHT", Integer.toString(newHauteur));
            media.setSpecificData(this.getPropertiesAsString(infoBean));
            sPathFile = f.getAbsolutePath();
            media.setPoids(new Integer(Long.toString(f.length() / 1024L)));
            if (newLargeur > critereLimite.getLargeur()) {
                newLargeur = critereLimite.getLargeur();
            }
            if (newHauteur > critereLimite.getHauteur()) {
                newHauteur = critereLimite.getHauteur();
            }
            infoBean.set(ATTRIBUT_LARGEUR, Integer.toString(newLargeur));
            infoBean.set(ATTRIBUT_HAUTEUR, Integer.toString(newHauteur));
        } else {
            sPathFile = media.getPathAbsolu();
        }
        if (infoBean.get("TYPE_MEDIA_" + this.getCode().toUpperCase()) != null && !infoBean.getString("TYPE_MEDIA_" + this.getCode().toUpperCase()).equals("0000")) {
            media.setTypeMedia(infoBean.getString("TYPE_MEDIA_" + this.getCode().toUpperCase()));
        }
        return sPathFile;
    }

    @Override
    public String processVignette(InfoBean infoBean, RessourceUniv media) throws Exception {
        String sPathFile = infoBean.getString("URL_RESSOURCE");
        if (!sPathFile.equals(media.getUrlAbsolue())) {
            File f = new File(sPathFile);
            if (!f.exists()) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_PHOTO_OBLIGATOIRE"));
            }
            if (media.getUrlVignette().endsWith(media.getUrl())) {
                String extension = FileUtil.getExtension(media.getSource());
                f = PhotoUtil.resize(f.getAbsolutePath(), extension, critereVignette.getLargeur(), critereVignette.getHauteur(), false);
                sPathFile = f.getAbsolutePath();
            }
        } else {
            sPathFile = media.getPathVignetteAbsolu();
        }
        return sPathFile;
    }

    public static CriterePhoto getCritereLimite() {
        return critereLimite;
    }

    public static CriterePhoto getCritereVignette() {
        return critereVignette;
    }

    static {
        critereLimite = new CriterePhoto();
        critereVignette = new CriterePhoto();
        lstCriterePhoto = new ArrayList();
        String critere = PropertyHelper.getCoreProperty("phototheque.limite");
        String[] lstLimite = critere.split("/", -2);
        critereLimite.setPoids(Long.parseLong(lstLimite[0]));
        critereLimite.setLargeur(Integer.parseInt(lstLimite[1]));
        critereLimite.setHauteur(Integer.parseInt(lstLimite[2]));
        LOG.debug("Crit\u00e8re limite construit : [ poids : {}, largeur {}: , hauteur : {}", new Object[]{lstLimite[0], lstLimite[1], lstLimite[2]});
        critere = PropertyHelper.getCoreProperty("phototheque.vignette");
        lstLimite = critere.split("/", -2);
        critereVignette.setCode(lstLimite[0]);
        critereVignette.setLargeur(Integer.parseInt(lstLimite[1]));
        critereVignette.setHauteur(Integer.parseInt(lstLimite[2]));
        String dimension = PropertyHelper.getCoreProperty("phototheque.dimension");
        LOG.debug("Crit\u00e8re vignette construit : [ code : {}, largeur {}: , hauteur : {}", new Object[]{lstLimite[0], lstLimite[1], lstLimite[2]});
        if (dimension != null) {
            String[] lstDimension;
            String[] stringArray = lstDimension = dimension.split(";", -2);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element;
                critere = element = stringArray[i];
                lstLimite = critere.split("/", -2);
                CriterePhoto aCritere = new CriterePhoto();
                aCritere.setCode(lstLimite[0]);
                aCritere.setPoids(Long.parseLong(lstLimite[1]));
                aCritere.setLargeur(Integer.parseInt(lstLimite[2]));
                aCritere.setHauteur(Integer.parseInt(lstLimite[3]));
                lstCriterePhoto.add(aCritere);
            }
        }
        LOG.debug("Liste des crit\u00e8res photo (taille : {}) : " + lstCriterePhoto, (Object)lstCriterePhoto.size());
    }
}

