/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.Formateur;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.toolbox.PluginTagHelper;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.sgbd.MetatagDB;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metatag
extends MetatagDB
implements Cloneable {
    private static final long serialVersionUID = 5615825273534294569L;
    public static final String REGEX_CAPTURE_LIEN = ".*?<a.*?href=\"([^\\\"]*)\".*?<\\/a>.*?";
    public static final Pattern PATTERN_CAPTURE_LIEN = Pattern.compile(".*?<a.*?href=\"([^\\\"]*)\".*?<\\/a>.*?");
    public static final String REGEX_CAPTURE_EXTENSION = "^\\/.*\\.([^?#]*)[?#]?.*";
    public static final Pattern PATTERN_CAPTURE_EXTENSION = Pattern.compile("^\\/.*\\.([^?#]*)[?#]?.*");
    public static final String REGEX_ID_METATAG = "^.*(?:\\D(\\d+))\\.[^.]*$";
    public static final Pattern PATTERN_ID_METATAG = Pattern.compile("^.*(?:\\D(\\d+))\\.[^.]*$");
    private static final Logger LOGGER = LoggerFactory.getLogger(Metatag.class);
    public static String HISTORIQUE_ANNULATION_DEMANDE_VALIDATION = "ANNULATION_DEMANDE_VALIDATION";
    public static String HISTORIQUE_ANNULATION_SUPPRESSION = "ANNULATION_SUPPRESSION";
    public static String HISTORIQUE_ARCHIVAGE = "ARCHIVAGE";
    public static String HISTORIQUE_ARCHIVAGE_AUTO = "ARCHIVAGE_AUTO";
    public static String HISTORIQUE_RUBRIQUAGE = "RUBRIQUAGE";
    public static String HISTORIQUE_RUBRIQUAGE_AUTO = "RUBRIQUAGE_AUTO";
    public static String HISTORIQUE_CREATION = "CREATION";
    public static String HISTORIQUE_DEMANDE_VALIDATION = "DEMANDE_VALIDATION";
    public static String HISTORIQUE_DUPLICATION = "DUPLICATION";
    public static String HISTORIQUE_TRADUCTION = "TRADUCTION";
    public static String HISTORIQUE_MODIFICATION = "MODIFICATION";
    public static String HISTORIQUE_RESTAURATION_ARCHIVAGE = "RESTAURATION_ARCHIVAGE";
    public static String HISTORIQUE_RESTAURATION_SAUVEGARDE = "RESTAURATION_SAUVEGARDE";
    public static String HISTORIQUE_RETOUR_AUTEUR = "RETOUR_AUTEUR";
    public static String HISTORIQUE_SUPPRESSION = "SUPPRESSION";
    public static String HISTORIQUE_VALIDATION = "VALIDATION";

    public void init() {
        this.setIdMetatag(0L);
        this.setMetaIdFiche(0L);
        this.setMetaCodeObjet("");
        this.setMetaLibelleObjet("");
        this.setMetaHistorique("");
        this.setMetaDateArchivage(new Date(0L));
        this.setMetaDateOperation(new Date(System.currentTimeMillis()));
        this.setMetaListeReferences("");
        this.setMetaForum("");
        this.setMetaForumAno("");
        this.setMetaMailAnonyme("");
        this.setMetaSaisieFront("0");
        this.setMetaInTree("0");
        this.setMetaNotificationMail("0");
        this.setMetaDocumentFichiergw("0");
        this.setMetaRubriquesPublication("");
        this.setMetaLibelleFiche("");
        this.setMetaCode("");
        this.setMetaCodeRattachement("");
        this.setMetaCodeRattachementAutres("");
        this.setMetaCodeRubrique("");
        this.setMetaMetaKeywords("");
        this.setMetaMetaDescription("");
        this.setMetaDateCreation(new Date(0L));
        this.setMetaDateProposition(new Date(0L));
        this.setMetaDateValidation(new Date(0L));
        this.setMetaDateModification(new Date(0L));
        this.setMetaCodeRedacteur("");
        this.setMetaCodeValidation("");
        this.setMetaLangue("");
        this.setMetaEtatObjet("");
        this.setMetaNbHits(0L);
        this.setMetaDiffusionPublicVise("");
        this.setMetaDiffusionModeRestriction("");
        this.setMetaDiffusionPublicViseRestriction("");
        this.setMetaNiveauApprobation("");
        this.setMetaSourceImport("");
        this.setMetaDateMiseEnLigne(new Date(0L));
        this.setMetaDateSuppression(new Date(0L));
        this.setMetaDateRubriquage(new Date(0L));
        this.setMetaCodeRubriquage("");
    }

    public void addHistorique(String evenement, String code_auteur, String etat_objet) {
        Vector<String> v = this.getVecteurHistorique();
        if (v.size() > 19) {
            v.removeElementAt(v.size() - 1);
        }
        GregorianCalendar cal = new GregorianCalendar();
        Object[] arguments = new Object[]{cal.get(5), cal.get(2) + 1, cal.get(1), cal.get(11), cal.get(12), cal.get(13)};
        String dateModif = MessageFormat.format("{2,number,0000}{1,number,00}{0,number,00}{3,number,00}{4,number,00}{5,number,00}", arguments);
        String item = "[" + evenement + "/" + dateModif + "/" + code_auteur + "/" + etat_objet + "]";
        v.insertElementAt(item, 0);
        this.setVecteurHistorique(v);
    }

    public void calculerReferences(FicheUniv ficheUniv) {
        int indexDebutMotCleSuivant;
        int indexDebutMotCleSuivant2;
        String references = ficheUniv.getReferences();
        references = references + FicheUnivMgr.getReferenceParTexte(ficheUniv.getContenuEncadre());
        String langue = ficheUniv.getLangue();
        String newRef = "";
        try {
            newRef = newRef + PluginTagHelper.getReferencesTags(references);
        }
        catch (Exception e) {
            LOGGER.error("impossible de calculer les r\u00e9f\u00e9rences des tags", (Throwable)e);
        }
        int indexTexte = 0;
        int indexDebutMotCle = -1;
        int indexFinMotCle = 0;
        while ((indexDebutMotCle = references.indexOf("[id-fiche]", indexTexte)) != -1 && (indexFinMotCle = references.indexOf("[/id-fiche]", indexDebutMotCle)) != -1 && ((indexDebutMotCleSuivant2 = references.indexOf("[id-fiche]", indexDebutMotCle + 1)) == -1 || indexDebutMotCleSuivant2 >= indexFinMotCle)) {
            String chaine = references.substring(indexDebutMotCle + 10, indexFinMotCle);
            Object codeFiche = "";
            String objetReference = "";
            int indiceToken = 0;
            StringTokenizer st = new StringTokenizer(chaine, ";");
            while (st.hasMoreTokens()) {
                if (indiceToken == 0) {
                    objetReference = st.nextToken();
                } else if (indiceToken == 1) {
                    codeFiche = st.nextToken();
                } else {
                    st.nextToken();
                }
                ++indiceToken;
            }
            boolean traitementRequete = false;
            if (((String)codeFiche).length() == 0) {
                traitementRequete = true;
            }
            if (((String)codeFiche).contains("=") && !((String)codeFiche).contains(",LANGUE=")) {
                traitementRequete = true;
            }
            if (!traitementRequete) {
                Object codeReference = "";
                String langueReference = "";
                if (!((String)codeFiche).contains(",LANGUE=")) {
                    codeReference = codeFiche;
                    langueReference = langue;
                } else {
                    codeReference = ((String)codeFiche).substring(0, ((String)codeFiche).indexOf(",LANGUE="));
                    langueReference = ((String)codeFiche).substring(((String)codeFiche).indexOf(",LANGUE=") + 8);
                }
                newRef = newRef + "[" + objetReference + ";" + (String)codeReference + ";" + langueReference + "]";
            }
            indexTexte = indexFinMotCle + 11;
        }
        Set<String> listeLiens = this.getListesLiensParReferences(references);
        if (CollectionUtils.isNotEmpty(listeLiens)) {
            String extension = PropertyHelper.getCoreProperty("application.content_extension");
            for (String lien : listeLiens) {
                String newReferencesMeta;
                if (!this.validerUrlRelative(lien, extension) || !StringUtils.isNotEmpty((CharSequence)(newReferencesMeta = this.getReferenceParMeta(lien)))) continue;
                newRef = newRef + newReferencesMeta;
            }
        }
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        while ((indexDebutMotCle = references.indexOf("[id-document]", indexTexte)) != -1 && (indexFinMotCle = references.indexOf("[/id-document]", indexDebutMotCle)) != -1 && ((indexDebutMotCleSuivant = references.indexOf("[id-document]", indexDebutMotCle + 1)) == -1 || indexDebutMotCleSuivant >= indexFinMotCle)) {
            String document = references.substring(indexDebutMotCle + 14, indexFinMotCle);
            String codeReference = "";
            String langueReference = "";
            if (!document.contains(",LANGUE=")) {
                codeReference = document;
                langueReference = langue;
            } else {
                codeReference = document.substring(0, document.indexOf(",LANGUE="));
                langueReference = document.substring(document.indexOf(",LANGUE=") + 8);
            }
            newRef = newRef + "[document;" + codeReference + ";" + langueReference + "]";
            indexTexte = indexFinMotCle + 14;
        }
        this.setMetaListeReferences(newRef);
    }

    public GregorianCalendar getDateDerniereModification() throws Exception {
        GregorianCalendar cal = null;
        if (this.getVecteurHistorique().size() > 0) {
            StringTokenizer st = new StringTokenizer(this.getVecteurHistorique().elementAt(0), "[/]");
            st.nextToken();
            String date = st.nextToken();
            int annee = Integer.parseInt(date.substring(0, 4));
            int mois = Integer.parseInt(date.substring(4, 6));
            int jour = Integer.parseInt(date.substring(6, 8));
            int heure = Integer.parseInt(date.substring(8, 10));
            int minute = Integer.parseInt(date.substring(10, 12));
            int secondes = Integer.parseInt(date.substring(12, 14));
            cal = new GregorianCalendar(annee, mois - 1, jour, heure, minute, secondes);
        }
        return cal;
    }

    public static String getIntituleAction(String action) {
        String res = "";
        Hashtable<String, String> actions = new Hashtable<String, String>();
        actions.put(HISTORIQUE_SUPPRESSION, "Suppression");
        actions.put(HISTORIQUE_ANNULATION_SUPPRESSION, "Annulation suppression");
        actions.put(HISTORIQUE_RESTAURATION_SAUVEGARDE, "Restauration");
        actions.put(HISTORIQUE_DUPLICATION, "Duplication");
        actions.put(HISTORIQUE_TRADUCTION, "Traduction");
        actions.put(HISTORIQUE_CREATION, "Cr\u00e9ation");
        actions.put(HISTORIQUE_MODIFICATION, "Modification");
        actions.put(HISTORIQUE_VALIDATION, "Validation");
        actions.put(HISTORIQUE_DEMANDE_VALIDATION, "Demande de validation");
        actions.put(HISTORIQUE_ANNULATION_DEMANDE_VALIDATION, "Annulation demande ");
        actions.put(HISTORIQUE_RETOUR_AUTEUR, "Retour au r\u00e9dacteur");
        actions.put(HISTORIQUE_RUBRIQUAGE, "Rubriquage ");
        actions.put(HISTORIQUE_RUBRIQUAGE_AUTO, "Rubriquage automatique ");
        actions.put(HISTORIQUE_ARCHIVAGE, "Archivage ");
        actions.put(HISTORIQUE_ARCHIVAGE_AUTO, "Archivage automatique ");
        actions.put(HISTORIQUE_RESTAURATION_ARCHIVAGE, "Restauration archive");
        if (actions.get(action) != null) {
            res = (String)actions.get(action);
        }
        return res;
    }

    public Vector<String> getVecteurHistorique() {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.getMetaHistorique(), ";");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            v.add(val);
        }
        return v;
    }

    public int select(String codeObjet, Long idFiche) throws Exception {
        ClauseWhere whereCodeObjetIdFiche = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeObjet)) {
            whereCodeObjetIdFiche.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
        }
        if (idFiche != null) {
            whereCodeObjetIdFiche.and(ConditionHelper.egal("META_ID_FICHE", idFiche, TypeOperande.LONG));
        }
        return this.select(whereCodeObjetIdFiche.formaterSQL());
    }

    public int selectParCodeIds(String codeObjet, Collection<String> idsFiches) throws Exception {
        ClauseWhere whereCodeObjetIdFiche = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeObjet)) {
            whereCodeObjetIdFiche.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
        }
        if (CollectionUtils.isNotEmpty(idsFiches)) {
            whereCodeObjetIdFiche.and(ConditionHelper.in("META_ID_FICHE", idsFiches));
        }
        return this.select(whereCodeObjetIdFiche.formaterSQL());
    }

    public int selectParReferences(String codeObjet, String code, String langue, Long idPhoto) throws Exception {
        ClauseWhere whereReferences = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeObjet)) {
            String nomObjet = ReferentielObjets.getNomObjet(codeObjet);
            whereReferences.setPremiereCondition(ConditionHelper.like("META_LISTE_REFERENCES", nomObjet + ";" + code + ";" + langue, "%[", "]%"));
            whereReferences.or(ConditionHelper.like("META_LISTE_REFERENCES", nomObjet + ";" + code + ",%;" + langue, "%[", "]%"));
        }
        if (!idPhoto.equals(new Long(0L))) {
            whereReferences.and(ConditionHelper.like("META_LISTE_REFERENCES", String.valueOf(idPhoto), "%[photo;", "]%"));
        }
        return this.select(whereReferences.formaterSQL());
    }

    public void setVecteurHistorique(Vector<String> v) {
        String liste = "";
        Enumeration<String> en = v.elements();
        while (en.hasMoreElements()) {
            liste = liste + en.nextElement() + ";";
        }
        this.setMetaHistorique(liste);
    }

    public int selectCount(String sqlSuffix) throws Exception {
        int count = 0;
        PreparedStatement _stmt = null;
        try {
            if (sqlSuffix == null) {
                sqlSuffix = "";
            }
            String query = "SELECT COUNT( DISTINCT ID_METATAG ) FROM " + this.qualifier + "METATAG T1 " + sqlSuffix;
            _stmt = this.ctx.getConnection().prepareStatement(query);
            ResultSet _rs = _stmt.executeQuery(query);
            _rs.next();
            count = _rs.getInt(1);
        }
        catch (SQLException exc) {
            throw new Exception("SELECT_FAILED " + exc);
        }
        finally {
            _stmt = null;
        }
        return count;
    }

    public Hashtable<String, String> getListeObjetsRedacteur(String codeRedacteur) throws Exception {
        Hashtable<String, String> hTypeFiche = new Hashtable<String, String>();
        PreparedStatement _stmt = null;
        try {
            ClauseWhere whereCodeRedacteur = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_REDACTEUR", codeRedacteur));
            String query = "SELECT DISTINCT ( META_CODE_OBJET ) FROM " + this.qualifier + " METATAG T1 " + whereCodeRedacteur.formaterSQL();
            _stmt = this.ctx.getConnection().prepareStatement(query);
            ResultSet _rs = _stmt.executeQuery();
            while (_rs.next()) {
                hTypeFiche.put(_rs.getString(1), "");
            }
        }
        catch (Exception exc) {
            throw new Exception("Erreur lors de la r\u00e9cup\u00e9ration des objets utilisateurs ");
        }
        finally {
            _stmt = null;
        }
        return hTypeFiche;
    }

    private void testerCoherenceChamp(List<String> differences, String nomChamp, String valeurMeta, String valeurFiche) {
        if (valeurMeta == null || !valeurMeta.equals(valeurFiche)) {
            differences.add("champ: " + nomChamp + " fiche: " + valeurFiche + " meta:" + valeurMeta);
        }
    }

    public List<String> controlerCoherenceAvecFiche(FicheUniv ficheRef) {
        ArrayList<String> differences = new ArrayList<String>();
        this.testerCoherenceChamp(differences, "code", this.getMetaCode(), ficheRef.getCode());
        this.testerCoherenceChamp(differences, "code_rattachement", this.getMetaCodeRattachement(), ficheRef.getCodeRattachement());
        String codeRubriqueFiche = ficheRef.getCodeRubrique();
        this.testerCoherenceChamp(differences, "code_rubrique", this.getMetaCodeRubrique(), codeRubriqueFiche);
        String dateMeta = Formateur.formater(this.getMetaDateCreation());
        String dateFiche = Formateur.formater(ficheRef.getDateCreation());
        this.testerCoherenceChamp(differences, "date_creation", dateMeta, dateFiche);
        dateMeta = Formateur.formater(this.getMetaDateProposition());
        dateFiche = Formateur.formater(ficheRef.getDateProposition());
        this.testerCoherenceChamp(differences, "date_proposition", dateMeta, dateFiche);
        dateMeta = Formateur.formater(this.getMetaDateValidation());
        dateFiche = Formateur.formater(ficheRef.getDateValidation());
        this.testerCoherenceChamp(differences, "date_validation", dateMeta, dateFiche);
        dateMeta = Formateur.formater(this.getMetaDateModification());
        dateFiche = Formateur.formater(ficheRef.getDateModification());
        this.testerCoherenceChamp(differences, "date_modification", dateMeta, dateFiche);
        dateMeta = Formateur.formater(this.getMetaDateModification());
        dateFiche = Formateur.formater(ficheRef.getDateModification());
        this.testerCoherenceChamp(differences, "date_modification", dateMeta, dateFiche);
        dateMeta = Formateur.formater(this.getMetaDateModification());
        dateFiche = Formateur.formater(ficheRef.getDateModification());
        this.testerCoherenceChamp(differences, "date_modification", dateMeta, dateFiche);
        this.testerCoherenceChamp(differences, "code_redacteur", this.getMetaCodeRedacteur(), ficheRef.getCodeRedacteur());
        this.testerCoherenceChamp(differences, "code_validation", this.getMetaCodeValidation(), ficheRef.getCodeValidation());
        this.testerCoherenceChamp(differences, "langue", this.getMetaLangue(), ficheRef.getLangue());
        this.testerCoherenceChamp(differences, "etat_objet", this.getMetaEtatObjet(), ficheRef.getEtatObjet());
        String codeRattachementAutres = "";
        if (ficheRef instanceof FicheRattachementsSecondaires) {
            codeRattachementAutres = Chaine.convertirPointsVirgulesEnAccolades(((FicheRattachementsSecondaires)((Object)ficheRef)).getCodeRattachementAutres());
            this.testerCoherenceChamp(differences, "code_rattachement_autres", this.getMetaCodeRattachementAutres(), codeRattachementAutres);
        }
        String diffusionPublicVise = "";
        if (ficheRef instanceof DiffusionSelective) {
            diffusionPublicVise = ((DiffusionSelective)((Object)ficheRef)).getDiffusionPublicVise();
            this.testerCoherenceChamp(differences, "diffusion_public_vise", this.getMetaDiffusionPublicVise(), diffusionPublicVise);
        }
        String diffusionModeRestriction = "";
        if (ficheRef instanceof DiffusionSelective) {
            diffusionModeRestriction = ((DiffusionSelective)((Object)ficheRef)).getDiffusionModeRestriction();
            this.testerCoherenceChamp(differences, "diffusion_public_vise", this.getMetaDiffusionModeRestriction(), diffusionModeRestriction);
        }
        String diffusionPublicViseRestriction = "";
        if (ficheRef instanceof DiffusionSelective) {
            diffusionPublicViseRestriction = ((DiffusionSelective)((Object)ficheRef)).getDiffusionPublicViseRestriction();
            this.testerCoherenceChamp(differences, "diffusion_public_vise", this.getMetaDiffusionPublicViseRestriction(), diffusionPublicViseRestriction);
        }
        return differences;
    }

    public void synchroniser(FicheUniv ficheUniv, boolean calculerReferences) throws Exception {
        if (calculerReferences) {
            this.calculerReferences(ficheUniv);
        }
        this.setMetaIdFiche(ficheUniv.getIdFiche());
        this.setMetaCodeRattachement(ficheUniv.getCodeRattachement());
        this.setMetaCodeRubrique(ficheUniv.getCodeRubrique());
        if (ficheUniv instanceof FicheRattachementsSecondaires) {
            this.setMetaCodeRattachementAutres(Chaine.convertirPointsVirgulesEnAccolades(((FicheRattachementsSecondaires)((Object)ficheUniv)).getCodeRattachementAutres()));
        } else {
            this.setMetaCodeRattachementAutres("");
        }
        this.setMetaLibelleObjet(ReferentielObjets.getLibelleObjet(this.getMetaCodeObjet()));
        this.setMetaLibelleFiche(ficheUniv.getLibelleAffichable());
        this.setMetaMetaKeywords(ficheUniv.getMetaKeywords());
        this.setMetaMetaDescription(ficheUniv.getMetaDescription());
        this.setMetaDateCreation(ficheUniv.getDateCreation());
        this.setMetaDateProposition(ficheUniv.getDateProposition());
        this.setMetaDateValidation(ficheUniv.getDateValidation());
        this.setMetaDateModification(ficheUniv.getDateModification());
        this.setMetaCodeRedacteur(ficheUniv.getCodeRedacteur());
        this.setMetaCodeValidation(ficheUniv.getCodeValidation());
        this.setMetaCode(ficheUniv.getCode());
        this.setMetaLangue(ficheUniv.getLangue());
        this.setMetaEtatObjet(ficheUniv.getEtatObjet());
        this.setMetaNbHits(ficheUniv.getNbHits());
        if (ficheUniv instanceof DiffusionSelective) {
            this.setMetaDiffusionPublicVise(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicVise());
            this.setMetaDiffusionModeRestriction(((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction());
            if (((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction().equals("4")) {
                this.setMetaForumAno("0");
            }
            this.setMetaDiffusionPublicViseRestriction(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction());
        } else {
            this.setMetaDiffusionPublicVise("");
            this.setMetaDiffusionModeRestriction("0");
            this.setMetaDiffusionPublicViseRestriction("");
        }
        if (this.getMetaForumAno() == null) {
            this.setMetaForumAno("");
        }
        if (!Formateur.estSaisie(this.getMetaDateMiseEnLigne())) {
            this.setMetaDateMiseEnLigne(ficheUniv.getDateCreation());
        }
    }

    public Metatag clone() throws CloneNotSupportedException {
        return (Metatag)super.clone();
    }

    protected Set<String> getListesLiensParReferences(String references) {
        HashSet<String> listeReferences = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)references)) {
            Matcher matcher = PATTERN_CAPTURE_LIEN.matcher(references);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String url = matcher.group(1);
                    if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("URL detect\u00e9e : %s", url));
                    }
                    listeReferences.add(url);
                }
            }
        }
        return listeReferences;
    }

    public String getReferenceParMeta(String url) {
        String idMetatag = this.getIdMetaParUrl(url);
        if (StringUtils.isNotEmpty((CharSequence)idMetatag)) {
            try (ContexteDao ctxConnection = new ContexteDao();){
                Metatag meta = new Metatag();
                meta.setCtx(ctxConnection);
                try {
                    meta.setIdMetatag(Long.valueOf(idMetatag));
                }
                catch (NumberFormatException e1) {
                    LOGGER.error("Le metatag r\u00e9cuper\u00e9 n'est pas num\u00e9rique", (Throwable)e1);
                    String string = "";
                    if (ctxConnection != null) {
                        if (var4_4 != null) {
                            try {
                                ctxConnection.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            ctxConnection.close();
                        }
                    }
                    return string;
                }
                try {
                    meta.retrieve();
                }
                catch (Exception e) {
                    LOGGER.error("Impossible de retrouver le metatag", (Throwable)e);
                    String string = "";
                    if (ctxConnection != null) {
                        if (var4_4 != null) {
                            try {
                                ctxConnection.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            ctxConnection.close();
                        }
                    }
                    return string;
                }
                String objet = ReferentielObjets.getNomObjet(meta.getMetaCodeObjet());
                String langueObjet = meta.getMetaLangue();
                String codeFiche = meta.getMetaCode();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ajout de la r\u00e9ference, objet : %s , code : %s , langue : %s", new Object[]{objet, codeFiche, langueObjet});
                }
                String string = "[" + objet + ";" + codeFiche + ";" + langueObjet + "]";
                return string;
            }
        }
        return "";
    }

    protected String getIdMetaParUrl(String url) {
        Matcher matcherIdMeta;
        if (StringUtils.isNotEmpty((CharSequence)url) && (matcherIdMeta = PATTERN_ID_METATAG.matcher(url)).find() && StringUtils.isNotEmpty((CharSequence)matcherIdMeta.group(1))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("ID M\u00e9tatag trouv\u00e9 : %s", matcherIdMeta.group(1)));
            }
            return matcherIdMeta.group(1);
        }
        return "";
    }

    protected boolean validerUrlRelative(String url, String extension) {
        Matcher matcherValidationUrl;
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)extension) && (matcherValidationUrl = PATTERN_CAPTURE_EXTENSION.matcher(url)).find() && StringUtils.isNotEmpty((CharSequence)matcherValidationUrl.group(1))) {
            return matcherValidationUrl.group(1).equals(extension);
        }
        return false;
    }
}

