/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.cms.objetspartages.annotation.FicheAnnotation;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheExportableXML;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.LigneContenu;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ParagrapheBean;
import com.univ.objetspartages.om.ParagrapheContenuHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.sgbd.PagelibreDB;
import com.univ.utils.ContexteUniv;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import com.univ.xml.NodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@FicheAnnotation(isSaisieFrontOffice=false, isEncadreRecherche=false, isEncadreRechercheEmbarquable=false)
public class PageLibre
extends PagelibreDB
implements FicheUniv,
DiffusionSelective,
FicheExportableXML {
    private static final long serialVersionUID = -7363849185331290776L;

    public static String getLibelleAffichable(OMContext ctx, String codes, String langue) throws Exception {
        String res = "";
        if (codes == null || codes.length() == 0) {
            return res;
        }
        PageLibre pagelibre = new PageLibre();
        pagelibre.init();
        pagelibre.setCtx(ctx);
        if (langue == null || langue.length() == 0) {
            langue = "0";
        }
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            int count = pagelibre.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = pagelibre.selectCodeLangueEtat(code, langue, "");
            }
            if (count > 0) {
                if (res.length() > 1) {
                    res = res + ";";
                }
                if (!pagelibre.nextItem()) continue;
                res = res + pagelibre.getLibelleAffichable();
                continue;
            }
            res = res + "-";
        }
        return res;
    }

    public static PageLibre getFichePagelibre(OMContext ctx, String code, String langue) throws Exception {
        PageLibre fiche = null;
        if (code != null && code.length() > 0) {
            if (langue == null || langue.length() == 0) {
                langue = "0";
            }
            fiche = new PageLibre();
            fiche.init();
            fiche.setCtx(ctx);
            int count = fiche.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, langue, "");
            }
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, "", "0003");
            }
            if (count > 0) {
                fiche.nextItem();
            }
        }
        return fiche;
    }

    @Override
    public void init() {
        FicheUnivMgr.init(this);
        this.setIdPagelibre(new Long(0L));
        String timeStamp = Long.toString(System.currentTimeMillis());
        this.setCode(timeStamp.substring(timeStamp.length() - 8, timeStamp.length()));
        this.setLangue("0");
        this.setTitre("");
        this.setRattachementBandeau("");
        this.setContenu("");
        this.setComplements("");
    }

    @Override
    public String getLibelleAffichable() {
        return this.getTitre().length() > 0 ? this.getTitre() : "-";
    }

    @Override
    public Long getIdFiche() {
        return this.getIdPagelibre();
    }

    @Override
    public void setIdFiche(Long idFiche) {
        this.setIdPagelibre(idFiche);
    }

    public String getFormatedComplements() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)this.ctx, this.getComplements());
    }

    public InfosRubriques getInfosRubrique() throws Exception {
        return Rubrique.renvoyerItemRubrique(this.getCodeRubrique());
    }

    public InfosStructure getInfosStructure() throws Exception {
        return Structure.renvoyerItemStructure(this.getCodeRattachement(), this.getLangue());
    }

    public Metatag getMeta() throws Exception {
        return FicheUnivMgr.lireMeta(this);
    }

    @Override
    public String getFullTextString() throws Exception {
        return this.getContenu() + " " + this.getComplements();
    }

    @Override
    public void dupliquer(String nouvelleLangue) throws Exception {
        FicheUnivMgr.dupliquer(this);
        this.setIdFiche(new Long(0L));
        this.setLangue(nouvelleLangue);
        this.add();
    }

    @Override
    public int traiterRequete(String requete) throws Exception {
        String titre = RequeteUtil.renvoyerParametre(requete, "TITRE");
        String motsCles = RequeteUtil.renvoyerParametre(requete, "MOTS_CLES");
        String codeRubrique = RequeteUtil.renvoyerParametre(requete, "CODE_RUBRIQUE");
        String codeRattachement = RequeteUtil.renvoyerParametre(requete, "CODE_RATTACHEMENT");
        String langue = RequeteUtil.renvoyerParametre(requete, "LANGUE");
        String code = RequeteUtil.renvoyerParametre(requete, "CODE");
        String selection = RequeteUtil.renvoyerParametre(requete, "SELECTION");
        String nombre = RequeteUtil.renvoyerParametre(requete, "NOMBRE");
        String etatObjet = (String)StringUtils.defaultIfBlank((CharSequence)RequeteUtil.renvoyerParametre(requete, "ETAT_OBJET"), (CharSequence)EtatFiche.EN_LIGNE.toString());
        String codeRedacteur = RequeteUtil.renvoyerParametre(requete, "CODE_REDACTEUR");
        String order = "";
        if (selection.length() > 0 && selection.equals("0007")) {
            order = "META.META_DATE_MISE_EN_LIGNE DESC";
        }
        return this.select(code, titre, motsCles, langue, codeRattachement, codeRubrique, codeRedacteur, etatObjet, nombre, order);
    }

    @Override
    public int selectCodeLangueEtat(String code, String langue, String etatObjet) throws Exception {
        RequeteSQL codeLangueEtatOrdreSurTitre = new RequeteSQL();
        ClauseWhere whereCodeLangueEtat = ConditionHelper.whereCodeLangueEtat(code, langue, etatObjet);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeLangueEtatOrdreSurTitre.where(whereCodeLangueEtat).orderBy(orderBy);
        return this.select(codeLangueEtatOrdreSurTitre.formaterRequete());
    }

    @Override
    @Deprecated
    public int selectParCodeRubrique(String codeRubrique, String langue) throws Exception {
        RequeteSQL codeRubriqueLangueEnLigneOrdreTitre = new RequeteSQL();
        ClauseWhere whereCodeRubriqueLangueEtat = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            whereCodeRubriqueLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_RUBRIQUE", codeRubrique));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
        }
        whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", "0003"));
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeRubriqueLangueEnLigneOrdreTitre.where(whereCodeRubriqueLangueEtat).orderBy(orderBy);
        return this.select(codeRubriqueLangueEnLigneOrdreTitre.formaterRequete());
    }

    @Override
    public String getReferences() {
        return FicheUnivMgr.getReferenceParTexte(this.getContenu()) + FicheUnivMgr.getReferenceParTexte(this.getComplements()) + FicheUnivMgr.getReferenceParJointure("structure", this.getCodeRattachement());
    }

    public int select(String code, String titre, String motsCles, String langue, String codeRattachement, String codeRubrique, String codeRedacteur, String etatObjet, String nombre, String order) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            where.setPremiereCondition(ConditionHelper.rechercheMots("TITRE", titre));
        }
        if (StringUtils.isNotEmpty((CharSequence)motsCles)) {
            where.and(ConditionHelper.rechercheMots("META_KEYWORDS", motsCles));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure("CODE_RATTACHEMENT", codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar("CODE_REDACTEUR", codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar("T1.CODE", code));
        }
        requeteSelect = RequeteSQLHelper.getRequeteGenerique(where, this.ctx, this, codeRubrique);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy(order);
        } else {
            orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        }
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(this.ctx, nombre);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }

    public String getLibelleBackOffice() {
        return this.getLibelleAffichable() + " [" + Rubrique.getIntitule(this.getCodeRubrique()) + "]";
    }

    @Deprecated
    public Vector<ParagrapheBean> getParagraphes() throws Exception {
        return ParagrapheContenuHelper.getParagraphes(this.getContenu());
    }

    public Collection<LigneContenu> getLignes() throws Exception {
        return ParagrapheContenuHelper.getLignes(this.getContenu());
    }

    public void setParagraphes(ArrayList<ParagrapheBean> _listeParagraphes) throws Exception {
        this.setContenu(ParagrapheContenuHelper.formateParagraphes(_listeParagraphes));
    }

    public String getRubriqueEncadre() {
        String rubrique = "";
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(this.getCodeRubrique());
        BeanPageAccueil beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(infos);
        rubrique = beanAccueil != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil && this.getCode().equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getCode()) && this.getLangue().equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getLangue()) && ReferentielObjets.getNomObjet(this).equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getObjet()) ? infos.getCodeRubriqueMere() : this.getCodeRubrique();
        return rubrique;
    }

    @Override
    public Node exportNodeFiche(Node liste, String formatExport) throws Exception {
        Document document = liste.getOwnerDocument();
        Element fiche = document.createElement("PAGELIBRE");
        NodeUtil.addNode((Node)fiche, "CODE", this.getCode());
        NodeUtil.addNode((Node)fiche, "LANGUE", this.getLangue());
        NodeUtil.addNode((Node)fiche, "RATTACHEMENT", Structure.getLibelleRattachement(this.ctx, this.getCodeRattachement(), this.getLangue(), true));
        NodeUtil.addNode((Node)fiche, "LIBELLE", this.getLibelleAffichable());
        NodeUtil.addNode((Node)fiche, "TITRE", this.getTitre());
        NodeUtil.addNode((Node)fiche, "CODE_RUBRIQUE", this.getCodeRubrique());
        NodeUtil.addNode((Node)fiche, "RUBRIQUE", Rubrique.renvoyerItemRubrique(this.getCodeRubrique()).getIntitule());
        Element nodeContenu = document.createElement("CONTENU");
        Vector<ParagrapheBean> listeParagraphes = this.getParagraphes();
        Enumeration<ParagrapheBean> e = listeParagraphes.elements();
        ParagrapheBean paragraphe = null;
        while (e.hasMoreElements()) {
            Element nodeParagraphe = document.createElement("PARAGRAPHE");
            paragraphe = e.nextElement();
            Enumeration<SousParagrapheBean> e3 = paragraphe.getSousParagraphes().elements();
            while (e3.hasMoreElements()) {
                Element nodeSousParagraphe = document.createElement("SOUS_PARAGRAPHE");
                SousParagrapheBean sousParagraphe = e3.nextElement();
                NodeUtil.addNode((Node)nodeSousParagraphe, "TITRE", sousParagraphe.getTitre());
                NodeUtil.addNode((Node)nodeSousParagraphe, "VALEUR", sousParagraphe.getContenu());
                nodeParagraphe.appendChild(nodeSousParagraphe);
            }
            nodeContenu.appendChild(nodeParagraphe);
        }
        fiche.appendChild(nodeContenu);
        return fiche;
    }
}

