/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class Perimetre {
    private String codeStructure = "";
    private String codeRubrique = "";
    private String codeProfil = "";
    private String codeGroupe = "";
    private String codeEspaceCollaboratif = "";
    private String identifiantNiveau = "";

    public Perimetre(String chaineSerialisee) {
        this.codeStructure = "";
        this.codeRubrique = "";
        this.codeProfil = "";
        this.codeGroupe = "";
        this.codeEspaceCollaboratif = "";
        String chaineTmp = chaineSerialisee;
        int indice = 0;
        while (chaineTmp.length() > 0) {
            String item = "";
            int iSlash = chaineTmp.indexOf(47);
            if (iSlash != -1) {
                item = chaineTmp.substring(0, iSlash);
                chaineTmp = chaineTmp.substring(iSlash + 1);
            } else {
                item = chaineTmp;
                chaineTmp = "";
            }
            switch (indice) {
                case 0: {
                    this.codeStructure = item;
                    break;
                }
                case 1: {
                    this.codeRubrique = item;
                    break;
                }
                case 2: {
                    this.codeProfil = item;
                    break;
                }
                case 3: {
                    this.codeGroupe = item;
                    break;
                }
                case 4: {
                    this.codeEspaceCollaboratif = item;
                }
            }
            ++indice;
        }
        this.identifiantNiveau = this.codeStructure + "/" + this.codeRubrique + "/" + this.codeGroupe + "/" + this.codeEspaceCollaboratif;
    }

    public Perimetre(String _codeStructure, String _codeRubrique, String _codeProfil, String _codeGroupe, String _codeEspaceCollaboratif) {
        this.codeStructure = _codeStructure;
        this.codeRubrique = _codeRubrique;
        this.codeProfil = _codeProfil;
        this.codeGroupe = _codeGroupe;
        this.codeEspaceCollaboratif = _codeEspaceCollaboratif;
        this.identifiantNiveau = this.codeStructure + "/" + this.codeRubrique + "/" + this.codeGroupe + "/" + this.codeEspaceCollaboratif;
    }

    public String getChaineSerialisee() {
        String res = "";
        if (this.getCodeStructure().length() > 0) {
            res = res + this.getCodeStructure();
        }
        res = res + "/";
        if (this.getCodeRubrique().length() > 0) {
            res = res + this.getCodeRubrique();
        }
        res = res + "/";
        if (this.getCodeProfil().length() > 0) {
            res = res + this.getCodeProfil();
        }
        res = res + "/";
        if (this.getCodeGroupe().length() > 0) {
            res = res + this.getCodeGroupe();
        }
        res = res + "/";
        if (this.getCodeEspaceCollaboratif().length() > 0) {
            res = res + this.getCodeEspaceCollaboratif();
        }
        return res;
    }

    public void setCodeGroupe(String codeGroupe) {
        this.codeGroupe = codeGroupe;
    }

    public String getCodeGroupe() {
        return this.codeGroupe;
    }

    public String getCodeRubrique() {
        return this.codeRubrique;
    }

    public String getCodeStructure() {
        return this.codeStructure;
    }

    public String getCodeProfil() {
        return this.codeProfil;
    }

    public boolean estConformeAuPerimetre(Perimetre perimetre) {
        boolean estUnSousPerimetre = true;
        if (!"*".equals(this.getCodeStructure())) {
            if (StringUtils.isNotBlank((CharSequence)perimetre.getCodeStructure())) {
                estUnSousPerimetre = false;
                if ("-".equals(perimetre.getCodeStructure())) {
                    estUnSousPerimetre = StringUtils.isEmpty((CharSequence)this.getCodeStructure());
                } else if (perimetre.getCodeStructure().equals(this.getCodeStructure())) {
                    estUnSousPerimetre = true;
                } else {
                    Iterator<InfosStructure> listeStructures = Structure.renvoyerItemStructure(perimetre.getCodeStructure()).getListeSousStructuresTousNiveaux().iterator();
                    while (listeStructures.hasNext() && !estUnSousPerimetre) {
                        if (!listeStructures.next().getCode().equals(this.getCodeStructure())) continue;
                        estUnSousPerimetre = true;
                    }
                }
            }
            if (!estUnSousPerimetre) {
                return false;
            }
        }
        if (!"*".equals(this.getCodeRubrique())) {
            if (StringUtils.isNotBlank((CharSequence)perimetre.getCodeRubrique())) {
                estUnSousPerimetre = false;
                if ("-".equals(perimetre.getCodeRubrique())) {
                    estUnSousPerimetre = StringUtils.isEmpty((CharSequence)this.getCodeRubrique());
                } else if (perimetre.getCodeRubrique().equals(this.getCodeRubrique())) {
                    estUnSousPerimetre = true;
                } else {
                    InfosRubriques rubriquePerimetre = Rubrique.renvoyerItemRubrique(perimetre.getCodeRubrique());
                    InfosRubriques rubriqueThis = Rubrique.renvoyerItemRubrique(this.getCodeRubrique());
                    estUnSousPerimetre = rubriquePerimetre.contains(rubriqueThis);
                }
            }
            if (!estUnSousPerimetre) {
                return false;
            }
        }
        if (!"*".equals(this.getCodeGroupe()) && StringUtils.isNotBlank((CharSequence)perimetre.getCodeGroupe())) {
            estUnSousPerimetre = false;
            if ("-".equals(perimetre.getCodeGroupe())) {
                estUnSousPerimetre = StringUtils.isEmpty((CharSequence)this.getCodeGroupe());
            } else if (perimetre.getCodeGroupe().equals(this.getCodeGroupe())) {
                estUnSousPerimetre = true;
            } else {
                InfosGroupeDsi groupePerimetre = Groupedsi.renvoyerItemGroupeDsi(perimetre.getCodeGroupe());
                InfosGroupeDsi groupeThis = Groupedsi.renvoyerItemGroupeDsi(this.getCodeGroupe());
                estUnSousPerimetre = groupePerimetre.contains(groupeThis);
            }
            if (!estUnSousPerimetre) {
                return false;
            }
        }
        if (!"*".equals(this.getCodeEspaceCollaboratif()) && StringUtils.isNotBlank((CharSequence)perimetre.getCodeEspaceCollaboratif()) && !perimetre.getCodeEspaceCollaboratif().equals(this.getCodeEspaceCollaboratif())) {
            estUnSousPerimetre = false;
        }
        return estUnSousPerimetre;
    }

    public boolean estUnSousPerimetreDe(Perimetre _perimetre, boolean _masque) {
        String codeGroupePerimetre;
        boolean estUnSousPerimetre = true;
        if (!_masque || this.codeStructure.length() > 0) {
            String codeStructurePerimetre = _perimetre.getCodeStructure();
            if (codeStructurePerimetre.length() > 0) {
                estUnSousPerimetre = false;
                if (codeStructurePerimetre.equals("-")) {
                    if (this.codeStructure.equals("-")) {
                        estUnSousPerimetre = true;
                    }
                } else if (this.codeStructure.equals(codeStructurePerimetre)) {
                    estUnSousPerimetre = true;
                } else if (Structure.renvoyerItemStructure(codeStructurePerimetre).getListeSousStructuresTousNiveaux().contains(Structure.renvoyerItemStructure(this.codeStructure))) {
                    estUnSousPerimetre = true;
                }
            }
            if (!estUnSousPerimetre) {
                return false;
            }
        }
        if (!_masque || this.codeRubrique.length() > 0) {
            String codeRubriquePerimetre = _perimetre.getCodeRubrique();
            if (codeRubriquePerimetre.length() > 0) {
                estUnSousPerimetre = false;
                if (codeRubriquePerimetre.equals("-")) {
                    if (this.codeRubrique.equals("-")) {
                        estUnSousPerimetre = true;
                    }
                } else if (this.codeRubrique.equals(codeRubriquePerimetre)) {
                    estUnSousPerimetre = true;
                } else {
                    InfosRubriques rubriquePerimetre = Rubrique.renvoyerItemRubrique(codeRubriquePerimetre);
                    InfosRubriques rubriqueThis = Rubrique.renvoyerItemRubrique(this.codeRubrique);
                    estUnSousPerimetre = rubriquePerimetre.contains(rubriqueThis);
                }
            }
            if (!estUnSousPerimetre) {
                return false;
            }
        }
        if (!(_masque && this.codeGroupe.length() <= 0 || (codeGroupePerimetre = _perimetre.getCodeGroupe()).length() <= 0)) {
            estUnSousPerimetre = false;
            if (codeGroupePerimetre.equals("-")) {
                if (this.codeGroupe.equals("-")) {
                    estUnSousPerimetre = true;
                }
            } else if (this.codeGroupe.equals(codeGroupePerimetre)) {
                estUnSousPerimetre = true;
            } else {
                InfosGroupeDsi groupePerimetre = Groupedsi.renvoyerItemGroupeDsi(codeGroupePerimetre);
                InfosGroupeDsi groupeThis = Groupedsi.renvoyerItemGroupeDsi(this.codeGroupe);
                estUnSousPerimetre = groupePerimetre.contains(groupeThis);
            }
        }
        if (!(_masque && this.getCodeEspaceCollaboratif().length() <= 0 || _perimetre.getCodeEspaceCollaboratif().length() <= 0 || this.getCodeEspaceCollaboratif().equals(_perimetre.getCodeEspaceCollaboratif()))) {
            estUnSousPerimetre = false;
        }
        return estUnSousPerimetre;
    }

    public boolean estPartiellementConformeAuPerimetre(Perimetre _perimetre) {
        boolean estUnSousPerimetre = false;
        if (this.getCodeStructure().length() > 0) {
            if (_perimetre.getCodeStructure().length() > 0) {
                if (!_perimetre.getCodeStructure().equals("-")) {
                    if (this.getCodeStructure().equals(_perimetre.getCodeStructure())) {
                        estUnSousPerimetre = true;
                    } else {
                        for (InfosStructure infosStructure : Structure.renvoyerItemStructure(_perimetre.getCodeStructure()).getListeSousStructuresTousNiveaux()) {
                            if (!infosStructure.getCode().equals(this.getCodeStructure())) continue;
                            estUnSousPerimetre = true;
                        }
                    }
                }
            } else {
                estUnSousPerimetre = true;
            }
        }
        if (estUnSousPerimetre) {
            return true;
        }
        if (this.getCodeRubrique().length() > 0) {
            if (_perimetre.getCodeRubrique().length() > 0) {
                if (!_perimetre.getCodeRubrique().equals("-")) {
                    if (this.getCodeRubrique().equals(_perimetre.getCodeRubrique())) {
                        estUnSousPerimetre = true;
                    } else {
                        InfosRubriques rubriquePerimetre = Rubrique.renvoyerItemRubrique(_perimetre.getCodeRubrique());
                        InfosRubriques rubriqueThis = Rubrique.renvoyerItemRubrique(this.getCodeRubrique());
                        estUnSousPerimetre = rubriquePerimetre.contains(rubriqueThis);
                    }
                }
            } else {
                estUnSousPerimetre = true;
            }
        }
        if (estUnSousPerimetre) {
            return true;
        }
        if (this.getCodeGroupe().length() > 0) {
            if (_perimetre.getCodeGroupe().length() > 0) {
                if (!_perimetre.getCodeGroupe().equals("-")) {
                    if (this.getCodeGroupe().equals(_perimetre.getCodeGroupe())) {
                        estUnSousPerimetre = true;
                    } else {
                        InfosGroupeDsi groupePerimetre = Groupedsi.renvoyerItemGroupeDsi(_perimetre.getCodeGroupe());
                        InfosGroupeDsi groupeThis = Groupedsi.renvoyerItemGroupeDsi(this.getCodeGroupe());
                        estUnSousPerimetre = groupePerimetre.contains(groupeThis);
                    }
                }
            } else {
                estUnSousPerimetre = true;
            }
        }
        if (this.getCodeEspaceCollaboratif().length() > 0) {
            if (_perimetre.getCodeEspaceCollaboratif().length() > 0) {
                if (this.getCodeEspaceCollaboratif().equals(_perimetre.getCodeEspaceCollaboratif())) {
                    estUnSousPerimetre = true;
                }
            } else {
                estUnSousPerimetre = true;
            }
        }
        return estUnSousPerimetre;
    }

    public static Perimetre calculerPerimetrePermission(Perimetre _perimetreAffectation, Perimetre _perimetreRole) {
        InfosRubriques infosRub;
        InfosStructure infosStruct;
        boolean isRubOk = false;
        boolean isStructOk = false;
        String codeStructure = _perimetreRole.getCodeStructure();
        if (_perimetreAffectation.getCodeStructure().length() > 0 && !_perimetreAffectation.getCodeStructure().equals("-") && (infosStruct = Structure.renvoyerItemStructure(codeStructure = _perimetreAffectation.getCodeStructure())).getCode().length() > 0) {
            isStructOk = true;
        }
        String codeRubrique = _perimetreRole.getCodeRubrique();
        if (_perimetreAffectation.getCodeRubrique().length() > 0 && !_perimetreAffectation.getCodeRubrique().equals("-") && (infosRub = Rubrique.renvoyerItemRubrique(codeRubrique = _perimetreAffectation.getCodeRubrique())).getCode().length() > 0) {
            isRubOk = true;
        }
        String codeGroupe = _perimetreRole.getCodeGroupe();
        if (_perimetreAffectation.getCodeGroupe().length() > 0) {
            codeGroupe = _perimetreAffectation.getCodeGroupe();
        }
        String codeProfil = _perimetreRole.getCodeProfil();
        if (_perimetreAffectation.getCodeProfil().length() > 0) {
            codeProfil = _perimetreAffectation.getCodeProfil();
        }
        String codeEspaceCollabortif = _perimetreRole.getCodeEspaceCollaboratif();
        if (_perimetreAffectation.getCodeEspaceCollaboratif().length() > 0) {
            codeEspaceCollabortif = _perimetreAffectation.getCodeEspaceCollaboratif();
        }
        if (!isRubOk) {
            InfosRubriques infosRub2 = Rubrique.renvoyerItemRubrique(codeRubrique);
            if (codeRubrique.length() > 0 && infosRub2.getCode().length() == 0 && !codeRubrique.equals("-")) {
                return null;
            }
        }
        if (!isStructOk) {
            InfosStructure infosStruct2 = Structure.renvoyerItemStructure(codeStructure);
            if (codeStructure.length() > 0 && infosStruct2.getCode().length() == 0 && !codeStructure.equals("-")) {
                return null;
            }
        }
        return new Perimetre(codeStructure, codeRubrique, codeProfil, codeGroupe, codeEspaceCollabortif);
    }

    public void setCodeProfil(String codeProfil) {
        this.codeProfil = codeProfil;
    }

    public String getCodeEspaceCollaboratif() {
        return this.codeEspaceCollaboratif;
    }

    public void setCodeEspaceCollaboratif(String codeEspaceCollaboratif) {
        this.codeEspaceCollaboratif = codeEspaceCollaboratif;
    }

    public boolean equals(Perimetre perimetre) {
        return this.getChaineSerialisee().equals(perimetre.getChaineSerialisee());
    }

    public String getIdentifiantNiveau() {
        return this.identifiantNiveau;
    }

    public String toString() {
        return this.getChaineSerialisee();
    }
}

