/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.objetspartages.sgbd.PreferencesDB;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Preferences
extends PreferencesDB {
    public static final String TYPE_SERVICE = "S";
    public static final String TOUS_SERVICES = "TOUS";

    public void init() {
        this.setIdPreferences(new Long(0L));
        this.setCodeUtilisateur("");
        this.setType("");
        this.setNom("");
        this.setValeur("");
    }

    public int selectPreferencesUser(String codeUser) throws Exception {
        int resultat = 0;
        if (codeUser != null) {
            RequeteSQL requeteParPreferencesUser = new RequeteSQL();
            ClauseOrderBy orderBy = new ClauseOrderBy("T1.SERVICE", ClauseOrderBy.SensDeTri.ASC);
            ClauseWhere where = new ClauseWhere();
            where.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", codeUser));
            where.and(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
            requeteParPreferencesUser.where(where).orderBy(orderBy);
            resultat = this.select(requeteParPreferencesUser.formaterRequete());
        }
        return resultat;
    }

    public int selectUserPreferences(String codeUser, String service, String nom) throws Exception {
        ClauseWhere whereUserTypeServiceNom = new ClauseWhere();
        whereUserTypeServiceNom.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", codeUser));
        whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
        whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.SERVICE", service));
        whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.NOM", nom));
        return this.select(whereUserTypeServiceNom.formaterSQL());
    }

    public void deleteAllPreferences(String codeService) throws Exception {
        if (codeService != null) {
            ClauseWhere whereTypeService = new ClauseWhere();
            whereTypeService.setPremiereCondition(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
            whereTypeService.and(ConditionHelper.egalVarchar("T1.SERVICE", codeService));
            this.select(whereTypeService.formaterSQL());
            while (this.nextItem()) {
                this.delete();
            }
        }
    }

    public int selectPreferencesGenerales(String codeService) throws Exception {
        RequeteSQL requeteParPreferencesUser = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("T1.SERVICE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        where.setPremiereCondition(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
        ConditionList conditionCodeUtilisateur = new ConditionList(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", ""));
        conditionCodeUtilisateur.or(ConditionHelper.isNull("T1.CODE_UTILISATEUR"));
        where.and(conditionCodeUtilisateur);
        if (StringUtils.isNotEmpty((CharSequence)codeService) && !TOUS_SERVICES.equals(codeService)) {
            where.and(ConditionHelper.egalVarchar("T1.SERVICE ", codeService));
        }
        requeteParPreferencesUser.where(where).orderBy(orderBy);
        return this.select(requeteParPreferencesUser.formaterRequete());
    }

    public static List<String> getListeValeurPreference(String valeur) {
        ArrayList<String> listeValeurs = new ArrayList<String>();
        int index = valeur.indexOf(";");
        String mot = "";
        while (index != -1) {
            if (index != valeur.length() && index != valeur.length() - 1 && ";".equals(valeur.substring(index + 1, index + 2))) {
                valeur = valeur.replaceFirst(";;", ";");
                mot = mot + valeur.substring(0, index + 1);
                valeur = valeur.substring(index + 1);
            } else {
                listeValeurs.add(mot + valeur.substring(0, index));
                valeur = valeur.substring(index + 1);
                mot = "";
            }
            index = valeur.indexOf(";");
        }
        if (!"".equals(valeur) || !"".equals(mot)) {
            listeValeurs.add(mot + valeur);
        }
        return listeValeurs;
    }

    public void setValues(Iterator<String> itValues) {
        String value = "";
        while (itValues.hasNext()) {
            String val = itValues.next();
            val = val.replaceAll(";", ";;");
            if ("".equals(value)) {
                value = val;
                continue;
            }
            value = value + ";" + val;
        }
        this.setValeur(value);
    }

    public void deleteUserPreferences(String codeUser) {
    }
}

