/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.cache.CacheProfilDsiManager;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.sgbd.ProfildsiDB;
import com.univ.utils.Chaine;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Profildsi
extends ProfildsiDB
implements Cloneable {
    public void init() {
        this.setIdProfildsi(0L);
        this.setCode(String.valueOf(System.currentTimeMillis()));
        this.setLibelle("");
        this.setCodeRubriqueAccueil("");
        this.setRoles("");
        this.setGroupes("");
        this.setCodeRattachement("");
    }

    public static Map<String, InfosProfilDsi> getListeInfosProfilDsi() {
        CacheProfilDsiManager cache = (CacheProfilDsiManager)ApplicationContextManager.getCoreContextBean("cacheProfilDsiManager");
        return cache.getListeProfilsDsi();
    }

    @Deprecated
    public static String getIntitule(OMContext _ctx, String _code) {
        return Profildsi.getIntitule(_code);
    }

    public static String getIntitule(String code) {
        if (code == null || code.length() == 0) {
            return MessageHelper.getCoreMessage("BO_PROFIL_INEXISTANT");
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)Profildsi.renvoyerItemProfilDsi(code).getIntitule(), (CharSequence)MessageHelper.getCoreMessage("BO_PROFIL_INEXISTANT"));
    }

    @Deprecated
    public static Hashtable<String, String> getListeIDProfilsDSI(OMContext _ctx) throws Exception {
        Profildsi profildsi = new Profildsi();
        profildsi.setCtx(_ctx);
        profildsi.init();
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (profildsi.select("") > 0) {
            while (profildsi.nextItem()) {
                h.put(profildsi.getIdProfildsi().toString(), profildsi.getLibelle());
            }
        }
        return h;
    }

    public static Collection<Profildsi> getListeProfilsDSI(OMContext ctx) throws Exception {
        Profildsi profildsi = new Profildsi();
        profildsi.setCtx(ctx);
        profildsi.init();
        ArrayList<Profildsi> toutLesProfils = new ArrayList<Profildsi>();
        if (profildsi.select("") > 0) {
            while (profildsi.nextItem()) {
                toutLesProfils.add(profildsi.clone());
            }
        }
        return toutLesProfils;
    }

    public static Hashtable<String, String> getListeProfilsDSI() {
        Map<String, InfosProfilDsi> infosProfils = Profildsi.getListeInfosProfilDsi();
        Hashtable<String, String> res = new Hashtable<String, String>(infosProfils.size());
        for (InfosProfilDsi info : infosProfils.values()) {
            res.put(info.getCode(), info.getIntitule());
        }
        return res;
    }

    public static Vector<String> renvoyerProfilsGroupes(Vector<String> _groupesUtilisateur) {
        TreeSet<String> listeProfilsUser = new TreeSet<String>();
        Enumeration<String> eProfil = Profildsi.getListeProfilsDSI().keys();
        while (eProfil.hasMoreElements()) {
            String codeProfil = eProfil.nextElement();
            InfosProfilDsi infosProfil = Profildsi.renvoyerItemProfilDsi(codeProfil);
            Vector<String> vGroupesProfil = infosProfil.getGroupes();
            Enumeration<String> eGroupeProfil = vGroupesProfil.elements();
            boolean profil = false;
            while (eGroupeProfil.hasMoreElements() && !profil) {
                InfosGroupeDsi infosGroupeProfil = Groupedsi.renvoyerItemGroupeDsi(eGroupeProfil.nextElement());
                Enumeration<String> eGroupeUser = _groupesUtilisateur.elements();
                while (eGroupeUser.hasMoreElements() && !profil) {
                    InfosGroupeDsi groupeUser = Groupedsi.renvoyerItemGroupeDsi(eGroupeUser.nextElement());
                    profil = infosGroupeProfil.contains(groupeUser);
                }
            }
            if (!profil) continue;
            listeProfilsUser.add(infosProfil.getCode());
        }
        return new Vector<String>(listeProfilsUser);
    }

    public static Hashtable<String, String> getListeProfilsDSIParGroupes(Vector<String> _groupes) {
        Vector<String> listeProfils = Profildsi.renvoyerProfilsGroupes(_groupes);
        Hashtable<String, String> hListeProfils = new Hashtable<String, String>();
        Enumeration<String> e = listeProfils.elements();
        while (e.hasMoreElements()) {
            String codeProfil = e.nextElement();
            hListeProfils.put(codeProfil, Profildsi.renvoyerItemProfilDsi(codeProfil).getIntitule());
        }
        return hListeProfils;
    }

    public static InfosProfilDsi renvoyerItemProfilDsi(String code) {
        InfosProfilDsi res = Profildsi.getListeInfosProfilDsi().get(code);
        if (res == null) {
            res = new InfosProfilDsi();
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, Vector<Perimetre>> renvoyerProfilsEtPerimetres(OMContext _ctx, String _role, List<String> _codesStructures, String _codeRubrique, String _publicsVises, String _codeEspaceCollaboratif) throws Exception {
        Hashtable<String, Vector<Perimetre>> h = new Hashtable<String, Vector<Perimetre>>();
        for (InfosProfilDsi info : Profildsi.getListeInfosProfilDsi().values()) {
            Vector<Perimetre> v = Role.renvoyerPerimetresAffectation(info.getRoles(), _role, _codesStructures, _codeRubrique, _publicsVises, _codeEspaceCollaboratif);
            if (v.size() <= 0) continue;
            h.put(info.getCode(), v);
        }
        return h;
    }

    public int select(String code, String libelle) throws Exception {
        RequeteSQL requeteCodeLibelle = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.like("LIBELLE", libelle, "%", "%"));
        }
        requeteCodeLibelle.where(where).orderBy(orderBy);
        return this.select(requeteCodeLibelle.formaterRequete());
    }

    public void setVecteurGroupes(Vector<String> v) {
        this.setGroupes(Chaine.convertirAccolades(v));
    }

    public Vector<String> getVecteurGroupes() {
        return Chaine.getVecteurAccolades(this.getGroupes());
    }

    public Profildsi clone() throws CloneNotSupportedException {
        return (Profildsi)super.clone();
    }
}

