/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.cms.objetspartages.ReferentielManager;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.FicheExportableXML;
import com.univ.objetspartages.om.FicheUniv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferentielObjets {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferentielObjets.class);

    public static Objetpartage getObjetByCode(String code) {
        return ReferentielObjets.getReferentiel().getObjetsByCode().get(code);
    }

    public static Objetpartage getObjetByNom(String nom) {
        return ReferentielObjets.getReferentiel().getObjetByNom(nom);
    }

    public static ReferentielManager getReferentiel() {
        return (ReferentielManager)ApplicationContextManager.getCoreContextBean("referentielManager");
    }

    public static boolean gereLienRequete(String _code) throws Exception {
        boolean res = true;
        Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(_code).getNomClasse());
        if (!FicheAnnotationHelper.isLienRequete(classeObjet.newInstance())) {
            res = false;
        }
        return res;
    }

    public static boolean gereLienInterne(String _code) throws Exception {
        boolean res = true;
        Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(_code).getNomClasse());
        if (!FicheAnnotationHelper.isLienInterne(classeObjet.newInstance())) {
            res = false;
        }
        return res;
    }

    public static boolean gereEncadreRecherche(String code) throws Exception {
        Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(code).getNomClasse());
        return FicheAnnotationHelper.isEncadreRechercheSurFicheCourante(classeObjet.newInstance());
    }

    public static boolean gereEncadreRechercheEmbarquable(String code) throws Exception {
        Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(code).getNomClasse());
        return FicheAnnotationHelper.isEncadreRechercheEmbarquable(classeObjet.newInstance());
    }

    public static String getCodeObjetParClasse(String nomClasse) {
        return ReferentielObjets.getReferentiel().getCodesObjetsByClasse().get(nomClasse);
    }

    public static String getCodeObjet(FicheUniv _ficheUniv) {
        String classe = _ficheUniv.getClass().getName();
        return ReferentielObjets.getCodeObjetParClasse(classe);
    }

    public static String getLibelleObjet(String codeOrNom) {
        if (ReferentielObjets.getObjetByCode(codeOrNom) != null) {
            return ReferentielObjets.getObjetByCode(codeOrNom).getLibelleObjet();
        }
        if (ReferentielObjets.getObjetByNom(codeOrNom) != null) {
            return ReferentielObjets.getObjetByNom(codeOrNom).getLibelleObjet();
        }
        return "";
    }

    public static int getNombreObjetsTypeStructure() {
        return ReferentielObjets.getReferentiel().getCodesObjetsStructure().size();
    }

    @Deprecated
    public static Hashtable<String, String> getListeObjets() {
        Hashtable<String, String> res = new Hashtable<String, String>();
        List<Objetpartage> objetsPartages = ReferentielObjets.getObjetsPartagesTries();
        for (Objetpartage objet : objetsPartages) {
            res.put(objet.getCodeObjet(), objet.getLibelleObjet());
        }
        return res;
    }

    public static List<Objetpartage> getObjetsPartagesTries() {
        ArrayList<Objetpartage> objetsPartages = new ArrayList<Objetpartage>(ReferentielObjets.getReferentiel().getObjetsByCode().values());
        Collections.sort(objetsPartages);
        return objetsPartages;
    }

    public static String getNomObjet(String code) {
        if (ReferentielObjets.getObjetByCode(code) != null) {
            return ReferentielObjets.getObjetByCode(code).getNomObjet();
        }
        return "";
    }

    public static String getNomObjet(FicheUniv fiche) {
        return ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(fiche));
    }

    public static String getNomPage(String code) {
        return ReferentielObjets.getNomObjet(code);
    }

    public static String getNomTableSql(String codeObjet) {
        Objetpartage objet = ReferentielObjets.getObjetByCode(codeObjet);
        return StringUtils.substringAfterLast((String)objet.getNomClasse(), (String)".").toUpperCase();
    }

    public static String getProcessus(String code) {
        String processus = "";
        Objetpartage objet = ReferentielObjets.getObjetByCode(code);
        if (objet != null) {
            processus = objet.getParametreProcessus();
        }
        return processus;
    }

    public static FicheUniv instancierFiche(String nomOUcode) {
        nomOUcode = nomOUcode.toLowerCase();
        try {
            Objetpartage objet = ReferentielObjets.getObjetByNom(nomOUcode);
            if (objet == null) {
                objet = ReferentielObjets.getObjetByCode(nomOUcode);
            }
            if (objet != null) {
                return (FicheUniv)Class.forName(objet.getNomClasse()).newInstance();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Erreur d'instanciation de la fiche " + nomOUcode, (Throwable)e);
        }
        return null;
    }

    public static Object instancierObjet(String nomOUcode) {
        nomOUcode = nomOUcode.toLowerCase();
        try {
            Objetpartage objet = ReferentielObjets.getObjetByNom(nomOUcode);
            if (objet == null) {
                objet = ReferentielObjets.getObjetByCode(nomOUcode);
            }
            if (objet != null) {
                return Class.forName(objet.getNomClasse()).newInstance();
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur d'instanciation de la fiche " + nomOUcode, (Throwable)e);
        }
        return null;
    }

    public static boolean isExportable(String code) throws Exception {
        boolean res = false;
        Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(code).getNomClasse());
        if (classeObjet.newInstance() instanceof FicheExportableXML) {
            res = true;
        }
        return res;
    }

    public static String[] getOrdreOnglets() {
        return ReferentielObjets.getReferentiel().getCodesObjetsTries().toArray(new String[0]);
    }

    public static String getCodeObjet(String nom) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)ReferentielObjets.getReferentiel().getCodesObjetsByNom().get(nom.toLowerCase()), (CharSequence)"");
    }

    protected static String getClasseObjetParNom(String nomObjet) {
        if (ReferentielObjets.getObjetByNom(nomObjet) != null) {
            return ReferentielObjets.getObjetByNom(nomObjet).getNomClasse();
        }
        return "";
    }

    protected static String getClasseObjetParCode(String codeObjet) {
        if (ReferentielObjets.getObjetByCode(codeObjet) != null) {
            return ReferentielObjets.getObjetByCode(codeObjet).getNomClasse();
        }
        return "";
    }

    public static String getClasseObjet(String codeOuNomObjet) {
        String classeObjet = "";
        Objetpartage objet = ReferentielObjets.getObjetByNom(codeOuNomObjet);
        if (objet == null) {
            objet = ReferentielObjets.getObjetByCode(codeOuNomObjet);
        }
        if (objet != null) {
            classeObjet = objet.getNomClasse();
        }
        return classeObjet;
    }

    public static boolean isObjetRecherchable(String nomObjet) {
        boolean recherchable = false;
        Objetpartage objet = ReferentielObjets.getObjetByNom(nomObjet);
        if (objet != null) {
            recherchable = objet.isRecherchable();
        }
        return recherchable;
    }

    public static boolean isObjetCollaboratif(String nomObjet, boolean strict) {
        boolean collaboratif = false;
        Objetpartage objet = ReferentielObjets.getObjetByNom(nomObjet);
        if (objet != null) {
            collaboratif = strict ? objet.isStrictlyCollaboratif() : objet.isCollaboratif();
        }
        return collaboratif;
    }

    public static List<Objetpartage> getAllObjetCollaboratif() {
        List<Objetpartage> objetCollaboratifs = ReferentielObjets.getObjetsPartagesTries();
        CollectionUtils.filter(objetCollaboratifs, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((Objetpartage)arg0).isCollaboratif();
            }
        });
        return objetCollaboratifs;
    }

    public static boolean isActionParametrableDansRole(String objet, String action) {
        String param = ReferentielObjets.getObjetByNom(objet).getProperty("fiche." + objet.toUpperCase() + ".saisie_role." + action);
        boolean recherchable = true;
        if ("0".equals(param)) {
            recherchable = false;
        }
        return recherchable;
    }

    public static boolean isActif(String objet) {
        String param = ReferentielObjets.getObjetByNom(objet).getProperty("fiche." + objet.toUpperCase() + ".activation");
        boolean actif = true;
        if ("0".equals(param)) {
            actif = false;
        }
        return actif;
    }

    public static String getLibellePersonnalisable(String objet) {
        String res = "";
        String param = ReferentielObjets.getObjetByCode(objet).getProperty("fiche." + objet.toUpperCase() + ".libelle");
        res = param != null ? param : ReferentielObjets.getLibelleObjet(objet);
        return res;
    }

    public static Collection<String> getListeNomsObjet() {
        return ReferentielObjets.getReferentiel().getCodesObjetsByNom().keySet();
    }

    public static Collection<String> getListeCodesObjet() {
        return ReferentielObjets.getReferentiel().getCodesObjetsTries();
    }

    public static String getExtension(String codeObjet) {
        String extension = "";
        Objetpartage objetParCode = ReferentielObjets.getObjetByCode(codeObjet);
        if (objetParCode != null) {
            extension = objetParCode.getIdExtension();
        }
        return extension;
    }

    public static String getExtension(FicheUniv fiche) {
        String extension = "";
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
            extension = ReferentielObjets.getExtension(codeObjet);
        }
        return extension;
    }

    public static Map<String, String> getEtatsObjet() {
        HashMap<String, String> etatsObjetEtLibelle = new HashMap<String, String>();
        List<String> codesEtats = ReferentielObjets.getReferentiel().getEtatsObjet();
        for (String codeEtat : codesEtats) {
            etatsObjetEtLibelle.put(codeEtat, MessageHelper.getCoreMessage("ETATFICHE_" + codeEtat));
        }
        return etatsObjetEtLibelle;
    }

    public static Map<String, String> getEtatsObjetFront() {
        HashMap<String, String> etatsObjetEtLibelle = new HashMap<String, String>();
        List<String> codesEtats = ReferentielObjets.getReferentiel().getEtatsObjetFront();
        for (String codeEtat : codesEtats) {
            etatsObjetEtLibelle.put(codeEtat, MessageHelper.getCoreMessage("ETATFICHE_" + codeEtat));
        }
        return etatsObjetEtLibelle;
    }

    public static String getLibelleEtatObjet(String code) {
        return ReferentielObjets.getEtatsObjet().get(code);
    }
}

