/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequeteGroupeDynamique {
    private static final Logger LOG = LoggerFactory.getLogger(RequeteGroupeDynamique.class);
    public static final int SYNCHRO_ACTION_AJOUT_MODIFICATION = 0;
    public static final int SYNCHRO_ACTION_SUPPRESSION = 1;
    @Deprecated
    protected OMContext ctx;
    private long delaiRechgtResolutionGroupesUt;
    private String nomRequete;

    @Deprecated
    public void setCtx(OMContext ctx) {
    }

    public void setNomRequete(String nomRequete) {
        this.nomRequete = nomRequete;
    }

    public String getNomRequete() {
        return this.nomRequete;
    }

    public void setDelaiRechargementResolutionGroupesUtilisateur(long delaiRechgtResolutionGroupesUt) {
        this.delaiRechgtResolutionGroupesUt = delaiRechgtResolutionGroupesUt;
    }

    public Vector<String> getGroupesUtilisateurCache(String codeUtilisateur, long ts) throws Exception {
        String sourceImport = "[" + this.getNomRequete() + "]";
        if (this.delaiRechgtResolutionGroupesUt == 0L) {
            LOG.debug("*** Cache desactive pour " + sourceImport);
            return this.getGroupesUtilisateur(codeUtilisateur);
        }
        Utilisateur utilisateur = new Utilisateur();
        utilisateur.init();
        try (ContexteDao ctx = new ContexteDao();){
            utilisateur.setCtx(ctx);
            if (StringUtils.isEmpty((CharSequence)codeUtilisateur) || utilisateur.selectParCode(codeUtilisateur) == 0) {
                Vector<String> vector = new Vector<String>(0);
                return vector;
            }
            utilisateur.nextItem();
        }
        long tsMin = ts / 60000L;
        HashSet<String> setGroupesCache = new HashSet<String>();
        Groupeutilisateur groupeUtilisateur = new Groupeutilisateur();
        groupeUtilisateur.init();
        try (ContexteDao ctx = new ContexteDao();){
            groupeUtilisateur.setCtx(ctx);
            ClauseWhere whereCodeUserAndSource = new ClauseWhere(ConditionHelper.egalVarchar("CODE_UTILISATEUR", codeUtilisateur));
            whereCodeUserAndSource.and(ConditionHelper.egalVarchar("SOURCE_IMPORT", sourceImport));
            if (groupeUtilisateur.select(whereCodeUserAndSource.formaterSQL()) != 0) {
                while (groupeUtilisateur.nextItem()) {
                    setGroupesCache.add(groupeUtilisateur.getCodeGroupe());
                }
            }
        }
        long timestamp = utilisateur.getTsCacheGroupes();
        if (timestamp != tsMin && timestamp + this.delaiRechgtResolutionGroupesUt >= tsMin) {
            LOG.debug("*** Cache encore valable pour " + codeUtilisateur + sourceImport);
            return new Vector<String>(setGroupesCache);
        }
        LOG.debug("*** Cache expire pour " + codeUtilisateur + sourceImport);
        LOG.debug("*** Cr\u00e9ation d'un cache utilisateur pour " + codeUtilisateur);
        Vector<String> listeGroupes = this.getGroupesUtilisateur(codeUtilisateur);
        if (!setGroupesCache.isEmpty()) {
            Iterator<String> itCodeGroupeCharge = listeGroupes.iterator();
            while (itCodeGroupeCharge.hasNext() && !setGroupesCache.isEmpty()) {
                String codeGroupe = itCodeGroupeCharge.next();
                if (!setGroupesCache.remove(codeGroupe)) {
                    if (this.supprimeGroupesHierarchie(codeGroupe, setGroupesCache)) continue;
                    this.invalideCacheGroupe(codeGroupe, sourceImport);
                    continue;
                }
                this.supprimeGroupesHierarchie(codeGroupe, setGroupesCache);
            }
            if (!setGroupesCache.isEmpty()) {
                for (String string : setGroupesCache) {
                    this.invalideCacheGroupe(string, sourceImport);
                }
            }
        }
        this.miseEnCacheGroupesUtilisateurCache(utilisateur, listeGroupes, tsMin, sourceImport);
        return listeGroupes;
    }

    private void invalideCacheGroupe(String codeGroupeCache, String sourceImport) throws Exception {
        Long tsInit = new Long(0L);
        try (ContexteDao ctx = new ContexteDao();){
            Groupedsi groupeDsi = new Groupedsi();
            groupeDsi.init();
            groupeDsi.setCtx(ctx);
            if (groupeDsi.select(codeGroupeCache, "", "", "", "1") != 0) {
                groupeDsi.nextItem();
                groupeDsi.setDerniereMajCache(tsInit);
                groupeDsi.update();
            }
        }
        Groupeutilisateur.deleteParGroupeSourceImport(codeGroupeCache, sourceImport);
        LOG.debug("*** on invalide le cache du groupe " + codeGroupeCache);
        InfosGroupeDsi infosGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupeCache);
        try (ContexteDao ctx = new ContexteDao();){
            for (int niveau = infosGroupe.getNiveau(); niveau > 0; --niveau) {
                String codeGroupePere = infosGroupe.getCodeGroupePere();
                Groupeutilisateur.deleteParGroupeSourceImport(codeGroupePere, sourceImport);
                infosGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupePere);
                Groupedsi groupeDsi = new Groupedsi();
                groupeDsi.init();
                groupeDsi.setCtx(ctx);
                if (groupeDsi.select(codeGroupePere, "", "", "", "1") == 0) continue;
                groupeDsi.nextItem();
                groupeDsi.setDerniereMajCache(tsInit);
                groupeDsi.update();
            }
        }
    }

    private boolean supprimeGroupesHierarchie(String codeGroupe, Set<String> setGroupesCache) throws Exception {
        boolean groupeSupprime = false;
        InfosGroupeDsi infosGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
        String codeGroupePere = null;
        for (int niveau = infosGroupe.getNiveau(); niveau > 0; --niveau) {
            codeGroupePere = infosGroupe.getCodeGroupePere();
            infosGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupePere);
            groupeSupprime = setGroupesCache.remove(codeGroupePere);
            if (!groupeSupprime) continue;
            LOG.debug("*** Suppression du groupe pere " + codeGroupePere);
        }
        return groupeSupprime;
    }

    private void miseEnCacheGroupesUtilisateurCache(Utilisateur utilisateur, Vector<String> listeGroupes, Long tsMin, String sourceImport) throws Exception {
        if (!listeGroupes.isEmpty()) {
            try (ContexteDao ctx = new ContexteDao();){
                String codeUtilisateur = utilisateur.getCode();
                Groupeutilisateur groupeutilisateur = new Groupeutilisateur();
                groupeutilisateur.setCtx(ctx);
                for (String codeGroupe : listeGroupes) {
                    ClauseWhere whereCodeUserSourceEtGroupe = new ClauseWhere(ConditionHelper.egalVarchar("CODE_UTILISATEUR", codeUtilisateur));
                    whereCodeUserSourceEtGroupe.and(ConditionHelper.egalVarchar("SOURCE_IMPORT", sourceImport));
                    whereCodeUserSourceEtGroupe.and(ConditionHelper.egalVarchar("CODE_GROUPE", codeGroupe));
                    if (groupeutilisateur.select(whereCodeUserSourceEtGroupe.formaterSQL()) != 0) continue;
                    groupeutilisateur.init();
                    groupeutilisateur.setCodeUtilisateur(codeUtilisateur);
                    groupeutilisateur.setCodeGroupe(codeGroupe);
                    groupeutilisateur.setSourceImport(sourceImport);
                    groupeutilisateur.add();
                }
                utilisateur.setCtx(ctx);
                utilisateur.setTsCacheGroupes(tsMin);
                utilisateur.update();
            }
        }
    }

    protected abstract Vector<String> getGroupesUtilisateur(String var1) throws Exception;

    public Vector<String> getVecteurUtilisateursCache(String codeGroupe, Set<String> setCodesGroupesCache) throws Exception {
        return this.getVecteurUtilisateursCache(codeGroupe, setCodesGroupesCache, System.currentTimeMillis());
    }

    private Vector<String> getVecteurUtilisateursCache(String codeGroupe, Set<String> setCodesGroupesCache, long ts) throws Exception {
        Vector<String> listeCodesUtilisateurs = null;
        if (!this.estGereParReqDyn(codeGroupe)) {
            listeCodesUtilisateurs = new Vector<String>(0);
        } else {
            Groupedsi groupeDsi = new Groupedsi();
            try (ContexteDao ctx = new ContexteDao();){
                groupeDsi.init();
                groupeDsi.setCtx(ctx);
                if (groupeDsi.select(codeGroupe, "", "", "", "1") == 0) {
                    Vector<String> vector = this.getVecteurUtilisateurs(codeGroupe);
                    return vector;
                }
                groupeDsi.nextItem();
            }
            long tsMin = ts / 60000L;
            String sourceImport = "[" + this.getNomRequete() + "]";
            if (groupeDsi.getDelaiExpirationCache() + groupeDsi.getDerniereMajCache() >= tsMin) {
                LOG.debug("*** Cache encore valable pour " + codeGroupe);
                if (setCodesGroupesCache == null) {
                    return Groupeutilisateur.getVecteurUtilisateursSourceImport(codeGroupe, sourceImport);
                }
            } else {
                LOG.debug("*** Cache expire pour " + codeGroupe);
                HashSet<String> setUtilisateursCache = null;
                ContexteDao ctx = new ContexteDao();
                Iterator iterator = null;
                try {
                    Groupeutilisateur groupeUtilisateur = new Groupeutilisateur();
                    groupeUtilisateur.init();
                    groupeUtilisateur.setCtx(ctx);
                    setUtilisateursCache = new HashSet<String>();
                    ClauseWhere whereGroupeSource = new ClauseWhere(ConditionHelper.like("CODE_GROUPE", codeGroupe, "", "%"));
                    whereGroupeSource.and(ConditionHelper.egalVarchar("SOURCE_IMPORT", sourceImport));
                    if (groupeUtilisateur.select(whereGroupeSource.formaterSQL()) != 0) {
                        while (groupeUtilisateur.nextItem()) {
                            setUtilisateursCache.add(groupeUtilisateur.getCodeUtilisateur());
                        }
                    }
                }
                catch (Throwable groupeUtilisateur) {
                    iterator = groupeUtilisateur;
                    throw groupeUtilisateur;
                }
                finally {
                    if (ctx != null) {
                        if (iterator != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable groupeUtilisateur) {
                                ((Throwable)((Object)iterator)).addSuppressed(groupeUtilisateur);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
                listeCodesUtilisateurs = this.getVecteurUtilisateurs(codeGroupe);
                if (setUtilisateursCache != null && !setUtilisateursCache.isEmpty()) {
                    for (String string : listeCodesUtilisateurs) {
                        String codeUtilisateur = string;
                        if (setUtilisateursCache.remove(codeUtilisateur)) continue;
                        this.invalideCacheUtilisateur(codeUtilisateur);
                    }
                    if (setUtilisateursCache.size() > 0) {
                        for (String string : setUtilisateursCache) {
                            this.invalideCacheUtilisateur(string);
                        }
                    }
                }
                this.miseEnCacheUtilisateursGroupes(groupeDsi, listeCodesUtilisateurs, sourceImport, new Long(tsMin));
            }
            if (setCodesGroupesCache != null) {
                setCodesGroupesCache.add(groupeDsi.getCode());
            }
        }
        return listeCodesUtilisateurs;
    }

    private void invalideCacheUtilisateur(String codeUtilisateur) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.init();
            utilisateur.setCtx(ctx);
            utilisateur.selectParCode(codeUtilisateur);
            utilisateur.nextItem();
            utilisateur.setTsCacheGroupes(new Long(0L));
            utilisateur.update();
        }
        LOG.debug("*** Cache de l'utilisateur " + codeUtilisateur + " invalide.");
    }

    private void miseEnCacheUtilisateursGroupes(Groupedsi groupeDsi, Vector<String> listeCodesUtilisateurs, String sourceImport, Long tsMin) throws Exception {
        Groupeutilisateur.deleteParGroupeSourceImport(groupeDsi.getCode(), sourceImport);
        try (ContexteDao ctx = new ContexteDao();){
            if (!listeCodesUtilisateurs.isEmpty()) {
                Groupeutilisateur groupeutilisateur = new Groupeutilisateur();
                groupeutilisateur.setCtx(ctx);
                for (String codeUtilisateur : listeCodesUtilisateurs) {
                    groupeutilisateur.init();
                    groupeutilisateur.setCodeUtilisateur(codeUtilisateur);
                    groupeutilisateur.setCodeGroupe(groupeDsi.getCode());
                    groupeutilisateur.setSourceImport(sourceImport);
                    groupeutilisateur.add();
                }
            }
            groupeDsi.setCtx(ctx);
            groupeDsi.setDerniereMajCache(tsMin);
            groupeDsi.update();
        }
    }

    protected abstract Vector<String> getVecteurUtilisateurs(String var1) throws Exception;

    protected abstract boolean estGereParReqDyn(String var1);

    public abstract void preparerPRINCIPAL(InfoBean var1, Groupedsi var2) throws Exception;

    public void traiterPRINCIPAL(InfoBean infoBean, Groupedsi groupe) throws Exception {
        groupe.setRequeteGroupe(this.getNomRequete());
        groupe.setRequeteLdap(infoBean.getString("REQUETE_LDAP_" + this.getNomRequete()));
    }
}

