/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.RequeteGroupeDynamique;
import com.univ.objetspartages.om.SynchronisationGroupeDynamiqueData;
import com.univ.objetspartages.om.SynchronisationGroupeDynamiqueEtat;
import com.univ.utils.ContexteDao;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequeteGroupeDynamiqueSynchronisable
extends RequeteGroupeDynamique {
    private final CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
    private static final Logger LOG = LoggerFactory.getLogger(RequeteGroupeDynamiqueSynchronisable.class);

    public boolean isAutoSynchronise() {
        return "1".equals(PropertyHelper.getCoreProperty("requete_groupe." + this.getNomRequete() + ".auto_synchronise"));
    }

    protected String getTypeSynchronisation() {
        return PropertyHelper.getCoreProperty("requete_groupe." + this.getNomRequete() + ".type_synchronise");
    }

    protected String getPrefixeNomGroupeSynchro() {
        String prefixe = PropertyHelper.getCoreProperty("requete_groupe." + this.getNomRequete() + ".prefixe_code_groupe_synchronise");
        if (prefixe == null) {
            return this.getNomRequete();
        }
        return prefixe;
    }

    protected String getCodeGroupePere() {
        String codePere = PropertyHelper.getCoreProperty("requete_groupe." + this.getNomRequete() + ".code_groupe_parent");
        if (codePere != null) {
            return codePere;
        }
        return "";
    }

    public SynchronisationGroupeDynamiqueEtat synchronize() {
        SynchronisationGroupeDynamiqueEtat result;
        block30: {
            result = new SynchronisationGroupeDynamiqueEtat();
            try {
                Map<String, SynchronisationGroupeDynamiqueData> dataToSynchronise = this.getDataToSynchronize();
                if (dataToSynchronise == null) break block30;
                Set<String> objectsCodesToSync = dataToSynchronise.keySet();
                String codeTypeGroupeSynchronise = this.getTypeSynchronisation();
                String prefixeCode = this.getPrefixeNomGroupeSynchro();
                ArrayList<String> codesGroupesSynchronises = new ArrayList<String>();
                for (InfosGroupeDsi infosGroupeDsi : Groupedsi.getListeGroupesDynamiques()) {
                    if (!codeTypeGroupeSynchronise.equals(infosGroupeDsi.getType())) continue;
                    codesGroupesSynchronises.add(infosGroupeDsi.getCode());
                }
                Throwable throwable = null;
                try (ContexteDao ctx = new ContexteDao();){
                    Groupedsi groupeDsi = new Groupedsi();
                    groupeDsi.setCtx(ctx);
                    for (String codeCourant : codesGroupesSynchronises) {
                        if (objectsCodesToSync.contains(codeCourant.substring(prefixeCode.length())) || groupeDsi.select(codeCourant, codeTypeGroupeSynchronise, "", "", "") <= 0) continue;
                        groupeDsi.nextItem();
                        result.addGroupeSynchroSupprime(groupeDsi.getCode(), groupeDsi.getLibelle());
                        groupeDsi.delete();
                    }
                }
                catch (Throwable groupeDsi) {
                    Throwable throwable2 = groupeDsi;
                    throw groupeDsi;
                }
                for (String string : objectsCodesToSync) {
                    SynchronisationGroupeDynamiqueData synchronisationData = dataToSynchronise.get(string);
                    ContexteDao ctx2 = new ContexteDao();
                    Throwable throwable3 = null;
                    try {
                        Groupedsi groupeDsi = new Groupedsi();
                        groupeDsi.init();
                        groupeDsi.setCtx(ctx2);
                        if (!codesGroupesSynchronises.contains(prefixeCode + string)) {
                            int countGroupeDsi = groupeDsi.select(prefixeCode + string, "", "", "", "");
                            if (countGroupeDsi > 0) {
                                groupeDsi.nextItem();
                                if (!this.isUpToDateGroupeDsi(groupeDsi, synchronisationData, prefixeCode)) continue;
                                this.synchroniseDataAndGroupeDsi(groupeDsi, synchronisationData, codeTypeGroupeSynchronise, prefixeCode);
                                groupeDsi.update();
                                result.addGroupeSynchroModifie(groupeDsi.getCode(), groupeDsi.getLibelle());
                                continue;
                            }
                            groupeDsi.init();
                            groupeDsi.setCode(prefixeCode + string);
                            this.synchroniseDataAndGroupeDsi(groupeDsi, synchronisationData, codeTypeGroupeSynchronise, prefixeCode);
                            groupeDsi.add();
                            result.addGroupeSynchroAjoute(groupeDsi.getCode(), groupeDsi.getLibelle());
                            continue;
                        }
                        if (groupeDsi.select(prefixeCode + string, "", "", "", "") != 1) continue;
                        groupeDsi.nextItem();
                        if (!this.isUpToDateGroupeDsi(groupeDsi, synchronisationData, prefixeCode)) continue;
                        this.synchroniseDataAndGroupeDsi(groupeDsi, synchronisationData, codeTypeGroupeSynchronise, prefixeCode);
                        groupeDsi.update();
                        result.addGroupeSynchroModifie(groupeDsi.getCode(), groupeDsi.getLibelle());
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ctx2 == null) continue;
                        if (throwable3 != null) {
                            try {
                                ctx2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ctx2.close();
                    }
                }
                if (result.getNbGroupesAjoutes() > 0 || result.getNbGroupesModifies() > 0 || result.getNbGroupesSupprimes() > 0) {
                    this.cache.flush();
                }
                result.setValide(true);
            }
            catch (Exception e) {
                LOG.error("Erreur lors de la synchronisation des groupes dynamiques (" + this.getNomRequete() + ") : ", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isUpToDateGroupeDsi(Groupedsi groupe, SynchronisationGroupeDynamiqueData data, String prefixeGroupe) {
        boolean sameData = data.getIntitule().equals(groupe.getLibelle());
        sameData &= data.getCodeDuParent() == null || (prefixeGroupe + data.getCodeDuParent()).equals(groupe.getCodeGroupePere()) || data.getCodeDuParent().equals("") && this.getCodeGroupePere().equals(groupe.getCodeGroupePere());
        sameData &= data.getCodePageDeTete() == null || data.getCodePageDeTete().equals(groupe.getCodePageTete());
        sameData &= data.getCodeStructureCode() == null || data.getCodeStructureCode().equals(groupe.getCodeStructure());
        return !(sameData &= data.getRoles() == null || data.getRoles().equals(groupe.getRoles()));
    }

    private void synchroniseDataAndGroupeDsi(Groupedsi groupeDsi, SynchronisationGroupeDynamiqueData synchronisationData, String codeTypeGroupeSynchronise, String prefixeCode) {
        groupeDsi.setLibelle(synchronisationData.getIntitule());
        groupeDsi.setType(codeTypeGroupeSynchronise);
        groupeDsi.setRequeteGroupe(this.getNomRequete());
        String codeLDAP = groupeDsi.getRequeteLdap();
        String codeObjet = synchronisationData.getCode();
        int positionCodeObjet = codeLDAP.indexOf(codeObjet);
        if (!(positionCodeObjet != -1 && (codeLDAP.equals(codeObjet) || positionCodeObjet == 0 && codeLDAP.indexOf(codeObjet + ";") == positionCodeObjet || positionCodeObjet > 0 && positionCodeObjet + codeObjet.length() < codeLDAP.length() && codeLDAP.indexOf(";" + codeObjet + ";") == positionCodeObjet - 1 || positionCodeObjet > 0 && positionCodeObjet + codeObjet.length() == codeLDAP.length() && codeLDAP.indexOf(";" + codeObjet) == positionCodeObjet - 1))) {
            if (codeLDAP.length() > 0) {
                groupeDsi.setRequeteLdap(synchronisationData.getCode() + ";" + codeLDAP);
            } else {
                groupeDsi.setRequeteLdap(synchronisationData.getCode());
            }
        }
        if (synchronisationData.getCodeDuParent() != null && synchronisationData.getCodeDuParent().length() > 0) {
            groupeDsi.setCodeGroupePere(prefixeCode + synchronisationData.getCodeDuParent());
        } else {
            groupeDsi.setCodeGroupePere(this.getCodeGroupePere());
        }
        if (synchronisationData.getCodePageDeTete() != null) {
            groupeDsi.setCodePageTete(synchronisationData.getCodePageDeTete());
        }
        if (synchronisationData.getCodeStructureCode() != null) {
            groupeDsi.setCodeStructure(synchronisationData.getCodeStructureCode());
        }
        if (synchronisationData.getRoles() != null) {
            groupeDsi.setRoles(synchronisationData.getRoles());
        }
    }

    public void traiterSYNCHRONISATION(InfoBean infoBean) throws Exception {
        LOG.debug(" *** D\u00e9but de la synchronisation des groupes dynamiques ");
        SynchronisationGroupeDynamiqueEtat resultatSynchronisation = this.synchronize();
        infoBean.set("RESULTAT", resultatSynchronisation.isValide());
        infoBean.set("INTITULE_REQUETE", Groupedsi.getListeRequetesGroupesPourAffichage().get(this.getNomRequete()));
        infoBean.set("NB_AJOUTS", resultatSynchronisation.getNbGroupesAjoutes());
        infoBean.set("NB_MODIFICATIONS", resultatSynchronisation.getNbGroupesModifies());
        infoBean.set("NB_SUPPRESSIONS", resultatSynchronisation.getNbGroupesSupprimes());
        infoBean.set("GROUPES_AJOUTES", resultatSynchronisation.getLibellesGroupeSynchroAjoutes());
        infoBean.set("GROUPES_MODIFIES", resultatSynchronisation.getLibellesGroupeSynchroModifies());
        infoBean.set("GROUPES_SUPPRIMES", resultatSynchronisation.getLibellesGroupeSynchroSupprimes());
        LOG.debug(" *** Fin de la synchronisation des groupes dynamiques ");
    }

    protected abstract Map<String, SynchronisationGroupeDynamiqueData> getDataToSynchronize() throws Exception;
}

