/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.MediaPhoto;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.sgbd.RessourceDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ressource
extends RessourceDB
implements Cloneable {
    private static final long serialVersionUID = -2582769772291064992L;
    private static final String COLONNE_CODE_PARENT = "CODE_PARENT";
    private static final Logger LOGGER = LoggerFactory.getLogger(Ressource.class);
    public static final String ETAT_SAUVEGARDE_STRUCTURE_COURANTE = "destruction_sauvegarde_courante";
    private Media media = null;

    public void init() {
        this.setIdRessource(0L);
        this.setIdMedia(0L);
        this.setCodeParent("");
        this.setEtat("");
        this.setOrdre(0);
    }

    public static void supprimerFichier(String _codeparent) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            Vector<Ressource> listeFichier = Ressource.getListeFichier(_codeparent);
            Ressource temp = new Ressource();
            temp.init();
            temp.setCtx(ctx);
            if (listeFichier.size() > 0) {
                for (Ressource ficdel : listeFichier) {
                    ficdel.setCtx(ctx);
                    ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                    if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                        Media.deleteById(ficdel.getIdMedia());
                    }
                    ficdel.delete();
                }
            }
        }
    }

    private static ClauseWhere whereIdMediaEgal(Long idMedia) {
        return new ClauseWhere(ConditionHelper.egalVarchar("ID_MEDIA", String.valueOf(idMedia)));
    }

    private static ClauseWhere whereCodeParentEgal(String codeParent) {
        return new ClauseWhere(ConditionHelper.egalVarchar(COLONNE_CODE_PARENT, codeParent));
    }

    public String getFullTextString() {
        return StringUtils.join((Object[])new String[]{this.getLibelle(), " ", this.getLegende(), " ", this.getDescription(), " ", this.getAuteur(), " ", this.getSource()});
    }

    public static void supprimerFichiers(OMContext _ctx, FicheUniv _fiche) throws Exception {
        Ressource temp = new Ressource();
        temp.init();
        temp.setCtx(_ctx);
        boolean modifFichier = false;
        Vector<Ressource> listeFichier = Ressource.getListeTotale(_fiche);
        if (listeFichier.size() > 0) {
            for (Ressource ficdel : listeFichier) {
                ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                    Media.deleteById(ficdel.getIdMedia());
                    if (FicheUnivMgr.isFicheCollaborative(_fiche)) {
                        modifFichier = true;
                    }
                }
                if ("0005".equals(_fiche.getEtatObjet())) {
                    ficdel.setEtat("2");
                    ficdel.update();
                    continue;
                }
                if (ETAT_SAUVEGARDE_STRUCTURE_COURANTE.equals(_fiche.getMessageAlerte())) {
                    ficdel.setEtat("0");
                    ficdel.update();
                    continue;
                }
                ficdel.delete();
            }
        }
    }

    public static void supprimerFichiers(FicheUniv fiche) throws Exception {
        block27: {
            Ressource temp = new Ressource();
            boolean modifFichier = false;
            temp.init();
            try (ContexteDao ctx = new ContexteDao();){
                temp.setCtx(ctx);
                Vector<Ressource> listeFichier = Ressource.getListeTotale(fiche);
                if (listeFichier.size() <= 0) break block27;
                for (Ressource ficdel : listeFichier) {
                    ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                    if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                        Media.deleteById(ficdel.getIdMedia());
                        if (FicheUnivMgr.isFicheCollaborative(fiche)) {
                            modifFichier = true;
                        }
                    }
                    ContexteDao ctx2 = new ContexteDao();
                    Throwable throwable = null;
                    try {
                        ficdel.setCtx(ctx2);
                        if ("0005".equals(fiche.getEtatObjet())) {
                            ficdel.setEtat("2");
                            ficdel.update();
                            continue;
                        }
                        if (ETAT_SAUVEGARDE_STRUCTURE_COURANTE.equals(fiche.getMessageAlerte())) {
                            ficdel.setEtat("0");
                            ficdel.update();
                            continue;
                        }
                        ficdel.delete();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx2 == null) continue;
                        if (throwable != null) {
                            try {
                                ctx2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ctx2.close();
                    }
                }
            }
        }
    }

    public static void synchroniserListeFichier(OMContext _ctx, FicheUniv _fiche, String _chaineFichier, String modeFichier, int indice) throws Exception {
        boolean modifFichier = false;
        boolean apercu = "0005".equals(_fiche.getEtatObjet()) || "0006".equals(_fiche.getEtatObjet());
        String codeParent = _fiche.getIdFiche() + ",TYPE=" + ReferentielObjets.getCodeObjet(_fiche) + ",NO=" + indice;
        Hashtable<String, String> hListeFichier = new Hashtable<String, String>();
        if (_chaineFichier.length() > 0) {
            StringTokenizer st = new StringTokenizer(_chaineFichier, "|");
            while (st.hasMoreTokens()) {
                String enregistrement = st.nextToken();
                String[] ligne = enregistrement.split(";", -2);
                Ressource ressource = new Ressource();
                ressource.init();
                ressource.setCtx(_ctx);
                ressource.setIdRessource(new Long(ligne[0]));
                ressource.retrieve();
                if (ressource.getCodeParent().length() == 0) {
                    if ("0".equals(ressource.getEtat())) {
                        if (FicheUnivMgr.isFicheCollaborative(_fiche)) {
                            modifFichier = true;
                        }
                        ressource.setEtat("1");
                    }
                    ressource.setCodeParent(codeParent);
                    if (apercu) {
                        ressource = Ressource.dupliquerFichier(ressource, codeParent, "1");
                    } else {
                        ressource.update();
                    }
                } else if (!ressource.getCodeParent().equals(codeParent)) {
                    ressource = Ressource.dupliquerFichier(ressource, codeParent, "1");
                }
                hListeFichier.put(ressource.getIdRessource().toString(), "");
            }
        }
        Ressource ficdel = new Ressource();
        ficdel.init();
        ficdel.setCtx(_ctx);
        ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(codeParent);
        if (ficdel.select(whereCodeParent.formaterSQL()) > 0) {
            while (ficdel.nextItem()) {
                ClauseWhere whereIdMedia;
                Ressource temp = new Ressource();
                temp.init();
                temp.setCtx(_ctx);
                if (hListeFichier.get(ficdel.getIdRessource().toString()) == null) {
                    whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                    if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                        Media.deleteById(ficdel.getIdMedia());
                        if (FicheUnivMgr.isFicheCollaborative(_fiche)) {
                            modifFichier = true;
                        }
                    }
                    ficdel.delete();
                    continue;
                }
                if (apercu) continue;
                whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                whereIdMedia.and(ConditionHelper.egalVarchar("ETAT", "2"));
                temp.select(whereIdMedia.formaterSQL());
                while (temp.nextItem()) {
                    temp.delete();
                }
            }
        }
    }

    public static void synchroniserListeFichier(OMContext _ctx, String _codeParent, String _chaineFichier, String modeFichier, boolean _apercu) throws Exception {
        Hashtable<String, String> hListeFichier = new Hashtable<String, String>();
        if (_chaineFichier.length() > 0) {
            StringTokenizer st = new StringTokenizer(_chaineFichier, "|");
            while (st.hasMoreTokens()) {
                String enregistrement = st.nextToken();
                String[] ligne = enregistrement.split(";", -2);
                Ressource fichiergw = new Ressource();
                fichiergw.init();
                fichiergw.setCtx(_ctx);
                fichiergw.setIdRessource(new Long(ligne[0]));
                fichiergw.retrieve();
                if (fichiergw.getCodeParent().length() == 0) {
                    if ("0".equals(fichiergw.getEtat())) {
                        fichiergw.setEtat("1");
                    }
                    if (_apercu) {
                        fichiergw.update();
                    }
                    fichiergw.setCodeParent(_codeParent);
                    if (_apercu) {
                        fichiergw = Ressource.dupliquerFichier(fichiergw, _codeParent, "1");
                    } else {
                        fichiergw.update();
                    }
                } else if (!fichiergw.getCodeParent().equals(_codeParent)) {
                    fichiergw = Ressource.dupliquerFichier(fichiergw, _codeParent, "1");
                }
                hListeFichier.put(fichiergw.getIdRessource().toString(), "");
            }
        }
        Ressource ficdel = new Ressource();
        ficdel.init();
        ficdel.setCtx(_ctx);
        ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(_codeParent);
        if (ficdel.select(whereCodeParent.formaterSQL()) > 0) {
            while (ficdel.nextItem()) {
                if (hListeFichier.get(ficdel.getIdRessource().toString()) != null) continue;
                Ressource temp = new Ressource();
                temp.init();
                temp.setCtx(_ctx);
                ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                    Media.deleteById(ficdel.getIdMedia());
                }
                ficdel.delete();
            }
        }
    }

    public static void synchroniserFichier(OMContext _ctx, FicheUniv _fiche, String _chaineFichier, String modeFichier, int indice) throws Exception {
        boolean modifFichier = false;
        String codeParent = _fiche.getIdFiche() + ",TYPE=FICHIER_" + ReferentielObjets.getCodeObjet(_fiche) + ",NO=" + Integer.toString(indice);
        String idFichier = "";
        if (_chaineFichier.length() > 0 && !"0".equals(_chaineFichier)) {
            String[] ligne = _chaineFichier.split(";", -2);
            Ressource fichiergw = new Ressource();
            fichiergw.init();
            fichiergw.setCtx(_ctx);
            fichiergw.setIdRessource(new Long(ligne[0]));
            fichiergw.retrieve();
            if (fichiergw.getCodeParent().length() == 0) {
                if ("0".equals(fichiergw.getEtat())) {
                    fichiergw.setEtat("1");
                    if (FicheUnivMgr.isFicheCollaborative(_fiche)) {
                        modifFichier = true;
                    }
                }
                if ("0005".equals(_fiche.getEtatObjet()) || "0006".equals(_fiche.getEtatObjet())) {
                    fichiergw.update();
                }
                fichiergw.setCodeParent(codeParent);
                if ("0005".equals(_fiche.getEtatObjet()) || "0006".equals(_fiche.getEtatObjet())) {
                    fichiergw = Ressource.dupliquerFichier(fichiergw, codeParent, "1");
                } else {
                    fichiergw.update();
                }
            } else if (!fichiergw.getCodeParent().equals(codeParent)) {
                fichiergw = Ressource.dupliquerFichier(fichiergw, codeParent, "1");
            }
            idFichier = fichiergw.getIdRessource().toString();
        }
        Ressource ficdel = new Ressource();
        ficdel.init();
        ficdel.setCtx(_ctx);
        ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(codeParent);
        if (ficdel.select(whereCodeParent.formaterSQL()) > 0) {
            while (ficdel.nextItem()) {
                if (ficdel.getIdRessource().toString().equals(idFichier)) continue;
                Ressource temp = new Ressource();
                temp.init();
                temp.setCtx(_ctx);
                ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                    Media.deleteById(ficdel.getIdMedia());
                    if (FicheUnivMgr.isFicheCollaborative(_fiche)) {
                        modifFichier = true;
                    }
                }
                ficdel.delete();
            }
        }
    }

    public static void saveContentRessource(OMContext _ctx, Map<String, Object> _infoBean, FicheUniv _ficheUniv) throws Exception {
        Ressource ressource = new Ressource();
        ressource.init();
        ressource.setCtx(_ctx);
        String type = "";
        String codeParent = "";
        String _codeParent = "_" + ReferentielObjets.getCodeObjet(_ficheUniv) + ",CODE=";
        String codeRecherche = "";
        codeRecherche = ((String)_infoBean.get("TS_CODE")).startsWith("TS") ? _codeParent + _infoBean.get("TS_CODE") : _codeParent + _ficheUniv.getCode();
        _codeParent = _codeParent + _ficheUniv.getCode();
        boolean duplique = true;
        HashSet hSetNew = (HashSet)_infoBean.get("contentNewRessources");
        HashSet hSetOld = (HashSet)_infoBean.get("contentOldRessources");
        for (String codeFichier : hSetNew) {
            try {
                duplique = true;
                type = codeFichier.contains("IMG") ? "IMG" : "LIEN";
                codeFichier = codeFichier.substring(0, codeFichier.indexOf("#"));
                codeParent = "TYPE=" + type + _codeParent;
                ClauseWhere whereCodeParentEtIdMedia = new ClauseWhere(ConditionHelper.like(COLONNE_CODE_PARENT, codeRecherche, "%", ""));
                whereCodeParentEtIdMedia.and(ConditionHelper.egalVarchar("ID_MEDIA", codeFichier));
                if (ressource.select(whereCodeParentEtIdMedia.formaterSQL()) > 0) {
                    while (ressource.nextItem()) {
                        if ("0".equals(ressource.getEtat())) {
                            if (_infoBean.get("#ETAT#").equals("CREATION") && "0005".equals(_ficheUniv.getEtatObjet())) {
                                ressource.update();
                                break;
                            }
                            ressource.setCodeParent(_ficheUniv.getIdFiche().toString() + "," + codeParent);
                            ressource.setEtat("1");
                            ressource.update();
                            duplique = false;
                            break;
                        }
                        if (ressource.getCodeParent().indexOf(_ficheUniv.getIdFiche().toString() + ",") != 0) continue;
                        duplique = false;
                        break;
                    }
                    if (!duplique) continue;
                    ressource.setIdRessource(0L);
                    ressource.setCodeParent(_ficheUniv.getIdFiche().toString() + "," + codeParent);
                    ressource.setEtat("1");
                    ressource.add();
                    continue;
                }
                try {
                    Media media = new Media();
                    media.init();
                    media.setCtx(_ctx);
                    media.setIdMedia(new Long(codeFichier));
                    media.retrieve();
                    ressource.setIdMedia(media.getIdMedia());
                    ressource.setIdRessource(0L);
                    ressource.setCodeParent(_ficheUniv.getIdFiche().toString() + "," + codeParent);
                    ressource.setEtat("1");
                    ressource.add();
                }
                catch (Exception media) {
                }
            }
            catch (Exception whereCodeParentEtIdMedia) {}
        }
        Ressource temp = new Ressource();
        temp.init();
        temp.setCtx(_ctx);
        String codeParentEchapper = EscapeString.escapeSql(_codeParent);
        String valeurLike = "'" + _ficheUniv.getIdFiche() + ",TYPE=%" + codeParentEchapper + "'";
        ClauseWhere whereCodeParentEtIdMedia = new ClauseWhere(ConditionHelper.genericConditionSurColonne(COLONNE_CODE_PARENT, valeurLike, TypeOperande.NON_ECHAPABLE, Operateur.LIKE));
        if (ressource.select(whereCodeParentEtIdMedia.formaterSQL()) > 0) {
            while (ressource.nextItem()) {
                if (!hSetOld.contains(ressource.getIdMedia().toString() + "#LIEN") && !hSetOld.contains(ressource.getIdMedia().toString() + "#IMG")) continue;
                ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ressource.getIdMedia());
                if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                    Media.deleteById(ressource.getIdMedia());
                }
                ressource.delete();
            }
        }
    }

    public static void synchroniserListeFichier(OMContext _ctx, String _codeParent, String _chaineFichier) throws Exception {
        Hashtable<String, String> hListeFichier = new Hashtable<String, String>();
        if (_chaineFichier.length() > 0) {
            StringTokenizer st = new StringTokenizer(_chaineFichier, "|");
            while (st.hasMoreTokens()) {
                String enregistrement = st.nextToken();
                String[] ligne = enregistrement.split(";", -2);
                Ressource fichiergw = new Ressource();
                fichiergw.init();
                fichiergw.setCtx(_ctx);
                fichiergw.setIdRessource(new Long(ligne[0]));
                fichiergw.retrieve();
                if (fichiergw.getCodeParent().length() == 0) {
                    if ("0".equals(fichiergw.getEtat())) {
                        fichiergw.setEtat("1");
                    }
                    fichiergw.setCodeParent(_codeParent);
                    fichiergw.update();
                }
                hListeFichier.put(fichiergw.getIdRessource().toString(), "");
            }
        }
        Ressource ficdel = new Ressource();
        ficdel.init();
        ficdel.setCtx(_ctx);
        ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(_codeParent);
        if (ficdel.select(whereCodeParent.formaterSQL()) > 0) {
            while (ficdel.nextItem()) {
                if (hListeFichier.get(ficdel.getIdRessource().toString()) != null) continue;
                Ressource temp = new Ressource();
                temp.init();
                temp.setCtx(_ctx);
                ClauseWhere whereIdMedia = Ressource.whereIdMediaEgal(ficdel.getIdMedia());
                if (temp.select(whereIdMedia.formaterSQL()) == 1) {
                    Media.deleteById(ficdel.getIdMedia());
                }
                ficdel.delete();
            }
        }
    }

    public static void synchroniserFichier(OMContext _ctx, String _chaineFichier, String codeParent, String modeFichier) throws Exception {
        String idFichier = "";
        if (_chaineFichier.length() > 0 && !"0".equals(_chaineFichier)) {
            String[] ligne = _chaineFichier.split(";", -2);
            Ressource fichiergw = new Ressource();
            fichiergw.init();
            fichiergw.setCtx(_ctx);
            fichiergw.setIdRessource(new Long(ligne[0]));
            fichiergw.retrieve();
            if ("0".equals(fichiergw.getEtat())) {
                fichiergw.setCodeParent(codeParent);
                fichiergw.setEtat("1");
                fichiergw.update();
            } else if (!fichiergw.getCodeParent().equals(codeParent)) {
                fichiergw = Ressource.dupliquerFichier(fichiergw, codeParent, "1");
            }
            idFichier = fichiergw.getIdRessource().toString();
        }
        Ressource ficdel = new Ressource();
        ficdel.init();
        ficdel.setCtx(_ctx);
        ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(codeParent);
        if (ficdel.select(whereCodeParent.formaterSQL()) > 0) {
            while (ficdel.nextItem()) {
                if (ficdel.getIdRessource().toString().equals(idFichier)) continue;
                Media.deleteById(ficdel.getIdMedia());
                ficdel.delete();
            }
        }
    }

    @Deprecated
    public static void dupliquerListeFichier(OMContext _ctx, FicheUniv _ficheOrigine, FicheUniv _ficheNouvelle) throws Exception {
        String codeParent = "";
        Vector<Ressource> listeFichier = Ressource.getListeTotale(_ficheOrigine);
        if (listeFichier.size() > 0) {
            for (Ressource fic : listeFichier) {
                codeParent = fic.getCodeParent().replaceFirst(_ficheOrigine.getIdFiche().toString(), _ficheNouvelle.getIdFiche().toString());
                if (codeParent.contains(_ficheOrigine.getCode())) {
                    codeParent = StringUtils.replace((String)codeParent, (String)_ficheOrigine.getCode(), (String)_ficheNouvelle.getCode());
                }
                Ressource.dupliquerFichier(fic, codeParent, "1");
            }
        }
    }

    public static void dupliquerListeFichier(FicheUniv ficheOrigine, FicheUniv ficheNouvelle) throws Exception {
        String codeParent = "";
        Vector<Ressource> listeFichier = Ressource.getListeTotale(ficheOrigine);
        if (listeFichier.size() > 0) {
            for (Ressource fic : listeFichier) {
                codeParent = fic.getCodeParent().replaceFirst(ficheOrigine.getIdFiche().toString(), ficheNouvelle.getIdFiche().toString());
                if (codeParent.contains(ficheOrigine.getCode())) {
                    codeParent = StringUtils.replace((String)codeParent, (String)ficheOrigine.getCode(), (String)ficheNouvelle.getCode());
                }
                Ressource.dupliquerFichier(fic, codeParent, "1");
            }
        }
    }

    @Deprecated
    public static Ressource dupliquerFichier(OMContext _ctx, Ressource _fichiergw, String _codeParent, String _etat) throws Exception {
        return Ressource.dupliquerFichier(_fichiergw, _codeParent, _etat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ressource dupliquerFichier(Ressource fichiergw, String codeParent, String etat) throws Exception {
        Ressource fichierACreer = new Ressource();
        ContexteDao ctx = new ContexteDao();
        fichierACreer.setCtx(ctx);
        fichierACreer.init();
        fichierACreer.setIdRessource(0L);
        fichierACreer.setIdMedia(fichiergw.getIdMedia());
        fichierACreer.setCodeParent(codeParent);
        fichierACreer.setOrdre(fichiergw.getOrdre());
        if (StringUtils.isEmpty((CharSequence)etat)) {
            etat = fichiergw.getEtat();
        }
        fichierACreer.setEtat(etat);
        try {
            fichierACreer.add();
        }
        finally {
            ctx.close();
        }
        return fichierACreer;
    }

    @Deprecated
    public static Vector<Ressource> getListeTotale(OMContext _ctx, FicheUniv _fiche) throws Exception {
        return Ressource.getListeTotale(_fiche);
    }

    public static Vector<Ressource> getListeTotale(FicheUniv fiche) throws Exception {
        String codeParent = fiche.getIdFiche() + ",TYPE=%" + ReferentielObjets.getCodeObjet(fiche) + "%";
        return Ressource.getListeFichier(codeParent, "");
    }

    @Deprecated
    public static Vector<Ressource> getListeFichier(OMContext _ctx, FicheUniv _fiche) throws Exception {
        return Ressource.getListeFichier(_fiche);
    }

    public static Vector<Ressource> getListeFichier(FicheUniv fiche) throws Exception {
        String codeParent = fiche.getIdFiche() + ",TYPE=" + ReferentielObjets.getCodeObjet(fiche) + "%";
        return Ressource.getListeFichier(codeParent, COLONNE_CODE_PARENT);
    }

    @Deprecated
    public static Vector<Ressource> getListeFichierByCodeParent(OMContext _ctx, String codeParent) throws Exception {
        return Ressource.getListeFichierByCodeParent(codeParent);
    }

    public static Vector<Ressource> getListeFichierByCodeParent(String codeParent) throws Exception {
        return Ressource.getListeFichier(codeParent, COLONNE_CODE_PARENT);
    }

    @Deprecated
    public static Vector<Ressource> getListeFichier(OMContext _ctx, FicheUniv _fiche, String indice) throws Exception {
        return Ressource.getListeFichier(_fiche, indice);
    }

    public static Vector<Ressource> getListeFichier(FicheUniv fiche, String indice) throws Exception {
        String codeParent = fiche.getIdFiche() + ",TYPE=" + ReferentielObjets.getCodeObjet(fiche) + ",NO=" + indice;
        return Ressource.getListeFichier(codeParent, COLONNE_CODE_PARENT);
    }

    @Deprecated
    public static Vector<Ressource> getListeFichierIndice(OMContext _ctx, FicheUniv _fiche) throws Exception {
        return Ressource.getListeFichierIndice(_fiche);
    }

    public static Vector<Ressource> getListeFichierIndice(FicheUniv fiche) throws Exception {
        String codeParent = fiche.getIdFiche() + ",TYPE=FICHIER_" + ReferentielObjets.getCodeObjet(fiche) + "%";
        return Ressource.getListeFichier(codeParent, COLONNE_CODE_PARENT);
    }

    @Deprecated
    public static Vector<Ressource> getListeFichierIndice(OMContext _ctx, FicheUniv _fiche, String indice) throws Exception {
        return Ressource.getListeFichierIndice(_fiche, indice);
    }

    public static Vector<Ressource> getListeFichierIndice(FicheUniv fiche, String indice) throws Exception {
        String codeParent = fiche.getIdFiche() + ",TYPE=FICHIER_" + ReferentielObjets.getCodeObjet(fiche) + ",NO=" + indice;
        return Ressource.getListeFichier(codeParent, COLONNE_CODE_PARENT);
    }

    @Deprecated
    public static Vector<Ressource> getListeFichier(OMContext _ctx, String _codeParent) throws Exception {
        return Ressource.getListeFichier(_codeParent);
    }

    public static Vector<Ressource> getListeFichier(String codeParent) throws Exception {
        return Ressource.getListeFichier(codeParent, "");
    }

    @Deprecated
    public static Vector<Ressource> getListeFichier(OMContext _ctx, String _codeParent, String _orderBy) throws Exception {
        Vector<Ressource> liste = new Vector<Ressource>();
        Ressource fichiergw = new Ressource();
        fichiergw.init();
        fichiergw.setCtx(_ctx);
        ClauseWhere whereCodeParentlike = new ClauseWhere(ConditionHelper.like(COLONNE_CODE_PARENT, _codeParent, "", ""));
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)_orderBy)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy(_orderBy);
        } else {
            orderBy.orderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
        }
        RequeteSQL requeteSQL = new RequeteSQL();
        requeteSQL.where(whereCodeParentlike).orderBy(orderBy);
        if (fichiergw.select(requeteSQL.formaterRequete()) > 0) {
            while (fichiergw.nextItem()) {
                Ressource fic = new Ressource();
                fic = (Ressource)fichiergw.clone();
                liste.add(fic);
            }
        }
        return liste;
    }

    public static Vector<Ressource> getListeFichier(String codeParent, String orderBy) throws Exception {
        Vector<Ressource> liste = new Vector<Ressource>();
        Ressource fichiergw = new Ressource();
        ClauseWhere whereCodeParentlike = new ClauseWhere(ConditionHelper.like(COLONNE_CODE_PARENT, codeParent, "", ""));
        ClauseOrderBy clauseOrderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            clauseOrderBy = OrderByHelper.reconstruireClauseOrderBy(orderBy);
        } else {
            clauseOrderBy.orderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
        }
        RequeteSQL requeteSQL = new RequeteSQL();
        requeteSQL.where(whereCodeParentlike).orderBy(clauseOrderBy);
        try (ContexteDao ctx = new ContexteDao();){
            fichiergw.init();
            fichiergw.setCtx(ctx);
            if (fichiergw.select(requeteSQL.formaterRequete()) > 0) {
                while (fichiergw.nextItem()) {
                    Ressource fic = (Ressource)fichiergw.clone();
                    liste.add(fic);
                }
            }
        }
        return liste;
    }

    @Deprecated
    public static Ressource getFichier(OMContext _ctx, FicheUniv _fiche) {
        return Ressource.getFichier(_fiche);
    }

    public static Ressource getFichier(FicheUniv fiche) {
        return Ressource.getFichier(fiche, "1");
    }

    @Deprecated
    public static Ressource getFichier(OMContext _ctx, FicheUniv _fiche, String indice) {
        String code = _fiche.getIdFiche() + ",TYPE=FICHIER_" + ReferentielObjets.getCodeObjet(_fiche) + ",NO=" + indice;
        Ressource fichiergw = new Ressource();
        fichiergw.init();
        fichiergw.setCtx(_ctx);
        try {
            ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(code);
            ClauseOrderBy orderByIdRessource = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
            RequeteSQL requeteCodeParentTrie = new RequeteSQL();
            requeteCodeParentTrie.where(whereCodeParent).orderBy(orderByIdRessource);
            fichiergw.select(requeteCodeParentTrie.formaterRequete());
            if (fichiergw.nextItem()) {
                return fichiergw;
            }
        }
        catch (Exception e) {
            LOGGER.error("Fichier code=" + code + " introuvable.", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ressource getFichier(FicheUniv _fiche, String indice) {
        String code = _fiche.getIdFiche() + ",TYPE=FICHIER_" + ReferentielObjets.getCodeObjet(_fiche) + ",NO=" + indice;
        Ressource fichiergw = new Ressource();
        fichiergw.init();
        try (ContexteDao ctx = new ContexteDao();){
            fichiergw.setCtx(ctx);
            ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(code);
            ClauseOrderBy orderByIdRessource = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
            RequeteSQL requeteCodeParentTrie = new RequeteSQL();
            requeteCodeParentTrie.where(whereCodeParent).orderBy(orderByIdRessource);
            fichiergw.select(requeteCodeParentTrie.formaterRequete());
            if (!fichiergw.nextItem()) return null;
            Ressource ressource = fichiergw;
            return ressource;
        }
        catch (Exception e) {
            LOGGER.error("Fichier code=" + code + " introuvable.", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static Ressource getFichier(OMContext _ctx, String _code) {
        block4: {
            Ressource fichiergw = new Ressource();
            fichiergw.init();
            fichiergw.setCtx(_ctx);
            try {
                if (_code.contains("TYPE=")) {
                    ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(_code);
                    ClauseOrderBy orderByIdRessource = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
                    RequeteSQL requeteCodeParentTrie = new RequeteSQL();
                    requeteCodeParentTrie.where(whereCodeParent).orderBy(orderByIdRessource);
                    fichiergw.select(requeteCodeParentTrie.formaterRequete());
                    if (fichiergw.nextItem()) {
                        return fichiergw;
                    }
                    break block4;
                }
                fichiergw.setIdRessource(new Long(_code));
                fichiergw.retrieve();
                return fichiergw;
            }
            catch (Exception e) {
                LOGGER.error("Fichier code/id=" + _code + " introuvable.", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ressource getFichier(String codeParentOuId) {
        block8: {
            Ressource fichiergw = new Ressource();
            fichiergw.init();
            fichiergw.setCtx(ctx);
            try (ContexteDao ctx = new ContexteDao();){
                if (codeParentOuId.contains("TYPE=")) {
                    ClauseWhere whereCodeParent = Ressource.whereCodeParentEgal(codeParentOuId);
                    ClauseOrderBy orderByIdRessource = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
                    RequeteSQL requeteCodeParentTrie = new RequeteSQL();
                    requeteCodeParentTrie.where(whereCodeParent).orderBy(orderByIdRessource);
                    fichiergw.select(requeteCodeParentTrie.formaterRequete());
                    if (fichiergw.nextItem()) {
                        Ressource ressource = fichiergw;
                        return ressource;
                    }
                    break block8;
                }
                fichiergw.setIdRessource(new Long(codeParentOuId));
                fichiergw.retrieve();
                Ressource whereCodeParent = fichiergw;
                return whereCodeParent;
            }
        }
        return null;
    }

    public String getPathAbsolu() {
        return this.getMedia().getPathAbsolu();
    }

    @JsonIgnore
    public boolean isPhoto() {
        return "photo".equalsIgnoreCase(this.getMedia().getTypeRessource());
    }

    public Ressource getPhoto() {
        if (this.isPhoto()) {
            return this;
        }
        return new Ressource();
    }

    public String getUrlPhoto() {
        String url = "";
        if (this.isPhoto()) {
            url = this.getMedia().getUrlAbsolue();
            if (StringUtils.contains((CharSequence)this.getCodeParent(), (CharSequence)",TYPE=") && "2".equals(this.getEtat())) {
                url = url + "?ID_FICHE=" + StringUtils.substringBefore((String)this.getCodeParent(), (String)",");
            }
        }
        return url;
    }

    public int getLargeurPhoto() {
        int largeur = 0;
        if (this.isPhoto()) {
            try {
                largeur = Integer.parseInt(this.getMedia().getSpecificData("LARGEUR"));
            }
            catch (Exception e) {
                largeur = MediaPhoto.getCritereLimite().getLargeur();
            }
        }
        return largeur;
    }

    public int getLargeurVignette() {
        return MediaPhoto.getCritereVignette().getLargeur();
    }

    public int getHauteurPhoto() {
        int hauteur = 0;
        if (this.isPhoto()) {
            try {
                hauteur = Integer.parseInt(this.getMedia().getSpecificData("HAUTEUR"));
            }
            catch (Exception e) {
                hauteur = MediaPhoto.getCritereLimite().getHauteur();
            }
        }
        return hauteur;
    }

    public int getHauteurVignette() {
        return MediaPhoto.getCritereVignette().getHauteur();
    }

    public boolean isLocal() {
        boolean bLocal;
        block2: {
            bLocal = false;
            try {
                new URL(this.getMedia().getUrl());
            }
            catch (MalformedURLException e) {
                if (this.getMedia().getUrl().contains("/")) break block2;
                bLocal = true;
            }
        }
        return bLocal;
    }

    public Media getMedia() {
        Media res = new Media();
        res.init();
        if (this.media == null && this.getIdMedia() != null && this.getIdMedia() != 0L) {
            try (ContexteDao ctxDao = new ContexteDao();){
                Media m = new Media();
                m.init();
                m.setCtx(ctxDao);
                m.setIdMedia(this.getIdMedia());
                m.retrieve();
                this.media = m;
                ContexteUniv ctxUniv = ContexteUtil.getContexteUniv();
                if (ctxUniv != null && ctxUniv.getLocale() != null && !ctxUniv.getLocale().equals(LangueUtil.getDefaultLocale())) {
                    this.media.setLangue(LangueUtil.getIndiceLocale(ctxUniv.getLocale()));
                }
                res = this.media;
            }
            catch (Exception exception) {}
        } else if (this.media != null) {
            res = this.media;
        }
        return res;
    }

    public String getAuteur() {
        return this.getMedia().getAuteur();
    }

    public String getCodeRedacteur() {
        return this.getMedia().getCodeRedacteur();
    }

    public String getCopyright() {
        return this.getMedia().getCopyright();
    }

    public Date getDateCreation() {
        return this.getMedia().getDateCreation();
    }

    public String getDescription() {
        return this.getMedia().getDescription();
    }

    public String getFormat() {
        return this.getMedia().getFormat();
    }

    public String getLegende() {
        return this.getMedia().getLegende();
    }

    public String getMetaKeywords() {
        return this.getMedia().getMetaKeywords();
    }

    public Integer getPoids() {
        return this.getMedia().getPoids();
    }

    public String getSpecificData() {
        return this.getMedia().getSpecificData();
    }

    public String getSource() {
        return this.getMedia().getSource();
    }

    public String getTitre() {
        return this.getMedia().getTitre();
    }

    public boolean isSecurise() {
        return !this.getMedia().isPublic();
    }

    public String getLibelle() {
        return this.getMedia().getLibelleAffichable();
    }

    public String getTypeMedia() {
        return this.getMedia().getTypeMedia();
    }

    public String getTypeRessource() {
        return this.getMedia().getTypeRessource();
    }

    public String getUrl() {
        String url = "";
        if (this.getMedia() != null) {
            url = this.media.getUrlAbsolue();
            if (StringUtils.contains((CharSequence)this.getCodeParent(), (CharSequence)",TYPE=") && "2".equals(this.getEtat())) {
                url = url + "?ID_FICHE=" + StringUtils.substringBefore((String)this.getCodeParent(), (String)",");
            }
        }
        return url;
    }

    public String getUrlVignette() {
        return this.getMedia().getUrlVignetteAbsolue();
    }

    public String getExtension() {
        return this.getMedia().getExtension();
    }
}

