/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.cache.CacheRoleManager;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.sgbd.RoleDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Role
extends RoleDB
implements Cloneable {
    private static Logger LOG = LoggerFactory.getLogger(Role.class);

    public void init() {
        this.setIdRole(0L);
        this.setCode(String.valueOf(System.currentTimeMillis()));
        this.setLibelle("");
        this.setPerimetre("");
        this.setPermissions("");
    }

    @Deprecated
    public static Vector<Perimetre> renvoyerPerimetresAffectation(OMContext ctx, String roles, String codeRole, List<String> codesStructures, String codeRubrique, String publicsVises, String codeEspaceCollaboratif) {
        return Role.renvoyerPerimetresAffectation(roles, codeRole, codesStructures, codeRubrique, publicsVises, codeEspaceCollaboratif);
    }

    public static Vector<Perimetre> renvoyerPerimetresAffectation(String roles, String _codeRole, List<String> codesStructures, String codeRubrique, String publicsVises, String codeEspaceCollaboratif) {
        if (_codeRole.contains("RESP_COL") && roles.contains("RESP_COL")) {
            LOG.debug("renvoyerPerimetresAffection [" + _codeRole + "] dans " + roles);
        }
        Vector<Perimetre> v = new Vector<Perimetre>();
        StringTokenizer st = new StringTokenizer(roles, "[]");
        while (st.hasMoreTokens()) {
            String codeRole;
            String val = st.nextToken();
            int indexPointVirgule = val.indexOf(59);
            if (indexPointVirgule == -1 || !(codeRole = val.substring(0, indexPointVirgule)).equals(_codeRole)) continue;
            String sPerimetre = val.substring(indexPointVirgule + 1);
            Perimetre perimetre = new Perimetre(sPerimetre);
            InfosRole infos = Role.renvoyerItemRole(_codeRole);
            if (infos.getCode().length() > 0) {
                perimetre = Perimetre.calculerPerimetrePermission(perimetre, new Perimetre(infos.getPerimetre()));
            } else {
                LOG.warn("renvoyerPerimetresAffection() role " + _codeRole + " affect\u00e9 mais non d\u00e9fini");
            }
            StringTokenizer stPublics = new StringTokenizer(publicsVises, "[]");
            if (stPublics.countTokens() > 0) {
                while (stPublics.hasMoreTokens()) {
                    String publicVise = stPublics.nextToken();
                    String profil = "";
                    String groupe = "";
                    int indiceSeparateur = publicVise.indexOf("/");
                    if (indiceSeparateur != -1) {
                        profil = publicVise.substring(0, indiceSeparateur);
                        groupe = publicVise.substring(indiceSeparateur + 1);
                    }
                    for (String codesStructure : codesStructures) {
                        Perimetre perimetreRecherche = new Perimetre(codesStructure, codeRubrique, profil, groupe, codeEspaceCollaboratif);
                        if (perimetre == null || !perimetreRecherche.estConformeAuPerimetre(perimetre)) continue;
                        v.add(perimetre);
                    }
                }
                continue;
            }
            for (String codesStructure : codesStructures) {
                Perimetre perimetreRecherche = new Perimetre(codesStructure, codeRubrique, "", "", codeEspaceCollaboratif);
                if (perimetre == null || !perimetreRecherche.estConformeAuPerimetre(perimetre)) continue;
                v.add(perimetre);
            }
        }
        return v;
    }

    public int select(String code, String libelle, String permission) throws Exception {
        RequeteSQL requeteCodeLibellePermission = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.like("LIBELLE", libelle, "%[", "]%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)permission)) {
            where.and(ConditionHelper.like("PERMISSIONS", permission, "%[", "]%"));
        }
        requeteCodeLibellePermission.where(where).orderBy(orderBy);
        return this.select(requeteCodeLibellePermission.formaterRequete());
    }

    @Deprecated
    public static Collection<Role> getListeIDRoles(OMContext ctx) throws Exception {
        Role role = new Role();
        role.setCtx(ctx);
        String requete = "";
        if (!Espacecollaboratif.isExtensionActivated()) {
            requete = "WHERE PERIMETRE NOT LIKE '%/*'";
        }
        int count = role.select(requete);
        ArrayList<Role> res = new ArrayList<Role>(count);
        while (role.nextItem()) {
            res.add(role.clone());
        }
        return res;
    }

    public static Collection<Role> getAllRolesWithoutCollab() throws Exception {
        Role role = new Role();
        ArrayList<Role> res = new ArrayList<Role>();
        try (ContexteDao ctx = new ContexteDao();){
            role.setCtx(ctx);
            String requete = "";
            if (!Espacecollaboratif.isExtensionActivated()) {
                requete = "WHERE PERIMETRE NOT LIKE '%/*'";
            }
            role.select(requete);
            while (role.nextItem()) {
                res.add(role.clone());
            }
        }
        return res;
    }

    public static Hashtable<String, String> getListeRoles(OMContext ctx) {
        HashMap<String, InfosRole> listeRoles = Role.getListeRoles();
        Collection toutLesInfosRoles = listeRoles.values();
        Hashtable<String, String> res = new Hashtable<String, String>(listeRoles.size());
        for (InfosRole info : toutLesInfosRoles) {
            res.put(info.getCode(), info.getIntitule());
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getListeRolesHorsEspace(OMContext ctx) {
        return Role.getListeRolesHorsEspace();
    }

    public static Hashtable<String, String> getListeRolesHorsEspace() {
        HashMap<String, InfosRole> listeRoles = Role.getListeRoles();
        Collection toutLesInfosRoles = listeRoles.values();
        Hashtable<String, String> res = new Hashtable<String, String>(listeRoles.size());
        for (InfosRole info : toutLesInfosRoles) {
            if (new Perimetre(info.getPerimetre()).getCodeEspaceCollaboratif().length() != 0) continue;
            res.put(info.getCode(), info.getIntitule());
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getListeRolesEspaceCollaboratif(OMContext ctx) {
        return Role.getListeRolesEspaceCollaboratif();
    }

    public static Hashtable<String, String> getListeRolesEspaceCollaboratif() {
        HashMap<String, InfosRole> listeRoles = Role.getListeRoles();
        Collection toutLesInfosRoles = listeRoles.values();
        Hashtable<String, String> res = new Hashtable<String, String>(listeRoles.size());
        for (InfosRole info : toutLesInfosRoles) {
            if (!new Perimetre(info.getPerimetre()).getCodeEspaceCollaboratif().equals("*")) continue;
            res.put(info.getCode(), info.getIntitule());
        }
        return res;
    }

    public static HashMap<String, InfosRole> getListeRoles() {
        CacheRoleManager cache = (CacheRoleManager)ApplicationContextManager.getCoreContextBean("cacheRoleManager");
        return cache.getListeRoles();
    }

    public static InfosRole renvoyerItemRole(String code) {
        HashMap<String, InfosRole> listeRoles = Role.getListeRoles();
        InfosRole res = (InfosRole)listeRoles.get(code);
        if (res == null) {
            res = new InfosRole();
        }
        return res;
    }

    @Deprecated
    public static String getIntitule(OMContext ctx, String code) {
        return Role.getIntitule(code);
    }

    public static String getIntitule(String codes) {
        String res = "-";
        if (codes == null || codes.length() == 0) {
            return res;
        }
        res = "";
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String intitule;
            String code = st.nextToken();
            if (res.length() > 0) {
                res = res + ";";
            }
            if ((intitule = Role.renvoyerItemRole(code).getIntitule()).length() == 0) {
                intitule = "-";
            }
            res = res + intitule;
        }
        return res;
    }

    public Vector<PermissionBean> getVecteurPermissions() {
        Vector<PermissionBean> v = new Vector<PermissionBean>();
        StringTokenizer st = new StringTokenizer(this.getPermissions(), "[]");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            v.add(new PermissionBean(val));
        }
        return v;
    }

    public void setVecteurPermissions(Vector<PermissionBean> v) {
        String liste = "";
        Enumeration<PermissionBean> en = v.elements();
        while (en.hasMoreElements()) {
            liste = liste + "[" + en.nextElement().getChaineSerialisee() + "]";
        }
        this.setPermissions(liste);
    }

    protected Role clone() throws CloneNotSupportedException {
        return (Role)super.clone();
    }
}

