/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cache.CacheUtil;
import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.UsingLibelleMedia;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.cache.CacheRubriqueManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosBandeau;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.sgbd.RubriqueDB;
import com.univ.url.CacheUrlManager;
import com.univ.url.CacheUrlRubrique;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.xhtml.JavascriptTreeRubrique;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rubrique
extends RubriqueDB
implements UsingLibelleMedia {
    private static final long serialVersionUID = 7434176178304119510L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Rubrique.class);
    public static final String CODE_RUBRIQUE_ROOT = "00";
    public static final String CODE_RUBRIQUE_INEXISTANTE = "ZYZYZYZYZYZYZYZYZYZYZY";

    public void init() {
        this.setIdRubrique(0L);
        this.setCode(String.valueOf(System.currentTimeMillis()));
        this.setLangue("0");
        this.setIntitule("");
        this.setAccroche("");
        this.setIdBandeau(0L);
        this.setCouleurFond("");
        this.setCouleurTitre("");
        this.setNomOnglet("");
        this.setCodeRubriqueMere("");
        this.setTypeRubrique("");
        this.setPageAccueil("");
        this.setGestionEncadre("0");
        this.setEncadre("");
        this.setEncadreSousRubrique("0");
        this.setOrdre("");
        this.setContact("");
        this.setGroupesDsi("");
        this.setRequetesRubriquePublication("");
        this.setCategorie("");
        this.setIdPicto(0L);
    }

    public String getFormatedAccroche() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)this.ctx, this.getAccroche());
    }

    public String getFormatedEncadre() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)this.ctx, this.getEncadre());
    }

    @Override
    public void delete() throws Exception {
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(this.getCode());
        FicheUniv maFicheUniv = null;
        String nomObjet = null;
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            nomObjet = ReferentielObjets.getNomObjet(codeObjet);
            maFicheUniv = ReferentielObjets.instancierFiche(nomObjet);
            if (maFicheUniv == null) continue;
            maFicheUniv.init();
            maFicheUniv.setCtx(this.ctx);
            if (maFicheUniv.select("WHERE CODE_RUBRIQUE='" + this.getCode() + "' AND ETAT_OBJET IN('0001','0002','0003')") <= 0) continue;
            throw new ErreurApplicative(String.format("La rubrique \"%s\" ne peut pas \u00eatre supprim\u00e9 : des fiches y sont rattach\u00e9es.", infos.getLibelleAffichable()));
        }
        if (!infos.getListeSousRubriques().isEmpty()) {
            throw new ErreurApplicative(String.format("La rubrique \"%s\" ne peut pas \u00eatre supprim\u00e9 : des rubriques y sont rattach\u00e9es", infos.getLibelleAffichable()));
        }
        super.delete();
        Rubrique.rechargement();
        Rubriquepublication.supprimerRubriquePublication(this.ctx, this.getCode());
    }

    public static void rechargement() {
        CacheRubriqueManager.getInstance().asyncRefresh();
        CacheUrlManager.getInstance().asyncRefresh();
    }

    public static boolean controlerPermission(AutorisationBean autorisations, String sPermission, String codeRubrique) {
        boolean res = false;
        PermissionBean permissionCourante = new PermissionBean(sPermission);
        Perimetre perimetre = new Perimetre("", codeRubrique, "", "", "");
        res = autorisations.possedePermissionPartielleSurPerimetre(permissionCourante, perimetre);
        if (!res && permissionCourante.getType().equals("FICHE") && permissionCourante.getAction().equals("M") && autorisations.possedePermissionPartielleSurPerimetre(permissionCourante = new PermissionBean(permissionCourante.getType(), permissionCourante.getObjet(), "C"), perimetre)) {
            res = true;
        }
        return res;
    }

    public static String getArbreJavaScript(String _code, AutorisationBean autorisations, String _sPermission) throws Exception {
        return Rubrique.getArbreJavaScript(_code, autorisations, _sPermission, CODE_RUBRIQUE_ROOT);
    }

    public static String getArbreJavaScript(String _code, AutorisationBean autorisations, String _sPermission, String _codeRacine) throws Exception {
        if (_codeRacine == null || _codeRacine.length() == 0) {
            _codeRacine = CODE_RUBRIQUE_ROOT;
        }
        if (_code == null || _code.length() == 0) {
            _code = _codeRacine;
        }
        if (!_codeRacine.equals(CODE_RUBRIQUE_ROOT) && !_codeRacine.equals(_code) && Rubrique.renvoyerItemRubrique(_code).contains(Rubrique.renvoyerItemRubrique(_codeRacine))) {
            _codeRacine = CODE_RUBRIQUE_ROOT;
        }
        JavascriptTreeRubrique tree = new JavascriptTreeRubrique(autorisations, _sPermission);
        tree.load(Rubrique.renvoyerItemRubrique(_codeRacine), Rubrique.renvoyerItemRubrique(_code));
        return tree.print();
    }

    @Deprecated
    public static String getIntitule(OMContext _ctx, String _code, boolean _inclureRubriqueCourante) {
        String res = "";
        if (_code == null || _code.length() == 0) {
            return res;
        }
        res = Rubrique.renvoyerItemRubrique(_code).getIntitule();
        return res;
    }

    public static String getIntitule(String codeRubrique) {
        String intitule = MessageHelper.getCoreMessage("RUBRIQUE_INEXISTANTE");
        if (StringUtils.isNotBlank((CharSequence)codeRubrique)) {
            intitule = Rubrique.renvoyerItemRubrique(codeRubrique).getIntitule();
        }
        return intitule;
    }

    @Deprecated
    public static String getIntituleComplet(OMContext _ctx, String _code, boolean _inclureRubriqueCourante) {
        String res = "";
        if (_code == null || _code.length() == 0) {
            return res;
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(_code);
        if (_inclureRubriqueCourante) {
            res = rubrique.getIntitule();
        }
        while (rubrique.getNiveau() > 1) {
            rubrique = rubrique.getRubriqueMere();
            if (res.length() > 0) {
                res = "&nbsp;&gt;&nbsp;" + res;
            }
            res = rubrique.getOnglet() + res;
        }
        return res;
    }

    public static String getIntituleComplet(String code, boolean inclureRubriqueCourante) {
        String res = "";
        if (StringUtils.isEmpty((CharSequence)code)) {
            return res;
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(code);
        if (inclureRubriqueCourante) {
            res = rubrique.getIntitule();
        }
        while (rubrique.getNiveau() > 1) {
            rubrique = rubrique.getRubriqueMere();
            if (res.length() > 0) {
                res = "&nbsp;&gt;&nbsp;" + res;
            }
            res = rubrique.getOnglet() + res;
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getListeRubriquesParIntituleComplet(OMContext _ctx) {
        HashMap<String, InfosRubriques> mapRubrique = Rubrique.obtenirListeRubriques();
        Iterator<InfosRubriques> it = mapRubrique.values().iterator();
        Hashtable<String, String> res = new Hashtable<String, String>(mapRubrique.size());
        while (it.hasNext()) {
            InfosRubriques info = it.next();
            res.put(info.getCode(), Rubrique.getIntituleComplet(info.getCode(), true));
        }
        return res;
    }

    public static Hashtable<String, String> getListeRubriquesParIntituleComplet() {
        HashMap<String, InfosRubriques> mapRubrique = Rubrique.obtenirListeRubriques();
        Iterator<InfosRubriques> it = mapRubrique.values().iterator();
        Hashtable<String, String> res = new Hashtable<String, String>(mapRubrique.size());
        while (it.hasNext()) {
            InfosRubriques info = it.next();
            res.put(info.getCode(), Rubrique.getIntituleComplet(info.getCode(), true));
        }
        return res;
    }

    public static Vector<String> getListeCodesRubriques(OMContext _ctx) {
        HashMap<String, InfosRubriques> mapRubriques = Rubrique.obtenirListeRubriques();
        Vector<String> res = new Vector<String>();
        for (InfosRubriques infosRubriques : mapRubriques.values()) {
            res.add(infosRubriques.getCode());
        }
        return res;
    }

    public static List<String> getListeCodesRubriques() {
        HashMap<String, InfosRubriques> mapRubriques = Rubrique.obtenirListeRubriques();
        ArrayList<String> res = new ArrayList<String>();
        for (InfosRubriques infosRubriques : mapRubriques.values()) {
            res.add(infosRubriques.getCode());
        }
        return res;
    }

    private static HashMap<String, InfosRubriques> obtenirListeRubriques() {
        return (HashMap)CacheRubriqueManager.getInstance().call();
    }

    public static CacheUrlRubrique getCacheUrlRubrique() {
        Object res = CacheUtil.getObjectValue("CacheUrlManager.cacheUrlRubrique", "CacheUrlManager.cacheUrlRubrique");
        if (res != null) {
            return (CacheUrlRubrique)res;
        }
        ApplicationContextManager.getCoreContextBean("cacheUrlManager");
        return new CacheUrlRubrique();
    }

    public static Collection<InfosRubriques> getListeRubriquesPrincipale() {
        return Rubrique.getListeRubriquesPrincipale(null, false);
    }

    public static Collection<InfosRubriques> getListeRubriquesPrincipale(ContexteUniv ctx, boolean front) {
        InfosRubriques topLevelRubrique = Rubrique.getTopLevelRubrique();
        Collection<InfosRubriques> list = null;
        list = front ? topLevelRubrique.getListeSousRubriquesFront(ctx) : topLevelRubrique.getListeSousRubriques();
        return list;
    }

    public static InfosRubriques getTopLevelRubrique() {
        return Rubrique.obtenirListeRubriques().get(CODE_RUBRIQUE_ROOT);
    }

    @Deprecated
    public static Rubrique getFicheRubrique(OMContext _ctx, String _code, String _langue) throws Exception {
        Rubrique res = null;
        Rubrique rubrique = null;
        if (_code == null || _code.length() == 0) {
            return rubrique;
        }
        String langue = _langue;
        if (langue == null || langue.length() == 0) {
            langue = "0";
        }
        rubrique = new Rubrique();
        rubrique.init();
        rubrique.setCtx(_ctx);
        int count = rubrique.selectCodeLangue(_code, langue);
        if (count > 0) {
            while (rubrique.nextItem()) {
                res = rubrique;
            }
        }
        return res;
    }

    @Deprecated
    public static Rubrique getFicheRubrique(String code, String langue) throws Exception {
        return Rubrique.getRubrique(code, langue);
    }

    public static Rubrique getRubrique(String code, String langue) throws Exception {
        Rubrique res = null;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        try (ContexteDao ctx = new ContexteDao();){
            rubrique.setCtx(ctx);
            int count = rubrique.selectCodeLangue(code, (String)StringUtils.defaultIfEmpty((CharSequence)langue, (CharSequence)"0"));
            if (count > 0) {
                while (rubrique.nextItem()) {
                    res = rubrique;
                }
            }
        }
        return res;
    }

    public static Rubrique getRubriqueByCode(String code) throws Exception {
        Rubrique res = null;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        try (ContexteDao ctx = new ContexteDao();){
            rubrique.setCtx(ctx);
            int count = rubrique.selectCodeLangue(code, "");
            if (count > 0) {
                while (rubrique.nextItem()) {
                    res = rubrique;
                }
            }
        }
        return res;
    }

    public static InfosRubriques renvoyerItemRubrique(String code) {
        InfosRubriques res = Rubrique.obtenirListeRubriques().get(code);
        if (res == null) {
            res = new InfosRubriques("");
        }
        return res;
    }

    public static String renvoyerRubriqueEncadre(String _codeRubrique) {
        HashMap<String, InfosRubriques> mapRubriques = Rubrique.obtenirListeRubriques();
        String rubriqueNavigation = "";
        InfosRubriques infos = mapRubriques.get(_codeRubrique);
        if (infos == null) {
            return rubriqueNavigation;
        }
        rubriqueNavigation = infos.getTypeRubrique().equals("0001") ? _codeRubrique : Rubrique.renvoyerItemRubrique(_codeRubrique).getCodeRubriqueMere();
        return rubriqueNavigation;
    }

    public int select(String code, String langue, String intitule, String codeSaisi) throws Exception {
        String codeAVerifier = "";
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("INTITULE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            codeAVerifier = code;
        } else if (StringUtils.isNotEmpty((CharSequence)codeSaisi)) {
            codeAVerifier = codeSaisi;
        }
        if (StringUtils.isNotEmpty((CharSequence)codeAVerifier)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", codeAVerifier));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)intitule)) {
            where.and(ConditionHelper.rechercheMots("INTITULE", intitule));
        }
        requeteSelect.where(where).orderBy(orderBy);
        return this.select(requeteSelect.formaterRequete());
    }

    @Deprecated
    public int selectCodeLangueEtat(String code, String langue, String etatObjet) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("INTITULE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            where.and(ConditionHelper.egalVarchar("LANGUE", langue));
        }
        requeteSelect.where(where).orderBy(orderBy);
        return this.select(requeteSelect.formaterRequete());
    }

    public int selectCodeLangue(String code, String langue) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseOrderBy orderBy = new ClauseOrderBy("INTITULE", ClauseOrderBy.SensDeTri.ASC);
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            where.and(ConditionHelper.egalVarchar("LANGUE", langue));
        }
        requeteSelect.where(where).orderBy(orderBy);
        return this.select(requeteSelect.formaterRequete());
    }

    @Deprecated
    public static InfosBandeau getInfosBandeau(OMContext _ctx, String code, String _langue) {
        InfosBandeau infosBandeau = new InfosBandeau();
        if (StringUtils.isBlank((CharSequence)code)) {
            return infosBandeau;
        }
        String codeRubrique = code;
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(codeRubrique);
        String urlBandeau = Media.getMedia(infos.getIdMediaBandeau()).getUrlAbsolue();
        String couleurFond = infos.getCouleurFond();
        String couleurTitre = infos.getCouleurTitre();
        for (int niveau = infos.getNiveau(); niveau > 1 && urlBandeau.length() == 0; --niveau) {
            codeRubrique = infos.getCodeRubriqueMere();
            infos = Rubrique.renvoyerItemRubrique(codeRubrique);
            urlBandeau = Media.getMedia(infos.getIdMediaBandeau()).getUrlAbsolue();
            couleurFond = infos.getCouleurFond();
            couleurTitre = infos.getCouleurTitre();
        }
        infosBandeau.setUrlBandeau(urlBandeau);
        infosBandeau.setCouleurFond(couleurFond);
        infosBandeau.setCouleurTitre(couleurTitre);
        return infosBandeau;
    }

    public static InfosBandeau getInfosBandeau(String code) {
        InfosBandeau infosBandeau = new InfosBandeau();
        if (StringUtils.isBlank((CharSequence)code)) {
            return infosBandeau;
        }
        String codeRubrique = code;
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(codeRubrique);
        String urlBandeau = Media.getMedia(infos.getIdMediaBandeau()).getUrlAbsolue();
        String couleurFond = infos.getCouleurFond();
        String couleurTitre = infos.getCouleurTitre();
        for (int niveau = infos.getNiveau(); niveau > 1 && urlBandeau.length() == 0; --niveau) {
            codeRubrique = infos.getCodeRubriqueMere();
            infos = Rubrique.renvoyerItemRubrique(codeRubrique);
            urlBandeau = Media.getMedia(infos.getIdMediaBandeau()).getUrlAbsolue();
            couleurFond = infos.getCouleurFond();
            couleurTitre = infos.getCouleurTitre();
        }
        infosBandeau.setUrlBandeau(urlBandeau);
        infosBandeau.setCouleurFond(couleurFond);
        infosBandeau.setCouleurTitre(couleurTitre);
        return infosBandeau;
    }

    public static boolean controlerRestrictionRubrique(ContexteUniv ctx, String codeRubriqueFiche) {
        boolean accesOK = true;
        if (StringUtils.isNotBlank((CharSequence)codeRubriqueFiche)) {
            boolean boucleSurLaRubriqueParente = true;
            boolean droitRubriqueCourante = true;
            TreeSet<String> listeGroupes = ctx.getGroupesDsiAvecAscendants();
            InfosRubriques infoRubrique = null;
            String codeRubriqueCourante = codeRubriqueFiche;
            while (boucleSurLaRubriqueParente) {
                droitRubriqueCourante = false;
                infoRubrique = Rubrique.renvoyerItemRubrique(codeRubriqueCourante);
                Set<String> groupesDSI = infoRubrique.getGroupesDsi();
                if (groupesDSI != null && !groupesDSI.isEmpty()) {
                    for (String codeGroupe : groupesDSI) {
                        if (!listeGroupes.contains(codeGroupe)) continue;
                        droitRubriqueCourante = true;
                        break;
                    }
                } else {
                    droitRubriqueCourante = true;
                }
                if (droitRubriqueCourante) {
                    if (infoRubrique.getCodeRubriqueMere().length() > 0) {
                        codeRubriqueCourante = infoRubrique.getCodeRubriqueMere();
                        continue;
                    }
                    boucleSurLaRubriqueParente = false;
                    continue;
                }
                boucleSurLaRubriqueParente = false;
                accesOK = false;
            }
        }
        return accesOK;
    }

    public static String getRubriquePublication(OMContext ctx, InfosRubriques infosRubriqueCourante, ArrayList<String> lstCodeRubriquePubliable, boolean _inRubriqueCourante) {
        InfosSite siteCourant = ctx.getInfosSite();
        boolean controlDsi = false;
        boolean rubriqueAutorisee = false;
        boolean possedeRubrique = false;
        if (ctx instanceof ContexteUniv) {
            controlDsi = true;
        }
        Iterator<String> it = lstCodeRubriquePubliable.iterator();
        String codeRubrique = null;
        while (it.hasNext()) {
            possedeRubrique = true;
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(it.next());
            if (StringUtils.isEmpty((CharSequence)rubrique.getCode()) || controlDsi && !Rubrique.controlerRestrictionRubrique((ContexteUniv)ctx, rubrique.getCode())) continue;
            rubriqueAutorisee = true;
            if (!siteCourant.isRubriqueVisibleInSite(rubrique)) continue;
            if (!_inRubriqueCourante) {
                return rubrique.getCode();
            }
            if (codeRubrique == null) {
                codeRubrique = rubrique.getCode();
            }
            if (!rubrique.getCode().equals(infosRubriqueCourante.getCode()) && !infosRubriqueCourante.getListeSousRubriquesTousNiveaux().contains(rubrique)) continue;
            return rubrique.getCode();
        }
        if (controlDsi && possedeRubrique && !rubriqueAutorisee) {
            ((ContexteUniv)ctx).setCodeRubriquePageCourante(CODE_RUBRIQUE_INEXISTANTE);
        }
        return codeRubrique;
    }

    public static Collection<InfosRubriques> determinerListeSousRubriquesAutorisees(ContexteUniv ctx, InfosRubriques rubrique) {
        HashSet<InfosRubriques> listeRubriquesAutorisees = new HashSet<InfosRubriques>();
        if (rubrique == null || rubrique.getCode().length() == 0) {
            rubrique = Rubrique.getTopLevelRubrique();
        }
        Rubrique.determinerListeSousRubriquesAutorisees(ctx.getGroupesDsiAvecAscendants(), rubrique, true, listeRubriquesAutorisees);
        return listeRubriquesAutorisees;
    }

    public static void determinerListeSousRubriquesAutorisees(Set<String> listeGroupes, InfosRubriques rubrique, boolean rechercheArborescente, Collection<InfosRubriques> listeRecursive) {
        Collection<InfosRubriques> listeSousRubriques = rubrique.getListeSousRubriques();
        Iterator<InfosRubriques> iter = listeSousRubriques.iterator();
        InfosRubriques rubriqueCourante = null;
        while (iter.hasNext()) {
            rubriqueCourante = iter.next();
            boolean autorisationRubrique = true;
            Iterator<String> iter2 = rubriqueCourante.getGroupesDsi().iterator();
            if (iter2.hasNext()) {
                autorisationRubrique = false;
                while (iter2.hasNext()) {
                    if (!listeGroupes.contains(iter2.next())) continue;
                    autorisationRubrique = true;
                }
            }
            if (!autorisationRubrique) continue;
            listeRecursive.add(rubriqueCourante);
            if (!rechercheArborescente || rubriqueCourante.getListeSousRubriques().isEmpty()) continue;
            Rubrique.determinerListeSousRubriquesAutorisees(listeGroupes, rubriqueCourante, rechercheArborescente, listeRecursive);
        }
    }

    public static String getFilAriane(String codeRubrique, String separateur) {
        StringBuilder filAriane = new StringBuilder();
        try {
            if (separateur.length() == 0) {
                separateur = "&gt;";
            }
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
            while (rubrique.getNiveau() > 0) {
                if (filAriane.length() > 0) {
                    filAriane.insert(0, " ");
                    filAriane.insert(1, separateur);
                    filAriane.insert(separateur.length() + 1, " ");
                }
                filAriane.insert(0, rubrique.getIntitule());
                rubrique = rubrique.getRubriqueMere();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filAriane.toString();
    }

    @Override
    public List<String> getCodesLibelleMedia() {
        return Arrays.asList("0100");
    }

    @Override
    public void checkCodesLibelleMedia(OMContext ctx, long idMedia) throws Exception {
        Rubrique rubrique = new Rubrique();
        rubrique.setCtx(ctx);
        rubrique.init();
        rubrique.select("WHERE ID_BANDEAU=" + idMedia);
        if (rubrique.nextItem()) {
            throw new ErreurApplicative(String.format(MessageHelper.getCoreMessage(ctx.getLocale(), "RUBRIQUE.BANDEAU.ERREUR.SUPPRESSION_RESSOURCE"), rubrique.getIntitule()));
        }
    }

    public static void invaliderCacheRubriqueParMedia(long idMedia) {
        if (Rubrique.hasRubriqueParIdPictoOuIdBandeau(idMedia)) {
            Rubrique.rechargement();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasRubriqueParIdPictoOuIdBandeau(long idMedia) {
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        try (ContexteDao ctx = new ContexteDao();){
            rubrique.setCtx(ctx);
            int count = rubrique.select("WHERE ID_BANDEAU=" + idMedia + " OR ID_PICTO=" + idMedia);
            boolean bl = count > 0;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Erreur dans la r\u00e9cup\u00e9ration des m\u00e9dias avec l'id m\u00e9dias {}", (Object)idMedia, (Object)e);
            return false;
        }
    }
}

