/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosFicheComparator;
import com.univ.multisites.InfosFicheReferencee;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.sgbd.RubriquepublicationDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rubriquepublication
extends RubriquepublicationDB
implements Cloneable {
    private static Logger LOG = LoggerFactory.getLogger(Rubriquepublication.class);
    private static final long serialVersionUID = -3902618148975148091L;

    public Rubriquepublication clone() throws CloneNotSupportedException {
        return (Rubriquepublication)super.clone();
    }

    public void init() {
        this.setIdRubriquepublication(new Long(0L));
        this.setTypeFicheOrig("");
        this.setCodeFicheOrig("");
        this.setLangueFicheOrig("");
        this.setRubriqueDest("");
        this.setSourceRequete("");
    }

    public static Vector<String> getListeRubriquesPublication(OMContext _ctx, FicheUniv fiche) throws Exception {
        return Rubriquepublication.getListeRubriquesPublication(_ctx, fiche, "");
    }

    public static Vector<String> getListeRubriquesPublication(OMContext _ctx, FicheUniv fiche, String _rubriqueRecherche) throws Exception {
        return Rubriquepublication.getListeRubriquesPublication(_ctx, fiche, _rubriqueRecherche, false);
    }

    public static Vector<String> getListeRubriquesPublication(OMContext _ctx, FicheUniv fiche, String _rubriqueRecherche, boolean _controleurUniv) throws Exception {
        Vector<String> res = new Vector<String>();
        String typeFiche = ReferentielObjets.getCodeObjet(fiche);
        String codeFiche = fiche.getCode();
        String langueFiche = fiche.getLangue();
        ArrayList<String> lstCodeRubriqueRecherche = new ArrayList<String>();
        if (_rubriqueRecherche.length() > 0) {
            lstCodeRubriqueRecherche.add(_rubriqueRecherche);
            InfosRubriques infosRub = Rubrique.renvoyerItemRubrique(_rubriqueRecherche);
            Collection<InfosRubriques> listeSousRubriques = infosRub.getListeSousRubriquesTousNiveaux();
            if (!listeSousRubriques.isEmpty()) {
                for (InfosRubriques rubrique : listeSousRubriques) {
                    lstCodeRubriqueRecherche.add(rubrique.getCode());
                }
            }
        }
        Rubriquepublication rubriquePublication = new Rubriquepublication();
        rubriquePublication.setCtx(_ctx);
        rubriquePublication.init();
        String code = "";
        if (rubriquePublication.select(typeFiche, codeFiche, langueFiche) > 0) {
            while (rubriquePublication.nextItem()) {
                code = rubriquePublication.getRubriqueDest();
                if (_rubriqueRecherche.length() != 0 && !lstCodeRubriqueRecherche.contains(code)) continue;
                if (_controleurUniv && rubriquePublication.getSourceRequete().length() > 0) {
                    code = "#AUTO#" + code;
                }
                if (_controleurUniv && res.contains(code)) continue;
                res.add(code);
            }
        }
        return res;
    }

    public int select(String typeFiche, String codeFiche, String langueFiche) throws Exception {
        ClauseWhere whereTypeCodeLangue = new ClauseWhere(ConditionHelper.egalVarchar("TYPE_FICHE_ORIG", typeFiche));
        whereTypeCodeLangue.and(ConditionHelper.egalVarchar("CODE_FICHE_ORIG", codeFiche));
        whereTypeCodeLangue.and(ConditionHelper.egalVarchar("LANGUE_FICHE_ORIG", langueFiche));
        return this.select(whereTypeCodeLangue.formaterSQL());
    }

    public static void supprimerRubriquePublication(OMContext _ctx, String codeRubriquePublication) throws Exception {
        if (codeRubriquePublication != null) {
            Rubriquepublication rubP = new Rubriquepublication();
            rubP.setCtx(_ctx);
            rubP.init();
            ClauseWhere whereRubDestSource = new ClauseWhere(ConditionHelper.egalVarchar("RUBRIQUE_DEST", codeRubriquePublication));
            whereRubDestSource.and(ConditionHelper.egalVarchar("SOURCE_REQUETE", ""));
            if (rubP.select(whereRubDestSource.formaterSQL()) > 0) {
                while (rubP.nextItem()) {
                    rubP.delete();
                }
            }
        }
    }

    public static void supprimerRubriquePublicationFiche(OMContext _ctx, InfosFicheReferencee fiche, boolean _ajouterCritereRequete) throws Exception {
        if (fiche != null && fiche.getCode() != null) {
            Rubriquepublication rubP = new Rubriquepublication();
            rubP.setCtx(_ctx);
            rubP.init();
            String sourceRequete = "";
            if (_ajouterCritereRequete) {
                sourceRequete = fiche.getRequete();
            }
            ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("TYPE_FICHE_ORIG", fiche.getType()));
            where.and(ConditionHelper.egalVarchar("CODE_FICHE_ORIG", fiche.getCode()));
            where.and(ConditionHelper.egalVarchar("LANGUE_FICHE_ORIG", fiche.getLangue()));
            where.and(ConditionHelper.egalVarchar("SOURCE_REQUETE", sourceRequete));
            if (rubP.select(where.formaterSQL()) > 0) {
                while (rubP.nextItem()) {
                    rubP.delete();
                }
            }
        }
    }

    @Deprecated
    public static void deleteGlobal(OMContext _ctx, FicheUniv _ficheUniv) throws Exception {
        PreparedStatement _stmt = null;
        try {
            String query = "DELETE FROM RUBRIQUEPUBLICATION WHERE TYPE_FICHE_ORIG='" + ReferentielObjets.getCodeObjet(_ficheUniv) + "' AND CODE_FICHE_ORIG ='" + _ficheUniv.getCode() + "' AND LANGUE_FICHE_ORIG='" + _ficheUniv.getLangue() + "'";
            _stmt = _ctx.getConnection().prepareStatement(query);
            _stmt.executeUpdate();
            _stmt.close();
        }
        catch (SQLException exc) {
            throw new Exception("ERROR_IN_METHOD Rubriquepublication.deleteGlobal() " + exc);
        }
        finally {
            _stmt = null;
        }
    }

    public static void deleteGlobal(FicheUniv ficheUniv) throws Exception {
        String query = "DELETE FROM RUBRIQUEPUBLICATION WHERE TYPE_FICHE_ORIG='" + ReferentielObjets.getCodeObjet(ficheUniv) + "' AND CODE_FICHE_ORIG ='" + ficheUniv.getCode() + "' AND LANGUE_FICHE_ORIG='" + ficheUniv.getLangue() + "'";
        try (ContexteDao ctx = new ContexteDao();
             PreparedStatement _stmt = ctx.getConnection().prepareStatement(query);){
            _stmt.executeUpdate();
        }
        catch (SQLException exc) {
            throw new Exception("ERROR_IN_METHOD Rubriquepublication.deleteGlobal() " + exc);
        }
    }

    public static void enregistrerRubriquePublication(OMContext _ctx, String codeRubriquePublication, List<InfosFicheReferencee> listeFiches) throws Exception {
        Rubriquepublication rubP = new Rubriquepublication();
        rubP.setCtx(_ctx);
        Rubriquepublication.supprimerRubriquePublication(_ctx, codeRubriquePublication);
        for (InfosFicheReferencee infosFiche : listeFiches) {
            rubP.init();
            rubP.setTypeFicheOrig(infosFiche.getType());
            rubP.setCodeFicheOrig(infosFiche.getCode());
            rubP.setLangueFicheOrig(infosFiche.getLangue());
            rubP.setRubriqueDest(codeRubriquePublication);
            rubP.add();
        }
    }

    public static void enregistrerRubriquePublicationFiche(OMContext _ctx, InfosFicheReferencee infosFiche, Vector<String> listeRubriques) throws Exception {
        Rubriquepublication rubP = new Rubriquepublication();
        rubP.setCtx(_ctx);
        Rubriquepublication.supprimerRubriquePublicationFiche(_ctx, infosFiche, false);
        Enumeration<String> e = listeRubriques.elements();
        while (e.hasMoreElements()) {
            String codeRubriquePublication = e.nextElement();
            rubP.init();
            rubP.setTypeFicheOrig(infosFiche.getType());
            rubP.setCodeFicheOrig(infosFiche.getCode());
            rubP.setLangueFicheOrig(infosFiche.getLangue());
            rubP.setRubriqueDest(codeRubriquePublication);
            rubP.add();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<InfosFicheReferencee> getListeFichesReferences(OMContext _ctx, String _codeRubriquePublication, boolean _avecInfosFiche) throws Exception {
        ArrayList<InfosFicheReferencee> liste = new ArrayList<InfosFicheReferencee>();
        if (_codeRubriquePublication == null) return liste;
        Rubriquepublication rubP = new Rubriquepublication();
        rubP.setCtx(_ctx);
        rubP.init();
        ClauseWhere whereRubDestEtSource = new ClauseWhere(ConditionHelper.egalVarchar("RUBRIQUE_DEST", _codeRubriquePublication));
        whereRubDestEtSource.and(ConditionHelper.egalVarchar("SOURCE_REQUETE", ""));
        if (rubP.select(whereRubDestEtSource.formaterSQL()) <= 0) return liste;
        while (rubP.nextItem()) {
            InfosFicheReferencee infosFiche = new InfosFicheReferencee();
            infosFiche.setCode(rubP.getCodeFicheOrig());
            infosFiche.setLangue(rubP.getLangueFicheOrig());
            infosFiche.setType(rubP.getTypeFicheOrig());
            infosFiche.setRequete(rubP.getSourceRequete());
            if (_avecInfosFiche) {
                FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(rubP.getTypeFicheOrig()));
                if (fiche != null) {
                    fiche.setCtx(_ctx);
                    if (fiche.selectCodeLangueEtat(rubP.getCodeFicheOrig(), rubP.getLangueFicheOrig(), "0003") <= 0) continue;
                    while (fiche.nextItem()) {
                        infosFiche.setIntitule(fiche.getLibelleAffichable());
                        infosFiche.setEtat(fiche.getEtatObjet());
                        infosFiche.setId(fiche.getIdFiche().toString());
                        liste.add(infosFiche);
                    }
                    continue;
                }
                LOG.warn(String.format("Object with code %s couldn't be instanciated.", rubP.getTypeFicheOrig()));
                continue;
            }
            liste.add(infosFiche);
        }
        return liste;
    }

    public static String getRubriqueDansSiteCourant(ContexteUniv _ctx, FicheUniv _fiche) throws Exception {
        String codeRubriqueTemp = null;
        String codeRubrique = null;
        String codeRubriquePrincipale = null;
        InfosRubriques infosRubCourante = Rubrique.renvoyerItemRubrique(_ctx.getCodeRubriqueHistorique());
        boolean rubriquePrincipaleAutorisee = false;
        boolean rubriquePublicationAutorisee = false;
        boolean possedeRubrique = false;
        codeRubriquePrincipale = _fiche.getCodeRubrique();
        if (codeRubriquePrincipale.length() > 0) {
            possedeRubrique = true;
            InfosRubriques rubriquePrincipale = Rubrique.renvoyerItemRubrique(codeRubriquePrincipale);
            if (Rubrique.controlerRestrictionRubrique(_ctx, rubriquePrincipale.getCode())) {
                if (_ctx.getInfosSite().isRubriqueVisibleInSite(rubriquePrincipale)) {
                    codeRubriqueTemp = rubriquePrincipale.getCode();
                }
                rubriquePrincipaleAutorisee = true;
            }
        }
        codeRubriquePrincipale = null;
        if (codeRubriqueTemp != null) {
            codeRubriquePrincipale = codeRubriqueTemp;
            if (infosRubCourante.getCode().equals(codeRubriqueTemp) || infosRubCourante.getListeSousRubriquesTousNiveaux().contains(Rubrique.renvoyerItemRubrique(codeRubriqueTemp))) {
                codeRubrique = codeRubriqueTemp;
            }
        }
        if (codeRubrique == null) {
            String codeRubriqueSite = _ctx.getInfosSite().getCodeRubrique();
            Vector<String> listeRubriquesPublication = Rubriquepublication.getListeRubriquesPublication(_ctx, _fiche, codeRubriqueSite);
            Iterator<String> itListeRubrique = listeRubriquesPublication.iterator();
            InfosRubriques rubriquePub = null;
            while (itListeRubrique.hasNext()) {
                possedeRubrique = true;
                rubriquePub = Rubrique.renvoyerItemRubrique(itListeRubrique.next());
                if (!Rubrique.controlerRestrictionRubrique(_ctx, rubriquePub.getCode())) continue;
                rubriquePublicationAutorisee = true;
                if (!_ctx.getInfosSite().isRubriqueVisibleInSite(rubriquePub)) continue;
                codeRubriqueTemp = rubriquePub.getCode();
                if (!infosRubCourante.getCode().equals(codeRubriqueTemp) && !infosRubCourante.getListeSousRubriquesTousNiveaux().contains(rubriquePub)) continue;
                codeRubrique = codeRubriqueTemp;
                break;
            }
        }
        if (codeRubrique == null) {
            codeRubrique = codeRubriquePrincipale != null ? codeRubriquePrincipale : codeRubriqueTemp;
        }
        if (possedeRubrique && !rubriquePrincipaleAutorisee && !rubriquePublicationAutorisee) {
            _ctx.setCodeRubriquePageCourante("ZYZYZYZYZYZYZYZYZYZYZY");
        }
        return codeRubrique;
    }

    public static InfosSite getSiteAffichage(ContexteUniv _ctx, FicheUniv _fiche) throws Exception {
        Vector<String> listeRubriquesPublications;
        InfosSite infosSite;
        String rubriquePrincipale = "";
        if (_fiche != null) {
            rubriquePrincipale = _fiche.getCodeRubrique();
        }
        if ((infosSite = Site.determinerSiteRubrique(rubriquePrincipale)) == null && (listeRubriquesPublications = Rubriquepublication.getListeRubriquesPublication(_ctx, _fiche)).size() > 0) {
            Iterator<String> it = listeRubriquesPublications.iterator();
            while (it.hasNext() && infosSite == null) {
                infosSite = Site.determinerSiteRubrique(it.next());
            }
        }
        return infosSite;
    }

    public static TreeSet<InfosFicheReferencee> supprimerRubriquePublicationAutomatique(OMContext ctx, String codeRubrique, String requete, boolean suppressionEffective) throws Exception {
        TreeSet<InfosFicheReferencee> listeReferencement = new TreeSet<InfosFicheReferencee>(new InfosFicheComparator());
        if (codeRubrique != null && requete != null) {
            Rubriquepublication rubP = new Rubriquepublication();
            rubP.setCtx(ctx);
            rubP.init();
            String requeteOldFormat = "";
            String[] item = requete.split("/", -2);
            if (item.length > 4 && item[3].length() == 0) {
                requeteOldFormat = item[0] + "/" + item[1] + "/" + item[2] + "/" + item[4];
            }
            ClauseWhere whereRupPub = new ClauseWhere(ConditionHelper.egalVarchar("RUBRIQUE_DEST", codeRubrique));
            ConditionList condSourceRequete = new ConditionList(ConditionHelper.egalVarchar("SOURCE_REQUETE", requete));
            if (StringUtils.isNotEmpty((CharSequence)requeteOldFormat)) {
                condSourceRequete.or(ConditionHelper.egalVarchar("SOURCE_REQUETE", requeteOldFormat));
            }
            whereRupPub.and(condSourceRequete);
            String requeteFormatee = whereRupPub.formaterSQL();
            if (rubP.select(requeteFormatee) > 0) {
                while (rubP.nextItem()) {
                    InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                    infosFiche.setCode(rubP.getCodeFicheOrig());
                    infosFiche.setLangue(rubP.getLangueFicheOrig());
                    infosFiche.setType(rubP.getTypeFicheOrig());
                    infosFiche.setRequete(rubP.getSourceRequete());
                    listeReferencement.add(infosFiche);
                }
            }
            if (suppressionEffective && listeReferencement.size() > 0) {
                PreparedStatement _stmt = null;
                try {
                    String query = "DELETE FROM RUBRIQUEPUBLICATION " + requeteFormatee;
                    _stmt = ctx.getConnection().prepareStatement(query);
                    _stmt.executeUpdate();
                    _stmt.close();
                }
                catch (SQLException exc) {
                    throw new ErreurApplicative(String.format(MessageHelper.getCoreMessage(ctx.getLocale(), "RUBRIQUE_PUBLICATION.ERREUR.SUPPRESSION_FICHE_IMPOSSIBLE"), requeteFormatee));
                }
                finally {
                    _stmt = null;
                }
            }
        }
        return listeReferencement;
    }
}

