/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.textsearch.util.IndexationHelper;
import com.univ.objetspartages.sgbd.SiteDB;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Site
extends SiteDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(Site.class);
    private String etatIndexation;

    public String getEtatIndexation() {
        return this.etatIndexation;
    }

    public void setEtatIndexation(String etatIndexation) {
        this.etatIndexation = etatIndexation;
    }

    public static List<Site> getListeSites(OMContext ctx) throws Exception {
        Site site = new Site();
        site.setCtx(ctx);
        int count = site.select(" order by CODE");
        ArrayList<Site> listeSites = new ArrayList<Site>(count);
        while (site.nextItem()) {
            listeSites.add((Site)site.clone());
        }
        return listeSites;
    }

    public void init() {
        this.setIdSite(new Long(System.currentTimeMillis()));
        this.setCode(String.valueOf(System.currentTimeMillis()));
        this.setLibelle("");
        this.setUrl("");
        this.setLangue("0");
        this.setRegExpAccepte("");
        this.setRegExpRefuse("");
        this.setNiveauProfondeur(new Integer(-1));
    }

    public Object clone() {
        Site siteDest = new Site();
        siteDest.init();
        siteDest.setCode(this.getCode());
        siteDest.setIdSite(new Long(this.getIdSite()));
        siteDest.setLangue(this.getLangue());
        siteDest.setLibelle(this.getLibelle());
        siteDest.setRegExpAccepte(this.getRegExpAccepte());
        siteDest.setRegExpRefuse(this.getRegExpRefuse());
        siteDest.setNiveauProfondeur(new Integer(this.getNiveauProfondeur()));
        siteDest.setUrl(this.getUrl());
        return siteDest;
    }

    @Deprecated
    public Site recopie(Site siteSrc) {
        return (Site)siteSrc.clone();
    }

    public File getRepertoireIndexation() {
        File repertoireIndexation = null;
        try {
            String indexDir = IndexationHelper.getWorkDirectory() + File.separator + this.getLangue() + File.separator + this.getCode();
            repertoireIndexation = new File(indexDir);
            if (!repertoireIndexation.exists()) {
                repertoireIndexation.mkdir();
            }
        }
        catch (Exception e) {
            LOGGER.error("erreur lors de la cr\u00e9ation du dossier", (Throwable)e);
        }
        return repertoireIndexation;
    }
}

