/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.univ.utils.Chaine;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SousParagrapheBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SousParagrapheBean.class);
    private String contenu = "";
    private String titre = "";
    private String couleur = "";
    public static final int STYLE_TITRE_INVISIBLE = 0;
    public static final int STYLE_TITRE_NORMAL = 1;
    public static final int STYLE_TITRE_MINI = 2;
    public static final int STYLE_TITRE_MAXI = 3;
    public static final int STYLE1 = 1;
    public static final int STYLE2 = 2;
    public static final int STYLE3 = 3;
    private int style = 0;
    private static final long timeout = 10000L;

    private static String extraireSousParagraphe(String texte, int _indexDebutParagraphe, int _indexFinParagraphe) {
        int indiceCR;
        String contenu = texte.substring(_indexDebutParagraphe, _indexFinParagraphe);
        if (_indexDebutParagraphe > 0 && ((indiceCR = contenu.indexOf("<br />")) == 0 || indiceCR == 1)) {
            contenu = contenu.substring(indiceCR + 6, contenu.length());
        }
        if (contenu.length() > 0 && contenu.endsWith("<br />")) {
            contenu = contenu.substring(0, contenu.length() - 6);
        }
        return contenu;
    }

    public String getContenu() {
        return this.contenu;
    }

    public String getCouleur() {
        return this.couleur;
    }

    public static boolean timeout(long start, String texte) {
        if (System.currentTimeMillis() - start > 10000L) {
            LOGGER.warn("Timeout sur l'\u00e9xecution de la m\u00e9thode getSousParagraphes avec le contenu suivant : " + texte);
            return true;
        }
        return false;
    }

    public static Vector<SousParagrapheBean> getSousParagraphes(String texte) {
        long start = System.currentTimeMillis();
        Vector<SousParagrapheBean> listeSousParagraphes = new Vector<SousParagrapheBean>();
        if (StringUtils.isNotBlank((CharSequence)texte)) {
            SousParagrapheBean sousParagraphe = new SousParagrapheBean();
            int indexTexte = 0;
            int indexDebutMotCle = -1;
            int indexDebutParagraphe = 0;
            int indexDebutStyle = -1;
            int indexFinStyle = -1;
            String titre = "";
            StringBuilder strbTexte = new StringBuilder();
            String strTexteRestant = texte;
            while (SousParagrapheBean.contientTagStyleValide(strTexteRestant)) {
                if (SousParagrapheBean.timeout(start, texte)) {
                    return listeSousParagraphes;
                }
                indexDebutStyle = StringUtils.indexOfIgnoreCase((CharSequence)strTexteRestant, (CharSequence)"[style");
                String style = strTexteRestant.substring(indexDebutStyle, indexFinStyle = strTexteRestant.indexOf(";", indexDebutStyle));
                titre = style.equalsIgnoreCase("[style1") ? "[titre" : (style.equalsIgnoreCase("[style2") ? "[titrecourt" : (style.equalsIgnoreCase("[style3") ? "[titrelong" : style));
                strbTexte.append(strTexteRestant.substring(indexTexte, indexDebutStyle));
                strbTexte.append(titre);
                strTexteRestant = strTexteRestant.substring(indexFinStyle);
            }
            strbTexte.append(strTexteRestant);
            strTexteRestant = texte = strbTexte.toString();
            while (SousParagrapheBean.contientTagTitreValide(StringUtils.substring((String)texte, (int)indexTexte)) || SousParagrapheBean.contientTagStyleValide(StringUtils.substring((String)texte, (int)indexTexte))) {
                String contenuLigne;
                int indexFinMotCle;
                if (SousParagrapheBean.timeout(start, texte)) {
                    return listeSousParagraphes;
                }
                int intIndexTitre = texte.indexOf("[titre", indexTexte);
                int intIndexStyle = texte.indexOf("[style", indexTexte);
                if (intIndexTitre != -1 && intIndexStyle != -1) {
                    indexDebutMotCle = intIndexTitre < intIndexStyle ? intIndexTitre : intIndexStyle;
                } else if (intIndexTitre != -1) {
                    indexDebutMotCle = intIndexTitre;
                } else if (intIndexStyle != -1) {
                    indexDebutMotCle = intIndexStyle;
                }
                if (indexDebutMotCle > 0) {
                    sousParagraphe.setContenu(SousParagrapheBean.extraireSousParagraphe(texte, indexDebutParagraphe, indexDebutMotCle));
                    listeSousParagraphes.add(sousParagraphe);
                }
                sousParagraphe = new SousParagrapheBean();
                int indiceFinLigne = texte.indexOf("\n", indexDebutMotCle);
                if (indiceFinLigne == -1) {
                    indiceFinLigne = texte.length();
                }
                if ((indexFinMotCle = (contenuLigne = texte.substring(indexDebutMotCle + 1, indiceFinLigne)).indexOf(93)) != -1) {
                    String contenuTag = Chaine.remplacerPointsVirgules(contenuLigne.substring(0, indexFinMotCle), true);
                    StringTokenizer st = new StringTokenizer(contenuTag, "*");
                    int indiceToken = 0;
                    while (st.hasMoreTokens()) {
                        if (SousParagrapheBean.timeout(start, texte)) {
                            return listeSousParagraphes;
                        }
                        String itemTag = st.nextToken();
                        if (indiceToken == 0) {
                            if (itemTag.equalsIgnoreCase("titre")) {
                                sousParagraphe.setStyle(1);
                            } else if (itemTag.equalsIgnoreCase("titrelong")) {
                                sousParagraphe.setStyle(3);
                            } else if (itemTag.equalsIgnoreCase("titrecourt")) {
                                sousParagraphe.setStyle(2);
                            } else {
                                String numStyle = itemTag.substring(5);
                                try {
                                    sousParagraphe.setStyle(Integer.parseInt(numStyle));
                                }
                                catch (Exception e) {
                                    LOGGER.debug("le style insere n'est pas un entier :" + itemTag);
                                }
                            }
                        }
                        if (indiceToken == 1) {
                            sousParagraphe.setTitre(itemTag);
                        }
                        if (indiceToken == 2) {
                            sousParagraphe.setCouleur(itemTag);
                        }
                        ++indiceToken;
                    }
                    indexTexte = indexDebutMotCle + indexFinMotCle + 2;
                    indexDebutParagraphe = indexDebutMotCle + indexFinMotCle + 2;
                    continue;
                }
                indexDebutParagraphe = indiceFinLigne + 1;
                indexTexte = indiceFinLigne + 1;
            }
            sousParagraphe.setContenu(SousParagrapheBean.extraireSousParagraphe(texte, indexDebutParagraphe, texte.length()));
            listeSousParagraphes.add(sousParagraphe);
        }
        return listeSousParagraphes;
    }

    private static boolean contientTagStyleValide(String texte) {
        return SousParagrapheBean.contientTagValide(texte, TagType.style);
    }

    private static boolean contientTagTitreValide(String texte) {
        return SousParagrapheBean.contientTagValide(texte, TagType.titre);
    }

    private static boolean contientTagValide(String texte, TagType tagType) {
        Pattern pattern = Pattern.compile("^.*\\[" + (Object)((Object)tagType) + ".*;.*\\].*$", 34);
        Matcher m = pattern.matcher(texte);
        return m.matches();
    }

    public int getStyle() {
        return this.style;
    }

    public String getTitre() {
        return this.titre;
    }

    public String getTitreUppercase() {
        String up = this.titre;
        up = SousParagrapheBean.remplacerChaine1parChaine2(up, "&#224;", "a");
        up = SousParagrapheBean.remplacerChaine1parChaine2(up, "&#232;", "e");
        up = SousParagrapheBean.remplacerChaine1parChaine2(up, "&#233;", "e");
        return up.toUpperCase();
    }

    public static String remplacerChaine1parChaine2(String _tag, String _chaine1, String _chaine2) {
        String tmp = "";
        int indexDebutTag = -1;
        int indexFinTag = 0;
        while ((indexDebutTag = _tag.indexOf(_chaine1, indexFinTag)) != -1) {
            tmp = tmp + _tag.substring(indexFinTag, indexDebutTag) + _chaine2;
            indexFinTag = indexDebutTag + _chaine1.length();
        }
        tmp = tmp + _tag.substring(indexFinTag);
        return tmp;
    }

    public void setContenu(String newContenu) {
        this.contenu = newContenu;
    }

    public void setCouleur(String newCouleur) {
        this.couleur = newCouleur;
    }

    public void setStyle(int newStyle) {
        this.style = newStyle;
    }

    public void setTitre(String newTitre) {
        this.titre = newTitre;
    }

    private static enum TagType {
        style,
        titre;

    }
}

