/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.univ.objetspartages.cache.CacheStructureManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.ElementArboStructure;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUtil;
import com.univ.xhtml.JavascriptTreeStructure;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Structure {
    public static final String CODE_STRUCTURE_ROOT = "00";
    public static final String NOM_OBJET_STRUCURE = "structure";
    private static final Logger LOG = LoggerFactory.getLogger(Structure.class);

    public static String checkCode(String _code, String _langue, OMContext _ctx) throws Exception {
        Chaine.controlerCodeMetier(_code);
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
            if (ficheUniv == null || !(ficheUniv instanceof StructureModele)) continue;
            StructureModele structure = (StructureModele)ficheUniv;
            structure.init();
            structure.setCtx(_ctx);
            int count = ficheUniv.selectCodeLangueEtat(_code, _langue, "");
            if (count <= 0) continue;
            ficheUniv.nextItem();
            throw new ErreurApplicative("Ce code est d\u00e9j\u00e0 utilis\u00e9 pour la fiche " + ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv)) + " : " + ficheUniv.getLibelleAffichable());
        }
        return _code;
    }

    public static void checkCycle(String _code, String _langue, String _codeRattachement) throws ErreurApplicative {
        InfosStructure infosStructureMere;
        InfosStructure infosStructure = Structure.renvoyerItemStructure(_code, _langue);
        if (infosStructure.contains(infosStructureMere = Structure.renvoyerItemStructure(_codeRattachement, _langue))) {
            throw new ErreurApplicative("La structure parente ne peut pas \u00eatre fille de la structure courante.");
        }
    }

    public static boolean controlerPermission(AutorisationBean autorisations, String sPermission, String codeStructure) {
        PermissionBean permissionCourante = new PermissionBean(sPermission);
        Perimetre perimetre = new Perimetre(codeStructure, "", "", "", "");
        boolean res = autorisations.possedePermissionPartielleSurPerimetre(permissionCourante, perimetre);
        if (!res && permissionCourante.getType().equals("FICHE") && permissionCourante.getAction().equals("M") && autorisations.possedePermissionPartielleSurPerimetre(permissionCourante = new PermissionBean(permissionCourante.getType(), permissionCourante.getObjet(), "C"), perimetre)) {
            res = true;
        }
        return res;
    }

    public static String getArbreJavaScript(String _code, String _langue, AutorisationBean autorisations, String _sPermission, String _sFiltre, boolean front, String _codeRoot) {
        if (_code == null || _code.length() == 0) {
            _code = CODE_STRUCTURE_ROOT;
        }
        if (_codeRoot == null || _codeRoot.length() == 0) {
            _codeRoot = CODE_STRUCTURE_ROOT;
        }
        JavascriptTreeStructure tree = new JavascriptTreeStructure(autorisations, _sPermission, _sFiltre, front);
        tree.load(Structure.getTopLevelStructure(_codeRoot, _langue), Structure.renvoyerItemStructure(_code, _langue));
        return tree.print();
    }

    public static InfosStructure getStructurePremierNiveau(String _code, String _langue) {
        if (_code == null || _code.length() == 0) {
            return new InfosStructure();
        }
        InfosStructure structure = Structure.renvoyerItemStructure(_code, _langue);
        while (structure.getNiveau() > 1) {
            structure = structure.getStructureRattachement();
        }
        return structure;
    }

    @Deprecated
    public static StructureModele getFicheStructure(OMContext _ctx, String _code, String _langue) throws Exception {
        return Structure.getFicheStructure(_code, _langue);
    }

    public static StructureModele getFicheStructure(String _code, String _langue) throws Exception {
        boolean etatEnLigne = false;
        if (ContexteUtil.getContexteUniv() != null) {
            etatEnLigne = true;
        }
        return Structure.getFicheStructure(_code, _langue, etatEnLigne);
    }

    @Deprecated
    public static StructureModele getFicheStructure(OMContext _ctx, String _code, String _langue, boolean _etatEnLigne) throws Exception {
        return Structure.getFicheStructure(_code, _langue, _etatEnLigne);
    }

    public static StructureModele getFicheStructure(String _code, String _langue, boolean _etatEnLigne) throws Exception {
        StructureModele res = null;
        StructureModele structure = null;
        if (StringUtils.isEmpty((CharSequence)_code)) {
            return structure;
        }
        String langue = (String)StringUtils.defaultIfEmpty((CharSequence)_langue, (CharSequence)"0");
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv;
            if (res != null || (ficheUniv = ReferentielObjets.instancierFiche(codeObjet)) == null || !(ficheUniv instanceof StructureModele)) continue;
            structure = (StructureModele)ficheUniv;
            structure.init();
            ContexteDao ctx = new ContexteDao();
            Throwable throwable = null;
            try {
                structure.setCtx(ctx);
                int count = ficheUniv.selectCodeLangueEtat(_code, langue, "0003");
                if (count == 0 && !_etatEnLigne) {
                    count = ficheUniv.selectCodeLangueEtat(_code, langue, "");
                }
                if (count <= 0) continue;
                while (structure.nextItem()) {
                    res = structure;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
        return res;
    }

    @Deprecated
    public static String getLibelleAffichable(OMContext _ctx, String _codes, String _langue) throws Exception {
        return Structure.getLibelleAffichable(_codes, _langue);
    }

    public static String getLibelleAffichable(String _codes, String _langue) throws Exception {
        String res = "";
        if (_codes == null || _codes.length() == 0) {
            return res;
        }
        StringTokenizer st = new StringTokenizer(_codes, ";");
        String code = "";
        while (st.hasMoreTokens()) {
            StructureModele structure;
            code = st.nextToken();
            InfosStructure info = Structure.renvoyerItemStructure(code, _langue);
            String libelleAffichable = info.getLibelleLong();
            if (libelleAffichable.length() == 0 && (structure = Structure.getFicheStructure(code, _langue)) != null) {
                libelleAffichable = structure.getLibelleAffichable();
            }
            if (res.length() > 0) {
                res = res + ";";
            }
            if (libelleAffichable != null && libelleAffichable.length() > 0) {
                res = res + libelleAffichable;
                continue;
            }
            res = res + '-';
        }
        if (res.length() == 0) {
            res = "-";
        }
        return res;
    }

    public static String getLibelleStructurePremierNiveau(OMContext _ctx, String _code, String _langue) throws Exception {
        String res = "-";
        if (_code == null || _code.length() == 0) {
            return res;
        }
        InfosStructure structure = Structure.getStructurePremierNiveau(_code, _langue);
        res = Structure.getLibelleAffichable(structure.getCode(), _langue);
        return res;
    }

    public static String getLibelleRattachement(OMContext _ctx, String _code, String _langue, boolean inclureStructureDepart) throws Exception {
        String res = "";
        if (_code == null || _code.length() == 0) {
            return res;
        }
        InfosStructure structure = Structure.renvoyerItemStructure(_code);
        if (inclureStructureDepart) {
            res = Structure.getLibelleAffichable(structure.getCode(), _langue);
        }
        while (structure.getNiveau() > 1) {
            structure = structure.getStructureRattachement();
            if (res.length() > 0) {
                res = "<br />" + res;
            }
            res = Structure.getLibelleAffichable(structure.getCode(), _langue) + res;
        }
        return res;
    }

    public static HashMap<String, ElementArboStructure> getListeStructures() {
        CacheStructureManager cacheStructureManager = (CacheStructureManager)ApplicationContextManager.getCoreContextBean("cacheStructureManager");
        return cacheStructureManager.getListeStructures();
    }

    public static InfosStructure getTopLevelStructure(String codeRoot, String _langue) {
        return Structure.getListeStructures().get(codeRoot).getInfosStructure(_langue);
    }

    public static InfosStructure getTopLevelStructure(String _langue) {
        return Structure.getTopLevelStructure(CODE_STRUCTURE_ROOT, _langue);
    }

    public static Hashtable<String, String> getListeStructuresPremierNiveau(String _langue, boolean front) {
        Hashtable<String, String> res = new Hashtable<String, String>();
        InfosStructure topLevelStructure = Structure.getTopLevelStructure(_langue);
        Iterator<InfosStructure> it = topLevelStructure.getListeSousStructures().iterator();
        InfosStructure structure = null;
        while (it.hasNext()) {
            structure = it.next();
            if (!structure.isVisibleInFront() && front) continue;
            res.put(structure.getCode(), structure.getLibelleCourt().toLowerCase());
        }
        return res;
    }

    public static InfosStructure renvoyerItemStructure(String code) {
        return Structure.renvoyerItemStructure(code, "0");
    }

    public static Hashtable<String, String> getListeStructureParIntituleComplet(OMContext _ctx) throws Exception {
        Iterator<ElementArboStructure> it = Structure.getListeStructures().values().iterator();
        Hashtable<String, String> res = new Hashtable<String, String>();
        while (it.hasNext()) {
            ElementArboStructure eltArbo = it.next();
            InfosStructure info = Structure.renvoyerItemStructure(eltArbo.getCode());
            String libelle = Structure.getLibelleRattachement(_ctx, info.getCode(), info.getLangue(), true);
            libelle = StringUtils.replace((String)libelle, (String)"<br />", (String)" > ");
            res.put(info.getCode(), libelle);
        }
        return res;
    }

    @Deprecated
    public static String getLibelleAffichableLong(OMContext _ctx, String _codes, String _langue) throws Exception {
        String res = "";
        if (_codes == null || _codes.length() == 0) {
            return res;
        }
        StringTokenizer st = new StringTokenizer(_codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            StructureModele structure = Structure.getFicheStructure(code, _langue);
            if (res.length() > 0) {
                res = res + ";";
            }
            if (structure != null) {
                res = res + structure.getLibelleLong();
                continue;
            }
            res = res + '-';
        }
        if (res.length() == 0) {
            res = "-";
        }
        return res;
    }

    public static InfosStructure renvoyerItemStructure(String code, String langue) {
        ElementArboStructure elementArbo = Structure.getListeStructures().get(code);
        InfosStructure structure = null;
        if (elementArbo != null && (structure = elementArbo.getInfosStructure(langue)) == null && !elementArbo.getListeInfosStructure().isEmpty()) {
            structure = elementArbo.getListeInfosStructure().values().iterator().next();
        }
        if (structure == null) {
            structure = new InfosStructure();
        }
        return structure;
    }

    public static String getFilAriane(String codeStructure, String langue) {
        String filAriane = "";
        try {
            String separateur = "&gt;";
            InfosStructure structure = Structure.renvoyerItemStructure(codeStructure, langue);
            String libelleStructure = "";
            while (structure.getNiveau() > 0) {
                if (filAriane.length() > 0) {
                    filAriane = " &gt; " + filAriane;
                }
                if ("".equals(libelleStructure = structure.getLibelleCourt())) {
                    libelleStructure = structure.getLibelleLong();
                }
                filAriane = libelleStructure + filAriane;
                structure = structure.getStructureRattachement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filAriane;
    }

    public static void forcerRechargement() {
        CacheStructureManager cacheStructureManager = (CacheStructureManager)ApplicationContextManager.getCoreContextBean("cacheStructureManager");
        cacheStructureManager.flush();
    }

    public static String getNomObjetStructureParCodeLangue(String codeObjet, String langue) {
        StructureModele structure = null;
        try {
            structure = Structure.getFicheStructure(codeObjet, langue);
        }
        catch (Exception e) {
            LOG.error("Erreur lors de la r\u00e9cup\u00e9ration de la structure", (Throwable)e);
        }
        if (structure != null) {
            return ReferentielObjets.getNomObjet(structure);
        }
        return "";
    }
}

