/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.SynchroniseurUtilisateur;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.security.MySQLHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.sgbd.UtilisateurDB;
import com.univ.utils.ContexteDao;
import com.univ.utils.RequeteGroupeUtil;
import com.univ.utils.sql.ConstanteSQL;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ClauseJoinHelper;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilisateur
extends UtilisateurDB {
    private static final Logger LOG = LoggerFactory.getLogger(Utilisateur.class);
    private Vector<String> vecteurGroupesDsiTmp;
    private static final String SOURCE_AUTHENTIFICATION = PropertyHelper.getCoreProperty("authentification.source");
    public static final String UTILISATEUR_ANONYME = "ANONYME";
    private static final String SOURCE_AUTHENTIFICATION_CLEARTRUST = "ctrust";
    private static final String SOURCE_AUTHENTIFICATION_CAS = "cas";
    private static final String SOURCE_AUTHENTIFICATION_LDAP = "ldap";

    @Override
    public void add() throws Exception {
        super.add();
        SynchroniseurUtilisateur.getInstance().synchroUtilisateur(0, this, this.ctx);
    }

    @Override
    public void delete() throws Exception {
        super.delete();
        SynchroniseurUtilisateur.getInstance().synchroUtilisateur(2, this, this.ctx);
    }

    @Override
    public void update() throws Exception {
        super.update();
        SynchroniseurUtilisateur.getInstance().synchroUtilisateur(1, this, this.ctx);
    }

    public void init() {
        this.setIdUtilisateur(0L);
        this.setCode("");
        this.setMotDePasse("");
        this.setDateNaissance(new Date(0L));
        this.setCivilite("");
        this.setNom("");
        this.setPrenom("");
        this.setCodeRattachement("");
        this.setGroupes("");
        this.setAdresseMail("");
        this.setExtensionModification("");
        this.setRestrictionValidation("");
        this.setCentresInteret("");
        this.setProfilDsi("");
        this.setGroupesDsiImport("");
        this.setCodeLdap("");
        this.setRoles("");
        this.setVecteurGroupesDsiTmp(new Vector<String>());
        this.setProfilDefaut("");
        this.setSourceImport("");
        this.setDateDerniereSession(new Date(0L));
        this.setFormatEnvoi("");
        this.setModeSaisieExpert("1");
        this.setTsCacheGroupes(0L);
    }

    @Deprecated
    public static String getAdresseMail(OMContext ctx, String codeUtilisateur) throws Exception {
        return Utilisateur.getAdresseMail(codeUtilisateur);
    }

    public static String getAdresseMail(String codeUtilisateur) throws Exception {
        return Utilisateur.getAdresseMail(codeUtilisateur, null);
    }

    @Deprecated
    public static String getAdresseMail(OMContext ctx, String codeUtilisateur, Metatag meta) throws Exception {
        String mail = "";
        if (StringUtils.isNotEmpty((CharSequence)codeUtilisateur) && !UTILISATEUR_ANONYME.equals(codeUtilisateur)) {
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.setCtx(ctx);
            utilisateur.init();
            ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", codeUtilisateur));
            int count = utilisateur.select(whereCode.formaterSQL());
            if (count == 1) {
                while (utilisateur.nextItem()) {
                    mail = utilisateur.getAdresseMail();
                }
            }
        } else if (meta != null) {
            mail = meta.getMetaMailAnonyme();
        }
        return mail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAdresseMail(String codeUtilisateur, Metatag meta) throws Exception {
        String mail = "";
        if (StringUtils.isNotEmpty((CharSequence)codeUtilisateur) && !UTILISATEUR_ANONYME.equals(codeUtilisateur)) {
            Utilisateur utilisateur = new Utilisateur();
            try (ContexteDao ctx = new ContexteDao();){
                utilisateur.setCtx(ctx);
                utilisateur.init();
                ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", codeUtilisateur));
                int count = utilisateur.select(whereCode.formaterSQL());
                if (count != 1) return mail;
                while (utilisateur.nextItem()) {
                    mail = utilisateur.getAdresseMail();
                }
                return mail;
            }
        }
        if (meta == null) return mail;
        return meta.getMetaMailAnonyme();
    }

    public String getLibelle() {
        return this.getNom() + " " + this.getPrenom();
    }

    @Deprecated
    public static String getLibelle(OMContext ctx, String code) throws Exception {
        return Utilisateur.getLibelle(code);
    }

    public static String getLibelle(String codes) throws Exception {
        String res = "";
        if (codes == null || codes.length() == 0) {
            return res;
        }
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            if (res.length() > 0) {
                res = res + ";";
            }
            Utilisateur utilisateur = Utilisateur.getUtilisateur(code);
            String intitule = "-";
            if (utilisateur != null) {
                intitule = utilisateur.getLibelle();
            }
            res = res + intitule;
        }
        return res;
    }

    @Deprecated
    public static Utilisateur getUtilisateur(OMContext ctx, String code) throws Exception {
        return Utilisateur.getUtilisateur(code);
    }

    public static Utilisateur getUtilisateur(String code) throws Exception {
        Utilisateur utilisateur = new Utilisateur();
        try (ContexteDao ctx = new ContexteDao();){
            ClauseWhere whereCode;
            utilisateur.setCtx(ctx);
            utilisateur.init();
            if (StringUtils.isNotBlank((CharSequence)code) && utilisateur.select((whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", code))).formaterSQL()) > 0) {
                utilisateur.nextItem();
            }
        }
        return utilisateur;
    }

    @Deprecated
    public static String despecialiseChaine(String chaine) {
        char[] listeCars;
        if (chaine == null) {
            return chaine;
        }
        for (char listeCar : listeCars = new char[]{'\\', '\'', '\"', '#', '(', ')', ';'}) {
            int idxCar = chaine.indexOf(listeCar);
            while (idxCar != -1) {
                chaine = chaine.substring(0, idxCar) + "\\" + listeCar + chaine.substring(idxCar + 1);
                idxCar += 2;
                idxCar = chaine.indexOf(listeCar, idxCar);
            }
        }
        return chaine;
    }

    public static void modifierMailPassword(String code, String mail, String password) throws Exception {
        Utilisateur utilisateur = Utilisateur.getUtilisateur(code);
        if (utilisateur != null) {
            if (StringUtils.isNotEmpty((CharSequence)password)) {
                String message = Utilisateur.verifieMotDePasse(password);
                if (message.length() == 0) {
                    utilisateur.setMotDePasse(MySQLHelper.encodePassword(password));
                } else {
                    throw new ErreurApplicative(message);
                }
            }
            if (mail != null) {
                utilisateur.setAdresseMail(mail);
            }
            try (ContexteDao ctx = new ContexteDao();){
                utilisateur.setCtx(ctx);
                utilisateur.update();
            }
        } else {
            LOG.warn("Probl\u00e8me mise \u00e0 jour base utilisateur");
        }
    }

    public Vector<String> getVecteurCentresInteret() throws Exception {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(StringUtils.defaultString((String)this.getCentresInteret()), ";");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    @Deprecated
    public static Vector<String> renvoyerCodesUtilisateursParEspaceParGroupe(OMContext ctx, String codeEspace) throws Exception {
        return new Vector<String>(Espacecollaboratif.renvoyerCodesUtilisateursParEspaceParGroupe(codeEspace));
    }

    @Deprecated
    public static Vector<String> renvoyerCodesUtilisateursParEspace(OMContext ctx, String codeEspace, boolean tousLesMembres, Vector<String> autresUtilisateurs) throws Exception {
        return new Vector<String>(Espacecollaboratif.renvoyerCodesUtilisateursParEspace(codeEspace));
    }

    private void determinerUsersEtGroupes(String codeGroupe, Set<String> listeUsers, Set<String> listeGroupes) throws Exception {
        InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
        if (infoGroupe.getRequete().length() == 0) {
            listeGroupes.add(codeGroupe);
            Iterator<InfosGroupeDsi> itGroupes = infoGroupe.getListeSousGroupes().iterator();
            InfosGroupeDsi infoSousGroupe = null;
            while (itGroupes.hasNext()) {
                infoSousGroupe = itGroupes.next();
                this.determinerUsersEtGroupes(infoSousGroupe.getCode(), listeUsers, listeGroupes);
            }
        } else {
            HashSet<String> setCodesGroupesCache = new HashSet<String>();
            Collection<String> listeUsersGroupe = RequeteGroupeUtil.getVecteurUtilisateurs(codeGroupe, setCodesGroupesCache);
            if (setCodesGroupesCache.isEmpty()) {
                listeUsers.addAll(listeUsersGroupe);
            } else {
                for (String string : setCodesGroupesCache) {
                    listeGroupes.add(string);
                }
            }
        }
    }

    private String construireRequete(String code, String nom, String prenom, String chaineDiffusion, String profil, String groupe, String structure, String adresseMail, boolean rechercheDansSousGroupes) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.NOM", ClauseOrderBy.SensDeTri.ASC).orderBy("T1.PRENOM", ClauseOrderBy.SensDeTri.ASC);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)nom)) {
            where.and(ConditionHelper.like("NOM", nom, "%", "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)prenom)) {
            where.and(ConditionHelper.like("PRENOM", prenom, "%", "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)adresseMail)) {
            where.and(ConditionHelper.like("ADRESSE_MAIL", adresseMail, "%", "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)chaineDiffusion)) {
            Collection<String> codeDespecialise = Utilisateur.despecialiseChaineDiffusion(chaineDiffusion);
            where.and(this.getCondtionCodeOuCodeGroupe(codeDespecialise));
        }
        if (StringUtils.isNotEmpty((CharSequence)structure)) {
            where.and(ConditionHelper.getConditionStructure("CODE_RATTACHEMENT", structure));
        }
        if (StringUtils.isNotEmpty((CharSequence)profil) && !"0000".equals(profil)) {
            InfosProfilDsi infosProfilDsi = Profildsi.renvoyerItemProfilDsi(profil);
            Vector<String> groupesProfilDsi = infosProfilDsi.getGroupes();
            if (groupesProfilDsi.isEmpty()) {
                where = new ClauseWhere(ConstanteSQL.CONDITION_IMPOSSIBLE);
            } else {
                where.and(this.getCondtionCodeOuCodeGroupe(groupesProfilDsi));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)groupe) && !"0000".equals(groupe)) {
            if (rechercheDansSousGroupes) {
                List<String> codeDesGroupes = Arrays.asList(groupe.split(";"));
                where.and(this.getCondtionCodeOuCodeGroupe(codeDesGroupes));
            } else {
                where.and(ConditionHelper.egalVarchar("T2.CODE_GROUPE", groupe));
            }
        }
        ClauseJoin join = this.traiterJointureGroupeUtilisateur(where);
        requeteSelect.where(where).join(join).orderBy(orderBy);
        return requeteSelect.formaterRequete();
    }

    private Condition getCondtionCodeOuCodeGroupe(Collection<String> codeDesGroupes) throws Exception {
        ConditionList conditioncodeOuCodeGroupe = new ConditionList();
        if (!codeDesGroupes.isEmpty()) {
            TreeSet<String> usersDynamiques = new TreeSet<String>();
            TreeSet<String> groupes = new TreeSet<String>();
            for (String groupeDiffusion : codeDesGroupes) {
                if (!StringUtils.isNotEmpty((CharSequence)groupeDiffusion)) continue;
                this.determinerUsersEtGroupes(groupeDiffusion, usersDynamiques, groupes);
            }
            if (!groupes.isEmpty()) {
                conditioncodeOuCodeGroupe.or(ConditionHelper.in("T2.CODE_GROUPE", groupes));
            }
            if (!usersDynamiques.isEmpty()) {
                conditioncodeOuCodeGroupe.or(ConditionHelper.in("T1.CODE", usersDynamiques));
            }
        }
        if (conditioncodeOuCodeGroupe.isEmpty()) {
            conditioncodeOuCodeGroupe.setPremiereCondtion(ConstanteSQL.CONDITION_IMPOSSIBLE);
        }
        return conditioncodeOuCodeGroupe;
    }

    private ClauseJoin traiterJointureGroupeUtilisateur(ClauseWhere where) {
        ClauseJoin join = new ClauseJoin();
        String requeteFormater = where.formaterSQL();
        if (StringUtils.isNotEmpty((CharSequence)requeteFormater) && requeteFormater.contains("T2.")) {
            join = ClauseJoinHelper.creerJointure(ClauseJoin.TypeJointure.LEFT_JOIN, "GROUPEUTILISATEUR T2", ConditionHelper.critereJointureSimple("T1.CODE", "T2.CODE_UTILISATEUR"));
        }
        return join;
    }

    public boolean appartientAGroupeOuSousGroupes(String codeGroupe, Vector<String> groupesUtilisateurs) {
        boolean res = false;
        InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
        Iterator<String> itGroupesUtilisateurs = groupesUtilisateurs.iterator();
        InfosGroupeDsi groupeUtilisateur = null;
        while (itGroupesUtilisateurs.hasNext() && !res) {
            groupeUtilisateur = Groupedsi.renvoyerItemGroupeDsi(itGroupesUtilisateurs.next());
            res = groupe.contains(groupeUtilisateur);
        }
        return res;
    }

    public void setVecteurCentresInteret(Vector<String> v) {
        this.setCentresInteret(StringUtils.join(v, (String)";"));
    }

    private static Collection<String> despecialiseChaineDiffusion(String chaineDiffusion) {
        ArrayList<String> listeChaineDiffusion = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)chaineDiffusion)) {
            String[] codesChaines;
            for (String codeChaine : codesChaines = chaineDiffusion.split(";")) {
                codeChaine = codeChaine.substring(1, codeChaine.length() - 1);
                int iSlash = codeChaine.indexOf("/");
                String groupe = codeChaine.substring(iSlash + 1);
                listeChaineDiffusion.add(groupe);
            }
        }
        return listeChaineDiffusion;
    }

    @Deprecated
    public static ArrayList<String[]> renvoyerMailsWebmasters(OMContext ctx) throws Exception {
        TreeSet<String> mailsWebmaster = Utilisateur.getListeUtilisateursPossedantPermission(new PermissionBean("TECH", "wmg", ""), new ArrayList<String>(), "", "", "", true);
        ArrayList<String[]> res = new ArrayList<String[]>();
        for (String aMailsWebmaster : mailsWebmaster) {
            res.add(aMailsWebmaster.split(";", -2));
        }
        return res;
    }

    public int select(String code, String nom, String prenom, String chaineDiffusion, String profil, String groupe, String structure, String adresseMail) throws Exception {
        return this.select(this.construireRequete(code, nom, prenom, chaineDiffusion, profil, groupe, structure, adresseMail, true));
    }

    public int selectParCode(String code) throws Exception {
        return this.select(code, "", "", "", "", "", "", "");
    }

    public void selectNoCount(String code, String nom, String prenom, String chaineDiffusion, String profil, String groupe, String structure, String adresseMail, int from, int increment) throws Exception {
        String requete = this.construireRequete(code, nom, prenom, chaineDiffusion, profil, groupe, structure, adresseMail, true);
        if (increment != 0) {
            requete = requete + " LIMIT " + from + "," + increment;
        }
        this.selectNoCount(requete);
    }

    @Deprecated
    public static String verifieMotDePasse(String motdepasse) throws Exception {
        String restriction = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("utilisateur.password.restriction"), (String)"0");
        if (StringUtils.isEmpty((CharSequence)motdepasse) || "0".equals(restriction)) {
            return "";
        }
        int iMax = PropertyHelper.getCorePropertyAsInt("utilisateur.password.longueur.max", -1);
        int iMin = PropertyHelper.getCorePropertyAsInt("utilisateur.password.longueur.min", -1);
        if (iMax != -1 && motdepasse.length() > iMax) {
            return "Votre mot de passe ne doit pas d\u00e9passer " + iMax + " caract\u00e8res.";
        }
        if (iMin != -1 && motdepasse.length() < iMin) {
            return "Votre mot de passe doit contenir au minimum " + iMin + " caract\u00e8res.";
        }
        String alphanum = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("utilisateur.password.alphanum"));
        String accents = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("utilisateur.password.accent"));
        String speciaux = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("utilisateur.password.special"));
        String liste = alphanum.toLowerCase() + alphanum.toUpperCase() + accents.toLowerCase() + accents.toUpperCase() + speciaux;
        boolean ok = true;
        for (int i = 0; i < motdepasse.length(); ++i) {
            if (liste.indexOf(motdepasse.charAt(i)) != -1) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return "Votre mot de passe comporte des caract\u00e8res non autoris\u00e9s";
        }
        return "";
    }

    @Deprecated
    public static TreeSet<String> getListeUtilisateursPossedantPermission(OMContext ctx, PermissionBean permission, List<String> codesStructures, String codeRubrique, String publicsVises, String codeEspaceCollaboratif, boolean renvoyerMails) throws Exception {
        return Utilisateur.getListeUtilisateursPossedantPermission(permission, codesStructures, codeRubrique, publicsVises, codeEspaceCollaboratif, renvoyerMails);
    }

    public static List<Utilisateur> getUtilisateursPossedantPermission(PermissionBean permission) throws Exception {
        ArrayList<Utilisateur> result = new ArrayList<Utilisateur>();
        TreeSet<String> listeRoles = new TreeSet<String>();
        TreeSet<String> listeGroupes = new TreeSet<String>();
        ContexteDao ctx = new ContexteDao();
        Object object = null;
        try {
            Role role = new Role();
            role.init();
            role.setCtx(ctx);
            if (role.select("", "", permission.getChaineSerialisee()) == 0) {
                ArrayList<Utilisateur> arrayList = result;
                return arrayList;
            }
            while (role.nextItem()) {
                listeRoles.add(role.getCode());
                Hashtable<String, Vector<Perimetre>> hGroupes = Groupedsi.renvoyerGroupesEtPerimetres(role.getCode(), Collections.emptyList(), "", "", "");
                for (String codeGroupe : hGroupes.keySet()) {
                    listeGroupes.add(codeGroupe);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        Vector<String> codeUtilisateursGroupe = Groupeutilisateur.getVecteurUtilisateurs(StringUtils.join(listeGroupes, (String)";"));
        for (String string : codeUtilisateursGroupe) {
            Utilisateur utilisateur = Utilisateur.getUtilisateur(string);
            if (utilisateur == null || !StringUtils.isNotBlank((CharSequence)utilisateur.getCode())) continue;
            result.add(utilisateur);
        }
        if (CollectionUtils.isNotEmpty(listeRoles)) {
            ClauseWhere whereRoles = new ClauseWhere();
            for (String codeRole : listeRoles) {
                whereRoles.or(ConditionHelper.like("ROLES", codeRole, "%[", ";%"));
            }
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.init();
            ContexteDao ctx2 = new ContexteDao();
            Object object2 = null;
            try {
                utilisateur.setCtx(ctx2);
                if (utilisateur.select(whereRoles.formaterSQL()) > 0) {
                    while (utilisateur.nextItem()) {
                        result.add((Utilisateur)BeanUtils.cloneBean((Object)utilisateur));
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (ctx2 != null) {
                    if (object2 != null) {
                        try {
                            ctx2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ctx2.close();
                    }
                }
            }
        }
        return result;
    }

    public static TreeSet<String> getListeUtilisateursPossedantPermission(PermissionBean permission, List<String> codesStructures, String codeRubrique, String publicsVises, String codeEspaceCollaboratif, boolean renvoyerMails) throws Exception {
        if (codeEspaceCollaboratif.length() > 0) {
            return Espacecollaboratif.getListeUtilisateursPossedantPermissionPourUnEspace(permission, codeEspaceCollaboratif, renvoyerMails);
        }
        TreeSet<String> res = new TreeSet<String>();
        TreeSet<String> listeRoles = new TreeSet<String>();
        Role role = new Role();
        role.init();
        TreeSet<String> listeGroupes = new TreeSet<String>();
        ContexteDao ctx = new ContexteDao();
        Object object = null;
        try {
            role.setCtx(ctx);
            if (role.select("", "", permission.getChaineSerialisee()) == 0) {
                TreeSet<String> treeSet = res;
                return treeSet;
            }
            while (role.nextItem()) {
                LOG.debug("getListeUtilisateursPossedantPermission role " + role.getCode());
                listeRoles.add(role.getCode());
                Hashtable<String, Vector<Perimetre>> hGroupes = Groupedsi.renvoyerGroupesEtPerimetres(role.getCode(), codesStructures, codeRubrique, publicsVises, codeEspaceCollaboratif);
                Enumeration<String> e = hGroupes.keys();
                while (e.hasMoreElements()) {
                    listeGroupes.add(e.nextElement());
                }
            }
        }
        catch (Throwable hGroupes) {
            object = hGroupes;
            throw hGroupes;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        String codesGroupes = "";
        for (String codeGroupe : listeGroupes) {
            if (codesGroupes.length() > 0) {
                codesGroupes = codesGroupes + ";";
            }
            codesGroupes = codesGroupes + codeGroupe;
        }
        Vector<String> listeUtilisateursGroupe = Groupeutilisateur.getVecteurUtilisateurs(codesGroupes);
        Enumeration<String> e = listeUtilisateursGroupe.elements();
        while (e.hasMoreElements()) {
            String codeUtilisateur = e.nextElement();
            if (renvoyerMails) {
                Utilisateur ut = Utilisateur.getUtilisateur(codeUtilisateur);
                if (ut.getCode().length() <= 0) continue;
                res.add(ut.getAdresseMail() + ";" + ut.getLibelle() + ";" + ut.getCode());
                continue;
            }
            res.add(codeUtilisateur);
        }
        if (!listeRoles.isEmpty()) {
            ClauseWhere whereRoles = new ClauseWhere();
            for (String codeRole : listeRoles) {
                whereRoles.or(ConditionHelper.like("ROLES", codeRole, "%[", ";%"));
            }
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.init();
            try (ContexteDao ctx2 = new ContexteDao();){
                utilisateur.setCtx(ctx2);
                if (utilisateur.select(whereRoles.formaterSQL()) > 0) {
                    while (utilisateur.nextItem()) {
                        for (String listeRole : listeRoles) {
                            Vector<Perimetre> v = Role.renvoyerPerimetresAffectation(utilisateur.getRoles(), listeRole, codesStructures, codeRubrique, publicsVises, codeEspaceCollaboratif);
                            if (v.isEmpty()) continue;
                            if (renvoyerMails) {
                                res.add(utilisateur.getAdresseMail() + ";" + utilisateur.getLibelle() + ";" + utilisateur.getCode());
                                continue;
                            }
                            res.add(utilisateur.getCode());
                        }
                    }
                }
            }
        }
        return res;
    }

    public Vector<String> getVecteurGroupesDsiTmp() {
        return this.vecteurGroupesDsiTmp;
    }

    public void setVecteurGroupesDsiTmp(Vector<String> vecteurGroupesDsiTmp) {
        this.vecteurGroupesDsiTmp = vecteurGroupesDsiTmp;
    }

    public boolean provientDuLdap() {
        return StringUtils.isNotBlank((CharSequence)this.getCodeLdap());
    }

    public boolean isModificationMotDePasseInterditeParSource() {
        boolean ldapActif = StringUtils.equals((CharSequence)SOURCE_AUTHENTIFICATION, (CharSequence)SOURCE_AUTHENTIFICATION_LDAP);
        boolean casActif = StringUtils.equals((CharSequence)SOURCE_AUTHENTIFICATION, (CharSequence)SOURCE_AUTHENTIFICATION_CAS);
        boolean cleartrustActif = StringUtils.equals((CharSequence)SOURCE_AUTHENTIFICATION, (CharSequence)SOURCE_AUTHENTIFICATION_CLEARTRUST);
        boolean utilisateurProvientDuLdap = StringUtils.isNotBlank((CharSequence)this.getCodeLdap());
        return utilisateurProvientDuLdap && (ldapActif || casActif || cleartrustActif);
    }
}

