/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.kportal.extension.module.composant.ComposantHelper;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.extension.module.composant.Menu;
import com.kportal.ihm.service.ServiceMenuBack;
import com.univ.objetspartages.om.AutorisationBean;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AffichageSousMenu
extends ProcessusBean {
    public AffichageSousMenu(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected boolean traiterAction() throws Exception {
        this.infoBean.getNomProcessus();
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            Menu menuEcranCourant = null;
            IComposant composantCourant = this.retrouverComposant(this.infoBean);
            Menu menuBackComplet = ServiceMenuBack.getMenuBackOfficeParUtilisateur(autorisations);
            if (menuBackComplet != null && CollectionUtils.isNotEmpty(menuBackComplet.getSousMenu())) {
                for (int index = 0; menuEcranCourant == null && index < menuBackComplet.getSousMenu().size(); ++index) {
                    Menu menuCourant = menuBackComplet.getSousMenu().get(index);
                    if (!StringUtils.equals((CharSequence)menuCourant.getIdMenu(), (CharSequence)composantCourant.getId())) continue;
                    menuEcranCourant = menuCourant;
                }
            }
            this.infoBean.setEcranLogique("ACCUEIL");
            this.infoBean.setTitreEcran(composantCourant.getLibelleAffichable());
            this.infoBean.set("MENU_ECRAN_COURANT", menuEcranCourant);
        }
        return Boolean.FALSE;
    }

    private IComposant retrouverComposant(InfoBean infoBean) {
        String nomProcessus = infoBean.getNomProcessus();
        Collection<IComposant> composantsDefinis = ComposantHelper.getComposants();
        for (IComposant composantCourant : composantsDefinis) {
            if (!composantCourant.getParametreProcessus().equals(nomProcessus)) continue;
            return composantCourant;
        }
        return null;
    }
}

