/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.AbstractProcessusBean;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.core.TypeMessage;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.stats.LogStats;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.multisites.InfosFicheReferencee;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.Encadre;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.StructureModele;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.processus.SaisieFiche;
import com.univ.objetspartages.processus.Validation;
import com.univ.synchro.SynchroGroupedsiStructure;
import com.univ.url.UrlManager;
import com.univ.utils.Chaine;
import com.univ.utils.ClassMetaUtil;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.MailUtil;
import com.univ.utils.URLResolver;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControleurUniv {
    private static final Logger LOG = LoggerFactory.getLogger(ControleurUniv.class);
    private static final DateFormat FORMAT_HEURE_MINUTE = new SimpleDateFormat("HH:mm");

    private static boolean lireFlag(String value) {
        return "1".equals(value);
    }

    /*
     * WARNING - void declaration
     */
    public static void preparerPRINCIPAL(InfoBean infoBean, FicheUniv ficheUniv, SaisieFiche processus) throws Exception {
        Vector<Perimetre> listePerimetresPublication;
        String nomobjet;
        List<String> differences;
        HttpSession session = infoBean.getSessionHttp();
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
        AutorisationBean autorisations = (AutorisationBean)sessionUtilisateur.getInfos().get("AUTORISATIONS");
        Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
        if (infoBean.getEtatObjet().equals("MODIFICATION") && !(differences = meta.controlerCoherenceAvecFiche(ficheUniv)).isEmpty()) {
            String chaineDifferences = "";
            for (String difference : differences) {
                chaineDifferences = chaineDifferences + "\n" + difference;
            }
            infoBean.set("GRS_CONTROLE_META", chaineDifferences);
        }
        infoBean.set("GRS_AUTORISATION_SUPPRESSION", "0");
        infoBean.set("GRS_AUTORISATION_DUPLICATION", "0");
        infoBean.set("GRS_AUTORISATION_TRADUCTION", "0");
        infoBean.set("GRS_AUTORISATION_VALIDATION", "0");
        if (autorisations != null) {
            if (autorisations.estAutoriseASupprimerLaFiche(ficheUniv)) {
                infoBean.set("GRS_AUTORISATION_SUPPRESSION", "1");
            }
            if (autorisations.getAutorisationParFiche(ficheUniv, 0)) {
                infoBean.set("GRS_AUTORISATION_DUPLICATION", "1");
            }
            if (autorisations.getAutorisationParFiche(ficheUniv, 1)) {
                infoBean.set("GRS_AUTORISATION_TRADUCTION", "1");
            }
            if (autorisations.possedeAutorisationValidation(ficheUniv, meta.getMetaNiveauApprobation())) {
                infoBean.set("GRS_AUTORISATION_VALIDATION", "1");
            }
        }
        if (infoBean.getActionUtilisateur() != null && (infoBean.getActionUtilisateur().equals("TRADUIRE") || infoBean.getActionUtilisateur().equals("DUPLIQUER"))) {
            infoBean.set("PREMIERE_ACTION", infoBean.getActionUtilisateur());
        } else if (!"ONGLET".equals(infoBean.getActionUtilisateur())) {
            infoBean.remove("PREMIERE_ACTION");
        }
        if (infoBean.get("SOUS_ONGLET") == null) {
            infoBean.set("SOUS_ONGLET", "");
        }
        if (infoBean.get("GRS_SAISIE_REFERENCEMENT") == null) {
            infoBean.set("GRS_SAISIE_REFERENCEMENT", "1");
        }
        if (infoBean.get("GRS_SAISIE_MODE_BROUILLON") == null) {
            infoBean.set("GRS_SAISIE_MODE_BROUILLON", "1");
        }
        if (infoBean.get("GRS_SAISIE_ENCADRES") == null) {
            infoBean.set("GRS_SAISIE_ENCADRES", "1");
        }
        if (infoBean.get("GRS_APERCU") == null) {
            infoBean.set("GRS_APERCU", "1");
        }
        infoBean.set("DATE_ALERTE", ficheUniv.getDateAlerte());
        infoBean.set("MESSAGE_ALERTE", ficheUniv.getMessageAlerte());
        infoBean.set("META_KEYWORDS", ficheUniv.getMetaKeywords());
        infoBean.set("META_DESCRIPTION", ficheUniv.getMetaDescription());
        infoBean.set("TITRE_ENCADRE", ficheUniv.getTitreEncadre());
        infoBean.set("CONTENU_ENCADRE", ficheUniv.getContenuEncadre());
        infoBean.set("LISTE_ENCADRES_RECHERCHE", Encadre.getListeEncadresRecherche());
        infoBean.set("ENCADRE_RECHERCHE", ficheUniv.getEncadreRecherche());
        infoBean.set("ENCADRE_RECHERCHE_BIS", ficheUniv.getEncadreRechercheBis());
        infoBean.set("DATE_CREATION", ficheUniv.getDateCreation());
        infoBean.set("DATE_PROPOSITION", ficheUniv.getDateProposition());
        infoBean.set("DATE_VALIDATION", ficheUniv.getDateValidation());
        infoBean.set("CODE_REDACTEUR", ficheUniv.getCodeRedacteur());
        infoBean.set("LIBELLE_CODE_REDACTEUR", Utilisateur.getLibelle(ficheUniv.getCodeRedacteur()));
        if ("ANONYME".equals(ficheUniv.getCodeRedacteur())) {
            infoBean.set("LIBELLE_CODE_REDACTEUR", "(anonyme) " + meta.getMetaMailAnonyme());
        }
        if (autorisations != null) {
            autorisations.setRedacteurFicheCourante(false);
            if (!"".equals(ficheUniv.getCodeRedacteur()) && !"ANONYME".equals(ficheUniv.getCodeRedacteur()) && ficheUniv.getCodeRedacteur().equals(sessionUtilisateur.getInfos().get("CODE"))) {
                autorisations.setRedacteurFicheCourante(true);
            }
        }
        infoBean.set("CODE_VALIDATION", ficheUniv.getCodeValidation());
        infoBean.set("ETAT_OBJET", ficheUniv.getEtatObjet());
        infoBean.set("AUTRES_ETATS", null);
        FicheUniv ficheEtats = (FicheUniv)ficheUniv.getClass().newInstance();
        ficheEtats.init();
        ficheEtats.setCtx(processus);
        if (ficheEtats.select(" WHERE CODE='" + ficheUniv.getCode() + "' AND ETAT_OBJET NOT IN ('" + ficheUniv.getEtatObjet() + "') ORDER BY LANGUE, ETAT_OBJET DESC") > 0) {
            Hashtable<String, String> etats = new Hashtable<String, String>();
            while (ficheEtats.nextItem()) {
                etats.put(ficheEtats.getEtatObjet(), ficheEtats.getIdFiche().toString());
            }
            if (etats.size() > 0) {
                infoBean.set("AUTRES_ETATS", etats);
            }
        }
        String code = ficheUniv.getCode();
        infoBean.set("CODE", code);
        if ("".equals(code)) {
            code = "TS" + System.currentTimeMillis();
        }
        infoBean.set("TS_CODE", code);
        infoBean.set("LANGUE", ficheUniv.getLangue());
        Hashtable<String, String> listeAutresLangues = new Hashtable<String, String>();
        Hashtable<String, String> listeLangues = LangueUtil.getListeLangues(processus.getLocale());
        infoBean.set("LISTE_LANGUES", listeLangues);
        if (infoBean.get("SAISIE_FRONT") == null && !"CREATION".equals(infoBean.getEtatObjet())) {
            FicheUniv ficheUniv2 = (FicheUniv)ficheUniv.getClass().newInstance();
            ficheUniv2.setCtx(processus);
            ficheUniv2.init();
            Enumeration<String> v = listeLangues.keys();
            while (v.hasMoreElements()) {
                String key = v.nextElement();
                if (ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), key, "") != 0) continue;
                listeAutresLangues.put(key, listeLangues.get(key));
            }
        }
        infoBean.set("LISTE_AUTRES_LANGUES", listeAutresLangues);
        infoBean.set("DEMANDE_VALIDATION", "0");
        infoBean.set("MISE_EN_LIGNE", "0");
        infoBean.set("REMPLACER_VERSION", "0");
        infoBean.set("RETOUR_AUTEUR", "0");
        infoBean.set("AFFICHER_REMPLACER_VERSION", "0");
        infoBean.set("MODE_BROUILLON", "0");
        if (infoBean.get("SAISIE_FRONT") == null && ("MODIFICATION".equals(infoBean.getEtatObjet()) || "CREATION".equals(infoBean.getEtatObjet()) && "1".equals(PropertyHelper.getCoreProperty("saisie.etat_creation.brouillon"))) && "0001".equals(ficheUniv.getEtatObjet())) {
            infoBean.set("MODE_BROUILLON", "1");
        }
        EtatFiche etatObjetInfoBean = EtatFiche.getEtatParCode(infoBean.getString("ETAT_OBJET"));
        if (EtatFiche.EN_LIGNE.getEtat().equals(ficheUniv.getEtatObjet()) && FicheUnivMgr.existeVersionTravail(ficheUniv)) {
            infoBean.set("AFFICHER_REMPLACER_VERSION", "1");
        } else if ((EtatFiche.A_SUPPRIMER.equals((Object)etatObjetInfoBean) || EtatFiche.SAUVEGARDE_AUTO.equals((Object)etatObjetInfoBean) || EtatFiche.ARCHIVE.equals((Object)etatObjetInfoBean)) && FicheUnivMgr.existeVersionTravail(ficheUniv)) {
            infoBean.set("AFFICHER_POPUP_RESTAURATION", "1");
        }
        if (infoBean.get("LIEN_DIRECT") != null && !"0002".equals(ficheUniv.getEtatObjet())) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_PLUS_ETAT_VALIDATION"));
        }
        if ("0003".equals(ficheUniv.getEtatObjet()) && ficheUniv.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0002") > 0) {
            boolean estValidateur;
            boolean bl = estValidateur = autorisations != null && autorisations.getAutorisation(infoBean.getString("CODE_OBJET"), 3);
            if (!estValidateur) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_VALIDATION_DOUBLON"));
            }
        }
        infoBean.set("AFFICHER_CHOISIR_VALIDATEUR", "1");
        infoBean.set("GRS_SAISIE_WORKFLOW", "0");
        String niveauApprobation = "";
        String libelleApprobation = "";
        if ("1".equals(PropertyHelper.getCoreProperty("validation_multi_niveaux.activation"))) {
            infoBean.set("GRS_SAISIE_WORKFLOW", "1");
            if ("0002".equals(ficheUniv.getEtatObjet())) {
                niveauApprobation = meta.getMetaNiveauApprobation();
                if (niveauApprobation.length() > 0) {
                    libelleApprobation = AutorisationBean.getListeNiveauxApprobation().get(niveauApprobation);
                } else {
                    infoBean.set("AFFICHER_CHOISIR_VALIDATEUR", "0");
                }
            }
        }
        infoBean.set("LIBELLE_APPROBATION", libelleApprobation);
        infoBean.set("NIVEAU_APPROBATION", niveauApprobation);
        String activationDsi = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("dsi.activation"), (CharSequence)"0");
        infoBean.set("GRS_SAISIE_COLLABORATIF", "0");
        infoBean.set("GRS_SAISIE_DIFFUSION", "0");
        if ("1".equals(activationDsi) && ficheUniv instanceof DiffusionSelective && autorisations != null && (autorisations.isDiffuseurDSI() || infoBean.get("SAISIE_FRONT") != null || infoBean.get("ESPACE") != null)) {
            infoBean.set("GRS_SAISIE_DIFFUSION", "1");
            DiffusionSelective ficheDiffusion = (DiffusionSelective)((Object)ficheUniv);
            ControleurUniv.formaterPublicViseDsiDansInfoBean(infoBean, processus, ficheDiffusion.getDiffusionPublicVise(), "PUBLIC_VISE_DSI");
            infoBean.set("DIFFUSION_MODE_RESTRICTION", ficheDiffusion.getDiffusionModeRestriction());
            if (!"4".equals(infoBean.get("DIFFUSION_MODE_RESTRICTION"))) {
                ControleurUniv.formaterPublicViseDsiDansInfoBean(infoBean, processus, ficheDiffusion.getDiffusionPublicViseRestriction(), "PUBLIC_VISE_DSI_RESTRICTION");
            } else {
                infoBean.set("PUBLIC_VISE_ESPACE", ficheDiffusion.getDiffusionPublicViseRestriction());
                infoBean.set("PUBLIC_VISE_DSI_RESTRICTION", "");
            }
            if (Espacecollaboratif.isExtensionActivated()) {
                if (FicheUnivMgr.isFicheCollaborative(ficheUniv)) {
                    infoBean.set("GRS_SAISIE_COLLABORATIF", "1");
                }
                if ("CREATION".equals(infoBean.getEtatObjet()) && infoBean.get("ESPACE") != null) {
                    infoBean.set("DIFFUSION_MODE_RESTRICTION", "4");
                    infoBean.set("PUBLIC_VISE_ESPACE", infoBean.get("ESPACE"));
                }
            }
        }
        infoBean.set("DATE_MODIFICATION", ficheUniv.getDateModification());
        infoBean.set("EXISTE_VERSION_PLUS_RECENTE", "0");
        String objet = ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET"));
        FicheUniv ficheUniv2 = ReferentielObjets.instancierFiche(objet);
        ficheUniv2.setCtx(processus);
        ficheUniv2.init();
        if ("CREATION".equals(infoBean.getEtatObjet())) {
            infoBean.set("DATE_MISE_EN_LIGNE", new Date(System.currentTimeMillis()));
            infoBean.set("HEURE_MISE_EN_LIGNE", "00:00");
            infoBean.set("GRS_SAUVEGARDE_DATE_MISE_EN_LIGNE", new Date(System.currentTimeMillis()));
        } else {
            Date dateHeureMiseEnLigne = meta.getMetaDateMiseEnLigne();
            infoBean.set("DATE_MISE_EN_LIGNE", dateHeureMiseEnLigne);
            infoBean.set("HEURE_MISE_EN_LIGNE", ((DateFormat)FORMAT_HEURE_MINUTE.clone()).format(dateHeureMiseEnLigne));
            infoBean.set("GRS_SAUVEGARDE_DATE_MISE_EN_LIGNE", meta.getMetaDateMiseEnLigne());
        }
        infoBean.set("DATE_ARCHIVAGE", meta.getMetaDateArchivage());
        infoBean.set("GRS_SAUVEGARDE_DATE_ARCHIVAGE", meta.getMetaDateArchivage());
        if ("CREATION".equals(infoBean.getEtatObjet()) || "DUPLIQUER".equals(infoBean.get("PREMIERE_ACTION")) || "TRADUIRE".equals(infoBean.get("PREMIERE_ACTION"))) {
            int archivage = -1;
            nomobjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()));
            if (PropertyHelper.getExtensionProperty(infoBean.getNomExtension(), "fiche." + nomobjet.toUpperCase() + ".archivage") != null) {
                try {
                    archivage = Integer.parseInt(PropertyHelper.getExtensionProperty(infoBean.getNomExtension(), "fiche." + nomobjet.toUpperCase() + ".archivage"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (archivage != -1) {
                GregorianCalendar aujourdhui2 = new GregorianCalendar();
                aujourdhui2.add(2, archivage);
                Date dateArchivage = new Date(aujourdhui2.getTime().getTime());
                infoBean.set("DATE_ARCHIVAGE", dateArchivage);
                infoBean.set("GRS_SAUVEGARDE_DATE_ARCHIVAGE", dateArchivage);
            }
        }
        infoBean.set("DATE_SUPPRESSION", meta.getMetaDateSuppression());
        infoBean.set("GRS_SAUVEGARDE_DATE_SUPPRESSION", meta.getMetaDateSuppression());
        if ("CREATION".equals(infoBean.getEtatObjet()) || "DUPLIQUER".equals(infoBean.get("PREMIERE_ACTION")) || "TRADUIRE".equals(infoBean.get("PREMIERE_ACTION"))) {
            int suppression = -1;
            nomobjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()));
            if (PropertyHelper.getExtensionProperty(infoBean.getNomExtension(), "fiche." + nomobjet.toUpperCase() + ".suppression") != null) {
                try {
                    suppression = Integer.parseInt(PropertyHelper.getExtensionProperty(infoBean.getNomExtension(), "fiche." + nomobjet.toUpperCase() + ".suppression"));
                }
                catch (Exception aujourdhui2) {
                    // empty catch block
                }
            }
            if (suppression != -1) {
                GregorianCalendar aujourdhui = new GregorianCalendar();
                aujourdhui.add(2, suppression);
                Date dateSuppression = new Date(aujourdhui.getTime().getTime());
                infoBean.set("DATE_SUPPRESSION", dateSuppression);
                infoBean.set("GRS_SAUVEGARDE_DATE_SUPPRESSION", dateSuppression);
            }
        }
        infoBean.set("DATE_RUBRIQUAGE", meta.getMetaDateRubriquage());
        infoBean.set("CODE_RUBRIQUAGE", meta.getMetaCodeRubriquage());
        infoBean.set("LIBELLE_CODE_RUBRIQUAGE", Rubrique.renvoyerItemRubrique(meta.getMetaCodeRubriquage()).getIntitule());
        infoBean.set("GRS_SAUVEGARDE_DATE_RUBRIQUAGE", meta.getMetaDateRubriquage());
        infoBean.set("GRS_SAUVEGARDE_CODE_RUBRIQUAGE", meta.getMetaCodeRubriquage());
        String codeRubrique = ficheUniv.getCodeRubrique();
        String filAriane = Rubrique.getFilAriane(codeRubrique, "");
        infoBean.set("FIL_ARIANE", filAriane);
        GregorianCalendar calFiche = meta.getDateDerniereModification();
        if (calFiche != null && ficheUniv.getCode().length() > 0 && ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "") > 0) {
            while (ficheUniv2.nextItem()) {
                Metatag meta2;
                GregorianCalendar calAutreFiche;
                if (ficheUniv2.getIdFiche().equals(ficheUniv.getIdFiche()) || !"0001".equals(ficheUniv.getEtatObjet()) && !"0002".equals(ficheUniv.getEtatObjet()) && !"0003".equals(ficheUniv.getEtatObjet()) || (calAutreFiche = (meta2 = FicheUnivMgr.lireMeta(infoBean.getString("CODE_OBJET"), ficheUniv2.getIdFiche())).getDateDerniereModification()) == null || !calAutreFiche.after(calFiche)) continue;
                infoBean.set("EXISTE_VERSION_PLUS_RECENTE", "1");
            }
        }
        if (ficheUniv instanceof StructureModele) {
            infoBean.set("IN_TREE_ACTIF", true);
            if ("CREATION".equals(infoBean.getEtatObjet())) {
                infoBean.set("IN_TREE", "1");
            } else {
                infoBean.set("IN_TREE", meta.getMetaInTree());
            }
        }
        String nomColonneStructure = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RATTACHEMENT");
        String nomColonneRubrique = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RUBRIQUE");
        String urlFicheModification = "";
        if ("CREATION".equals(infoBean.getEtatObjet())) {
            if (infoBean.get("PREV_CODE_RATTACHEMENT") != null) {
                infoBean.set(nomColonneStructure, infoBean.getString("PREV_CODE_RATTACHEMENT"));
                infoBean.set("LIBELLE_" + nomColonneStructure, Structure.getLibelleAffichable(infoBean.getString("PREV_CODE_RATTACHEMENT"), ficheUniv.getLangue()));
                urlFicheModification = urlFicheModification + "&PREV_CODE_RATTACHEMENT=" + infoBean.getString("PREV_CODE_RATTACHEMENT");
            } else if (infoBean.get("SAISIE_FRONT") != null) {
                infoBean.set(nomColonneStructure, "");
                infoBean.set("LIBELLE_" + nomColonneStructure, "");
            }
        } else if (infoBean.get("SAISIE_FRONT") != null) {
            infoBean.set(nomColonneStructure, ficheUniv.getCodeRattachement());
            infoBean.set("LIBELLE_" + nomColonneStructure, Structure.getLibelleAffichable(ficheUniv.getCodeRattachement(), ficheUniv.getLangue()));
        }
        if ("CREATION".equals(infoBean.getEtatObjet())) {
            if (infoBean.get("PREV_CODE_RUBRIQUE") != null) {
                InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique((String)infoBean.get("PREV_CODE_RUBRIQUE"));
                infoBean.set(nomColonneRubrique, rubriqueCourante.getCode());
                String titre = rubriqueCourante.getIntitule();
                if (titre.contains("#")) {
                    titre = titre.substring(titre.indexOf("#") + 1);
                }
                infoBean.set("LIBELLE_" + nomColonneRubrique, titre);
                urlFicheModification = urlFicheModification + "&PREV_CODE_RUBRIQUE=" + infoBean.getString("PREV_CODE_RUBRIQUE");
            } else if (infoBean.get("SAISIE_FRONT") != null) {
                infoBean.set(nomColonneRubrique, "");
                infoBean.set("LIBELLE_" + nomColonneRubrique, "");
            }
        } else if (infoBean.get("SAISIE_FRONT") != null) {
            infoBean.set(nomColonneRubrique, ficheUniv.getCodeRubrique());
            infoBean.set("LIBELLE_" + nomColonneRubrique, Rubrique.renvoyerItemRubrique(ficheUniv.getCodeRubrique()).getIntitule());
        }
        if (ficheUniv instanceof DiffusionSelective && "CREATION".equals(infoBean.getEtatObjet()) && infoBean.get("ESPACE") == null) {
            if (infoBean.get("PREV_DIFFUSION_PUBLIC_VISE") != null) {
                ControleurUniv.formaterPublicViseDsiDansInfoBean(infoBean, processus, infoBean.getString("PREV_DIFFUSION_PUBLIC_VISE"), "PUBLIC_VISE_DSI");
                infoBean.set("DIFFUSION_MODE_RESTRICTION", "0");
                urlFicheModification = urlFicheModification + "&PREV_DIFFUSION_PUBLIC_VISE=" + infoBean.getString("PREV_DIFFUSION_PUBLIC_VISE");
            } else if (infoBean.get("SAISIE_FRONT") != null) {
                infoBean.set("PUBLIC_VISE_DSI", "");
                infoBean.set("LIBELLE_PUBLIC_VISE_DSI", "");
                infoBean.set("DIFFUSION_MODE_RESTRICTION", "0");
            }
        }
        if (infoBean.get("SAISIE_FRONT") != null) {
            if (autorisations != null && autorisations.possedeModeExpert()) {
                if ("CREATION".equals(infoBean.getEtatObjet())) {
                    if (!(ficheUniv instanceof FicheObjet)) {
                        urlFicheModification = "/servlet/com.jsbsoft.jtf.core.SG?ACTION=AJOUTER" + urlFicheModification;
                    }
                } else {
                    urlFicheModification = "/servlet/com.jsbsoft.jtf.core.SG?ACTION=MODIFIER&amp;ID_FICHE=" + ficheUniv.getIdFiche();
                }
                if (StringUtils.isNotBlank((CharSequence)urlFicheModification)) {
                    urlFicheModification = urlFicheModification + "&amp;EXT=" + ReferentielObjets.getExtension(infoBean.getString("CODE_OBJET")) + "&amp;PROC=SAISIE_" + ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")).toUpperCase();
                    urlFicheModification = "href=\"#\" onclick=\"window.open('" + URLResolver.getAbsoluteUrl(urlFicheModification, processus) + "','_blank','');";
                    urlFicheModification = infoBean.getString("URL_REDIRECT") != null && infoBean.getString("URL_REDIRECT").length() > 0 ? urlFicheModification + "window.location.href='" + infoBean.getString("URL_REDIRECT") + "';\"" : urlFicheModification + "window.history.back();\"";
                    infoBean.set("GRS_URL_MODIFICATION_EXPERT", urlFicheModification);
                }
            }
            if ("1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && "MODIFICATION".equals(infoBean.getEtatObjet())) {
                String urlFicheSuppression = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(infoBean.getString("CODE_OBJET")) + "&amp;ACTION=SUPPRIMER&amp;SAISIE_FRONT=TRUE&amp;TYPE_FICHE=" + ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")).toUpperCase();
                urlFicheSuppression = urlFicheSuppression + "&amp;ID_FICHE=" + ficheUniv.getIdFiche() + "&amp;PROC=SAISIE_" + ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")).toUpperCase() + "_FRONT";
                if (infoBean.get("ESPACE") != null) {
                    urlFicheSuppression = urlFicheSuppression + "&amp;ESPACE=" + infoBean.getString("ESPACE");
                }
                if (infoBean.get("RH") != null) {
                    urlFicheSuppression = urlFicheSuppression + "&amp;RH=" + infoBean.getString("RH");
                }
                if (infoBean.get("LANGUE") != null) {
                    urlFicheSuppression = urlFicheSuppression + "&amp;LANGUE=" + infoBean.getString("LANGUE");
                }
                infoBean.set("GRS_URL_SUPPRESSION", urlFicheSuppression);
            }
            if ("CREATION".equals(infoBean.getEtatObjet())) {
                infoBean.set("MAIL_ANONYME", "");
            } else {
                infoBean.set("MAIL_ANONYME", meta.getMetaMailAnonyme());
            }
        }
        PluginFicheHelper.preparerPrincipal(infoBean, ficheUniv, meta);
        if (StringUtils.isNotEmpty((CharSequence)meta.getMetaDocumentFichiergw())) {
            if ("1".equals(meta.getMetaDocumentFichiergw())) {
                infoBean.set("DOCUMENT_FICHIERGW", "1");
            } else {
                infoBean.set("DOCUMENT_FICHIERGW", "0");
            }
        }
        boolean initProcessus = false;
        if (infoBean.get(nomColonneRubrique) != null && infoBean.getString(nomColonneRubrique).length() > 0) {
            initProcessus = true;
        }
        if (infoBean.getString(nomColonneStructure) != null && infoBean.getString(nomColonneStructure).length() > 0) {
            initProcessus = true;
        }
        String structureParDefaut = "";
        String rubriqueParDefaut = "";
        if (!initProcessus && infoBean.getEtatObjet().equals("CREATION") && autorisations != null) {
            String structureUtilisateur;
            int niveauRubriqueCourante = 10;
            Vector<Perimetre> listePerimetres = autorisations.getListePerimetres(new PermissionBean("FICHE", ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()), "C"));
            Enumeration<Perimetre> e = listePerimetres.elements();
            while (e.hasMoreElements()) {
                InfosRubriques infosRubrique;
                int niveauRubrique;
                Perimetre perimetreCourant = e.nextElement();
                if (!"".equals(perimetreCourant.getCodeEspaceCollaboratif()) || perimetreCourant.getCodeRubrique().length() <= 0 || (niveauRubrique = (infosRubrique = Rubrique.renvoyerItemRubrique(perimetreCourant.getCodeRubrique())).getNiveau()) >= niveauRubriqueCourante) continue;
                niveauRubriqueCourante = niveauRubrique;
                rubriqueParDefaut = perimetreCourant.getCodeRubrique();
                structureParDefaut = perimetreCourant.getCodeStructure();
            }
            if (rubriqueParDefaut.length() > 0 && !"-".equals(rubriqueParDefaut)) {
                infoBean.set(nomColonneRubrique, rubriqueParDefaut);
                infoBean.set("LIBELLE_" + nomColonneRubrique, Rubrique.renvoyerItemRubrique(rubriqueParDefaut).getIntitule());
            }
            if (("".equals(structureParDefaut) || "-".equals(structureParDefaut)) && (structureUtilisateur = autorisations.getCodeStructure()).length() > 0 && autorisations.possedePermission(new PermissionBean("FICHE", ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()), "C"), new Perimetre(structureUtilisateur, rubriqueParDefaut, "*", "*", ""))) {
                structureParDefaut = structureUtilisateur;
            }
            if (structureParDefaut.length() > 0 && !"-".equals(structureParDefaut)) {
                infoBean.set(nomColonneStructure, structureParDefaut);
                infoBean.set("LIBELLE_" + nomColonneStructure, Structure.getLibelleAffichable(structureParDefaut, "0"));
            }
        }
        infoBean.set("GRS_PERMISSION_TYPE", "FICHE");
        infoBean.set("GRS_PERMISSION_OBJET", infoBean.getString("GRS_CODE_OBJET"));
        infoBean.set("GRS_PERMISSION_ACTION", "C");
        if (infoBean.getEtatObjet().equals("CREATION")) {
            infoBean.set("GRS_PERMISSION_ACTION", "C");
        }
        if (infoBean.getEtatObjet().equals("MODIFICATION")) {
            infoBean.set("GRS_PERMISSION_ACTION", "M");
        }
        infoBean.set("GRS_SAUVEGARDE_CODE_RUBRIQUE", infoBean.get(nomColonneRubrique));
        infoBean.set("NOM_CODE_RUBRIQUE", nomColonneRubrique);
        infoBean.set("GRS_SAUVEGARDE_CODE_RATTACHEMENT", infoBean.get(nomColonneStructure));
        infoBean.set("NOM_CODE_RATTACHEMENT", nomColonneStructure);
        String nomColonneRattachementAutres = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RATTACHEMENT_AUTRES");
        if (infoBean.get(nomColonneRattachementAutres) != null) {
            infoBean.set("GRS_SAUVEGARDE_CODE_RATTACHEMENT_AUTRES", infoBean.get(nomColonneRattachementAutres));
            infoBean.set("NOM_CODE_RATTACHEMENT_AUTRES", nomColonneRattachementAutres);
        }
        if (infoBean.get("PUBLIC_VISE_DSI") != null) {
            infoBean.set("GRS_SAUVEGARDE_PUBLIC_VISE_ESPACE", infoBean.get("PUBLIC_VISE_ESPACE"));
        } else {
            infoBean.set("GRS_SAUVEGARDE_PUBLIC_VISE_ESPACE", "");
        }
        infoBean.set("GRS_SAISIE_PUBLICATION", "0");
        if (autorisations != null && (listePerimetresPublication = autorisations.getListePerimetres(new PermissionBean("TECH", "pub", ""))).size() > 0) {
            void var33_45;
            infoBean.set("GRS_SAISIE_PUBLICATION", "1");
            Vector<Object> rubPub = new Vector();
            if ("0003".equals(ficheUniv.getEtatObjet())) {
                rubPub = Rubriquepublication.getListeRubriquesPublication(processus, ficheUniv, "", true);
            }
            Vector<String> rubriquesMeta = Chaine.getVecteurPointsVirgules(meta.getMetaRubriquesPublication());
            Enumeration<String> eMeta = rubriquesMeta.elements();
            while (eMeta.hasMoreElements()) {
                String codeMeta = eMeta.nextElement();
                if (rubPub.contains(codeMeta)) continue;
                rubPub.add(codeMeta);
            }
            HashSet<String> rubPubToRemove = new HashSet<String>();
            for (String string : rubPub) {
                if (Rubrique.controlerPermission(autorisations, "TECH/pub/", string)) continue;
                rubPubToRemove.add(string);
            }
            rubPub.removeAll(rubPubToRemove);
            String codesRubriquesPublication = "";
            String string = "";
            String codesRubriquesPublicationAutomatiques = "";
            Enumeration<Object> eRub = rubPub.elements();
            while (eRub.hasMoreElements()) {
                void var33_47;
                String codeRubPub = (String)eRub.nextElement();
                String libelleAuto = "";
                String codeRubAuto = codeRubPub;
                if (codesRubriquesPublication.length() > 0) {
                    codesRubriquesPublication = codesRubriquesPublication + ";";
                    String string2 = (String)var33_45 + ";";
                }
                if (codeRubAuto.startsWith("#AUTO#")) {
                    if (codesRubriquesPublicationAutomatiques.length() > 0) {
                        codesRubriquesPublicationAutomatiques = codesRubriquesPublicationAutomatiques + ";";
                    }
                    codeRubPub = codeRubAuto.substring(6);
                    codesRubriquesPublicationAutomatiques = codesRubriquesPublicationAutomatiques + codeRubAuto;
                    libelleAuto = " (automatique)";
                }
                String libelleRubPub = Rubrique.getIntitule(codeRubPub);
                codesRubriquesPublication = codesRubriquesPublication + codeRubAuto;
                String string3 = (String)var33_47 + libelleRubPub + libelleAuto;
            }
            infoBean.set("RUBRIQUE_PUBLICATION_HORS_PERIMETRE", rubPubToRemove);
            infoBean.set("RUBRIQUE_PUBLICATION_AUTOMATIQUE", codesRubriquesPublicationAutomatiques);
            infoBean.set("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION", codesRubriquesPublication);
            infoBean.set("GRS_SAUVEGARDE_LIBELLE_RUBRIQUE_PUBLICATION", var33_45);
            infoBean.set("RUBRIQUE_PUBLICATION", codesRubriquesPublication);
            infoBean.set("LIBELLE_RUBRIQUE_PUBLICATION", var33_45);
        }
        infoBean.set("FICHES_AUTRE_LANGUE", null);
        if ("MODIFICATION".equals(infoBean.getEtatObjet())) {
            Hashtable<String, String> hLangue = LangueUtil.getListeLangues(processus.getLocale());
            hLangue.remove(ficheUniv.getLangue());
            if (hLangue.size() > 0) {
                FicheUniv fiche2 = (FicheUniv)ficheUniv.getClass().newInstance();
                fiche2.init();
                fiche2.setCtx(processus);
                if (fiche2.select(" WHERE CODE='" + ficheUniv.getCode() + "' AND ETAT_OBJET NOT IN ('0005','0006') ORDER BY LANGUE, ETAT_OBJET DESC") > 1) {
                    TreeMap<String, String> autresLangues = new TreeMap<String, String>();
                    String etatObjetFicheEnregistree = "";
                    while (fiche2.nextItem()) {
                        if (!hLangue.containsKey(fiche2.getLangue()) || autorisations == null || !autorisations.estAutoriseAModifierLaFiche(fiche2) || autresLangues.get(fiche2.getLangue()) != null && (autresLangues.get(fiche2.getLangue()) == null || !"0004".equals(etatObjetFicheEnregistree))) continue;
                        String extension = ReferentielObjets.getExtension(ReferentielObjets.getCodeObjet(fiche2));
                        String nomProcessus = "SAISIE_" + ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")).toUpperCase();
                        String[][] stringArray = new String[][]{{"ID_FICHE", fiche2.getIdFiche().toString()}};
                        String urlFiche = ProcessusHelper.getUrlProcessAction(infoBean, extension, nomProcessus, "MODIFIER", stringArray);
                        autresLangues.put(fiche2.getLangue(), urlFiche);
                        etatObjetFicheEnregistree = fiche2.getEtatObjet();
                    }
                    if (autresLangues.size() > 0) {
                        infoBean.set("FICHES_AUTRE_LANGUE", autresLangues);
                    }
                }
            }
        }
        ControleurUniv.setMessagesAlerte(infoBean);
    }

    private static void setMessagesAlerte(InfoBean infoBean) {
        if ("MODIFICATION".equals(infoBean.getEtatObjet()) && EtatFiche.SAUVEGARDE_AUTO.getEtat().equals(infoBean.get("ETAT_OBJET"))) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_SAUVEGARDE_AUTO_APERCU"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_RESTAURATION"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_SUPPRESSION_POSSIBLE"));
        } else if ("1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && EtatFiche.A_SUPPRIMER.getEtat().equals(infoBean.get("ETAT_OBJET"))) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_A_SUPPRIMER"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_RESTAURATION"));
        } else if ("1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && EtatFiche.ARCHIVE.getEtat().equals(infoBean.get("ETAT_OBJET"))) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_ARCHIVE"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_RESTAURATION"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_SUPPRESSION_POSSIBLE"));
        }
        if (infoBean.get("GRS_CONTROLE_META") != null) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_META_DONNEES"));
        }
        if ("1".equals(infoBean.getString("EXISTE_VERSION_PLUS_RECENTE"))) {
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_ENCOURS_MODIFICATION"));
            infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_FICHE_VERSION_RECENTE"));
        }
    }

    public static String traiterPRINCIPAL(InfoBean infoBean, FicheUniv ficheUniv, SaisieFiche processus) throws Exception {
        String saveMetaForumAno;
        String saveMetaForum;
        String[] rubPub;
        Vector<String> listeRubPub;
        String ecranLogique = "CONFIRMATION";
        String action = infoBean.getActionUtilisateur();
        if (infoBean.get("GRS_LIBELLE_COPIE") != null) {
            infoBean.remove("GRS_LIBELLE_COPIE");
        }
        HttpSession session = infoBean.getSessionHttp();
        AutorisationBean autorisations = null;
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
        if (sessionUtilisateur != null) {
            autorisations = (AutorisationBean)sessionUtilisateur.getInfos().get("AUTORISATIONS");
        }
        String codeEspaceCollaboratif = "";
        if (infoBean.get("ESPACE") != null && infoBean.getString("ESPACE").length() > 0) {
            codeEspaceCollaboratif = infoBean.getString("ESPACE");
        }
        Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
        PluginFicheHelper.preTraiterPrincipal(infoBean, ficheUniv, meta);
        if (!("SUPPRIMER".equals(action) || "ARCHIVER".equals(action) || "RESTAURER_ARCHIVE".equals(action) || "RESTAURER_SAUVEGARDE".equals(action) || "DUPLIQUER".equals(action) || "TRADUIRE".equals(action) || "ENREGISTRER".equals(action) || "ANNULER_SUPPRESSION".equals(action))) {
            return "PRINCIPAL";
        }
        String nomColonneStructure = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RATTACHEMENT");
        String nomColonneRattachementAutres = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RATTACHEMENT_AUTRES");
        String nomColonneRubrique = ClassMetaUtil.getClassMetaValue(processus, "NOM_CODE_RUBRIQUE");
        boolean modificationPerimetre = false;
        FicheUniv ficheEnLigneAvantTraitement = (FicheUniv)ficheUniv.getClass().newInstance();
        ficheEnLigneAvantTraitement.init();
        ficheEnLigneAvantTraitement.setCtx(processus);
        if (ficheEnLigneAvantTraitement.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0003") > 0) {
            ficheEnLigneAvantTraitement.nextItem();
        } else {
            ficheEnLigneAvantTraitement = null;
        }
        boolean miseEnLigne = false;
        if (!"SUPPRIMER".equals(action)) {
            if (infoBean.get(nomColonneStructure) != null && !infoBean.getString("GRS_SAUVEGARDE_CODE_RATTACHEMENT").equals(infoBean.get(nomColonneStructure))) {
                modificationPerimetre = true;
            }
            if (infoBean.get(nomColonneRattachementAutres) != null && !infoBean.getString("GRS_SAUVEGARDE_CODE_RATTACHEMENT_AUTRES").equals(infoBean.get(nomColonneRattachementAutres))) {
                modificationPerimetre = true;
            }
            if (infoBean.get(nomColonneRubrique) != null && !infoBean.getString("GRS_SAUVEGARDE_CODE_RUBRIQUE").equals(infoBean.get(nomColonneRubrique))) {
                modificationPerimetre = true;
            }
            if (infoBean.get("PUBLIC_VISE_DSI") != null && infoBean.get("PUBLIC_VISE_ESPACE") != null && !infoBean.getString("GRS_SAUVEGARDE_PUBLIC_VISE_ESPACE").equals(infoBean.getString("PUBLIC_VISE_ESPACE"))) {
                modificationPerimetre = true;
            }
            if (ficheUniv instanceof StructureModele && infoBean.get("IN_TREE") != null) {
                meta.setMetaInTree((String)infoBean.get("IN_TREE"));
            }
            if (!Formateur.estSaisie((Date)infoBean.get("DATE_MISE_EN_LIGNE"))) {
                if (Formateur.estSaisie((Date)infoBean.get("GRS_SAUVEGARDE_DATE_MISE_EN_LIGNE"))) {
                    meta.setMetaDateMiseEnLigne((Date)infoBean.get("GRS_SAUVEGARDE_DATE_MISE_EN_LIGNE"));
                } else {
                    meta.setMetaDateMiseEnLigne((Date)infoBean.get("DATE_CREATION"));
                }
            } else {
                Date dateCreation = (Date)infoBean.get("DATE_MISE_EN_LIGNE");
                if (StringUtils.isNotBlank((CharSequence)((String)infoBean.get("HEURE_MISE_EN_LIGNE")))) {
                    java.util.Date heureMiseEnLigne = ((DateFormat)FORMAT_HEURE_MINUTE.clone()).parse((String)infoBean.get("HEURE_MISE_EN_LIGNE"));
                    long heureEnMinutes = DateUtils.getFragmentInMinutes((java.util.Date)heureMiseEnLigne, (int)5);
                    java.util.Date dateMiseEnLigneSansHeure = DateUtils.truncate((java.util.Date)dateCreation, (int)5);
                    dateCreation = new Date(DateUtils.addMinutes((java.util.Date)dateMiseEnLigneSansHeure, (int)((int)heureEnMinutes)).getTime());
                }
                meta.setMetaDateMiseEnLigne(dateCreation);
            }
            if (infoBean.get("FORUM") != null) {
                meta.setMetaForum((String)infoBean.get("FORUM"));
            }
            if (infoBean.get("FORUM_ANO") != null) {
                meta.setMetaForumAno((String)infoBean.get("FORUM_ANO"));
            }
            if (infoBean.get("DOCUMENT_FICHIERGW") != null) {
                meta.setMetaDocumentFichiergw((String)infoBean.get("DOCUMENT_FICHIERGW"));
            }
            if (codeEspaceCollaboratif.length() > 0 && infoBean.get("ENVOI_MAIL") != null) {
                meta.setMetaNotificationMail((String)infoBean.get("ENVOI_MAIL"));
            }
            if (infoBean.get("MAIL_ANONYME") != null) {
                meta.setMetaMailAnonyme((String)infoBean.get("MAIL_ANONYME"));
            }
            if (infoBean.get("SAISIE_FRONT") != null) {
                meta.setMetaSaisieFront("1");
            }
        }
        String typeEnregistrementMeta = "";
        Date date = new Date(System.currentTimeMillis());
        ficheUniv.setDateModification(date);
        if ("SUPPRIMER".equals(action)) {
            if (autorisations == null || !autorisations.estAutoriseASupprimerLaFiche(ficheUniv)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_SUPPRESSION_PERIMETRE"));
            }
            ficheUniv.setEtatObjet("0004");
            ficheUniv.update();
            meta.addHistorique(Metatag.HISTORIQUE_SUPPRESSION, ControleurUniv.getCodeAuteur(processus), "0004");
            meta.synchroniser(ficheUniv, true);
            FicheUnivMgr.enregistrerMeta(meta);
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_FICHE"), ficheUniv.getLibelleAffichable());
            infoBean.addMessageConfirmation(confirmation);
        } else if ("ARCHIVER".equals(action)) {
            ficheUniv.setEtatObjet("0007");
            ficheUniv.update();
            meta.setMetaDateArchivage(new Date(0L));
            meta.addHistorique(Metatag.HISTORIQUE_ARCHIVAGE, ControleurUniv.getCodeAuteur(processus), "0007");
            meta.synchroniser(ficheUniv, true);
            if (infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION") != null) {
                meta.setMetaRubriquesPublication(infoBean.getString("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION"));
            }
            FicheUnivMgr.enregistrerMeta(meta);
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_ARCHIVER_FICHE"), ficheUniv.getLibelleAffichable());
            infoBean.addMessageConfirmation(confirmation);
        } else if ("ANNULER_SUPPRESSION".equals(action) || "RESTAURER_SAUVEGARDE".equals(action) || "RESTAURER_ARCHIVE".equals(action)) {
            String restauration = (String)infoBean.get("RESTAURATION");
            if ("NOUVELLE_FICHE".equals(restauration)) {
                ficheUniv.setCode(Long.toString(System.currentTimeMillis()));
            } else if ("REMPLACER_BROUILLON".equals(restauration)) {
                FicheUniv ficheUniv2 = (FicheUniv)ficheUniv.getClass().newInstance();
                ficheUniv2.setCtx(processus);
                if (ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0001") > 0) {
                    ficheUniv2.nextItem();
                    FicheUnivMgr.supprimerFiche(ficheUniv2, true);
                }
            }
            ficheUniv.setEtatObjet("0001");
            ficheUniv.update();
            meta.addHistorique(Metatag.HISTORIQUE_RESTAURATION_ARCHIVAGE, ControleurUniv.getCodeAuteur(processus), "0001");
            meta.setMetaNiveauApprobation("");
            meta.synchroniser(ficheUniv, true);
            FicheUnivMgr.enregistrerMeta(meta);
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_RESTAURER_FICHE"), ficheUniv.getLibelleAffichable());
            infoBean.addMessageConfirmation(confirmation);
        } else if ("DUPLIQUER".equals(action)) {
            if (autorisations == null || !autorisations.getAutorisationParFiche(ficheUniv, 0)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_AJOUT_PERIMETRE"));
            }
            FicheUniv ficheUnivOrigine = (FicheUniv)ficheUniv.getClass().newInstance();
            ficheUnivOrigine.setCtx(processus);
            ficheUnivOrigine.init();
            ficheUnivOrigine.setIdFiche(ficheUniv.getIdFiche());
            ficheUnivOrigine.retrieve();
            FicheUnivMgr.dupliquer(ficheUniv);
            ficheUniv.setIdFiche(0L);
            ficheUniv.setCode(Long.toString(System.currentTimeMillis()));
            ficheUniv.setCodeRedacteur(autorisations.getCode());
            ficheUniv.add();
            if (infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION") != null) {
                listeRubPub = new Vector<String>();
                for (String aRubPub : rubPub = infoBean.getString("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION").split(";", -2)) {
                    if (aRubPub.startsWith("#AUTO#")) continue;
                    listeRubPub.add(aRubPub);
                }
                InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                infosFiche.setCode(ficheUniv.getCode());
                infosFiche.setLangue(ficheUniv.getLangue());
                infosFiche.setType(ReferentielObjets.getCodeObjet(ficheUniv));
                Rubriquepublication.enregistrerRubriquePublicationFiche(processus, infosFiche, listeRubPub);
            }
            saveMetaForum = meta.getMetaForum();
            saveMetaForumAno = meta.getMetaForumAno();
            String saveMetaInTree = meta.getMetaInTree();
            meta = FicheUnivMgr.creerMeta(ficheUniv);
            if (infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION") != null) {
                meta.setMetaRubriquesPublication(infoBean.getString("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION"));
            }
            meta.addHistorique(Metatag.HISTORIQUE_DUPLICATION, ControleurUniv.getCodeAuteur(processus), "0001");
            meta.setMetaForum(saveMetaForum);
            meta.setMetaForumAno(saveMetaForumAno);
            meta.setMetaInTree(saveMetaInTree);
            if (StringUtils.isNotEmpty((CharSequence)infoBean.getString("DOCUMENT_FICHIERGW"))) {
                meta.setMetaDocumentFichiergw((String)infoBean.get("DOCUMENT_FICHIERGW"));
            }
            FicheUnivMgr.enregistrerMeta(meta);
            PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
            infoBean.setEtatObjet("MODIFICATION");
            infoBean.addMessageConfirmation("Fiche dupliqu\u00e9e");
            infoBean.set("GRS_LIBELLE_COPIE", "Copie");
            ecranLogique = "PRINCIPAL";
            processus.preparerPRINCIPAL();
        } else if ("TRADUIRE".equals(action)) {
            if (autorisations == null || !autorisations.getAutorisationParFiche(ficheUniv, 1)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_TRADUCTION_PERIMETRE"));
            }
            if (StringUtils.isEmpty((CharSequence)infoBean.getString("AUTRE_LANGUE")) || "0000".equals(infoBean.getString("AUTRE_LANGUE"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_SAISIR_LANGUE"));
            }
            FicheUniv ficheUnivOrigine = (FicheUniv)ficheUniv.getClass().newInstance();
            ficheUnivOrigine.setCtx(processus);
            ficheUnivOrigine.init();
            ficheUnivOrigine.setIdFiche(ficheUniv.getIdFiche());
            ficheUnivOrigine.retrieve();
            ficheUniv.setCodeRedacteur(autorisations.getCode());
            ficheUniv.dupliquer(infoBean.getString("AUTRE_LANGUE"));
            Ressource.dupliquerListeFichier(ficheUnivOrigine, ficheUniv);
            if (infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION") != null) {
                listeRubPub = new Vector();
                for (String aRubPub : rubPub = infoBean.getString("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION").split(";", -2)) {
                    if (aRubPub.startsWith("#AUTO#")) continue;
                    listeRubPub.add(aRubPub);
                }
                InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                infosFiche.setCode(ficheUniv.getCode());
                infosFiche.setLangue(ficheUniv.getLangue());
                infosFiche.setType(ReferentielObjets.getCodeObjet(ficheUniv));
                Rubriquepublication.enregistrerRubriquePublicationFiche(processus, infosFiche, listeRubPub);
            }
            saveMetaForum = meta.getMetaForum();
            saveMetaForumAno = meta.getMetaForumAno();
            String[] saveMetaInTree = meta.getMetaInTree();
            meta.getIdMetatag();
            meta = FicheUnivMgr.creerMeta(ficheUniv);
            meta.addHistorique(Metatag.HISTORIQUE_TRADUCTION, ControleurUniv.getCodeAuteur(processus), "0001");
            meta.setMetaForum(saveMetaForum);
            meta.setMetaForumAno(saveMetaForumAno);
            meta.setMetaInTree((String)saveMetaInTree);
            FicheUnivMgr.enregistrerMeta(meta);
            PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
            infoBean.setEtatObjet("MODIFICATION");
            ecranLogique = "PRINCIPAL";
            infoBean.addMessageConfirmation("Fiche dupliqu\u00e9e en " + LangueUtil.getDisplayName(infoBean.getString("AUTRE_LANGUE")));
            infoBean.set("GRS_LIBELLE_COPIE", "Traduction");
            processus.preparerPRINCIPAL();
        } else if (action.equals("ENREGISTRER")) {
            Date infoBeanDateArchivage;
            String dateSauvegardeArchivage;
            String dateArchivage;
            Date infoBeanDateSuppression;
            String dateSauvegardeSuppression;
            String dateSuppression;
            String codeRedacteurPrecedent = ficheUniv.getCodeRedacteur();
            if (infoBean.get("CODE_REDACTEUR") != null) {
                ficheUniv.setCodeRedacteur(infoBean.getString("CODE_REDACTEUR"));
            }
            if (infoBean.getEtatObjet().equals("CREATION")) {
                ficheUniv.setCodeRedacteur((String)processus.getGp().getSessionUtilisateur().getInfos().get("CODE"));
                if ("1".equals(meta.getMetaSaisieFront()) && ficheUniv.getCodeRedacteur() == null) {
                    ficheUniv.setCodeRedacteur("ANONYME");
                }
            }
            if (ficheUniv.getCodeRedacteur() == null) {
                ficheUniv.setCodeRedacteur("");
            }
            if (infoBean.get("DATE_ALERTE") != null) {
                ficheUniv.setDateAlerte((Date)infoBean.get("DATE_ALERTE"));
            }
            if (infoBean.get("MESSAGE_ALERTE") != null) {
                ficheUniv.setMessageAlerte((String)infoBean.get("MESSAGE_ALERTE"));
            }
            if (infoBean.get("META_KEYWORDS") != null) {
                ficheUniv.setMetaKeywords((String)infoBean.get("META_KEYWORDS"));
            }
            if (infoBean.get("META_DESCRIPTION") != null) {
                ficheUniv.setMetaDescription((String)infoBean.get("META_DESCRIPTION"));
            }
            if (infoBean.get("CONTENU_ENCADRE") != null) {
                ficheUniv.setContenuEncadre((String)infoBean.get("CONTENU_ENCADRE"));
            }
            if (infoBean.get("ENCADRE_RECHERCHE") != null) {
                ficheUniv.setEncadreRecherche((String)infoBean.get("ENCADRE_RECHERCHE"));
                ficheUniv.setEncadreRechercheBis((String)infoBean.get("ENCADRE_RECHERCHE_BIS"));
            } else {
                ficheUniv.setEncadreRecherche("");
                ficheUniv.setEncadreRechercheBis("");
            }
            String activationDsi = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("dsi.activation"), (String)"0");
            if ("1".equals(activationDsi) && ficheUniv instanceof DiffusionSelective && autorisations != null && (autorisations.isDiffuseurDSI() || "4".equals(infoBean.get("DIFFUSION_MODE_RESTRICTION")))) {
                DiffusionSelective ficheDiffusion = (DiffusionSelective)((Object)ficheUniv);
                if (infoBean.getString("PUBLIC_VISE_DSI") != null) {
                    ficheDiffusion.setDiffusionPublicVise(ControleurUniv.formaterPublicViseDsiPourEnregistrement(infoBean.getString("PUBLIC_VISE_DSI")));
                    if (infoBean.getString("DIFFUSION_MODE_RESTRICTION") != null && infoBean.getString("DIFFUSION_MODE_RESTRICTION").length() > 0) {
                        if ("2".equals(infoBean.getString("DIFFUSION_MODE_RESTRICTION")) && "".equals(infoBean.getString("PUBLIC_VISE_DSI"))) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_SAISIR_PUBLICS_VISES"));
                        }
                        if ("3".equals(infoBean.getString("DIFFUSION_MODE_RESTRICTION")) && "".equals(infoBean.getString("PUBLIC_VISE_DSI_RESTRICTION"))) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_SAISIR_PUBLICS_AUTORISES"));
                        }
                        ficheDiffusion.setDiffusionModeRestriction(infoBean.getString("DIFFUSION_MODE_RESTRICTION"));
                    }
                }
                if (infoBean.getString("PUBLIC_VISE_DSI_RESTRICTION") != null) {
                    if ("4".equals(infoBean.get("DIFFUSION_MODE_RESTRICTION"))) {
                        ficheDiffusion.setDiffusionPublicVise("");
                        ficheDiffusion.setDiffusionPublicViseRestriction(infoBean.getString("PUBLIC_VISE_ESPACE"));
                    } else {
                        ficheDiffusion.setDiffusionPublicViseRestriction(ControleurUniv.formaterPublicViseDsiPourEnregistrement(infoBean.getString("PUBLIC_VISE_DSI_RESTRICTION")));
                    }
                }
            }
            if (infoBean.get("DATE_RUBRIQUAGE") != null && infoBean.get("CODE_RUBRIQUAGE") != null) {
                String dateRubriquage = Formateur.formater(infoBean.get("DATE_RUBRIQUAGE"));
                String codeRubriquage = Formateur.formater(infoBean.get("CODE_RUBRIQUAGE"));
                String dateSauvegardeRubriquage = Formateur.formater(infoBean.get("GRS_SAUVEGARDE_DATE_RUBRIQUAGE"));
                String codeSauvegardeRubriquage = infoBean.getString("GRS_SAUVEGARDE_CODE_RUBRIQUAGE");
                if (!dateSauvegardeRubriquage.equals(dateRubriquage) || !codeSauvegardeRubriquage.equals(codeRubriquage)) {
                    if (Formateur.estSaisie((Date)infoBean.get("DATE_RUBRIQUAGE"))) {
                        if (infoBean.getString("CODE_RUBRIQUAGE").length() == 0) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_SAISIR_RUBRIQUE_DESTINATION"));
                        }
                    } else if (infoBean.getString("CODE_RUBRIQUAGE").length() > 0) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_SAISIR_DATE_RUBRIQUAGE"));
                    }
                    String codeRubriqueInitial = ficheUniv.getCodeRubrique();
                    ficheUniv.setCodeRubrique(infoBean.getString("CODE_RUBRIQUAGE"));
                    if (autorisations == null || !autorisations.estAutoriseAModifierLaFiche(ficheUniv, false)) {
                        ficheUniv.setCodeRubrique(codeRubriqueInitial);
                        infoBean.set("DATE_RUBRIQUAGE", infoBean.get("GRS_SAUVEGARDE_DATE_RUBRIQUAGE"));
                        infoBean.set("CODE_RUBRIQUAGE", infoBean.get("GRS_SAUVEGARDE_CODE_RUBRIQUAGE"));
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_RUBRIQUAGE_PERIMETRE"));
                    }
                    ficheUniv.setCodeRubrique(codeRubriqueInitial);
                }
                meta.setMetaDateRubriquage((Date)infoBean.get("DATE_RUBRIQUAGE"));
                meta.setMetaCodeRubriquage(infoBean.getString("CODE_RUBRIQUAGE"));
            }
            if (!(dateSuppression = Formateur.formater(infoBean.get("DATE_SUPPRESSION"))).equals(dateSauvegardeSuppression = Formateur.formater(infoBean.get("GRS_SAUVEGARDE_DATE_SUPPRESSION")))) {
                if (autorisations == null || !autorisations.estAutoriseASupprimerLaFiche(ficheUniv, false)) {
                    infoBean.set("DATE_SUPPRESSION", infoBean.get("GRS_SAUVEGARDE_DATE_SUPPRESSION"));
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_DATE_SUPPESSION_PERIMETRE"));
                }
                if (ControleurUniv.isDateApresAujourdhui((Date)infoBean.get("DATE_SUPPRESSION"))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_INVALIDE_DATE_SUPPRESSION"));
                }
            }
            if ((infoBeanDateSuppression = infoBean.getDate("DATE_SUPPRESSION")) != null) {
                meta.setMetaDateSuppression(infoBeanDateSuppression);
            }
            if (!(dateArchivage = Formateur.formater(infoBean.get("DATE_ARCHIVAGE"))).equals(dateSauvegardeArchivage = Formateur.formater(infoBean.get("GRS_SAUVEGARDE_DATE_ARCHIVAGE")))) {
                if (autorisations == null || !autorisations.estAutoriseASupprimerLaFiche(ficheUniv, false)) {
                    infoBean.set("DATE_ARCHIVAGE", infoBean.get("GRS_SAUVEGARDE_DATE_ARCHIVAGE"));
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_DATE_ARCHIVAGE_PERIMETRE"));
                }
                if (ControleurUniv.isDateApresAujourdhui((Date)infoBean.get("DATE_ARCHIVAGE"))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_INVALIDE_DATE_ARCHIVAGE"));
                }
            }
            if ((infoBeanDateArchivage = infoBean.getDate("DATE_ARCHIVAGE")) != null) {
                meta.setMetaDateArchivage(infoBeanDateArchivage);
            }
            if ("1".equals(infoBean.getString("APERCU"))) {
                if (!infoBean.getEtatObjet().equals("CREATION")) {
                    Long idMetaFicheEnLigne = meta.getIdMetatag();
                    if (!"0006".equals(ficheUniv.getEtatObjet())) {
                        FicheUniv ficheUniv2 = (FicheUniv)ficheUniv.getClass().newInstance();
                        ficheUniv2.setCtx(processus);
                        if (ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0006") > 0) {
                            while (ficheUniv2.nextItem()) {
                                ficheUniv2.setMessageAlerte("destruction_sauvegarde_courante");
                                FicheUnivMgr.supprimerFiche(ficheUniv2, true);
                            }
                        }
                        ficheUniv.setIdFiche(0L);
                        ficheUniv.setEtatObjet("0006");
                        ficheUniv.add();
                        meta.setIdMetatag(0L);
                        meta.setMetaIdFiche(ficheUniv.getIdFiche());
                        meta.setMetaEtatObjet("0006");
                        meta.synchroniser(ficheUniv, true);
                        if (infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION") != null) {
                            meta.setMetaRubriquesPublication(infoBean.getString("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION"));
                        }
                        FicheUnivMgr.enregistrerMeta(meta);
                        PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
                    }
                    if (ficheEnLigneAvantTraitement != null) {
                        meta.setMetaNbHits(idMetaFicheEnLigne);
                    }
                }
                ficheUniv.setIdFiche(0L);
                ficheUniv.setEtatObjet("0005");
                ficheUniv.add();
                meta.setIdMetatag(0L);
                meta.setMetaIdFiche(ficheUniv.getIdFiche());
                meta.setMetaEtatObjet(EtatFiche.APERCU.getEtat());
                meta.setMetaLangue(ficheUniv.getLangue());
                infoBean.set("CODE", ficheUniv.getCode());
                infoBean.set("LANGUE", ficheUniv.getLangue());
                infoBean.setEcranLogique("APERCU");
                FicheUnivMgr.enregistrerMeta(meta);
                infoBean.set("ID_METATAG", meta.getIdMetatag().toString());
                PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
                ControleurUniv.gestionRedirectionPourApercu(infoBean);
                return "APERCU";
            }
            String typeEnregistrement = "";
            if (infoBean.get("TYPE_ENREGISTREMENT") != null) {
                typeEnregistrement = infoBean.getString("TYPE_ENREGISTREMENT");
            }
            boolean retourValidation = false;
            if ("3".equals(typeEnregistrement)) {
                retourValidation = true;
            }
            boolean demandeMiseEnLigne = false;
            boolean validationApprobation = false;
            String niveauApprobationCourant = meta.getMetaNiveauApprobation();
            if ("2".equals(typeEnregistrement)) {
                if ("".equals(niveauApprobationCourant)) {
                    miseEnLigne = true;
                } else {
                    validationApprobation = true;
                    demandeMiseEnLigne = true;
                }
            }
            boolean annulerDemandeValidation = ControleurUniv.lireFlag(infoBean.getString("ANNULER_DEMANDE_VALIDATION"));
            boolean modeBrouillon = false;
            if (infoBean.get("MODE_BROUILLON") != null && "1".equals(infoBean.getString("MODE_BROUILLON"))) {
                modeBrouillon = true;
                meta.setMetaNiveauApprobation("");
            }
            boolean bl = demandeMiseEnLigne = !modeBrouillon && !retourValidation && ("0001".equals(ficheUniv.getEtatObjet()) || "0003".equals(ficheUniv.getEtatObjet()) || "0002".equals(ficheUniv.getEtatObjet()) && demandeMiseEnLigne);
            if (demandeMiseEnLigne && autorisations != null) {
                String niveauApprobationDemande = "";
                if (infoBean.get("NIVEAU_APPROBATION_DEMANDE") != null) {
                    niveauApprobationDemande = infoBean.getString("NIVEAU_APPROBATION_DEMANDE");
                }
                if (niveauApprobationDemande.length() == 0) {
                    int indice = 3;
                    if ("4".equals(infoBean.get("DIFFUSION_MODE_RESTRICTION"))) {
                        indice = 5;
                    }
                    if (autorisations.getAutorisationParFiche(ficheUniv, indice, meta.getMetaNiveauApprobation())) {
                        miseEnLigne = true;
                        demandeMiseEnLigne = false;
                    } else if (autorisations.getAutorisationParFiche(ficheUniv, 6) && (infoBean.getEtatObjet().equals("CREATION") || codeRedacteurPrecedent.equals(autorisations.getCode()))) {
                        miseEnLigne = true;
                        demandeMiseEnLigne = false;
                    }
                } else {
                    if (!autorisations.estAutoriseADemanderApprobation(ficheUniv, meta.getMetaNiveauApprobation(), niveauApprobationDemande)) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_APPROBATION_PERIMETRE"));
                    }
                    if (!MailUtil.controlerListeValidateur(processus, ficheUniv, infoBean.getString("LISTE_VALIDATEURS"), niveauApprobationDemande)) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_VALIDATEUR_PERIMETRE"));
                    }
                }
                if (!Validation.hasUserAuthorizedNextLevel(autorisations.getNiveauApprobation(), ficheUniv)) {
                    throw new ErreurApplicative(String.format(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_AUCUN_VALIDATEUR"), Validation.getLibelleAprobationParCodeNiveau(autorisations.getNiveauApprobation())));
                }
                if (!miseEnLigne) {
                    meta.setMetaNiveauApprobation(autorisations.getNiveauApprobation());
                }
            }
            if (autorisations != null) {
                if (infoBean.getEtatObjet().equals("CREATION")) {
                    String anonyme;
                    boolean ano = false;
                    if (infoBean.get("SAISIE_FRONT") != null && "1".equals(anonyme = PropertyHelper.getExtensionProperty(infoBean.getNomExtension(), ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv)) + ".anonyme"))) {
                        ano = true;
                    }
                    if (!autorisations.getAutorisationParFiche(ficheUniv, 0) && !ano) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_CREATION_PERIMETRE"));
                    }
                }
                if (infoBean.getEtatObjet().equals("MODIFICATION") && !retourValidation && !miseEnLigne && !validationApprobation) {
                    boolean effectuerControle = true;
                    if (autorisations.getCode().equals(ficheUniv.getCodeRedacteur()) && ficheUniv.getCodeRedacteur().equals(codeRedacteurPrecedent)) {
                        effectuerControle = modificationPerimetre;
                    }
                    if (effectuerControle && !autorisations.estAutoriseAModifierLaFiche(ficheUniv, false)) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_MODIFICATION_RUBRIQUE_STRUCTURE"));
                    }
                }
                if (retourValidation || miseEnLigne || validationApprobation) {
                    boolean droitsMiseEnLigne = false;
                    if (autorisations.getAutorisationParFiche(ficheUniv, 6) && (codeRedacteurPrecedent.equals(autorisations.getCode()) || infoBean.getEtatObjet().equals("CREATION"))) {
                        droitsMiseEnLigne = true;
                    }
                    if (autorisations.getAutorisationParFiche(ficheUniv, 5, niveauApprobationCourant)) {
                        droitsMiseEnLigne = true;
                    }
                    if (!droitsMiseEnLigne) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_VALIDATION_RUBRIQUE_STRUCTURE"));
                    }
                }
            }
            if (infoBean.getEtatObjet().equals("CREATION")) {
                ficheUniv.setDateCreation(date);
                ficheUniv.setDateProposition(date);
            }
            if ("0003".equals(ficheUniv.getEtatObjet()) && !miseEnLigne) {
                if (ficheUniv.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0001") > 0 && !modeBrouillon) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_BROUILLON_DOUBLON"));
                }
                FicheUnivMgr.creerVersionTravail(ficheUniv);
                meta.setIdMetatag(0L);
                meta.setMetaEtatObjet(ficheUniv.getEtatObjet());
                typeEnregistrementMeta = Metatag.HISTORIQUE_CREATION;
            }
            if (retourValidation && miseEnLigne) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_ENLIGNE_RENVOYEE"));
            }
            if (demandeMiseEnLigne && (StringUtils.isEmpty((CharSequence)ficheUniv.getEtatObjet()) || !ficheUniv.getEtatObjet().equals("0002"))) {
                try (ContexteDao ctx = new ContexteDao();){
                    ficheUniv.setCtx(ctx);
                    if (ficheUniv.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0002") > 0) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_A_VALIDER_DOUBLON"));
                    }
                }
                typeEnregistrementMeta = Metatag.HISTORIQUE_DEMANDE_VALIDATION;
                ficheUniv.setEtatObjet("0002");
                ficheUniv.setDateProposition(date);
                infoBean.addMessageConfirmation(MessageHelper.getCoreMessage("ST_FRONT_AVALIDER"));
            }
            if (annulerDemandeValidation) {
                FicheUniv ficheUniv2 = (FicheUniv)ficheUniv.getClass().newInstance();
                ficheUniv2.setCtx(processus);
                if (ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0001") > 0) {
                    ficheUniv2.nextItem();
                    FicheUnivMgr.supprimerFiche(ficheUniv2, true);
                }
                typeEnregistrementMeta = Metatag.HISTORIQUE_ANNULATION_DEMANDE_VALIDATION;
                meta.setMetaNiveauApprobation("");
                ficheUniv.setEtatObjet("0001");
                ficheUniv.setDateProposition(new Date(0L));
            }
            if (retourValidation) {
                MailUtil.envoyerMailRetourValidation(infoBean, ficheUniv, meta, false);
                typeEnregistrementMeta = Metatag.HISTORIQUE_RETOUR_AUTEUR;
                ficheUniv.setEtatObjet("0001");
                meta.setMetaNiveauApprobation("");
            }
            if (miseEnLigne) {
                if ("0002".equals(ficheUniv.getEtatObjet())) {
                    typeEnregistrementMeta = Metatag.HISTORIQUE_VALIDATION;
                    retourValidation = true;
                }
                ficheUniv.setCodeValidation((String)processus.getGp().getSessionUtilisateur().getInfos().get("CODE"));
                ficheUniv.setDateValidation(date);
            }
            if ("CREATION".equals(infoBean.getEtatObjet())) {
                if (typeEnregistrementMeta.length() == 0) {
                    typeEnregistrementMeta = Metatag.HISTORIQUE_CREATION;
                }
                FicheUnivMgr.enregistrer(true, ficheUniv);
            }
            if ("MODIFICATION".equals(infoBean.getEtatObjet())) {
                if (typeEnregistrementMeta.length() == 0) {
                    typeEnregistrementMeta = Metatag.HISTORIQUE_MODIFICATION;
                }
                FicheUnivMgr.enregistrer(false, ficheUniv);
            }
            if (infoBean.get("GRS_SAISIE_PUBLICATION") != null && "1".equals(infoBean.get("GRS_SAISIE_PUBLICATION"))) {
                if (miseEnLigne) {
                    Set listRubriqueAdd;
                    Vector<String> listeRubriquesAutomatiques;
                    Vector<String> listeRubriques = Chaine.getVecteurPointsVirgules(infoBean.getString("RUBRIQUE_PUBLICATION"));
                    if (!listeRubriques.containsAll(listeRubriquesAutomatiques = Chaine.getVecteurPointsVirgules(infoBean.getString("RUBRIQUE_PUBLICATION_AUTOMATIQUE")))) {
                        infoBean.set("RUBRIQUE_PUBLICATION", infoBean.get("GRS_SAUVEGARDE_RUBRIQUE_PUBLICATION"));
                        infoBean.set("LIBELLE_RUBRIQUE_PUBLICATION", infoBean.get("GRS_SAUVEGARDE_LIBELLE_RUBRIQUE_PUBLICATION"));
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_IMPOSSIBLE_SUPPRIMER_RUBPUB"));
                    }
                    listeRubriques.removeAll(listeRubriquesAutomatiques);
                    if (infoBean.get("RUBRIQUE_PUBLICATION_HORS_PERIMETRE") != null && CollectionUtils.isNotEmpty((Collection)(listRubriqueAdd = infoBean.get("RUBRIQUE_PUBLICATION_HORS_PERIMETRE", Set.class)))) {
                        listeRubriques.addAll(listRubriqueAdd);
                    }
                    InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                    infosFiche.setCode(ficheUniv.getCode());
                    infosFiche.setLangue(ficheUniv.getLangue());
                    infosFiche.setType(ReferentielObjets.getCodeObjet(ficheUniv));
                    Rubriquepublication.enregistrerRubriquePublicationFiche(processus, infosFiche, listeRubriques);
                    meta.setMetaRubriquesPublication("");
                } else {
                    Set listRubriquePublicationHorsPerimetre;
                    String rubriquePublication = infoBean.getString("RUBRIQUE_PUBLICATION");
                    if (infoBean.get("RUBRIQUE_PUBLICATION_HORS_PERIMETRE") != null && CollectionUtils.isNotEmpty((Collection)(listRubriquePublicationHorsPerimetre = infoBean.get("RUBRIQUE_PUBLICATION_HORS_PERIMETRE", Set.class)))) {
                        if (StringUtils.isNotBlank((CharSequence)rubriquePublication)) {
                            rubriquePublication = rubriquePublication + ";";
                        }
                        rubriquePublication = rubriquePublication + StringUtils.join((Iterable)listRubriquePublicationHorsPerimetre, (String)";");
                    }
                    meta.setMetaRubriquesPublication(rubriquePublication);
                }
            }
            if (miseEnLigne) {
                Long idMetaFicheEnLigne = FicheUnivMgr.mettreEnLigne(ficheUniv, ficheEnLigneAvantTraitement);
                if (idMetaFicheEnLigne != 0L && !meta.getIdMetatag().equals(idMetaFicheEnLigne)) {
                    try (ContexteDao ctx = new ContexteDao();){
                        meta.setCtx(ctx);
                        meta.delete();
                    }
                    meta.setIdMetatag(idMetaFicheEnLigne);
                }
                if (typeEnregistrementMeta.length() == 0) {
                    typeEnregistrementMeta = Metatag.HISTORIQUE_MODIFICATION;
                }
                meta.addHistorique(typeEnregistrementMeta, ControleurUniv.getCodeAuteur(processus), ficheUniv.getEtatObjet());
                meta.synchroniser(ficheUniv, true);
                FicheUnivMgr.enregistrerMeta(meta);
                PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
                if (retourValidation) {
                    MailUtil.envoyerMailRetourValidation(infoBean, ficheUniv, meta, true);
                }
                MailUtil.envoyerMailNotification(infoBean, ficheUniv, meta);
            } else {
                if (typeEnregistrementMeta.length() == 0) {
                    typeEnregistrementMeta = Metatag.HISTORIQUE_MODIFICATION;
                }
                meta.addHistorique(typeEnregistrementMeta, ControleurUniv.getCodeAuteur(processus), ficheUniv.getEtatObjet());
                meta.synchroniser(ficheUniv, true);
                FicheUnivMgr.enregistrerMeta(meta);
                PluginFicheHelper.traiterPrincipal(infoBean, ficheUniv, meta);
            }
            if (demandeMiseEnLigne) {
                MailUtil.envoyerMailDemandeValidation(infoBean, ficheUniv, meta);
            }
            FicheUniv ficheUniv3 = (FicheUniv)ficheUniv.getClass().newInstance();
            ficheUniv3.setCtx(processus);
            if (ficheUniv3.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0006") > 0) {
                while (ficheUniv3.nextItem()) {
                    FicheUnivMgr.supprimerFiche(ficheUniv3, true);
                }
            }
            ControleurUniv.ajouterConfirmationApresEnregistrement(infoBean, ficheUniv, miseEnLigne);
        }
        FicheUniv ficheEnLigneApresTraitement = (FicheUniv)ficheUniv.getClass().newInstance();
        ficheEnLigneApresTraitement.init();
        ficheEnLigneApresTraitement.setCtx(processus);
        if (ficheEnLigneApresTraitement.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "0003") > 0) {
            ficheEnLigneApresTraitement.nextItem();
        } else {
            ficheEnLigneApresTraitement = null;
        }
        if (ficheEnLigneAvantTraitement == null && ficheEnLigneApresTraitement != null) {
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
        } else if (ficheEnLigneAvantTraitement != null && ficheEnLigneApresTraitement != null && ControleurUniv.perimetreModifie(ficheEnLigneAvantTraitement, ficheEnLigneApresTraitement)) {
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
        } else if (ficheEnLigneAvantTraitement != null && ficheEnLigneApresTraitement == null) {
            PluginFicheHelper.synchroniserObjets(ficheUniv, meta, null);
        }
        if (ficheUniv instanceof StructureModele && (action.equals("ENREGISTRER") || action.equals("SUPPRIMER"))) {
            Structure.forcerRechargement();
            SynchroGroupedsiStructure.synchroniserGroupeDsi(processus, (StructureModele)ficheUniv);
        }
        PluginFicheHelper.postTraiterPrincipal(infoBean, ficheUniv, meta);
        infoBean.set("ETAT_FICHE_ENREGISTREE", ficheUniv.getEtatObjet());
        LOG.debug("ETAT FICHE : " + infoBean.get("ETAT_FICHE_ENREGISTREE"));
        if (LogStats.isLogStats() && ("ENREGISTRER".equals(action) || "SUPPRIMER".equals(action))) {
            HashMap<String, String> mapInfosContrib = new HashMap<String, String>(7);
            mapInfosContrib.put("%adresseip", infoBean.getString("#remote-addr"));
            mapInfosContrib.put("%ksession", (String)sessionUtilisateur.getInfos().get("KSESSION"));
            mapInfosContrib.put("%profildsi", (String)sessionUtilisateur.getInfos().get("PROFIL_DSI"));
            mapInfosContrib.put("%ifsaisie", infoBean.get("SAISIE_FRONT") != null ? "FO" : "BO");
            mapInfosContrib.put("%libelleobjet", ReferentielObjets.getLibelleObjet(ReferentielObjets.getCodeObjet(ficheUniv)));
            mapInfosContrib.put("%actionobjet", infoBean.getEtatObjet());
            mapInfosContrib.put("%libellerub", Rubrique.renvoyerItemRubrique(ficheUniv.getCodeRubrique()).getLibelleAffichable());
            LogStats.log(processus, "contrib", mapInfosContrib);
        }
        if (!FicheUnivMgr.isFicheCollaborative(ficheUniv)) {
            ControleurUniv.gestionRedirectionApresEnregistrement(infoBean);
        }
        return ecranLogique;
    }

    private static boolean isDateApresAujourdhui(Date dateAVerifier) {
        GregorianCalendar calendrierSuppression = new GregorianCalendar();
        calendrierSuppression.setTime(dateAVerifier);
        Calendar maintenant = DateUtils.truncate((Calendar)new GregorianCalendar(), (int)5);
        return Formateur.estSaisie(dateAVerifier) && maintenant.after(calendrierSuppression);
    }

    private static void ajouterConfirmationApresEnregistrement(InfoBean infoBean, FicheUniv ficheUniv, boolean isMiseEnLigne) {
        infoBean.removeMessage(TypeMessage.CONFIRMATION.getCode());
        String messageConfirmation = "";
        if (isMiseEnLigne) {
            messageConfirmation = MessageHelper.getCoreMessage("CONFIRMATION_MISE_EN_LIGNE_FICHE");
        } else if ("CREATION".equals(infoBean.getEtatObjet())) {
            messageConfirmation = MessageHelper.getCoreMessage("CONFIRMATION_CREATION_FICHE");
        } else if ("MODIFICATION".equals(infoBean.getEtatObjet())) {
            messageConfirmation = MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_FICHE");
        }
        if (StringUtils.isNotBlank((CharSequence)messageConfirmation)) {
            String confirmation = String.format(messageConfirmation, ficheUniv.getLibelleAffichable());
            infoBean.addMessageConfirmation(confirmation);
        }
    }

    private static void gestionRedirectionApresEnregistrement(InfoBean infoBean) throws Exception {
        StringBuilder urlRedirect = new StringBuilder("/servlet/com.jsbsoft.jtf.core.SG");
        urlRedirect.append("?PROC=");
        urlRedirect.append(infoBean.getNomProcessus());
        String action = infoBean.getActionUtilisateur();
        if (infoBean.getSessionHttp().getAttribute("CURRENT_SEARCH_PARAMS") != null) {
            urlRedirect.append("&").append(URLEncoder.encode("#ECRAN_LOGIQUE#", "UTF-8")).append("=RECHERCHE&").append(URLEncoder.encode("#ETAT#", "UTF-8")).append("=RECHERCHE&RECHERCHE_ETENDUE=OUI&SEARCH_PARAMS=IN_CACHE");
            if (infoBean.get("PAGE") != null) {
                urlRedirect.append("&PAGE=").append(infoBean.getString("PAGE"));
            }
        } else if ("ANNULER_SUPPRESSION".equals(action) || "RESTAURER_SAUVEGARDE".equals(action) || "RESTAURER_ARCHIVE".equals(action)) {
            urlRedirect.append("&ACTION=MODIFIER&ID_FICHE=").append(infoBean.getString("ID_FICHE"));
        } else {
            urlRedirect.append("&ACTION=ACCUEIL");
        }
        if (infoBean.get("ECRANVALIDER") != null) {
            urlRedirect = new StringBuilder("/servlet/com.jsbsoft.jtf.core.SG");
            urlRedirect.append("?PROC=VALIDATION&ACTION=LISTE");
        }
        if (infoBean.get("ETAT_FICHE_ENREGISTREE") != null) {
            urlRedirect.append("&ETAT_FICHE_ENREGISTREE=").append(EscapeString.escapeURL(infoBean.getString("ETAT_FICHE_ENREGISTREE")));
        }
        infoBean.setEcranRedirection(urlRedirect.toString());
    }

    private static void gestionRedirectionPourApercu(InfoBean infoBean) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String urlApercu = UrlManager.calculerUrlApercu(infoBean.getString("ID_METATAG"));
        String rubrique = infoBean.getString("CODE_RUBRIQUE");
        if (StringUtils.isEmpty((CharSequence)rubrique)) {
            rubrique = infoBean.getString("RH");
        }
        urlApercu = URLResolver.getAbsoluteUrl(urlApercu, (OMContext)ctx, Site.determinerSiteRubrique(rubrique));
        infoBean.setEcranRedirection(urlApercu);
    }

    public static void formaterPublicViseDsiDansInfoBean(InfoBean infoBean, OMContext ctx, String publicViseDsiEnregistre, String nomDonnee) {
        String publicViseDsiSaisi = "";
        String libellePublicViseDsi = "";
        StringTokenizer st = new StringTokenizer(publicViseDsiEnregistre, ";");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if (item.indexOf("[") == 0) {
                item = item.substring(1, item.length() - 1);
            }
            if (item.startsWith("/")) {
                item = item.substring(1);
            }
            if (publicViseDsiSaisi.length() > 0) {
                publicViseDsiSaisi = publicViseDsiSaisi + ";";
            }
            publicViseDsiSaisi = publicViseDsiSaisi + item;
            String libelleTmp = "";
            int iSlash = item.indexOf("/");
            if (iSlash > 0) {
                libelleTmp = libelleTmp + Profildsi.getIntitule(item.substring(0, iSlash));
            }
            if (iSlash < item.length() - 1) {
                if (libelleTmp.length() > 0) {
                    libelleTmp = libelleTmp + "/";
                }
                libelleTmp = libelleTmp + Groupedsi.getIntitule(item.substring(iSlash + 1));
            }
            if (libellePublicViseDsi.length() > 0) {
                libellePublicViseDsi = libellePublicViseDsi + ";";
            }
            libellePublicViseDsi = libellePublicViseDsi + libelleTmp;
        }
        infoBean.set(nomDonnee, publicViseDsiSaisi);
        infoBean.set("LIBELLE_" + nomDonnee, libellePublicViseDsi);
    }

    public static String formaterPublicViseDsiPourEnregistrement(String publicViseDsiSaisi) {
        String publicViseDsiEnregistre = "";
        StringTokenizer st = new StringTokenizer(publicViseDsiSaisi, ";");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if (publicViseDsiEnregistre.length() > 0) {
                publicViseDsiEnregistre = publicViseDsiEnregistre + ";";
            }
            publicViseDsiEnregistre = publicViseDsiEnregistre + "[/" + item + "]";
        }
        return publicViseDsiEnregistre;
    }

    @Deprecated
    public static int preparerLISTE_POPUP(InfoBean infoBean, FicheUniv ficheUniv, SaisieFiche processus) throws Exception {
        String intitule;
        TreeMap<String, FicheUniv> listeFiches = new TreeMap<String, FicheUniv>();
        Hashtable<String, String> listeCodesLangues = new Hashtable<String, String>();
        while (ficheUniv.nextItem()) {
            if (!"0001".equals(ficheUniv.getEtatObjet()) && !"0002".equals(ficheUniv.getEtatObjet()) && !"0003".equals(ficheUniv.getEtatObjet())) continue;
            boolean aStocker = true;
            String codeLangue = ficheUniv.getCode() + "/" + ficheUniv.getLangue();
            intitule = (String)listeCodesLangues.get(codeLangue);
            if (intitule != null) {
                String etat = intitule.substring(intitule.lastIndexOf("/") + 1);
                if (ficheUniv.getEtatObjet().compareTo(etat) > 0) {
                    listeFiches.remove(intitule);
                    listeCodesLangues.remove(codeLangue);
                } else {
                    aStocker = false;
                }
            }
            if (!aStocker) continue;
            intitule = ficheUniv.getLangue().equals(infoBean.getString("LANGUE_FICHE")) ? "0/" : "1/";
            intitule = intitule + ficheUniv.getLangue() + "/";
            intitule = intitule + ficheUniv.getLibelleAffichable() + " [" + Rubrique.getIntitule(ficheUniv.getCodeRubrique()) + "]";
            intitule = intitule + "/" + ficheUniv.getCode();
            intitule = intitule + "/" + ficheUniv.getEtatObjet();
            FicheUniv cloneFiche = (FicheUniv)ficheUniv.getClass().newInstance();
            cloneFiche.setIdFiche(ficheUniv.getIdFiche());
            cloneFiche.setCtx(processus);
            cloneFiche.retrieve();
            listeFiches.put(intitule.toUpperCase(), cloneFiche);
            listeCodesLangues.put(codeLangue, intitule.toUpperCase());
        }
        Iterator iter = listeFiches.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            ficheUniv = (FicheUniv)iter.next();
            intitule = ficheUniv.getLibelleAffichable() + " [" + Rubrique.getIntitule(ficheUniv.getCodeRubrique()) + "]";
            Vector<String> listeRubriques = null;
            if (infoBean.get("FCK_PLUGIN") != null) {
                listeRubriques = Rubriquepublication.getListeRubriquesPublication(processus, ficheUniv);
                if (ficheUniv.getCodeRubrique().length() > 0) {
                    listeRubriques.add(0, ficheUniv.getCodeRubrique());
                }
            }
            String sListeCodesRubrique = "";
            String sListeLibellesRubrique = "";
            if (listeRubriques != null && listeRubriques.size() > 1) {
                for (String listeRubrique : listeRubriques) {
                    if (sListeCodesRubrique.length() > 0) {
                        sListeCodesRubrique = sListeCodesRubrique + ";;";
                        sListeLibellesRubrique = sListeLibellesRubrique + ";;";
                    }
                    String libelle = Rubrique.getIntituleComplet(listeRubrique, true);
                    sListeCodesRubrique = sListeCodesRubrique + listeRubrique;
                    sListeLibellesRubrique = sListeLibellesRubrique + (libelle.length() > 0 ? libelle : "--");
                }
                sListeLibellesRubrique = StringUtils.replace((String)sListeLibellesRubrique, (String)"'", (String)"\\'");
                sListeLibellesRubrique = StringUtils.replace((String)sListeLibellesRubrique, (String)"\"", (String)"&#34;");
            }
            infoBean.set("CODE#" + i, ficheUniv.getCode());
            infoBean.set("LANGUE#" + i, ficheUniv.getLangue());
            infoBean.set("LIBELLE#" + i, intitule);
            infoBean.set("ETAT_OBJET#" + i, ficheUniv.getEtatObjet());
            infoBean.set("LISTE_CODES_RUBRIQUE#" + i, sListeCodesRubrique);
            infoBean.set("LISTE_LIBELLES_RUBRIQUE#" + i, sListeLibellesRubrique);
            infoBean.set("DOCUMENT#" + i, "0");
            if (infoBean.get("FCK_PLUGIN") != null) {
                Metatag metatag = FicheUnivMgr.lireMeta(ficheUniv);
                if ("1".equals(metatag.getMetaDocumentFichiergw())) {
                    infoBean.set("DOCUMENT#" + i, "2");
                } else {
                    infoBean.set("DOCUMENT#" + i, "1");
                }
            }
            try {
                Method m = ficheUniv.getClass().getMethod("getUrl", new Class[0]);
                infoBean.set("URL#" + i, m.invoke((Object)ficheUniv, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return listeFiches.size();
    }

    private static boolean perimetreModifie(FicheUniv ficheUnivAvant, FicheUniv ficheUnivApres) {
        boolean res = false;
        if (ficheUnivAvant.getCodeRattachement() != null && !ficheUnivAvant.getCodeRattachement().equals(ficheUnivApres.getCodeRattachement())) {
            res = true;
        }
        if (ficheUnivAvant.getCodeRubrique() != null && !ficheUnivAvant.getCodeRubrique().equals(ficheUnivApres.getCodeRubrique())) {
            res = true;
        }
        if (ficheUnivAvant instanceof FicheRattachementsSecondaires && ((FicheRattachementsSecondaires)((Object)ficheUnivAvant)).getCodeRattachementAutres() != null && !((FicheRattachementsSecondaires)((Object)ficheUnivAvant)).getCodeRattachementAutres().equals(((FicheRattachementsSecondaires)((Object)ficheUnivApres)).getCodeRattachementAutres())) {
            res = true;
        }
        if (ficheUnivAvant instanceof DiffusionSelective && (((DiffusionSelective)((Object)ficheUnivAvant)).getDiffusionPublicVise() != null && !((DiffusionSelective)((Object)ficheUnivAvant)).getDiffusionPublicVise().equals(((DiffusionSelective)((Object)ficheUnivApres)).getDiffusionPublicVise()) || !((DiffusionSelective)((Object)ficheUnivAvant)).getDiffusionModeRestriction().equals(((DiffusionSelective)((Object)ficheUnivApres)).getDiffusionModeRestriction()) || !((DiffusionSelective)((Object)ficheUnivAvant)).getDiffusionPublicViseRestriction().equals(((DiffusionSelective)((Object)ficheUnivApres)).getDiffusionPublicViseRestriction()))) {
            res = true;
        }
        return res;
    }

    private static String getCodeAuteur(AbstractProcessusBean processus) {
        Object codeAuteur_tmp = processus.getGp().getSessionUtilisateur().getInfos().get("CODE");
        String codeAuteur = "ANONYME";
        if (codeAuteur_tmp != null) {
            codeAuteur = codeAuteur_tmp.toString();
        }
        return codeAuteur;
    }
}

