/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.AbstractRequeteur;
import com.univ.utils.AttributRequeteur;
import com.univ.utils.Chaine;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.IRequeteurConstantes;
import com.univ.utils.RequeteurFiches;
import com.univ.utils.URLResolver;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GestionFiches
extends ProcessusBean
implements IRequeteurConstantes {
    private static final Logger LOG = LoggerFactory.getLogger(GestionFiches.class);
    private static final String ECRAN_LISTE = "LISTE";
    AutorisationBean autorisations;

    public GestionFiches(InfoBean ciu) {
        super(ciu);
    }

    private void preparerLISTE() throws Exception {
        RequeteurFiches requeteur = new RequeteurFiches(this.infoBean);
        String codeUtilisateur = (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE");
        String libelle = "";
        if (this.infoBean.get("LIBELLE_FICHE") != null) {
            libelle = this.infoBean.getString("LIBELLE_FICHE");
            requeteur.setAttribut("LIBELLE_FICHE", libelle, true, true);
        } else {
            libelle = requeteur.getAttribut("LIBELLE_FICHE").getValeur();
        }
        this.infoBean.set("LIBELLE_FICHE", libelle);
        this.infoBean.set("LIBELLE_FICHE_REQ", requeteur.getAttribut("LIBELLE_FICHE").getRequetable());
        this.infoBean.set("LIBELLE_FICHE_TRI", requeteur.getAttribut("LIBELLE_FICHE").getTriable());
        String langue = "";
        if (this.isInfoBeanAttributeValued("LANGUE_FICHE")) {
            langue = this.infoBean.getString("LANGUE_FICHE");
            if (langue.equals("DYNAMIK")) {
                langue = LangueUtil.getLangueLocale(this.getLocale());
            }
            requeteur.setAttribut("LANGUE_FICHE", langue, true, true);
        } else {
            langue = requeteur.getAttribut("LANGUE_FICHE").getValeur();
        }
        this.infoBean.set("LANGUE_FICHE", langue);
        Hashtable<String, String> hash = LangueUtil.getListeLangues(this.getLocale());
        this.infoBean.set("LISTE_LANGUES", hash);
        if (hash.size() > 1) {
            this.infoBean.set("LANGUE_FICHE_REQ", requeteur.getAttribut("LANGUE_FICHE").getRequetable());
            this.infoBean.set("LANGUE_FICHE_TRI", requeteur.getAttribut("LANGUE_FICHE").getTriable());
        } else {
            this.infoBean.set("LANGUE_FICHE_REQ", "0");
            this.infoBean.set("LANGUE_FICHE_TRI", "0");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String typeDate = requeteur.getAttribut("TYPE_DATE").getValeur();
        if (typeDate == null || typeDate.equals("")) {
            typeDate = "DATE_MODIFICATION";
        }
        this.infoBean.set("TYPE_DATE", typeDate);
        this.infoBean.set("TYPE_DATE_REQ", requeteur.getAttribut("TYPE_DATE").getRequetable());
        this.infoBean.set("TYPE_DATE_TRI", requeteur.getAttribut("TYPE_DATE").getTriable());
        Date dateDebut = new Date(0L);
        if (this.infoBean.get("DATE_DEBUT") != null) {
            dateDebut = (Date)this.infoBean.get("DATE_DEBUT");
            requeteur.setAttribut("DATE_DEBUT", sdf.format(dateDebut), true, true);
        } else {
            try {
                dateDebut = ECRAN_LISTE.equals(this.ecranLogique) && this.infoBean.get("DATE_FIN") != null ? new Date(0L) : new Date(sdf.parse(requeteur.getAttribut("DATE_DEBUT").getValeur()).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.infoBean.set("DATE_DEBUT", dateDebut);
        this.infoBean.set("DATE_DEBUT_REQ", requeteur.getAttribut("DATE_DEBUT").getRequetable());
        Date dateFin = new Date(0L);
        if (this.infoBean.get("DATE_FIN") != null) {
            dateFin = (Date)this.infoBean.get("DATE_FIN");
            requeteur.setAttribut("DATE_FIN", sdf.format(dateFin), true, true);
        } else {
            try {
                dateFin = ECRAN_LISTE.equals(this.ecranLogique) && this.infoBean.get("DATE_DEBUT") != null ? new Date(System.currentTimeMillis()) : new Date(sdf.parse(requeteur.getAttribut("DATE_FIN").getValeur()).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.infoBean.set("DATE_FIN", dateFin);
        this.infoBean.set("DATE_FIN_REQ", requeteur.getAttribut("DATE_FIN").getRequetable());
        String redacteur = "";
        String codeRedacteur = "";
        if (this.infoBean.get("CODE_REDACTEUR") != null) {
            codeRedacteur = this.infoBean.getString("CODE_REDACTEUR");
            requeteur.setAttribut("CODE_REDACTEUR", codeRedacteur, false, false);
        } else if (this.infoBean.get("REDACTEUR") != null) {
            redacteur = this.infoBean.getString("REDACTEUR");
            if (redacteur.length() > 0 && requeteur.getAttribut("REDACTEUR").getValeur().equals(redacteur)) {
                codeRedacteur = requeteur.getAttribut("CODE_REDACTEUR").getValeur();
            } else {
                requeteur.setAttribut("REDACTEUR", redacteur, false, false);
            }
        } else {
            codeRedacteur = requeteur.getAttribut("CODE_REDACTEUR").getValeur();
            if (codeRedacteur.equals("DYNAMIK") && codeUtilisateur != null) {
                codeRedacteur = codeUtilisateur;
            } else if (codeRedacteur.equals("SANSDYNAMIK") && codeUtilisateur != null) {
                codeRedacteur = "SANSDYNAMIK" + codeUtilisateur;
            }
            redacteur = requeteur.getAttribut("REDACTEUR").getValeur();
            if (redacteur.equals("")) {
                requeteur.setAttribut("CODE_REDACTEUR", codeRedacteur, AbstractRequeteur.getBooleanValue(requeteur.getAttribut("CODE_REDACTEUR").getRequetable()), AbstractRequeteur.getBooleanValue(requeteur.getAttribut("CODE_REDACTEUR").getTriable()));
            }
        }
        this.infoBean.set("CODE_REDACTEUR", codeRedacteur);
        this.infoBean.set("REDACTEUR", redacteur);
        this.infoBean.set("CODE_REDACTEUR_REQ", requeteur.getAttribut("CODE_REDACTEUR").getRequetable());
        this.infoBean.set("CODE_REDACTEUR_TRI", requeteur.getAttribut("CODE_REDACTEUR").getTriable());
        String diffusionPublicVise = "";
        if (this.isInfoBeanAttributeValued("DIFFUSION_PUBLIC_VISE")) {
            diffusionPublicVise = this.infoBean.getString("DIFFUSION_PUBLIC_VISE");
            requeteur.setAttribut("DIFFUSION_PUBLIC_VISE", diffusionPublicVise, true, true);
        } else {
            diffusionPublicVise = requeteur.getAttribut("DIFFUSION_PUBLIC_VISE").getValeur();
        }
        this.infoBean.set("DIFFUSION_PUBLIC_VISE", diffusionPublicVise);
        this.infoBean.set("DIFFUSION_PUBLIC_VISE_REQ", requeteur.getAttribut("DIFFUSION_PUBLIC_VISE").getRequetable());
        this.infoBean.set("DIFFUSION_PUBLIC_VISE_TRI", requeteur.getAttribut("DIFFUSION_PUBLIC_VISE").getTriable());
        String diffusionModeRestriction = "";
        if (this.infoBean.get("DIFFUSION_MODE_RESTRICTION") != null) {
            diffusionModeRestriction = this.infoBean.getString("DIFFUSION_MODE_RESTRICTION");
            requeteur.setAttribut("DIFFUSION_MODE_RESTRICTION", diffusionModeRestriction, false, false);
        } else {
            diffusionModeRestriction = requeteur.getAttribut("DIFFUSION_MODE_RESTRICTION").getValeur();
        }
        this.infoBean.set("DIFFUSION_MODE_RESTRICTION", diffusionModeRestriction);
        String diffusionPublicViseRestriction = "";
        if (this.infoBean.get("DIFFUSION_PUBLIC_VISE_RESTRICTION") != null) {
            diffusionPublicViseRestriction = this.infoBean.getString("DIFFUSION_PUBLIC_VISE_RESTRICTION");
            requeteur.setAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION", diffusionPublicViseRestriction, false, false);
        } else {
            diffusionPublicViseRestriction = requeteur.getAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION").getValeur();
        }
        String codeEspaceCollaboratif = "";
        if (this.infoBean.get("ESPACE") != null && this.infoBean.getString("ESPACE").length() > 0) {
            codeEspaceCollaboratif = this.infoBean.getString("ESPACE");
        }
        if (StringUtils.isNotEmpty((CharSequence)codeEspaceCollaboratif)) {
            diffusionModeRestriction = "4";
            requeteur.setAttribut("DIFFUSION_MODE_RESTRICTION", diffusionModeRestriction, false, false);
            diffusionPublicViseRestriction = codeEspaceCollaboratif;
            requeteur.setAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION", codeEspaceCollaboratif, false, false);
        } else if ("4".equals(diffusionModeRestriction) && diffusionPublicViseRestriction.length() > 0) {
            this.infoBean.set("ESPACE", diffusionPublicViseRestriction);
            codeEspaceCollaboratif = diffusionPublicViseRestriction;
        }
        this.infoBean.set("DIFFUSION_PUBLIC_VISE_RESTRICTION", diffusionPublicViseRestriction);
        this.infoBean.set("DIFFUSION_PUBLIC_VISE_RESTRICTION_REQ", requeteur.getAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION").getRequetable());
        this.infoBean.set("DIFFUSION_PUBLIC_VISE_RESTRICTION_TRI", requeteur.getAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION").getTriable());
        String rubrique = "";
        if (this.isInfoBeanAttributeValued("CODE_RUBRIQUE")) {
            rubrique = this.infoBean.getString("CODE_RUBRIQUE");
            AttributRequeteur oldAttributRubrique = requeteur.getAttribut("CODE_RUBRIQUE");
            requeteur.setAttribut("CODE_RUBRIQUE", rubrique, oldAttributRubrique.isRequetable(), oldAttributRubrique.isTriable());
        } else {
            rubrique = requeteur.getAttribut("CODE_RUBRIQUE").getValeur();
        }
        this.infoBean.set("CODE_RUBRIQUE", rubrique);
        String libelleRubrique = Rubrique.getIntitule(rubrique);
        if (libelleRubrique.contains("#")) {
            libelleRubrique = libelleRubrique.substring(libelleRubrique.indexOf("#") + 1);
        }
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", libelleRubrique);
        this.infoBean.set("CODE_RUBRIQUE_REQ", requeteur.getAttribut("CODE_RUBRIQUE").getRequetable());
        this.infoBean.set("CODE_RUBRIQUE_TRI", requeteur.getAttribut("CODE_RUBRIQUE").getTriable());
        String rattachement = "";
        if (this.isInfoBeanAttributeValued("CODE_RATTACHEMENT")) {
            rattachement = this.infoBean.getString("CODE_RATTACHEMENT");
            requeteur.setAttribut("CODE_RATTACHEMENT", rattachement, true, true);
        } else {
            rattachement = requeteur.getAttribut("CODE_RATTACHEMENT").getValeur();
        }
        this.infoBean.set("CODE_RATTACHEMENT", rattachement);
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(rattachement, langue));
        this.infoBean.set("CODE_RATTACHEMENT_REQ", requeteur.getAttribut("CODE_RATTACHEMENT").getRequetable());
        this.infoBean.set("CODE_RATTACHEMENT_TRI", requeteur.getAttribut("CODE_RATTACHEMENT").getTriable());
        String code0bjet = "";
        if (this.infoBean.get("CODE_OBJET") != null) {
            code0bjet = this.infoBean.getString("CODE_OBJET");
            AttributRequeteur oldCodeObjetAttribut = requeteur.getAttribut("CODE_OBJET");
            requeteur.setAttribut("CODE_OBJET", code0bjet, oldCodeObjetAttribut.isRequetable(), oldCodeObjetAttribut.isTriable());
        } else {
            code0bjet = requeteur.getAttribut("CODE_OBJET").getValeur();
        }
        Hashtable<String, String> hashObjets = new Hashtable<String, String>();
        String listeObjets = requeteur.getAttribut(ECRAN_LISTE).getValeur().toUpperCase();
        String nomObjet = "";
        if (listeObjets.length() == 0) {
            listeObjets = code0bjet.toUpperCase();
        }
        if (listeObjets.length() > 0) {
            String[] listeObjetsTab;
            for (String element : listeObjetsTab = listeObjets.split(",")) {
                nomObjet = element.toUpperCase();
                hashObjets.put(nomObjet, ReferentielObjets.getLibelleObjet(ReferentielObjets.getCodeObjet(nomObjet)));
            }
        } else {
            String libelleObjet = "";
            if (StringUtils.isNotEmpty((CharSequence)codeEspaceCollaboratif)) {
                InfosEspaceCollaboratif espace = Espacecollaboratif.renvoyerItemEspace(codeEspaceCollaboratif);
                Collection<String> services = espace.getServicesList();
                for (String service : services) {
                    if (listeObjets.length() > 0) {
                        listeObjets = listeObjets + ",";
                    }
                    listeObjets = listeObjets + service;
                    hashObjets.put(service, ReferentielObjets.getLibelleObjet(service));
                }
            } else {
                for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                    nomObjet = ReferentielObjets.getNomObjet(codeObjet);
                    libelleObjet = ReferentielObjets.getLibelleObjet(codeObjet);
                    if (listeObjets.length() > 0) {
                        listeObjets = listeObjets + ",";
                    }
                    listeObjets = listeObjets + nomObjet;
                    hashObjets.put(nomObjet, libelleObjet);
                }
            }
        }
        this.infoBean.set("LISTE_CODE_OBJET", hashObjets);
        this.infoBean.set("CODE_OBJET", code0bjet.toUpperCase());
        this.infoBean.set("CODE_OBJET_REQ", requeteur.getAttribut("CODE_OBJET").getRequetable());
        this.infoBean.set("CODE_OBJET_TRI", requeteur.getAttribut("CODE_OBJET").getTriable());
        if (code0bjet.length() == 0 || code0bjet.equals("TOUS") || code0bjet.equals("0000")) {
            code0bjet = listeObjets;
            requeteur.setAttribut("CODE_OBJET", code0bjet, AbstractRequeteur.getBooleanValue(requeteur.getAttribut("CODE_OBJET").getRequetable()), AbstractRequeteur.getBooleanValue(requeteur.getAttribut("CODE_OBJET").getTriable()));
        }
        requeteur.setAttribut(ECRAN_LISTE, listeObjets, false, false);
        this.infoBean.set(ECRAN_LISTE, code0bjet);
        String etatObjet = "";
        if (this.infoBean.get("ETAT_OBJET") != null) {
            etatObjet = this.infoBean.getString("ETAT_OBJET");
            requeteur.setAttribut("ETAT_OBJET", etatObjet, true, true);
        } else {
            etatObjet = requeteur.getAttribut("ETAT_OBJET").getValeur();
        }
        this.infoBean.set("ETAT_OBJET", etatObjet);
        this.infoBean.set("ETAT_OBJET_REQ", requeteur.getAttribut("ETAT_OBJET").getRequetable());
        this.infoBean.set("ETAT_OBJET_TRI", requeteur.getAttribut("ETAT_OBJET").getTriable());
        String titre = "";
        if (this.infoBean.get("TITRE") != null) {
            titre = this.infoBean.getString("TITRE");
            requeteur.setAttribut("TITRE", titre, false, false);
        } else {
            titre = requeteur.getAttribut("TITRE").getValeur();
        }
        String urlCourante = StringUtils.replace((String)requeteur.genererUrlRequete(), (String)"\"", (String)"&#34;");
        if (this.infoBean.getString("RF") != null) {
            urlCourante = urlCourante + "&amp;RF=" + this.infoBean.getString("RF");
        } else if (this.infoBean.getString("RH") != null) {
            urlCourante = urlCourante + "&amp;RF=" + this.infoBean.getString("RH");
        }
        this.infoBean.set("TITRE", titre);
        this.infoBean.setTitreEcran(titre);
        this.infoBean.set("MODE", requeteur.getMode());
        this.infoBean.set("ACTIONS", requeteur.getSelection());
        this.infoBean.set("PAGE", requeteur.getPagination());
        this.infoBean.set("AJOUT", requeteur.getAjoutLien());
        this.infoBean.set("REQUETE", StringUtils.replace((String)requeteur.getAttributRequete(), (String)"\"", (String)"&#34;"));
        this.infoBean.set("URL_REDIRECT", urlCourante);
        int indexDebut = 0;
        if (this.infoBean.getString("FROM") != null) {
            indexDebut = Integer.parseInt(this.infoBean.getString("FROM"));
        }
        this.infoBean.setInt("FROM", indexDebut);
        int increment = 10;
        if (this.infoBean.getString("INCREMENT") != null) {
            try {
                increment = Integer.parseInt(this.infoBean.getString("INCREMENT"));
                if (increment == 0) {
                    increment = 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.infoBean.setInt("INCREMENT", increment);
        String tri = "";
        if (this.infoBean.get("TRI") != null && this.infoBean.getString("TRI").length() > 0) {
            tri = this.infoBean.getString("TRI");
        }
        String ordretri = "";
        if (this.infoBean.get("ORDRE_TRI") != null && this.infoBean.getString("ORDRE_TRI").length() > 0) {
            ordretri = this.infoBean.getString("ORDRE_TRI");
        }
        this.infoBean.set("ORDRE_TRI", ordretri);
        this.infoBean.set("TRI", tri);
        TreeMap<String, Object> tMap = requeteur.getListeFiches(code0bjet, etatObjet, libelle, codeRedacteur, rubrique, rattachement, typeDate, dateDebut, dateFin, diffusionPublicVise, diffusionModeRestriction, diffusionPublicViseRestriction, langue, tri, ordretri, indexDebut, increment, requeteur.getMode(), "2");
        int nbItemsTotal = 0;
        try {
            nbItemsTotal = (Integer)tMap.get(String.valueOf(100000));
        }
        catch (Exception exception) {
            // empty catch block
        }
        tMap.remove(String.valueOf(100000));
        int i = 0;
        String libelleService = "";
        String libelleGroupes = "";
        boolean afficheAction = false;
        TreeMap<Integer, FicheUniv> tMapInfoBean = new TreeMap<Integer, FicheUniv>();
        for (String donneeFiche : tMap.keySet()) {
            MetatagBean bean = (MetatagBean)tMap.get(donneeFiche);
            Long idFiche = bean.getMetaIdFiche();
            String codeObjet = bean.getMetaCodeObjet();
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(codeObjet));
            if (ficheUniv != null) {
                ficheUniv.init();
                ficheUniv.setCtx(this);
                ficheUniv.setIdFiche((long)idFiche);
                try {
                    ficheUniv.retrieve();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv));
            libelleService = ReferentielObjets.getLibelleObjet(ReferentielObjets.getCodeObjet(ficheUniv));
            if (ficheUniv instanceof DiffusionSelective) {
                InfosEspaceCollaboratif infos;
                libelleGroupes = "";
                if (FicheUnivMgr.isFicheCollaborative(ficheUniv) && (infos = Espacecollaboratif.renvoyerItemEspace(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction())).getIntitule().length() > 0) {
                    libelleGroupes = infos.getIntitule();
                }
                if (libelleGroupes.length() == 0) {
                    Vector<String> vTemp = Chaine.getVecteurPointsVirgules(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicVise());
                    for (String item : vTemp) {
                        String[] temp = (item = item.substring(1, item.length() - 1)).split("/", -2);
                        String libelleGroupe = Groupedsi.getIntitule(temp[1]);
                        if (libelleGroupe.length() <= 0) continue;
                        if (libelleGroupes.length() > 0) {
                            libelleGroupes = libelleGroupes + " / ";
                        }
                        libelleGroupes = libelleGroupes + libelleGroupe;
                    }
                }
                this.infoBean.set("DIFFUSION_PUBLIC_VISE#" + i, libelleGroupes);
            }
            this.infoBean.set("INTITULE_FICHE#" + i, ficheUniv.getLibelleAffichable());
            this.infoBean.set("TYPE_FICHE#" + i, nomObjet.toUpperCase());
            this.infoBean.set("LIBELLE_FICHE#" + i, libelleService);
            this.infoBean.set("ID_FICHE#" + i, ficheUniv.getIdFiche().toString());
            this.infoBean.set("ETAT#" + i, ficheUniv.getEtatObjet());
            this.infoBean.set("CODE_RATTACHEMENT#" + i, Structure.getLibelleAffichable(ficheUniv.getCodeRattachement(), langue));
            this.infoBean.set("LANGUE#" + i, "");
            this.infoBean.set("CODE_RUBRIQUE#" + i, "");
            this.infoBean.set("RUBRIQUE#" + i, "");
            this.infoBean.set("LANGUE#" + i, ficheUniv.getLangue());
            String codeRubrique = ficheUniv.getCodeRubrique();
            this.infoBean.set("RUBRIQUE#" + i, codeRubrique);
            libelleRubrique = Rubrique.getIntitule(codeRubrique);
            if (libelleRubrique.contains("#")) {
                libelleRubrique = libelleRubrique.substring(libelleRubrique.indexOf("#") + 1);
            }
            this.infoBean.set("CODE_RUBRIQUE#" + i, libelleRubrique);
            String urlFicheModification = "";
            String urlFicheSuppression = "";
            String parametres = "";
            String ext = StringUtils.isNotEmpty((CharSequence)ReferentielObjets.getExtension(ficheUniv)) ? "EXT=" + ReferentielObjets.getExtension(ficheUniv) + "&amp;" : "";
            boolean actionPossible = false;
            if (FicheAnnotationHelper.isSaisieFrontOffice(ficheUniv)) {
                actionPossible = true;
                urlFicheModification = "/servlet/com.jsbsoft.jtf.core.SG?" + ext + "ACTION=MODIFIER&amp;SAISIE_FRONT=TRUE";
                urlFicheSuppression = "/servlet/com.jsbsoft.jtf.core.SG?" + ext + "ACTION=SUPPRIMER&amp;SAISIE_FRONT=TRUE&amp;TYPE_FICHE=" + nomObjet.toUpperCase();
                parametres = "&amp;ID_FICHE=" + ficheUniv.getIdFiche() + "&amp;PROC=SAISIE_" + nomObjet.toUpperCase() + "_FRONT&amp;URL_REDIRECT=" + URLEncoder.encode(urlCourante, "UTF-8");
                urlFicheSuppression = urlFicheSuppression + parametres;
                urlFicheModification = urlFicheModification + parametres;
                if (StringUtils.isNotEmpty((CharSequence)codeEspaceCollaboratif)) {
                    urlFicheModification = urlFicheModification + "&amp;ESPACE=" + codeEspaceCollaboratif;
                    urlFicheSuppression = urlFicheSuppression + "&amp;ESPACE=" + codeEspaceCollaboratif;
                }
                if (this.infoBean.get("RH") != null) {
                    urlFicheModification = urlFicheModification + "&amp;RH=" + this.infoBean.getString("RH");
                    urlFicheSuppression = urlFicheSuppression + "&amp;RH=" + this.infoBean.getString("RH");
                } else {
                    urlFicheModification = urlFicheModification + "&amp;RH=" + ficheUniv.getCodeRubrique();
                    urlFicheSuppression = urlFicheSuppression + "&amp;RH=" + ficheUniv.getCodeRubrique();
                }
                if (this.infoBean.get("LANGUE") != null) {
                    urlFicheModification = urlFicheModification + "&amp;LANGUE=" + this.infoBean.getString("LANGUE");
                    urlFicheSuppression = urlFicheSuppression + "&amp;LANGUE=" + this.infoBean.getString("LANGUE");
                }
            } else {
                urlFicheModification = "";
                urlFicheSuppression = "";
                if (this.autorisations != null && this.autorisations.possedeModeExpert()) {
                    actionPossible = true;
                    urlFicheModification = "/servlet/com.jsbsoft.jtf.core.SG?" + ext + "ACTION=MODIFIER";
                    urlFicheSuppression = "/servlet/com.jsbsoft.jtf.core.SG?" + ext + "ACTION=SUPPRIMER";
                    parametres = "&amp;ID_FICHE=" + ficheUniv.getIdFiche() + "&amp;PROC=SAISIE_" + nomObjet.toUpperCase();
                    urlFicheSuppression = "href=\"#\" onclick=\"window.open('" + URLResolver.getAbsoluteBoUrl(urlFicheSuppression + parametres, this.getInfosSite()) + "','_blank','');return false\"";
                    urlFicheModification = "href=\"#\" onclick=\"window.open('" + URLResolver.getAbsoluteBoUrl(urlFicheModification + parametres, this.getInfosSite()) + "','_blank','');return false\"";
                }
            }
            this.infoBean.set("URL_FICHE#" + i, urlFicheModification);
            this.infoBean.set("URL_MODIF_FICHE#" + i, urlFicheModification);
            this.infoBean.set("URL_SUPPR_FICHE#" + i, urlFicheSuppression);
            this.infoBean.set("DATE#" + i, ficheUniv.getDateModification());
            if (this.autorisations != null) {
                boolean autorisation = false;
                if (actionPossible && requeteur.getListeActions().contains("S")) {
                    autorisation = this.autorisations.estAutoriseASupprimerLaFiche(ficheUniv);
                }
                if (autorisation) {
                    this.infoBean.set("SUPPRIMER_FICHE#" + i, "1");
                    afficheAction = true;
                } else {
                    this.infoBean.set("SUPPRIMER_FICHE#" + i, "0");
                }
                autorisation = false;
                if (actionPossible && requeteur.getListeActions().contains("M")) {
                    autorisation = this.autorisations.estAutoriseAModifierLaFiche(ficheUniv, true);
                }
                if (autorisation) {
                    this.infoBean.set("MODIFIER_FICHE#" + i, "1");
                    afficheAction = true;
                } else {
                    this.infoBean.set("MODIFIER_FICHE#" + i, "0");
                }
                autorisation = false;
                if (ficheUniv.getEtatObjet().equals("0003") && requeteur.getListeActions().contains("V")) {
                    autorisation = FicheUnivMgr.controlerRestriction(ficheUniv, this);
                }
                if (autorisation) {
                    this.infoBean.set("VOIR_FICHE#" + i, "1");
                    afficheAction = true;
                } else {
                    this.infoBean.set("VOIR_FICHE#" + i, "0");
                }
            }
            this.infoBean.set("REDACTEUR#" + i, Utilisateur.getLibelle(ficheUniv.getCodeRedacteur()));
            tMapInfoBean.put(i, ficheUniv);
            ++i;
        }
        if (afficheAction) {
            this.infoBean.set("ACTION_FICHE", "1");
        } else {
            this.infoBean.set("ACTION_FICHE", "0");
        }
        this.infoBean.set("TREE_FICHES", tMapInfoBean);
        this.infoBean.set("LISTE_NB_ITEMS", i);
        this.infoBean.setInt("NB_TOTAL", nbItemsTotal);
        if (increment != 0) {
            this.infoBean.setInt("NUM_PAGE", indexDebut / increment + 1);
            this.infoBean.setInt("NB_PAGES", (nbItemsTotal - 1) / increment + 1);
        }
        this.ecranLogique = ECRAN_LISTE;
    }

    @Override
    public boolean traiterAction() throws Exception {
        Object o = this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (o == null && !"CONSUL".equals(this.infoBean.getString("MODE"))) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.autorisations = (AutorisationBean)o;
                if (this.autorisations != null) {
                    ((Hashtable)this.getDatas()).put("AUTORISATIONS", this.autorisations);
                }
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.etat = 1;
                if (this.action.equals(ECRAN_LISTE) || this.action.equals("VALIDER")) {
                    this.preparerLISTE();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur lors du traitement du processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    public String getProcessus() {
        return this.infoBean.getString("PROC");
    }

    private boolean isInfoBeanAttributeValued(String attributeName) {
        return StringUtils.isNotBlank((CharSequence)((String)this.infoBean.get(attributeName))) && !StringUtils.equals((CharSequence)((String)this.infoBean.get(attributeName)), (CharSequence)"0000");
    }
}

