/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.MyRequestWrapper;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.SourceAuthHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.security.MySQLHelper;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.processus.MotDePasseCtrl;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.MailUtil;
import com.univ.utils.SessionUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identification
extends ProcessusBean {
    private static final String PROC_IDENTIFICATION_FRONT = "IDENTIFICATION_FRONT";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";
    private static final String ECRAN_DEMANDE_MDP = "DEMANDE_MDP";
    private static final String ECRAN_PRESENTATION_MDP = "PRESENTATION_MDP";
    private static final String ECRAN_CONFIRMATION_MDP = "CONFIRMATION_MDP";
    private static final String ECRAN_PERSONNALISATION = "PERSONNALISATION";
    private static final String ECRAN_COOKIE = "COOKIE";
    private static final String ECRAN_DECONNEXION = "DECONNEXION";
    private static final String ECRAN_MENU = "MENU";
    private static final String ECRAN_REDIRECTION = "REDIRECTION";
    private static final Logger LOG = LoggerFactory.getLogger(Identification.class);
    private final GestionnaireIdentification gI = GestionnaireIdentification.getInstance();

    public Identification(InfoBean ciu) {
        super(ciu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean traiterAction() throws Exception {
        try {
            this.ecranLogique = this.infoBean.getEcranLogique();
            this.action = this.infoBean.getActionUtilisateur();
            Hashtable<String, Object> mapInfosSessionsUser = this.getGp().getSessionUtilisateur().getInfos();
            if (this.ecranLogique == null) {
                if ("DECONNECTER".equals(this.action)) {
                    this.gI.deconnecte((String)mapInfosSessionsUser.get("KSESSION"), mapInfosSessionsUser, this);
                    this.setKUserConnectorCookieValue("no");
                    ContexteUniv ctx = ContexteUtil.getContexteUniv();
                    if (ctx != null) {
                        ctx.supprimerInfosUtilisateurs();
                    } else {
                        LOG.error("impossible de recuperer le contexte");
                    }
                    this.getGp().getSessionUtilisateur().getHttpSession().invalidate();
                    String redirectionLogin = PropertyHelper.getCoreProperty("sso.redirection_login");
                    boolean redirection = !"false".equalsIgnoreCase(this.infoBean.getString("REDIRECT"));
                    boolean bIdentificationFront = this.infoBean.getNomProcessus().equals(PROC_IDENTIFICATION_FRONT);
                    if (redirection) {
                        if (bIdentificationFront && "1".equals(redirectionLogin)) {
                            this.setEcranRedirection(true);
                        } else {
                            this.setEcranLogin();
                        }
                    } else {
                        this.ecranLogique = ECRAN_CONFIRMATION;
                    }
                } else if ("CONNECTER".equals(this.action)) {
                    String codeUtilisateur = (String)mapInfosSessionsUser.get("CODE");
                    if (codeUtilisateur == null || codeUtilisateur.length() == 0) {
                        this.setEcranLogin();
                    } else {
                        this.setEcranRedirection(false);
                    }
                } else if ("REVENIR_ACCUEIL".equals(this.action)) {
                    this.initialiserACCUEIL();
                } else if ("PERSONNALISER".equals(this.action)) {
                    this.initialiserPERSONNALISATION();
                } else if ("DEMANDER_MDP".equals(this.action)) {
                    this.initialiserDEMANDE_MDP();
                } else if ("PRESENTER_MDP".equals(this.action)) {
                    this.traiterGENERATION_MDP();
                } else if ("VALIDER".equals(this.action)) {
                    if ("1".equals(this.infoBean.get("KUSER_CONNECTOR"))) {
                        Utilisateur utilisateur = this.gI.connecteUserKbd(this.infoBean.getString("LOGIN"), this.infoBean.getString("PASSWORD"), this, this.getGp().getSessionUtilisateur().getInfos(), this.infoBean.getString("#user-agent"));
                        if (utilisateur == null) {
                            this.infoBean.addMessageErreur(MessageHelper.getCoreMessage(this.getLocale(), "ST_LOGIN_PASSWORD_INCORRECT"));
                            this.ecranLogique = ECRAN_PRINCIPAL;
                        } else {
                            this.setEcranRedirection(false);
                        }
                    } else {
                        boolean bIdentificationFront = this.infoBean.getNomProcessus().equals(PROC_IDENTIFICATION_FRONT);
                        if (this.gI.estSourceAuth("cas")) {
                            LOG.debug("Connexion CAS");
                            Utilisateur utilisateur = this.gI.getValidateurCAS().validation(this, this.infoBean);
                            if (utilisateur != null) {
                                this.gI.chargeInfoUser(utilisateur, this, this.getGp().getSessionUtilisateur().getInfos(), this.infoBean.getString("#user-agent"), bIdentificationFront);
                                this.setEcranRedirection(false);
                            } else {
                                this.setEcranLogin();
                            }
                        } else if (this.gI.estSourceAuth("ClearTrust")) {
                            LOG.debug("Connexion Ctrust");
                            HttpServletRequest request = (HttpServletRequest)((Hashtable)this.getDatas()).get("_sg_requete_http");
                            String loginCtrust = request.getHeader("ct-remote-user");
                            if (loginCtrust != null && StringUtils.isEmpty((CharSequence)((String)mapInfosSessionsUser.get("CODE")))) {
                                if (!this.gI.chargeInfoUser(loginCtrust, this, request.getSession(Boolean.FALSE.booleanValue()), request.getHeader("user-agent"))) throw new ErreurApplicative(MessageFormat.format(MessageHelper.getCoreMessage("ST_DSI_IDENTIFICATION_ECHEC"), loginCtrust));
                                this.setEcranLogin();
                            } else {
                                this.infoBean.setEcranRedirection(URLResolver.getAbsoluteUrl("/", ContexteUtil.getContexteUniv()));
                                this.ecranLogique = ECRAN_REDIRECTION;
                            }
                        }
                    }
                } else if ("CREER_COOKIE".equals(this.action)) {
                    String remoteAddr = ((HttpServletRequest)((Hashtable)this.getDatas()).get("_sg_requete_http")).getRemoteAddr();
                    if (GestionnaireIdentification.isAuthorizedAddr(remoteAddr)) {
                        String user = this.infoBean.getString("USER");
                        if (user == null) {
                            user = PropertyHelper.getCoreProperty("identification.user");
                        }
                        Utilisateur userBatch = Utilisateur.getUtilisateur(user);
                        this.gI.chargeInfoUser(userBatch, this, this.getGp().getSessionUtilisateur().getInfos(), this.infoBean.getString("#user-agent"), true);
                    }
                    this.ecranLogique = ECRAN_COOKIE;
                }
            } else if (ECRAN_PRINCIPAL.equals(this.ecranLogique)) {
                this.traiterPRINCIPAL();
            } else if (ECRAN_PERSONNALISATION.equals(this.ecranLogique)) {
                this.traiterPERSONNALISATION();
            } else if (ECRAN_DEMANDE_MDP.equals(this.ecranLogique)) {
                this.traiterDEMANDE_MDP();
            }
            this.infoBean.setEcranLogique(this.ecranLogique);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        if (this.etat != 2) return false;
        return true;
    }

    private void setEcranRedirection(boolean ecranDeconnexion) {
        String redirection;
        boolean bIdentificationFront = this.infoBean.getNomProcessus().equals(PROC_IDENTIFICATION_FRONT);
        if (!bIdentificationFront) {
            this.ecranLogique = ecranDeconnexion ? ECRAN_DECONNEXION : ECRAN_MENU;
            return;
        }
        this.ecranLogique = ECRAN_REDIRECTION;
        String ksession = (String)this.getGp().getSessionUtilisateur().getInfos().get("KSESSION");
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String action = "";
        if (this.infoBean != null) {
            action = StringUtils.defaultString((String)this.infoBean.getActionUtilisateur());
        }
        if ("VALIDER".equals(action) && !ecranDeconnexion) {
            Cookie cookie = new Cookie("sso", "true");
            cookie.setPath("/");
            ctx.getReponseHTTP().addCookie(cookie);
        }
        if ("1".equals(redirection = PropertyHelper.getCoreProperty("sso.redirection_login")) && !"REVENIR_ACCUEIL".equals(action) && !"RETOUR_PARENT".equals(action)) {
            String urlRedirect = (String)this.infoBean.get("URL_REDIRECT");
            if (urlRedirect == null) {
                urlRedirect = "";
            }
            LOG.debug("Identification set redirection : " + urlRedirect);
            if (urlRedirect.length() > 0) {
                this.infoBean.setEcranRedirection(urlRedirect);
                return;
            }
        }
        String urlDemandee = "";
        if (ctx.getRequeteHTTP().getSession(false) != null) {
            urlDemandee = UnivWebFmt.renvoyerUrlRedirection(ctx.getRequeteHTTP().getSession(false));
        }
        if (StringUtils.isNotEmpty((CharSequence)urlDemandee)) {
            try {
                urlDemandee = URLDecoder.decode(urlDemandee, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (StringUtils.isNotEmpty((CharSequence)ksession)) {
                urlDemandee = urlDemandee.indexOf(63) == -1 ? urlDemandee + "?" : urlDemandee + "&";
                urlDemandee = urlDemandee + "ksession=" + ksession;
            }
            LOG.debug("Redirection url demandee : " + urlDemandee);
            this.infoBean.setEcranRedirection(URLResolver.getAbsoluteUrl(urlDemandee, ctx));
        } else {
            String urlRedirect = URLResolver.getAbsoluteUrl("/", ctx);
            try {
                Hashtable<String, Object> infosSession = SessionUtil.getInfosSession(ctx.getRequeteHTTP());
                InfosRubriques accueil = (InfosRubriques)infosSession.get("RUBRIQUE_ACCUEIL");
                if (StringUtils.isNotBlank((CharSequence)accueil.getCode())) {
                    urlRedirect = URLResolver.getAbsoluteUrl(ctx.getReponseHTTP().encodeRedirectURL(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, accueil.getCode(), true, accueil.getLangue())), ctx);
                } else {
                    String codeFiche = (String)infosSession.get("CODE_PAGE_ACCUEIL");
                    String langueFiche = (String)infosSession.get("LANGUE_PAGE_ACCUEIL");
                    if (codeFiche != null && codeFiche.length() > 0) {
                        urlRedirect = URLResolver.getAbsoluteUrl(ctx.getReponseHTTP().encodeRedirectURL(UnivWebFmt.determinerUrlFiche(ctx, "pagelibre", codeFiche, langueFiche, false)), ctx);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotEmpty((CharSequence)ksession)) {
                urlRedirect = urlRedirect.indexOf(63) == -1 ? urlRedirect + "?" : urlRedirect + "&";
                urlRedirect = urlRedirect + "ksession=" + ksession;
            }
            this.infoBean.setEcranRedirection(urlRedirect);
        }
    }

    private void traiterPRINCIPAL() throws Exception {
        Utilisateur utilisateur = "1".equals(this.infoBean.get("KUSER_CONNECTOR")) ? this.gI.connecteUserKbd(this.infoBean.getString("LOGIN"), this.infoBean.getString("PASSWORD"), this, this.getGp().getSessionUtilisateur().getInfos(), this.infoBean.getString("#user-agent")) : this.gI.connecte(this.infoBean.getString("LOGIN"), this.infoBean.getString("PASSWORD"), this, this.getGp().getSessionUtilisateur().getInfos(), this.infoBean.getString("#user-agent"));
        if (utilisateur == null) {
            this.infoBean.addMessageErreur(MessageHelper.getCoreMessage(this.getLocale(), "ST_LOGIN_PASSWORD_INCORRECT"));
            this.ecranLogique = ECRAN_PRINCIPAL;
        } else {
            if ("1".equals(this.infoBean.get("KUSER_CONNECTOR"))) {
                this.setKUserConnectorCookieValue("ok");
            } else {
                this.setKUserConnectorCookieValue("no");
            }
            this.setEcranRedirection(false);
        }
    }

    private void initialiserPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("LOGIN", "");
        this.infoBean.set("PASSWORD", "");
    }

    private void initialiserDEMANDE_MDP() throws Exception {
        this.ecranLogique = ECRAN_DEMANDE_MDP;
        this.infoBean.set("LOGIN", "");
        this.infoBean.set("EMAIL", "");
        this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("ST_DSI_OUBLI_MDP_TITRE"));
    }

    private void initialiserPERSONNALISATION() throws Exception {
        if (!SessionUtil.estConnecte(this.getGp().getSessionUtilisateur())) {
            this.setEcranLogin();
        } else {
            this.ecranLogique = ECRAN_PERSONNALISATION;
            if (!this.gI.getMappingLogin()) {
                this.infoBean.set("LOGIN", this.getGp().getSessionUtilisateur().getInfos().get("CODE"));
            } else {
                this.infoBean.set("LOGIN", this.getGp().getSessionUtilisateur().getInfos().get("CODE_GESTION"));
            }
            String synchronisationUtilisateurEtAnnuaire = PropertyHelper.getCoreProperty("utilisateur.synchronisation_code_avec_annuaire");
            if (synchronisationUtilisateurEtAnnuaire == null) {
                synchronisationUtilisateurEtAnnuaire = "1";
            }
            this.infoBean.set("SYNCHRONISATION", synchronisationUtilisateurEtAnnuaire);
            this.infoBean.set("PASSWORD_1", "");
            this.infoBean.set("PASSWORD_2", "");
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.setCtx(this);
            utilisateur.init();
            if (utilisateur.selectParCode((String)this.getGp().getSessionUtilisateur().getInfos().get("CODE")) == 1) {
                utilisateur.nextItem();
                this.infoBean.set("NOM", utilisateur.getNom());
                this.infoBean.set("PRENOM", utilisateur.getPrenom());
                this.infoBean.set("ADRESSE_MAIL", utilisateur.getAdresseMail());
                String droitModificationPassword = PropertyHelper.getCoreProperty("dsi.droits.modification_password");
                if (droitModificationPassword == null) {
                    droitModificationPassword = "1";
                }
                if (utilisateur.isModificationMotDePasseInterditeParSource()) {
                    droitModificationPassword = "0";
                }
                this.infoBean.set("DROIT_MODIFICATION_PASSWORD", droitModificationPassword);
                String droitModificationEmail = PropertyHelper.getCoreProperty("dsi.droits.modification_email");
                droitModificationEmail = droitModificationEmail == null && !utilisateur.provientDuLdap() ? "1" : "0";
                this.infoBean.set("DROIT_MODIFICATION_EMAIL", droitModificationEmail);
                this.initialiserPERSONNALISATIONStructure(utilisateur.getCodeRattachement());
                this.infoBean.set("FORMAT_ENVOI", utilisateur.getFormatEnvoi());
                this.infoBean.set("RADIO0", "HTML");
                this.infoBean.set("RADIO1", "Texte");
                this.infoBean.set("MODIFICATION_PROFIL_DEFAUT", "0");
                Vector<String> groupesDsi = Groupeutilisateur.getVecteurGroupes(utilisateur.getCode());
                Hashtable<String, String> listeProfils = Profildsi.getListeProfilsDSIParGroupes(groupesDsi);
                this.infoBean.set("PROFIL_DEFAUT", utilisateur.getProfilDefaut());
                this.infoBean.set("LISTE_PROFILS", listeProfils);
                if (listeProfils.size() > 1) {
                    this.infoBean.set("MODIFICATION_PROFIL_DEFAUT", "1");
                }
                Vector<String> vThemesUtilisateurs = utilisateur.getVecteurCentresInteret();
                int iTheme = 0;
                Libelle libelle = new Libelle();
                libelle.setCtx(this);
                ClauseWhere whereType = new ClauseWhere(ConditionHelper.egalVarchar("TYPE", "04"));
                whereType.and(ConditionHelper.egalVarchar("LANGUE", LangueUtil.getLangueLocale(this.getLocale())));
                ClauseOrderBy orderByLibelle = new ClauseOrderBy("LiBELLE", ClauseOrderBy.SensDeTri.ASC);
                RequeteSQL requete = new RequeteSQL();
                requete.where(whereType).orderBy(orderByLibelle);
                if (libelle.select(requete.formaterRequete()) > 0) {
                    while (libelle.nextItem()) {
                        String valeurTheme = "0";
                        if (vThemesUtilisateurs.indexOf(libelle.getCode()) != -1) {
                            valeurTheme = "1";
                        }
                        this.infoBean.set("CODE_THEME#" + iTheme, libelle.getCode());
                        this.infoBean.set("LIBELLE_THEME#" + iTheme, libelle.getLibelle());
                        this.infoBean.set("VALEUR_THEME#" + iTheme, valeurTheme);
                        ++iTheme;
                    }
                }
                this.infoBean.set("THEMES_NB_ITEMS", iTheme);
            }
        }
    }

    private void setEcranLogin() throws Exception {
        HttpServletRequest request = (HttpServletRequest)((Hashtable)this.getDatas()).get("_sg_requete_http");
        boolean kUserConnector = SourceAuthHelper.isDoubleSourceAuthActif(request, this.infoBean);
        if (!kUserConnector && this.gI.estSourceAuth("cas")) {
            boolean isFront = this.infoBean.getNomProcessus().equals(PROC_IDENTIFICATION_FRONT);
            if (this.infoBean.get("URL_DEMANDEE") != null) {
                UnivWebFmt.initialiserUrlRedirection(request.getSession(), this.infoBean.getString("URL_DEMANDEE"));
            }
            if (isFront) {
                this.infoBean.setEcranRedirection(URLResolver.getAbsoluteUrl(this.gI.getValidateurCAS().getUrlCasLoginFront(this), ContexteUtil.getContexteUniv()));
            } else {
                this.infoBean.setEcranRedirection(URLResolver.getAbsoluteUrl(this.gI.getValidateurCAS().getUrlCasLogin(this), ContexteUtil.getContexteUniv()));
            }
            this.ecranLogique = ECRAN_REDIRECTION;
        } else if (!kUserConnector && this.gI.estSourceAuth("ClearTrust")) {
            this.infoBean.setEcranRedirection(URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=VALIDER", ContexteUtil.getContexteUniv()));
            this.ecranLogique = ECRAN_REDIRECTION;
        } else {
            this.initialiserPRINCIPAL();
        }
    }

    private void traiterDEMANDE_MDP() throws Exception {
        if (this.action.equals("VALIDER")) {
            String message = "";
            MotDePasseCtrl unNouveauMotDePasse = new MotDePasseCtrl();
            unNouveauMotDePasse.demande(this.infoBean, this);
            this.traiterCONFIRMATION_MDP("");
        }
    }

    private void traiterCONFIRMATION_MDP(String message) throws Exception {
        this.infoBean.set("MESSAGE", message);
        this.ecranLogique = ECRAN_CONFIRMATION_MDP;
    }

    private void traiterGENERATION_MDP() throws Exception {
        HashMap<String, String> presentation;
        if (StringUtils.isNotEmpty((CharSequence)this.infoBean.getString("ID"))) {
            String id = this.infoBean.getString("ID");
            this.ecranLogique = ECRAN_PRESENTATION_MDP;
            MotDePasseCtrl unNouveauMotDePasse = new MotDePasseCtrl();
            presentation = unNouveauMotDePasse.fabrication(id, this);
            if (presentation.get("nom") == null) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ST_ERR_DEMANDE_MDP_DEMANDE_INVALIDE"));
            }
        } else {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ST_ERR_DEMANDE_MDP_DEMANDE_INVALIDE"));
        }
        this.infoBean.set("LOGIN", presentation.get("code"));
        this.infoBean.set("NOM", presentation.get("nom"));
        this.infoBean.set("PRENOM", presentation.get("prenom"));
        this.infoBean.set("MDP", presentation.get("motDePasse"));
    }

    private void traiterPERSONNALISATION() throws Exception {
        if (!SessionUtil.estConnecte(this.getGp().getSessionUtilisateur())) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ST_ACCES_RESERVE"));
        }
        if ("VALIDER".equals(this.action)) {
            String password;
            String codeUtilisateur = (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE");
            String droitModificationPassword = PropertyHelper.getCoreProperty("dsi.droits.modification_password");
            if ((droitModificationPassword == null || "1".equals(droitModificationPassword)) && StringUtils.isNotBlank((CharSequence)(password = this.infoBean.getString("PASSWORD_1").trim()))) {
                String msgErrorPassword = Utilisateur.verifieMotDePasse(password);
                if (msgErrorPassword != null && !msgErrorPassword.equals("")) {
                    throw new ErreurApplicative(msgErrorPassword);
                }
                if (!password.equalsIgnoreCase(this.infoBean.getString("PASSWORD_2"))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "AUTHENTIFICATION.ERREUR.MOT_PASSE_CONFIRM_INCORRECT"));
                }
            }
            String email = null;
            String droitModificationEmail = PropertyHelper.getCoreProperty("dsi.droits.modification_email");
            if ((droitModificationEmail == null || "1".equals(droitModificationEmail)) && !MailUtil.verifMail(email = this.infoBean.getString("ADRESSE_MAIL"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ST_ERR_DEMANDE_MDP_EMAIL"));
            }
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.setCtx(this);
            utilisateur.init();
            if (utilisateur.selectParCode(codeUtilisateur) == 1) {
                utilisateur.nextItem();
                if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("PASSWORD_1"))) {
                    utilisateur.setMotDePasse(MySQLHelper.encodePassword(this.infoBean.getString("PASSWORD_1")));
                }
                utilisateur.setAdresseMail(email);
                String codeStructureRattachement = this.determinerCodeRattachement();
                if (codeStructureRattachement != null) {
                    utilisateur.setCodeRattachement(codeStructureRattachement);
                }
                if (this.infoBean.getString("FORMAT_ENVOI") != null) {
                    utilisateur.setFormatEnvoi(this.infoBean.getString("FORMAT_ENVOI"));
                }
                if (this.infoBean.getString("PROFIL_DEFAUT") != null) {
                    utilisateur.setProfilDefaut(this.infoBean.getString("PROFIL_DEFAUT"));
                }
                Vector<String> v = new Vector<String>();
                for (int j = 0; j < Integer.parseInt(this.infoBean.getString("THEMES_NB_ITEMS")); ++j) {
                    if (!this.infoBean.getString("VALEUR_THEME#" + j).equals("1")) continue;
                    v.add(this.infoBean.getString("CODE_THEME#" + j));
                }
                utilisateur.setVecteurCentresInteret(v);
                utilisateur.update();
                this.getGp().getSessionUtilisateur().getInfos().put("CENTRES_INTERET", utilisateur.getVecteurCentresInteret());
                String synchronisation = PropertyHelper.getCoreProperty("utilisateur.synchronisation_code_avec_annuaire");
                if (synchronisation == null || "1".equals(synchronisation)) {
                    this.synchFicheAnnuaire(codeUtilisateur, email, codeStructureRattachement);
                }
            }
            this.setEcranRedirection(false);
        }
    }

    private void synchFicheAnnuaire(String codeUtilisateur, String email, String codeRattachement) throws Exception {
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
            if (!(ficheUniv instanceof AnnuaireModele)) continue;
            ficheUniv.setCtx(this);
            ficheUniv.init();
            int count = ficheUniv.selectCodeLangueEtat(codeUtilisateur, "", "");
            if (count <= 0) continue;
            while (ficheUniv.nextItem()) {
                if (!ficheUniv.getCodeRedacteur().equals(codeUtilisateur)) continue;
                ((AnnuaireModele)ficheUniv).setAdresseMail(email);
                ficheUniv.setCodeRattachement(codeRattachement);
                ficheUniv.update();
                Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
                meta.synchroniser(ficheUniv, false);
                FicheUnivMgr.enregistrerMeta(meta);
            }
        }
    }

    private void initialiserACCUEIL() throws Exception {
        if (this.infoBean.get("PROFIL") != null) {
            Hashtable<String, Object> hashInfosUser = this.getGp().getSessionUtilisateur().getInfos();
            hashInfosUser.put("PROFIL_DSI", this.infoBean.getString("PROFIL"));
            InfosProfilDsi info = Profildsi.renvoyerItemProfilDsi(this.infoBean.getString("PROFIL"));
            String codeRubrique = info.getCodeRubriqueAccueil();
            InfosRubriques infos = Rubrique.renvoyerItemRubrique(codeRubrique);
            hashInfosUser.put("RUBRIQUE_ACCUEIL", infos);
        }
        this.setEcranRedirection(false);
    }

    protected void initialiserPERSONNALISATIONStructure(String codeRattachement) throws Exception {
        this.infoBean.set("CODE_STRUCTURE", codeRattachement);
        this.infoBean.set("LIBELLE_CODE_STRUCTURE", Structure.getLibelleAffichable(codeRattachement, ""));
    }

    protected String determinerCodeRattachement() throws Exception {
        return this.infoBean.getString("CODE_RATTACHEMENT");
    }

    private void setKUserConnectorCookieValue(String value) {
        MyRequestWrapper myRequest = (MyRequestWrapper)((Object)((Hashtable)this.getDatas()).get("_sg_requete_http"));
        HttpServletResponse response = myRequest.getResponse();
        myRequest.getHttpServletRequest();
        Cookie cookie = new Cookie("KUSER_CONNECTOR", value);
        cookie.setPath("/");
        response.addCookie(cookie);
    }
}

