/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.security.MySQLHelper;
import com.univ.objetspartages.om.Changementmotpasse;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class MotDePasseCtrl {
    private Utilisateur utilisateur = null;
    private static final String PROPRIETE_LONGUEUR_MOT_DE_PASSE = "utilisateur.password.longueur.max";
    public static final int LONGUEUR_MOT_DE_PASSE_DEFAUT = 64;

    public static int getLongueurChampMotDePasse() {
        int tailleMotDePasse = 64;
        String prop = PropertyHelper.getCoreProperty(PROPRIETE_LONGUEUR_MOT_DE_PASSE);
        if (StringUtils.isNotBlank((CharSequence)prop) && StringUtils.isNumeric((CharSequence)prop)) {
            try {
                tailleMotDePasse = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                tailleMotDePasse = 64;
            }
        }
        return tailleMotDePasse;
    }

    public void demande(InfoBean infoBean, OMContext ctx) throws Exception {
        String email = infoBean.getString("EMAIL");
        ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("ADRESSE_MAIL", email));
        where.and(ConditionHelper.notEgal("MOT_DE_PASSE", "", TypeOperande.VARCHAR));
        String code = infoBean.getString("LOGIN");
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar("CODE", code));
        }
        this.utilisateur = new Utilisateur();
        this.utilisateur.setCtx(ctx);
        this.utilisateur.init();
        int nb = this.utilisateur.select(where.formaterSQL());
        if (nb == 0) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(StringUtils.isNotEmpty((CharSequence)code) ? "ST_ERR_DEMANDE_MDP_EMAIL_LOGIN" : "ST_ERR_DEMANDE_MDP_EMAIL"));
        }
        if (nb > 1) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("ST_ERR_DEMANDE_MDP_COMPTES"));
        }
        this.utilisateur.nextItem();
        String id = this.enregistrementDEMANDE_MDP(this.utilisateur.getCode(), email);
        this.envoiEmailDEMANDE_MDP(id, email, ctx);
    }

    public HashMap<String, String> fabrication(String id, OMContext ctx) throws Exception {
        this.utilisateur = new Utilisateur();
        this.utilisateur.setCtx(ctx);
        this.utilisateur.init();
        HashMap<String, String> presentation = new HashMap<String, String>();
        if (id == null) {
            return presentation;
        }
        presentation = this.recuperationDEMANDE_MDP(id);
        if (StringUtils.isEmpty((CharSequence)presentation.get("code"))) {
            return presentation;
        }
        String motDePasse = this.generationMDP();
        presentation.put("motDePasse", motDePasse);
        String code = presentation.get("code");
        String email = presentation.get("email");
        this.enregistrementUtilisateur(code, email, motDePasse);
        this.suppressionTouteDEMANDE_MDP(code);
        return presentation;
    }

    private String enregistrementDEMANDE_MDP(String code, String email) throws Exception {
        code = EscapeString.escapeSql(code);
        email = EscapeString.escapeSql(email);
        Changementmotpasse chgMdp = new Changementmotpasse();
        try (ContexteDao ctx = new ContexteDao();){
            chgMdp.setCtx(ctx);
            chgMdp.init();
            chgMdp.setCode(code);
            chgMdp.setEmail(email);
            chgMdp.setId(this.generationID());
            chgMdp.setDateDemande(new Date(System.currentTimeMillis()));
            chgMdp.add();
        }
        return chgMdp.getId();
    }

    private void suppressionDEMANDE_MDP(String id) throws Exception {
        Changementmotpasse chgMdp = new Changementmotpasse();
        try (ContexteDao ctx = new ContexteDao();){
            chgMdp.setCtx(ctx);
            chgMdp.init();
            ClauseWhere whereID = new ClauseWhere(ConditionHelper.egalVarchar("ID", id));
            if (chgMdp.select(whereID.formaterSQL()) > 0) {
                while (chgMdp.nextItem()) {
                    chgMdp.delete();
                }
            }
        }
    }

    private void suppressionTouteDEMANDE_MDP(String code) throws Exception {
        Changementmotpasse chgMdp = new Changementmotpasse();
        try (ContexteDao ctx = new ContexteDao();){
            chgMdp.setCtx(ctx);
            chgMdp.init();
            ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("code", code));
            if (chgMdp.select(whereCode.formaterSQL()) > 0) {
                while (chgMdp.nextItem()) {
                    chgMdp.delete();
                }
            }
        }
    }

    private void enregistrementUtilisateur(String code, String email, String motDePasse) throws Exception {
        Utilisateur utilisateur = new Utilisateur();
        try (ContexteDao ctx = new ContexteDao();){
            utilisateur.setCtx(ctx);
            utilisateur.init();
            ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("code", code));
            if (utilisateur.select(whereCode.formaterSQL()) > 0 && utilisateur.nextItem()) {
                utilisateur.setMotDePasse(MySQLHelper.encodePassword(motDePasse));
                if (utilisateur.getAdresseMail().length() == 0 && !email.equals("")) {
                    utilisateur.setAdresseMail(email);
                }
                utilisateur.update();
            }
        }
    }

    private void envoiEmailDEMANDE_MDP(String id, String to, OMContext ctx) throws Exception {
        String universite = ctx.getInfosSite() != null ? ctx.getInfosSite().getIntitule() : "K-Portal";
        String sujet = universite + " " + MessageHelper.getCoreMessage(ctx.getLocale(), "ST_OBJET_DSI_CONNEXION_INTRANET");
        String url = "/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=PRESENTER_MDP&ID=" + id;
        String message = MessageHelper.getCoreMessage(ctx.getLocale(), "ST_CLIQUEZ_LIEN");
        message = message + URLResolver.getAbsoluteUrl(url, ctx);
        message = message + MessageHelper.getCoreMessage(ctx.getLocale(), "ST_EQUIPE_WEB") + universite;
        JSBMailbox mailbox = new JSBMailbox(false);
        try {
            mailbox.sendSystemMsg(to, sujet, message);
        }
        catch (Exception e) {
            this.suppressionDEMANDE_MDP(id);
            throw e;
        }
    }

    private String generationMDP() {
        String charMin = "abcdefghijklmnopqrstuvwxyz";
        String charMaj = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String charNb = "0123456789";
        String charTout = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        String mdp = "";
        for (int i = 0; i < 7; ++i) {
            mdp = mdp.concat("" + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)(Math.random() * 1000.0 % (double)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length())));
        }
        return mdp;
    }

    private String generationID() {
        String charMin = "abcdefghijklmnopqrstuvwxyz";
        String charMaj = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String charNb = "0123456789";
        String charTout = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        String id = "";
        for (int i = 0; i < 8; ++i) {
            id = id.concat("" + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)(Math.random() * 1000.0 % (double)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length())));
        }
        return id;
    }

    private HashMap<String, String> recuperationDEMANDE_MDP(String id) throws Exception {
        HashMap<String, String> demande = new HashMap<String, String>();
        Changementmotpasse chgMdp = new Changementmotpasse();
        try (ContexteDao ctx = new ContexteDao();){
            chgMdp.setCtx(ctx);
            chgMdp.init();
            ClauseWhere whereID = new ClauseWhere(ConditionHelper.egalVarchar("ID", id));
            if (chgMdp.select(whereID.formaterSQL()) > 0) {
                while (chgMdp.nextItem()) {
                    ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("code", chgMdp.getCode()));
                    if (this.utilisateur.select(whereCode.formaterSQL()) <= 0) continue;
                    this.utilisateur.nextItem();
                    demande.put("code", chgMdp.getCode());
                    demande.put("email", chgMdp.getEmail());
                    demande.put("nom", this.utilisateur.getNom());
                    demande.put("prenom", this.utilisateur.getPrenom());
                }
            }
        }
        return demande;
    }
}

