/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RechercheFiche;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RechercheDirecte
extends RechercheFiche {
    protected static final String ECRAN_RECHERCHE_DIRECTE = "RECHERCHE";
    protected static final String ACTION_RECHERCHE_AVANCEE = "RECHERCHE_AVANCEE";
    protected static final String ACTION_RECHERCHER = "RECHERCHER";
    private static final Logger LOG = LoggerFactory.getLogger(RechercheDirecte.class);

    public RechercheDirecte(InfoBean ciu) {
        super(ciu);
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.ecranLogique = this.infoBean.getEcranLogique() == null ? "" : this.infoBean.getEcranLogique();
        this.action = this.infoBean.getActionUtilisateur();
        this.etat = 1;
        if (ECRAN_RECHERCHE_DIRECTE.equals(this.ecranLogique)) {
            this.traiterRECHERCHE();
        } else if (ACTION_RECHERCHE_AVANCEE.equals(this.action) || ACTION_RECHERCHER.equals(this.action)) {
            this.traiterRECHERCHEAVANCEE();
        }
        this.infoBean.setEcranLogique(this.ecranLogique);
        return this.etat == 2;
    }

    protected void traiterRECHERCHEAVANCEE() throws Exception {
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.ecranLogique = "LOGIN";
        } else {
            this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
            this.ecranLogique = ECRAN_RECHERCHE_DIRECTE;
        }
    }

    @Override
    protected void traiterRECHERCHE() throws Exception {
        if ("VALIDER".equals(this.action)) {
            AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            if (autorisations == null) {
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.ecranLogique = "LOGIN";
            } else {
                this.insererRechercheDansInfoBean(this.infoBean);
                this.preparerLISTE();
            }
        }
    }

    private void insererRechercheDansInfoBean(InfoBean infoBean) throws ErreurApplicative {
        ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
        String urlFiche = infoBean.getString("URL_FICHE");
        if (StringUtils.isNotBlank((CharSequence)urlFiche)) {
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "URL_FICHE"));
        } else {
            String etatObjet;
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(infoBean, "TITRE"));
            String codeObjet = infoBean.getString("CODE_OBJET");
            if (StringUtils.isNotBlank((CharSequence)codeObjet) && !"0000".equals(codeObjet)) {
                String libelleObjet = ReferentielObjets.getLibelleObjet(codeObjet);
                criteres.add(new CritereRecherche("CODE_OBJET", codeObjet, (String)StringUtils.defaultIfBlank((CharSequence)libelleObjet, (CharSequence)codeObjet)));
            }
            if (StringUtils.isNotBlank((CharSequence)infoBean.getString("CODE_RUBRIQUE_RECHERCHE"))) {
                String codeRubrique;
                String libelleRubrique = codeRubrique = infoBean.getString("CODE_RUBRIQUE_RECHERCHE");
                try {
                    libelleRubrique = Rubrique.getIntitule(codeRubrique);
                }
                catch (Exception e) {
                    LOG.info("pas de rubrique de code : " + codeRubrique);
                }
                criteres.add(new CritereRecherche("CODE_RUBRIQUE_RECHERCHE", codeRubrique, (String)StringUtils.defaultIfBlank((CharSequence)libelleRubrique, (CharSequence)codeRubrique)));
                criteres.add(new CritereRecherche("LIBELLE_CODE_RUBRIQUE_RECHERCHE", libelleRubrique, ""));
            }
            if (StringUtils.isNotBlank((CharSequence)infoBean.getString("CODE_RATTACHEMENT"))) {
                String codeRattachement;
                String libelleStrucuture = codeRattachement = infoBean.getString("CODE_RATTACHEMENT");
                try {
                    libelleStrucuture = Structure.getLibelleAffichable(codeRattachement, LangueUtil.getLangueLocale(this.getLocale()));
                }
                catch (Exception e) {
                    LOG.info("pas de structure de code : " + codeRattachement);
                }
                criteres.add(new CritereRecherche("CODE_RATTACHEMENT", codeRattachement, (String)StringUtils.defaultIfBlank((CharSequence)libelleStrucuture, (CharSequence)codeRattachement)));
                criteres.add(new CritereRecherche("LIBELLE_CODE_RATTACHEMENT", libelleStrucuture, ""));
            }
            if (StringUtils.isNotBlank((CharSequence)infoBean.getString("CODE_REDACTEUR")) || StringUtils.isNotBlank((CharSequence)infoBean.getString("DE_MOI"))) {
                String codeRedacteur = infoBean.getString("CODE_REDACTEUR");
                String libelleUtilisateur = codeRedacteur = StringUtils.isEmpty((CharSequence)infoBean.getString("DE_MOI")) ? codeRedacteur : (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE");
                try {
                    libelleUtilisateur = Utilisateur.getLibelle(codeRedacteur);
                }
                catch (Exception e) {
                    LOG.info("pas d'utilisateur ayant ce code : " + codeRedacteur);
                }
                criteres.add(new CritereRecherche("CODE_REDACTEUR", codeRedacteur, (String)StringUtils.defaultIfBlank((CharSequence)libelleUtilisateur, (CharSequence)codeRedacteur)));
                criteres.add(new CritereRecherche("LIBELLE_CODE_REDACTEUR", libelleUtilisateur, ""));
            }
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "ID_META"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "CODE_FICHE"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_CREATION_DEBUT"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_CREATION_FIN"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_MODIFICATION_DEBUT"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_MODIFICATION_FIN"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_MISE_EN_LIGNE_DEBUT"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate(infoBean, "DATE_MISE_EN_LIGNE_FIN"));
            String langue = infoBean.getString("LANGUE");
            if (StringUtils.isNotBlank((CharSequence)langue) && !"0000".equals(langue)) {
                Locale localeRechercher = LangueUtil.getLocale(langue);
                String libelleLangue = langue;
                if (localeRechercher != null) {
                    libelleLangue = localeRechercher.getDisplayLanguage(ContexteUtil.getContexteUniv().getLocale());
                }
                criteres.add(new CritereRecherche("LANGUE", langue, libelleLangue));
            }
            if (StringUtils.isNotBlank((CharSequence)(etatObjet = infoBean.getString("ETAT_OBJET"))) && !"0000".equals(etatObjet)) {
                String libelleEtatObjet = MessageHelper.getCoreMessage("ETATFICHE_" + etatObjet);
                criteres.add(new CritereRecherche("ETAT_OBJET", etatObjet, (String)StringUtils.defaultIfBlank((CharSequence)libelleEtatObjet, (CharSequence)etatObjet)));
            }
        }
        String idBean = "multiFicheDatagrid";
        if (StringUtils.isNotBlank((CharSequence)infoBean.getString("TOOLBOX"))) {
            idBean = "multiFicheToolboxDatagrid";
        }
        criteres.add(new CritereRecherche("BEAN_RECHERCHE", idBean, ""));
        infoBean.set("CRITERE_REQUETE", criteres);
    }
}

