/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RechercheGroupeDsi
extends ProcessusBean {
    private static Logger LOG = LoggerFactory.getLogger(RechercheGroupeDsi.class);
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_LISTE = "LISTE";
    AutorisationBean autorisations = null;
    Groupedsi groupedsi = null;

    public RechercheGroupeDsi(InfoBean ciu) {
        super(ciu);
    }

    private void preparerLISTE() throws Exception {
        int i = 0;
        this.ecranLogique = ECRAN_LISTE;
        this.groupedsi.select("", this.infoBean.getString("TYPE"), this.infoBean.getString("LIBELLE"), this.infoBean.getString("CODE_STRUCTURE"), "");
        String sPermission = this.infoBean.getString("PERMISSION");
        if (sPermission == null) {
            sPermission = "";
        }
        while (this.groupedsi.nextItem()) {
            boolean insererGroupe = true;
            if (sPermission.length() > 0 && !this.autorisations.possedePermissionPartielleSurPerimetre(new PermissionBean(this.infoBean.getString("PERMISSION")), new Perimetre("", "", "", this.groupedsi.getCode(), ""))) {
                insererGroupe = false;
            }
            if (!insererGroupe) continue;
            this.infoBean.set("CODE#" + i, this.groupedsi.getCode());
            this.infoBean.set("LIBELLE#" + i, this.groupedsi.getLibelle());
            this.infoBean.set("LIBELLE_STRUCTURE#" + i, Structure.getLibelleAffichable(this.groupedsi.getCodeStructure(), "0"));
            ++i;
        }
        if (i > 0) {
            this.infoBean.set("LISTE_NB_ITEMS", i);
        } else {
            this.infoBean.addMessageErreur("Aucun groupe ne r\u00e9pond aux crit\u00e8res");
        }
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_TYPES", Libelle.getListe("11", LangueUtil.getDefaultLocale()));
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.groupedsi = new Groupedsi();
                this.groupedsi.setCtx(this);
                this.groupedsi.init();
                this.etat = 1;
                if (this.ecranLogique == null) {
                    if (this.action.equals("RECHERCHER")) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.preparerRECHERCHE();
                    }
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur lors du traitement du processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER")) {
            this.preparerLISTE();
        }
        if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        }
    }
}

