/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Profildsi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecherchePublicViseDsi
extends ProcessusBean {
    private static Logger LOG = LoggerFactory.getLogger(RecherchePublicViseDsi.class);
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    Groupedsi groupedsi = null;

    public RecherchePublicViseDsi(InfoBean ciu) {
        super(ciu);
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_PROFILS_DSI", Profildsi.getListeProfilsDSI());
        if (this.infoBean.get("PERMISSION") != null) {
            PermissionBean permission = new PermissionBean(this.infoBean.getString("PERMISSION"));
            this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE", "1");
            this.infoBean.set("GRS_PERMISSION_TYPE", permission.getType());
            this.infoBean.set("GRS_PERMISSION_OBJET", permission.getObjet());
            this.infoBean.set("GRS_PERMISSION_ACTION", permission.getAction());
        }
    }

    @Override
    public boolean traiterAction() throws Exception {
        Object o = this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (o == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.etat = 1;
                if (this.ecranLogique == null) {
                    if (this.action.equals("RECHERCHER")) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.preparerRECHERCHE();
                    }
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        }
    }
}

