/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.univ.objetspartages.om.Article;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.processus.ControleurUniv;
import com.univ.objetspartages.processus.SaisieFiche;
import java.sql.Date;
import org.apache.commons.lang3.StringUtils;

public class SaisieArticle
extends SaisieFiche {
    private Article article = null;

    public SaisieArticle(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.infoBean.set("CODE_OBJET", "0015");
        this.article = new Article();
        this.article.init();
        this.traiterActionParDefaut(this.article);
        this.infoBean.set("NOM_ONGLET", "article");
        return this.etat == 2;
    }

    @Override
    protected void preparerRECHERCHE() throws Exception {
        this.ecranLogique = "RECHERCHE";
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
        this.infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", this.getLocale()));
    }

    @Override
    protected void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = "PRINCIPAL";
        this.infoBean.set("ID_ARTICLE", this.article.getIdFiche().toString());
        this.infoBean.set("TITRE", this.article.getTitre());
        this.infoBean.set("CHAPEAU", this.article.getChapeau());
        this.infoBean.set("CORPS", this.article.getCorps());
        this.infoBean.set("THEMATIQUE", this.article.getThematique());
        this.infoBean.set("LIBELLE_THEMATIQUE", this.article.getLibelleThematique());
        this.infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", LangueUtil.getLocale(this.article.getLangue())));
        if (Formateur.estSaisie(this.article.getDateArticle())) {
            this.infoBean.set("DATE_ARTICLE", this.article.getDateArticle());
        } else {
            this.infoBean.set("DATE_ARTICLE", new Date(System.currentTimeMillis()));
        }
        this.infoBean.set("SOUS_TITRE", this.article.getSousTitre());
        if (1000 == this.article.getOrdre()) {
            this.infoBean.set("ORDRE", "");
        } else {
            this.infoBean.set("ORDRE", this.article.getOrdre().toString());
        }
        this.infoBean.set("CODE_RUBRIQUE", this.article.getCodeRubrique());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", this.article.getInfosRubrique().getLibelleAffichable());
        this.infoBean.set("CODE_RATTACHEMENT", this.article.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", this.article.getInfosStructure().getLibelleAffichable());
        this.infoBean.set("LIBELLE_AFFICHABLE", this.article.getLibelleAffichable());
        this.infoBean.set("SOUS_ONGLET", "PRINCIPAL");
        ControleurUniv.preparerPRINCIPAL(this.infoBean, this.article, this);
    }

    @Override
    protected void traiterPRINCIPAL() throws Exception {
        if ("CREATION".equals(this.infoBean.getEtatObjet())) {
            this.article.init();
        } else {
            this.article.setIdFiche(new Long(this.infoBean.getString("ID_ARTICLE")));
            this.article.retrieve();
        }
        if ("ONGLET".equals(this.action)) {
            this.infoBean.set("SOUS_ONGLET", this.infoBean.getString("SOUS_ONGLET_DEMANDE"));
        } else if ("ENREGISTRER".equals(this.action)) {
            this.alimenteDonneesCreation(this.article, false);
            this.article.setTitre((String)this.infoBean.get("TITRE"));
            this.article.setThematique((String)this.infoBean.get("THEMATIQUE"));
            this.article.setChapeau(this.infoBean.getString("CHAPEAU"));
            this.article.setSousTitre((String)this.infoBean.get("SOUS_TITRE"));
            if (Formateur.estSaisie((Date)this.infoBean.get("DATE_ARTICLE"))) {
                this.article.setDateArticle((Date)this.infoBean.get("DATE_ARTICLE"));
            }
            this.article.setCorps((String)this.infoBean.get("CORPS"));
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("ORDRE"))) {
                try {
                    Integer ordreArticle = new Integer(this.infoBean.getString("ORDRE"));
                    this.article.setOrdre(ordreArticle);
                }
                catch (Exception e) {
                    throw new ErreurApplicative("Format de l'ordre incorrect");
                }
            } else {
                this.article.setOrdre(1000);
            }
            if (this.infoBean.get("CODE_RUBRIQUE") != null && !"0000".equals(this.infoBean.getString("CODE_RUBRIQUE"))) {
                this.article.setCodeRubrique(this.infoBean.getString("CODE_RUBRIQUE"));
            } else {
                this.article.setCodeRubrique("");
            }
            this.article.setCodeRattachement(this.infoBean.getString("CODE_RATTACHEMENT"));
        }
        this.ecranLogique = ControleurUniv.traiterPRINCIPAL(this.infoBean, this.article, this);
        if (this.ecranLogique.length() == 0) {
            this.etat = 2;
        }
    }
}

