/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Encadre;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieEncadre
extends ProcessusBean {
    private static final Logger LOG = LoggerFactory.getLogger(SaisieEncadre.class);
    private int mode = -1;
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_ACCUEIL = "ACCUEIL";
    Encadre encadre = null;
    Map<Integer, Long> listeIdentifiant = null;
    AutorisationBean autorisations = null;

    public SaisieEncadre(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        Long idEncadre;
        this.encadre = new Encadre();
        this.encadre.setCtx(this);
        this.encadre.init();
        this.infoBean.set("LISTE_STRUCTURES", Structure.getListeStructureParIntituleComplet(this));
        this.etat = 1;
        if (this.action.equals("AJOUTER")) {
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        }
        if (this.action.equals("MODIFIERPARID")) {
            idEncadre = new Long(this.infoBean.getString("ID_ENCADRE"));
            try {
                this.encadre.setIdEncadre(idEncadre);
                this.encadre.retrieve();
            }
            catch (Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ENCADRE.ERREUR.ENCADRE_INEXISTANT"));
            }
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre(this.encadre.getCodeRattachement(), this.encadre.getCodeRubrique(), "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerPRINCIPAL();
        }
        if (this.action.equals("SUPPRIMERPARID")) {
            idEncadre = new Long(this.infoBean.getString("ID_ENCADRE"));
            try {
                this.encadre.setIdEncadre(idEncadre);
                this.encadre.retrieve();
            }
            catch (Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ENCADRE.ERREUR.ENCADRE_INEXISTANT"));
            }
            this.supprimerEncadre();
        } else if (this.action.equals(ECRAN_ACCUEIL)) {
            this.ecranLogique = ECRAN_ACCUEIL;
        }
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        String timeStamp = Long.toString(System.currentTimeMillis());
        this.infoBean.set("CODE", StringUtils.isEmpty((CharSequence)this.encadre.getCode()) ? timeStamp.substring(timeStamp.length() - 8, timeStamp.length()) : this.encadre.getCode());
        this.infoBean.set("CODE_RATTACHEMENT", this.encadre.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(this.encadre.getCodeRattachement(), this.encadre.getLangue()));
        this.infoBean.set("CODE_RUBRIQUE", this.encadre.getCodeRubrique());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", Rubrique.renvoyerItemRubrique(this.encadre.getCodeRubrique()).getIntitule());
        if (!this.autorisations.isWebMaster()) {
            Vector<Perimetre> perimetresEncadre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "enc", "M"));
            if (perimetresEncadre != null && this.mode == 0) {
                for (Perimetre perimetreEncadre : perimetresEncadre) {
                    if (StringUtils.isNotBlank((CharSequence)perimetreEncadre.getCodeRubrique())) {
                        this.infoBean.set("CODE_RUBRIQUE", perimetreEncadre.getCodeRubrique());
                        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", Rubrique.renvoyerItemRubrique(perimetreEncadre.getCodeRubrique()).getIntitule());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)perimetreEncadre.getCodeStructure())) continue;
                    this.infoBean.set("CODE_RATTACHEMENT", perimetreEncadre.getCodeStructure());
                    this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(perimetreEncadre.getCodeStructure(), this.encadre.getLangue()));
                }
            }
            this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE", "CODE_RUBRIQUE");
            this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT", "CODE_RATTACHEMENT");
            this.infoBean.set("GRS_PERMISSION_TYPE", "TECH");
            this.infoBean.set("GRS_PERMISSION_OBJET", "enc");
            this.infoBean.set("GRS_PERMISSION_ACTION", "M");
        }
        this.infoBean.set("INTITULE", this.encadre.getIntitule());
        this.infoBean.set("ACTIF", this.encadre.getActif());
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
        this.infoBean.set("LANGUE", this.encadre.getLangue());
        this.infoBean.set("POIDS", this.encadre.getPoids());
        this.infoBean.set("CONTENU", this.encadre.getContenu());
        Hashtable<String, String> hObjets = new Hashtable<String, String>();
        for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
            hObjets.put(objet.getCodeObjet(), objet.getLibelleObjet());
        }
        this.infoBean.set("LISTE_OBJETS", hObjets);
        this.infoBean.set("LISTE_RUBRIQUES", Rubrique.getListeRubriquesParIntituleComplet());
        List<String> listeObjets = this.encadre.getVecteurObjets();
        this.infoBean.setInt("CODE_OBJETS_NB_ITEMS", listeObjets.size());
        int i = 0;
        for (String string : listeObjets) {
            this.infoBean.set("CODE_OBJET#" + i, string);
            ++i;
        }
        if (StringUtils.isNotBlank((CharSequence)this.encadre.getIntitule())) {
            this.infoBean.setTitreEcran(this.encadre.getIntitule());
        }
    }

    @Override
    public boolean traiterAction() throws Exception {
        try {
            this.ecranLogique = this.infoBean.getEcranLogique();
            this.action = this.infoBean.getActionUtilisateur();
            this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            if (this.autorisations == null) {
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.infoBean.setEcranLogique("LOGIN");
            } else {
                if (this.etat == 0) {
                    this.initialisation();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
        }
        catch (Exception e) {
            LOG.error("Erreur lors du traitement sur les encadres", (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        return this.etat == 2;
    }

    private void traiterPRINCIPAL() throws Exception {
        int j;
        String code;
        int nbItems;
        if (this.action.equals("AJOUTER_CODE_RUBRIQUE")) {
            if (this.infoBean.get("CODE_RUBRIQUE_APPLICATION").equals("")) {
                this.infoBean.addMessageErreur("La rubrique doit \u00eatre sp\u00e9cifi\u00e9e");
            } else {
                nbItems = this.infoBean.getInt("CODE_OBJETS_NB_ITEMS");
                this.ajoutePerimetreDansInfoBean(nbItems, "RUB_" + this.infoBean.get("CODE_RUBRIQUE_APPLICATION"));
            }
            this.infoBean.set("ACTION_PERIMETRE", Boolean.TRUE);
        }
        if (this.action.equals("AJOUTER_CODE_STRUCTURE")) {
            if (this.infoBean.get("CODE_STRUCTURE").equals("") && this.infoBean.get("CODE_OBJET").equals("0000")) {
                this.infoBean.addMessageErreur("La structure et/ou l'objet doit \u00eatre sp\u00e9cifi\u00e9e");
            } else {
                if (this.infoBean.get("CODE_STRUCTURE").equals("") && !this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre("-", "*", "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + MessageHelper.getCoreMessage("SAISIE_ENCADRE_PAS_DROIT_PERIMETRE_STRUCTURE"));
                }
                nbItems = this.infoBean.getInt("CODE_OBJETS_NB_ITEMS");
                code = "";
                if (!this.infoBean.get("CODE_OBJET").equals("0000")) {
                    code = this.infoBean.getString("CODE_OBJET");
                }
                code = code + "/";
                code = code + this.infoBean.getString("CODE_STRUCTURE");
                this.ajoutePerimetreDansInfoBean(nbItems, code);
            }
            this.infoBean.set("ACTION_PERIMETRE", Boolean.TRUE);
        }
        if (this.action.equals("AJOUTER_CODE_STRUCTURE_SEULE")) {
            if (this.infoBean.get("CODE_STRUCTURE_SEULE").equals("")) {
                this.infoBean.addMessageErreur("La structure doit \u00eatre sp\u00e9cifi\u00e9e.");
            } else {
                nbItems = this.infoBean.getInt("CODE_OBJETS_NB_ITEMS");
                code = "";
                code = code + "/";
                code = code + this.infoBean.getString("CODE_STRUCTURE_SEULE");
                this.ajoutePerimetreDansInfoBean(nbItems, code);
            }
            this.infoBean.set("ACTION_PERIMETRE", Boolean.TRUE);
        }
        if (this.action.indexOf("SUPPRIMER_CODE_OBJET") != -1) {
            int indice;
            int indiceDiese = this.action.indexOf("#");
            for (j = indice = Integer.parseInt(this.action.substring(indiceDiese + 1)); j < this.infoBean.getInt("CODE_OBJETS_NB_ITEMS") - 1; ++j) {
                this.infoBean.set("CODE_OBJET#" + j, this.infoBean.get("CODE_OBJET#" + (j + 1)));
            }
            this.infoBean.setInt("CODE_OBJETS_NB_ITEMS", this.infoBean.getInt("CODE_OBJETS_NB_ITEMS") - 1);
            this.infoBean.set("ACTION_PERIMETRE", Boolean.TRUE);
        }
        if (this.action.equals("VALIDER")) {
            if (!this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre(this.infoBean.getString("CODE_RATTACHEMENT"), this.infoBean.getString("CODE_RUBRIQUE"), "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_ACTION_HORS_PERIMETRE"));
            }
            this.encadre.setIntitule((String)this.infoBean.get("INTITULE"));
            this.encadre.setActif((String)this.infoBean.get("ACTIF"));
            this.encadre.setLangue((String)this.infoBean.get("LANGUE"));
            this.encadre.setPoids((Integer)this.infoBean.get("POIDS"));
            this.encadre.setContenu((String)this.infoBean.get("CONTENU"));
            this.encadre.setCode((String)this.infoBean.get("CODE"));
            this.encadre.setCodeRattachement((String)this.infoBean.get("CODE_RATTACHEMENT"));
            this.encadre.setCodeRubrique((String)this.infoBean.get("CODE_RUBRIQUE"));
            Vector<String> v = new Vector<String>();
            String sObjet = "";
            for (j = 0; j < this.infoBean.getInt("CODE_OBJETS_NB_ITEMS"); ++j) {
                sObjet = this.infoBean.getString("CODE_OBJET#" + j);
                if (sObjet.startsWith("RUB_") ? !this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre("-", sObjet.substring(4), "*", "*", "")) : sObjet.indexOf("/") != -1 && !this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre(sObjet.substring(sObjet.indexOf("/") + 1), "-", "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + MessageHelper.getCoreMessage("SAISIE_ENCADRE_PAS_DROIT_PERIMETRE"));
                }
                v.add(sObjet);
            }
            if (v.size() == 0 && !this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre("-", "-", "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + MessageHelper.getCoreMessage("SAISIE_ENCADRE_PAS_DROIT_PERIMETRE"));
            }
            this.encadre.setVecteurObjets(v);
            if (this.mode == 0) {
                this.encadre.add();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_ENCADRE"), this.encadre.getIntitule());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            if (this.mode == 1) {
                this.encadre.update();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_ENCADRE"), this.encadre.getIntitule());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            Media.modifierCodeRubriqueParInfobean(this.infoBean, this.encadre.getCodeRubrique());
            this.etat = 2;
        } else if (this.action.equals("SUPPRIMER")) {
            this.supprimerEncadre();
        }
    }

    private void ajoutePerimetreDansInfoBean(int nbItems, String valeurPerimetre) {
        if (this.isPerimetreUnique(valeurPerimetre)) {
            this.infoBean.set("CODE_OBJET#" + nbItems, valeurPerimetre);
            this.infoBean.setInt("CODE_OBJETS_NB_ITEMS", nbItems + 1);
        }
    }

    private boolean isPerimetreUnique(String valeurPerimetre) {
        boolean isUnique = Boolean.TRUE;
        for (int i = 0; i < this.infoBean.getInt("CODE_OBJETS_NB_ITEMS"); ++i) {
            if (!valeurPerimetre.equals(this.infoBean.get("CODE_OBJET#" + i))) continue;
            isUnique = Boolean.FALSE;
            break;
        }
        return isUnique;
    }

    private void supprimerEncadre() throws ErreurApplicative, Exception {
        if (!this.autorisations.isWebMaster() && !this.autorisations.possedePermission(new PermissionBean("TECH", "enc", "M"), new Perimetre(this.infoBean.getString("CODE_RATTACHEMENT"), this.infoBean.getString("CODE_RUBRIQUE"), "*", "*", ""))) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
        }
        this.encadre.delete();
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_ENCADRE"), this.encadre.getIntitule());
        this.infoBean.addMessageConfirmation(confirmation);
        this.etat = 2;
    }
}

